%%NAME
%%  edfont - define and load own postscript font
%%
%%SYNOPSIS
%%  fontNo=edfont(fontFileName,fontName)
%%
%%PARAMETER(S)
%%  fontFileName   pathname of an own postscript font definition file
%%                 or filename of a standard psd-file in the "eFontPath"-directory
%%  fontName       name of an own font
%% 
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010

function fontNo=edfont(fontFileName,fontName)
  if nargin<2 |nargin>2
    eusage('fontNo=edfont(fontFileName,fontName)');
  end
  eglobpar;


  % test file
  fontFileName=fontFileName(find(fontFileName~=' '));
  testName=['./' fontFileName];
  fontFile=fopen(testName,'rb');
  if fontFile==-1
    testName=[eFontPath fontFileName];
    fontFile=fopen(testName,'rb');
  end
  if fontFile~=-1
    fontFileName=testName;
    % load font from file
    fseek(fontFile,0,1); 
    fontFileLength=ftell(fontFile);
    fseek(fontFile,0,0); 
    bufferSize=100000;
    fontFile=fopen(fontFileName,'rb');
    nBuffer=fix(fontFileLength/bufferSize);
    tail=rem(fontFileLength,bufferSize);
    for i=1:nBuffer
      buffer=fread(fontFile,bufferSize,'char');
      fwrite(eFile,buffer,'char');
    end
    if tail>0
      buffer=fread(fontFile,tail,'char');
      fwrite(eFile,buffer,'char');
    end
    fclose(fontFile);
    % append font to fontlist
    nFonts=size(eFonts,1);
    fontNameSize=size(eFonts,2);
    newFontNameSize=size(fontName,2);
    if newFontNameSize<fontNameSize
      newFontName=[fontName char(ones(1,fontNameSize-newFontNameSize)*32)];
    else
      newFontName=fontName((newFontNameSize-fontNameSize+1):newFontNameSize);
    end
    eFonts=[eFonts;newFontName];
    fontNo=nFonts+1;
  end
  
  
