%%NAME
%%  ehtmladdeps  -  add EPS-file to exist HTML-file
%%
%%SYNOPSIS
%%  ehtmladdeps(htmlFileName[,epsFileName[,resolution]])
%%
%%PARAMETER(S)
%%  htmlFileName   name of html-file
%%  epsFileName    name of eps-file
%%                 default: string of global parameter 'eFileName' 
%%  resolution     resolution of bitmap
%%                 default: 72 dpi
%%GLOBAL PARAMETER(S)
%%  eFileName
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010
function [htmlFileName]=ehtmladdeps(htmlFileName,epsFileName,resolution)
  if (nargin<1)||(nargin>3)
    eusage('ehtmladdeps(htmlFileName[,epsFileName[,resolution]])');
  end
  eglobpar;
  if exist('eFac')
    if isempty(eFac)
      einit;
    end
  else
    einit;
  end
  if nargin<2
    epsFileName=eFileName;
  end
  if nargin<3
    resolution=72;
  end

  if exist(epsFileName)~=2
    disp('error in ehtmladdeps: file not exist');
  else
    htmlFile=fopen(htmlFileName,'r+b');
    if htmlFile<=0
      disp('error in ehtmladdeps: file not exist');
    else
      % get new image
      pngFileName=[htmlFileName(1:(length(htmlFileName)-5)) '.png'];
      map=ebitmap(0,resolution,pngFileName,epsFileName);
      fid=fopen(pngFileName,'rb');
      [imgString n]=fread(fid,inf,'uchar');
      fclose(fid);
      delete(pngFileName);
      [code codeL]=evec2b64(imgString);
      trans='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
      codeC=trans(code+1);
      % add image to html file
      fseek(htmlFile,-30,1);
      [data dl]=fread(htmlFile,inf,'uchar');
      htmlText=char(data).';
      pos=findstr(htmlText,'</CENTER></BODY>')-1;
      fseek(htmlFile,-30,1);
      fwrite(htmlFile,data(1:pos),'uchar');
      fprintf(htmlFile,'<IMG src=\"data:image/png;base64,%s\">\n',codeC);
      fprintf(htmlFile,'</CENTER></BODY>\n<HTML>\n');
      fclose(htmlFile);
    end
  end
