/*
 * Copyright (c) 2013 Qualcomm Atheros, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted (subject to the limitations in the
 * disclaimer below) provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *  * Neither the name of Qualcomm Atheros nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE
 * GRANTED BY THIS LICENSE.  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT
 * HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * @File: VBUF_api.h
 * 
 * @Abstract: Host Interface api
 * 
 * @Notes:
 */

#ifndef _VDESC_API_H
#define _VDESC_API_H

#define MAX_HW_DESC_SIZE 20

typedef struct _VDESC
{
	struct _VDESC   *next_desc;
	A_UINT8         *buf_addr;
	A_UINT16        buf_size;
	A_UINT16        data_offset;
	A_UINT16        data_size;
	A_UINT16        control;
	A_UINT8         hw_desc_buf[MAX_HW_DESC_SIZE]; 
} VDESC;

#define VDESC_HW_TO_VDESC(hwdesc)   ((VDESC *)(((A_UINT32 *)hwdesc - 4)))

struct vdesc_api {
	void        (*_init)(int nDesc);
	VDESC*      (*_alloc_vdesc)();
	A_UINT8*    (*_get_hw_desc)(VDESC *desc);
	void        (*_swap_vdesc)(VDESC *dest, VDESC *src);

        /* room to expand this table by another table */
	void *pReserved;    
};

extern void vdesc_module_install(struct vdesc_api *apis);

#endif 
