#! /bin/bash

templatedir=.

convlocale()
{
    local lc=$(echo $1 | tr _ -)
    echo $lc
}

rlc2oolc()
{
    local lc=$(echo $1 | tr _ -)
    case "$lc" in
        as|gu|hi|ml|or|pa|ta|te) lc=$lc-IN;;
    esac
    echo $lc
}

lc2rlc()
{
    local rlc
    lc=$(echo $1 | tr - _)
    case "$lc" in
        be_BY) lc=be;;
        sr_CS) lc=sr;;
        ti_ER) lc=ti;;
    esac
    echo $lc
}

locale_ok()
{
    # OOo doesn't have these, no -l10n package built anyway.
    case "$1" in
	aa|ace|am|ast|az|ber|bo|ceb|csb|de_AT|de_DE|dv|en_AU|en_CA|en_NZ) return 1;;
	es_ES|es_PR|fil|fr_FR|fy|gd|hy|id|is) return 1;;
	jv|kab|kk|ky|la|lb|mn|ms|mt|nap|nds|nl_NL|oc|pt_PT) return 1;;
	qu|sco|sd|si|so|sq|tlh|tl|ug|yi|zh_HK) return 1;;
	???) return 1;;
	an||||||||) return 1;;
    esac
    #echo >&2 locale $1 ok
    return 0
}

extract_supp()
{
    local po=$1
    local lc=$2
    if [ ! -f $po ]; then
	echo >&2 "no translation for $lc"
	return 1
    fi
    txt_supp=$(awk -F\" '/^msgid \"Get Help Online/ {getline; print $2}' $po)
    #echo >&2 "XXX $lc: /$txt_help/$txt_supp/"
    tr="-e s/@LC@/$(rlc2oolc $lc)/"
    if [ -n "$txt_supp" ]; then
	sed $tr -n -e "/@SUPP@/s/@SUPP@/$txt_supp/p" \
	    $templatedir/GSI_LCsupp.sdf
    fi
}

extract_trans()
{
    local po=$1
    local lc=$2
    if [ ! -f $po ]; then
	echo >&2 "no translation for $lc"
	return 1
    fi
    txt_trans=$(awk -F\" '/^msgid \"Translate This App/ {getline; print $2}' $po)
    #echo >&2 "XXX $lc: /$txt_help/$txt_supp/"
    tr="-e s/@LC@/$(rlc2oolc $lc)/"
    if [ -n "$txt_trans" ]; then
	sed $tr -n -e "/@TRANS@/s/@TRANS@/$txt_trans/p" \
	    $templatedir/GSI_LCtrans.sdf
    fi
}

extract_report()
{
    local po=$1
    local lc=$2
    if [ ! -f $po ]; then
	echo >&2 "no translation for $lc"
	return 1
    fi
    txt_rep=$(awk -F\" '/^msgid \"Report a Problem/ {getline; print $2}' $po)
    #echo >&2 "XXX $lc: /$txt_help/$txt_supp/"
    tr="-e s/@LC@/$(rlc2oolc $lc)/"
    if [ -n "$txt_rep" ]; then
	sed $tr -n -e "/@REPORT@/s/@REPORT@/$txt_rep/p" \
	    $templatedir/GSI_LCreport.sdf
    fi
}

grep -h '	en-US	' $templatedir/GSI_LCsupp.sdf

for fn in "$@"; do
    lc=$(basename $fn .po)
    locale_ok $lc || continue
    extract_supp $fn $lc
done

grep -h '	en-US	' $templatedir/GSI_LCtrans.sdf

for fn in "$@"; do
    lc=$(basename $fn .po)
    locale_ok $lc || continue
    extract_trans $fn $lc
done

grep -h '	en-US	' $templatedir/GSI_LCreport.sdf

for fn in "$@"; do
    lc=$(basename $fn .po)
    locale_ok $lc || continue
    extract_report $fn $lc
done
