/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Character
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGCHARACTERBASE_H_
#define _OSGCHARACTERBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGDrawable.h> // Parent

#include <OSGCharacterModelFields.h> // Model type
#include <OSGUInt32Fields.h> // CurrentAnimation type
#include <OSGReal32Fields.h> // BlendTime type
#include <OSGReal32Fields.h> // Delta type
#include <OSGReal32Fields.h> // TimeScale type
#include <OSGBoolFields.h> // DrawSkeleton type
#include <OSGBoolFields.h> // UseShaderForGeometry type
#include <OSGDynamicVolumeFields.h> // ModelVolume type

#include <OSGCharacterFields.h>

OSG_BEGIN_NAMESPACE

class Character;
class BinaryDataHandler;

//! \brief Character Base Class.

class OSG_CONTRIBLIB_DLLMAPPING CharacterBase : public Drawable
{
  private:

    typedef Drawable    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef CharacterPtr  Ptr;

    enum
    {
        ModelFieldId                = Inherited::NextFieldId,
        CurrentAnimationFieldId     = ModelFieldId                + 1,
        BlendTimeFieldId            = CurrentAnimationFieldId     + 1,
        DeltaFieldId                = BlendTimeFieldId            + 1,
        TimeScaleFieldId            = DeltaFieldId                + 1,
        DrawSkeletonFieldId         = TimeScaleFieldId            + 1,
        UseShaderForGeometryFieldId = DrawSkeletonFieldId         + 1,
        ModelVolumeFieldId          = UseShaderForGeometryFieldId + 1,
        NextFieldId                 = ModelVolumeFieldId          + 1
    };

    static const OSG::BitVector ModelFieldMask;
    static const OSG::BitVector CurrentAnimationFieldMask;
    static const OSG::BitVector BlendTimeFieldMask;
    static const OSG::BitVector DeltaFieldMask;
    static const OSG::BitVector TimeScaleFieldMask;
    static const OSG::BitVector DrawSkeletonFieldMask;
    static const OSG::BitVector UseShaderForGeometryFieldMask;
    static const OSG::BitVector ModelVolumeFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFCharacterModelPtr *getSFModel          (void);
           SFUInt32            *getSFCurrentAnimation(void);
           SFReal32            *getSFBlendTime      (void);
           SFReal32            *getSFDelta          (void);
           SFReal32            *getSFTimeScale      (void);
           SFBool              *getSFDrawSkeleton   (void);
           SFBool              *getSFUseShaderForGeometry(void);
           SFDynamicVolume     *getSFModelVolume    (void);

           CharacterModelPtr   &getModel          (void);
     const CharacterModelPtr   &getModel          (void) const;
           UInt32              &getCurrentAnimation(void);
     const UInt32              &getCurrentAnimation(void) const;
           Real32              &getBlendTime      (void);
     const Real32              &getBlendTime      (void) const;
           Real32              &getDelta          (void);
     const Real32              &getDelta          (void) const;
           Real32              &getTimeScale      (void);
     const Real32              &getTimeScale      (void) const;
           bool                &getDrawSkeleton   (void);
     const bool                &getDrawSkeleton   (void) const;
           bool                &getUseShaderForGeometry(void);
     const bool                &getUseShaderForGeometry(void) const;
           DynamicVolume       &getModelVolume    (void);
     const DynamicVolume       &getModelVolume    (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setModel          ( const CharacterModelPtr &value );
     void setCurrentAnimation( const UInt32 &value );
     void setBlendTime      ( const Real32 &value );
     void setDelta          ( const Real32 &value );
     void setTimeScale      ( const Real32 &value );
     void setDrawSkeleton   ( const bool &value );
     void setUseShaderForGeometry( const bool &value );
     void setModelVolume    ( const DynamicVolume &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  CharacterPtr      create          (void); 
    static  CharacterPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFCharacterModelPtr   _sfModel;
    SFUInt32            _sfCurrentAnimation;
    SFReal32            _sfBlendTime;
    SFReal32            _sfDelta;
    SFReal32            _sfTimeScale;
    SFBool              _sfDrawSkeleton;
    SFBool              _sfUseShaderForGeometry;
    SFDynamicVolume     _sfModelVolume;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    CharacterBase(void);
    CharacterBase(const CharacterBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~CharacterBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      CharacterBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      CharacterBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const CharacterBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef CharacterBase *CharacterBaseP;

typedef osgIF<CharacterBase::isNodeCore,
              CoredNodePtr<Character>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet CharacterNodePtr;

typedef RefPtr<CharacterPtr> CharacterRefPtr;

OSG_END_NAMESPACE

#define OSGCHARACTERBASE_HEADER_CVSID "@(#)$Id: OSGCharacterBase.h,v 1.2 2006/02/20 17:04:12 dirk Exp $"

#endif /* _OSGCHARACTERBASE_H_ */
