/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class BlendShapeDeformer
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGBLENDSHAPEDEFORMERBASE_H_
#define _OSGBLENDSHAPEDEFORMERBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGDeformer.h> // Parent

#include <OSGReal32Fields.h> // Weight type
#include <OSGUInt32Fields.h> // VertexIndices type
#include <OSGUInt16Fields.h> // TargetIndices type
#include <OSGPnt3fFields.h> // TargetVertices type
#include <OSGUInt32Fields.h> // NormalIndices type
#include <OSGUInt16Fields.h> // NormalTargetIndices type
#include <OSGVec3fFields.h> // TargetNormals type

#include <OSGBlendShapeDeformerFields.h>

OSG_BEGIN_NAMESPACE

class BlendShapeDeformer;
class BinaryDataHandler;

//! \brief BlendShapeDeformer Base Class.

class OSG_CONTRIBLIB_DLLMAPPING BlendShapeDeformerBase : public Deformer
{
  private:

    typedef Deformer    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef BlendShapeDeformerPtr  Ptr;

    enum
    {
        WeightFieldId              = Inherited::NextFieldId,
        VertexIndicesFieldId       = WeightFieldId              + 1,
        TargetIndicesFieldId       = VertexIndicesFieldId       + 1,
        TargetVerticesFieldId      = TargetIndicesFieldId       + 1,
        NormalIndicesFieldId       = TargetVerticesFieldId      + 1,
        NormalTargetIndicesFieldId = NormalIndicesFieldId       + 1,
        TargetNormalsFieldId       = NormalTargetIndicesFieldId + 1,
        NextFieldId                = TargetNormalsFieldId       + 1
    };

    static const OSG::BitVector WeightFieldMask;
    static const OSG::BitVector VertexIndicesFieldMask;
    static const OSG::BitVector TargetIndicesFieldMask;
    static const OSG::BitVector TargetVerticesFieldMask;
    static const OSG::BitVector NormalIndicesFieldMask;
    static const OSG::BitVector NormalTargetIndicesFieldMask;
    static const OSG::BitVector TargetNormalsFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           MFReal32            *getMFWeight         (void);
           MFUInt32            *getMFVertexIndices  (void);
           MFUInt16            *getMFTargetIndices  (void);
           MFPnt3f             *getMFTargetVertices (void);
           MFUInt32            *getMFNormalIndices  (void);
           MFUInt16            *getMFNormalTargetIndices(void);
           MFVec3f             *getMFTargetNormals  (void);

           Real32              &getWeight         (const UInt32 index);
           MFReal32            &getWeight         (void);
     const MFReal32            &getWeight         (void) const;
           UInt32              &getVertexIndices  (const UInt32 index);
           MFUInt32            &getVertexIndices  (void);
     const MFUInt32            &getVertexIndices  (void) const;
           UInt16              &getTargetIndices  (const UInt32 index);
           MFUInt16            &getTargetIndices  (void);
     const MFUInt16            &getTargetIndices  (void) const;
           Pnt3f               &getTargetVertices (const UInt32 index);
           MFPnt3f             &getTargetVertices (void);
     const MFPnt3f             &getTargetVertices (void) const;
           UInt32              &getNormalIndices  (const UInt32 index);
           MFUInt32            &getNormalIndices  (void);
     const MFUInt32            &getNormalIndices  (void) const;
           UInt16              &getNormalTargetIndices(const UInt32 index);
           MFUInt16            &getNormalTargetIndices(void);
     const MFUInt16            &getNormalTargetIndices(void) const;
           Vec3f               &getTargetNormals  (const UInt32 index);
           MFVec3f             &getTargetNormals  (void);
     const MFVec3f             &getTargetNormals  (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  BlendShapeDeformerPtr      create          (void); 
    static  BlendShapeDeformerPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    MFReal32            _mfWeight;
    MFUInt32            _mfVertexIndices;
    MFUInt16            _mfTargetIndices;
    MFPnt3f             _mfTargetVertices;
    MFUInt32            _mfNormalIndices;
    MFUInt16            _mfNormalTargetIndices;
    MFVec3f             _mfTargetNormals;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    BlendShapeDeformerBase(void);
    BlendShapeDeformerBase(const BlendShapeDeformerBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~BlendShapeDeformerBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      BlendShapeDeformerBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      BlendShapeDeformerBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const BlendShapeDeformerBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef BlendShapeDeformerBase *BlendShapeDeformerBaseP;

typedef osgIF<BlendShapeDeformerBase::isNodeCore,
              CoredNodePtr<BlendShapeDeformer>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet BlendShapeDeformerNodePtr;

typedef RefPtr<BlendShapeDeformerPtr> BlendShapeDeformerRefPtr;

OSG_END_NAMESPACE

#define OSGBLENDSHAPEDEFORMERBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGBLENDSHAPEDEFORMERBASE_H_ */
