/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DeformableGeometry!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDEFORMABLEGEOMETRYINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDeformableGeometryBase.h"
#include "OSGDeformableGeometry.h"


OSG_USING_NAMESPACE

const OSG::BitVector  DeformableGeometryBase::DeformersFieldMask = 
    (TypeTraits<BitVector>::One << DeformableGeometryBase::DeformersFieldId);

const OSG::BitVector  DeformableGeometryBase::BasePositionsFieldMask = 
    (TypeTraits<BitVector>::One << DeformableGeometryBase::BasePositionsFieldId);

const OSG::BitVector  DeformableGeometryBase::BaseNormalsFieldMask = 
    (TypeTraits<BitVector>::One << DeformableGeometryBase::BaseNormalsFieldId);

const OSG::BitVector DeformableGeometryBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var DeformerPtr     DeformableGeometryBase::_mfDeformers
    Array of deformers that are executed in the given order to modify geometry properties.
*/
/*! \var GeoPositionsPtr DeformableGeometryBase::_sfBasePositions
    Base vertex positions before geometry is deformed.
*/
/*! \var GeoNormalsPtr   DeformableGeometryBase::_sfBaseNormals
    Base vertex normals before geometry is deformed.
*/

//! DeformableGeometry description

FieldDescription *DeformableGeometryBase::_desc[] = 
{
    new FieldDescription(MFDeformerPtr::getClassType(), 
                     "deformers", 
                     DeformersFieldId, DeformersFieldMask,
                     false,
                     (FieldAccessMethod) &DeformableGeometryBase::getMFDeformers),
    new FieldDescription(SFGeoPositionsPtr::getClassType(), 
                     "basePositions", 
                     BasePositionsFieldId, BasePositionsFieldMask,
                     false,
                     (FieldAccessMethod) &DeformableGeometryBase::getSFBasePositions),
    new FieldDescription(SFGeoNormalsPtr::getClassType(), 
                     "baseNormals", 
                     BaseNormalsFieldId, BaseNormalsFieldMask,
                     false,
                     (FieldAccessMethod) &DeformableGeometryBase::getSFBaseNormals)
};


FieldContainerType DeformableGeometryBase::_type(
    "DeformableGeometry",
    "Geometry",
    NULL,
    (PrototypeCreateF) &DeformableGeometryBase::createEmpty,
    DeformableGeometry::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DeformableGeometryBase, DeformableGeometryPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DeformableGeometryBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DeformableGeometryBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr DeformableGeometryBase::shallowCopy(void) const 
{ 
    DeformableGeometryPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const DeformableGeometry *>(this)); 

    return returnValue; 
}

UInt32 DeformableGeometryBase::getContainerSize(void) const 
{ 
    return sizeof(DeformableGeometry); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DeformableGeometryBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DeformableGeometryBase *) &other, whichField);
}
#else
void DeformableGeometryBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DeformableGeometryBase *) &other, whichField, sInfo);
}
void DeformableGeometryBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DeformableGeometryBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfDeformers.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DeformableGeometryBase::DeformableGeometryBase(void) :
    _mfDeformers              (), 
    _sfBasePositions          (), 
    _sfBaseNormals            (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DeformableGeometryBase::DeformableGeometryBase(const DeformableGeometryBase &source) :
    _mfDeformers              (source._mfDeformers              ), 
    _sfBasePositions          (source._sfBasePositions          ), 
    _sfBaseNormals            (source._sfBaseNormals            ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DeformableGeometryBase::~DeformableGeometryBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DeformableGeometryBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (DeformersFieldMask & whichField))
    {
        returnValue += _mfDeformers.getBinSize();
    }

    if(FieldBits::NoField != (BasePositionsFieldMask & whichField))
    {
        returnValue += _sfBasePositions.getBinSize();
    }

    if(FieldBits::NoField != (BaseNormalsFieldMask & whichField))
    {
        returnValue += _sfBaseNormals.getBinSize();
    }


    return returnValue;
}

void DeformableGeometryBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (DeformersFieldMask & whichField))
    {
        _mfDeformers.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BasePositionsFieldMask & whichField))
    {
        _sfBasePositions.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BaseNormalsFieldMask & whichField))
    {
        _sfBaseNormals.copyToBin(pMem);
    }


}

void DeformableGeometryBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (DeformersFieldMask & whichField))
    {
        _mfDeformers.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BasePositionsFieldMask & whichField))
    {
        _sfBasePositions.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BaseNormalsFieldMask & whichField))
    {
        _sfBaseNormals.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DeformableGeometryBase::executeSyncImpl(      DeformableGeometryBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (DeformersFieldMask & whichField))
        _mfDeformers.syncWith(pOther->_mfDeformers);

    if(FieldBits::NoField != (BasePositionsFieldMask & whichField))
        _sfBasePositions.syncWith(pOther->_sfBasePositions);

    if(FieldBits::NoField != (BaseNormalsFieldMask & whichField))
        _sfBaseNormals.syncWith(pOther->_sfBaseNormals);


}
#else
void DeformableGeometryBase::executeSyncImpl(      DeformableGeometryBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (BasePositionsFieldMask & whichField))
        _sfBasePositions.syncWith(pOther->_sfBasePositions);

    if(FieldBits::NoField != (BaseNormalsFieldMask & whichField))
        _sfBaseNormals.syncWith(pOther->_sfBaseNormals);


    if(FieldBits::NoField != (DeformersFieldMask & whichField))
        _mfDeformers.syncWith(pOther->_mfDeformers, sInfo);


}

void DeformableGeometryBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (DeformersFieldMask & whichField))
        _mfDeformers.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DeformableGeometryPtr>::_type("DeformableGeometryPtr", "GeometryPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(DeformableGeometryPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(DeformableGeometryPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGDEFORMABLEGEOMETRYBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDEFORMABLEGEOMETRYBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDEFORMABLEGEOMETRYFIELDS_HEADER_CVSID;
}

