/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsGeom!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &PhysicsGeomBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 PhysicsGeomBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
PhysicsGeomPtr PhysicsGeomBase::create(void) 
{
    PhysicsGeomPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = PhysicsGeomPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
PhysicsGeomPtr PhysicsGeomBase::createEmpty(void) 
{ 
    PhysicsGeomPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the PhysicsGeom::_sfBody field.
inline
SFPhysicsBodyPtr *PhysicsGeomBase::getSFBody(void)
{
    return &_sfBody;
}

//! Get the PhysicsGeom::_sfPosition field.
inline
SFVec3f *PhysicsGeomBase::getSFPosition(void)
{
    return &_sfPosition;
}

//! Get the PhysicsGeom::_sfRotation field.
inline
SFMatrix *PhysicsGeomBase::getSFRotation(void)
{
    return &_sfRotation;
}

//! Get the PhysicsGeom::_sfQuaternion field.
inline
SFQuaternion *PhysicsGeomBase::getSFQuaternion(void)
{
    return &_sfQuaternion;
}

//! Get the PhysicsGeom::_sfCategoryBits field.
inline
SFUInt64 *PhysicsGeomBase::getSFCategoryBits(void)
{
    return &_sfCategoryBits;
}

//! Get the PhysicsGeom::_sfCollideBits field.
inline
SFUInt64 *PhysicsGeomBase::getSFCollideBits(void)
{
    return &_sfCollideBits;
}

//! Get the PhysicsGeom::_sfSpace field.
inline
SFPhysicsSpacePtr *PhysicsGeomBase::getSFSpace(void)
{
    return &_sfSpace;
}

//! Get the PhysicsGeom::_sfEnable field.
inline
SFBool *PhysicsGeomBase::getSFEnable(void)
{
    return &_sfEnable;
}


//! Get the value of the PhysicsGeom::_sfBody field.
inline
PhysicsBodyPtr &PhysicsGeomBase::getBody(void)
{
    return _sfBody.getValue();
}

//! Get the value of the PhysicsGeom::_sfBody field.
inline
const PhysicsBodyPtr &PhysicsGeomBase::getBody(void) const
{
    return _sfBody.getValue();
}

//! Set the value of the PhysicsGeom::_sfBody field.
inline
void PhysicsGeomBase::setBody(const PhysicsBodyPtr &value)
{
    _sfBody.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfPosition field.
inline
Vec3f &PhysicsGeomBase::getPosition(void)
{
    return _sfPosition.getValue();
}

//! Get the value of the PhysicsGeom::_sfPosition field.
inline
const Vec3f &PhysicsGeomBase::getPosition(void) const
{
    return _sfPosition.getValue();
}

//! Set the value of the PhysicsGeom::_sfPosition field.
inline
void PhysicsGeomBase::setPosition(const Vec3f &value)
{
    _sfPosition.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfRotation field.
inline
Matrix &PhysicsGeomBase::getRotation(void)
{
    return _sfRotation.getValue();
}

//! Get the value of the PhysicsGeom::_sfRotation field.
inline
const Matrix &PhysicsGeomBase::getRotation(void) const
{
    return _sfRotation.getValue();
}

//! Set the value of the PhysicsGeom::_sfRotation field.
inline
void PhysicsGeomBase::setRotation(const Matrix &value)
{
    _sfRotation.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfQuaternion field.
inline
Quaternion &PhysicsGeomBase::getQuaternion(void)
{
    return _sfQuaternion.getValue();
}

//! Get the value of the PhysicsGeom::_sfQuaternion field.
inline
const Quaternion &PhysicsGeomBase::getQuaternion(void) const
{
    return _sfQuaternion.getValue();
}

//! Set the value of the PhysicsGeom::_sfQuaternion field.
inline
void PhysicsGeomBase::setQuaternion(const Quaternion &value)
{
    _sfQuaternion.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfCategoryBits field.
inline
UInt64 &PhysicsGeomBase::getCategoryBits(void)
{
    return _sfCategoryBits.getValue();
}

//! Get the value of the PhysicsGeom::_sfCategoryBits field.
inline
const UInt64 &PhysicsGeomBase::getCategoryBits(void) const
{
    return _sfCategoryBits.getValue();
}

//! Set the value of the PhysicsGeom::_sfCategoryBits field.
inline
void PhysicsGeomBase::setCategoryBits(const UInt64 &value)
{
    _sfCategoryBits.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfCollideBits field.
inline
UInt64 &PhysicsGeomBase::getCollideBits(void)
{
    return _sfCollideBits.getValue();
}

//! Get the value of the PhysicsGeom::_sfCollideBits field.
inline
const UInt64 &PhysicsGeomBase::getCollideBits(void) const
{
    return _sfCollideBits.getValue();
}

//! Set the value of the PhysicsGeom::_sfCollideBits field.
inline
void PhysicsGeomBase::setCollideBits(const UInt64 &value)
{
    _sfCollideBits.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfSpace field.
inline
PhysicsSpacePtr &PhysicsGeomBase::getSpace(void)
{
    return _sfSpace.getValue();
}

//! Get the value of the PhysicsGeom::_sfSpace field.
inline
const PhysicsSpacePtr &PhysicsGeomBase::getSpace(void) const
{
    return _sfSpace.getValue();
}

//! Set the value of the PhysicsGeom::_sfSpace field.
inline
void PhysicsGeomBase::setSpace(const PhysicsSpacePtr &value)
{
    _sfSpace.setValue(value);
}

//! Get the value of the PhysicsGeom::_sfEnable field.
inline
bool &PhysicsGeomBase::getEnable(void)
{
    return _sfEnable.getValue();
}

//! Get the value of the PhysicsGeom::_sfEnable field.
inline
const bool &PhysicsGeomBase::getEnable(void) const
{
    return _sfEnable.getValue();
}

//! Set the value of the PhysicsGeom::_sfEnable field.
inline
void PhysicsGeomBase::setEnable(const bool &value)
{
    _sfEnable.setValue(value);
}


OSG_END_NAMESPACE

#define OSGPHYSICSGEOMBASE_INLINE_CVSID "@(#)$Id: OSGPhysicsGeomBase.inl,v 1.2 2006/02/20 17:04:21 dirk Exp $"

