/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class IntersectActor
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

//----------------------------------------------------------------------------
//    Includes
//----------------------------------------------------------------------------

#include <OSGConfig.h>
#include <OSGNodeCore.h>

#include "OSGIntersectActorBase.h"

OSG_USING_NAMESPACE

//----------------------------------------------------------------------------
//    Static Member Init
//----------------------------------------------------------------------------

IntersectActorBase::EnterStoreType *IntersectActorBase::_pClassEnterStore = NULL;
IntersectActorBase::LeaveStoreType *IntersectActorBase::_pClassLeaveStore = NULL;

//----------------------------------------------------------------------------
//    Destructor
//----------------------------------------------------------------------------

/*! Destructor.
 */

IntersectActorBase::~IntersectActorBase(void)
{
}

//----------------------------------------------------------------------------
//    Start/Stop
//----------------------------------------------------------------------------

/*! Called before a traversal begins. This method can be overridden in derived
 *  classes, but the inherited version must be called.
 */

IntersectActorBase::ResultE
IntersectActorBase::start(void)
{
    return BasicActorBase::start();
}

/*! Called after a traversal ends. This method can be overridden in derived
 *  classes, but the inherited version must be called.
 */

IntersectActorBase::ResultE
IntersectActorBase::stop(void)
{
    return BasicActorBase::stop();
}

//----------------------------------------------------------------------------
//    Enter/Leave
//----------------------------------------------------------------------------

/*! This method is called when a node is entered. This method can be overridden
 *  in derived classes, but the inherited version should be called if there is
 *  nothing to do for the node.
 */

IntersectActorBase::ResultE
IntersectActorBase::enterNode(FunctorArgumentType &funcArg)
{
    ResultE      result    = NewActionTypes::Continue;
    NodeCorePtr  pNodeCore = funcArg.getNode()->getCore();
    Functor     *pFunc     = NULL;

    if((pFunc = _instanceEnterStore.getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else if((pFunc = _pClassEnterStore->getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else
    {
        result = BasicActorBase::enterNode(funcArg);
    }

    return result;
}

/*! This method is called when a node is left. This method can be overridden
 *  in derived classes, but the inherited version should be called if there is
 *  nothing to do for the node.
 */

IntersectActorBase::ResultE
IntersectActorBase::leaveNode(FunctorArgumentType &funcArg)
{
    ResultE      result    = NewActionTypes::Continue;
    NodeCorePtr  pNodeCore = funcArg.getNode()->getCore();
    Functor     *pFunc     = NULL;

    if((pFunc = _instanceLeaveStore.getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else if((pFunc = _pClassLeaveStore->getFunctor(pNodeCore->getType())) != NULL)
    {
        result = pFunc->call(pNodeCore, funcArg);
    }
    else
    {
        result = BasicActorBase::leaveNode(funcArg);
    }

    return result;
}

//----------------------------------------------------------------------------
//    Enter Registration
//----------------------------------------------------------------------------


/*! Register a functor that is used by all instances of this class, when
 *  entering a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 */

void
IntersectActorBase::regClassEnter(const Functor            &refFunc,
                                  const FieldContainerType &refType )
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->regFunctor(refFunc, refType);
}

/*! Register a functor that is used by the instance of this class, when
 *  entering a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 *  Instance functors take priority over class functors.
 */

void
IntersectActorBase::regEnter(const Functor            &refFunc,
                             const FieldContainerType &refType )
{
    _instanceEnterStore.regFunctor(refFunc, refType);
}

/*! Register a functor that is used by all instances of this class, when
 *  entering a node with a core for which no specific functor was registerd.
 */

void
IntersectActorBase::regDefaultClassEnter(const Functor &refFunc)
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->regDefaultFunctor(refFunc);
}

/*! Register a functor that is used by the instance of this class, when
 *  entering a node with a core for which no specific functor was registerd.
 *  Instance functors take priority over class functors.
 */

void
IntersectActorBase::regDefaultEnter(const Functor &refFunc)
{
    _instanceEnterStore.regDefaultFunctor(refFunc);
}

/*! Remove a functor registered with regClassEnter.
 */

void
IntersectActorBase::unregClassEnter(const FieldContainerType &refType)
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->unregFunctor(refType);
}

/*! Remove a functor registered with regEnter.
 */

void
IntersectActorBase::unregEnter(const FieldContainerType &refType)
{
    _instanceEnterStore.unregFunctor(refType);
}

/*! Remove the functor registered with regDefaultClassEnter.
 */

void
IntersectActorBase::unregDefaultClassEnter(void)
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    _pClassEnterStore->unregDefaultFunctor();
}

/*! Remove the functor registered with regDefaultEnter.
 */

void
IntersectActorBase::unregDefaultEnter(void)
{
    _instanceEnterStore.unregDefaultFunctor();
}

//----------------------------------------------------------------------------
//    Leave Registration
//----------------------------------------------------------------------------

/*! Register a functor that is used by all instances of this class, when
 *  leaveing a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 */

void
IntersectActorBase::regClassLeave(const Functor            &refFunc,
                                 const FieldContainerType &refType )
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->regFunctor(refFunc, refType);
}

/*! Register a functor that is used by the instance of this class, when
 *  leaveing a node with a core of the specified type.
 *  For every type of NodeCore a different functor can be registerd.
 *  Instance functors take priority over class functors.
 */

void
IntersectActorBase::regLeave(const Functor            &refFunc,
                            const FieldContainerType &refType )
{
    _instanceLeaveStore.regFunctor(refFunc, refType);
}

/*! Register a functor that is used by all instances of this class, when
 *  leaveing a node with a core for which no specific functor was registerd.
 */

void
IntersectActorBase::regDefaultClassLeave(const Functor &refFunc)
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->regDefaultFunctor(refFunc);
}

/*! Register a functor that is used by the instance of this class, when
 *  leaveing a node with a core for which no specific functor was registerd.
 *  Instance functors take priority over class functors.
 */

void
IntersectActorBase::regDefaultLeave(const Functor &refFunc)
{
    _instanceLeaveStore.regDefaultFunctor(refFunc);
}

/*! Remove a functor registered with regClassLeave.
 */

void
IntersectActorBase::unregClassLeave(const FieldContainerType &refType)
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->unregFunctor(refType);
}

/*! Remove a functor registered with regLeave.
 */

void
IntersectActorBase::unregLeave(const FieldContainerType &refType)
{
    _instanceLeaveStore.unregFunctor(refType);
}

/*! Remove the functor registered with regDefaultClassLeave.
 */

void
IntersectActorBase::unregDefaultClassLeave(void)
{
    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    _pClassLeaveStore->unregDefaultFunctor();
}

/*! Remove the functor registered with regDefaultLeave.
 */

void
IntersectActorBase::unregDefaultLeave(void)
{
    _instanceLeaveStore.unregDefaultFunctor();
}

//----------------------------------------------------------------------------
//    State Management
//----------------------------------------------------------------------------

#ifdef OSG_NEWACTION_STATESLOTINTERFACE

UInt32
IntersectActorBase::createStateClone(void)
{
    UInt32     stateSlot = getSlotMap   (               ).size();
    StateType *pClone    = new StateType(*getCastState());

    getSlotMap().push_back(pClone);

    setState(pClone);

    return stateSlot;
}

#else /* OSG_NEWACTION_STATESLOTINTERFACE */

IntersectActorBase::ActorBaseState *
IntersectActorBase::createStateClone(void)
{
    StateType *pClone = new StateType(*getCastState());

    setState(pClone);

    return pClone;
}

#endif /* OSG_NEWACTION_STATESLOTINTERFACE */

#ifdef OSG_NEWACTION_STATESLOTINTERFACE

void
IntersectActorBase::destroyStateClone(UInt32 slotId)
{
    delete getSlotMap()[slotId];
}

#else /* OSG_NEWACTION_STATESLOTINTERFACE */

void
IntersectActorBase::destroyStateClone(ActorBaseState *pState)
{
    delete pState;
}

#endif /* OSG_NEWACTION_STATESLOTINTERFACE */

void
IntersectActorBase::createInitialState(void)
{
    if(getState() != NULL)
    {
        SWARNING << "IntersectActorBase::createInitialState: State is not NULL."
                 << endLog;
    }

    setState(new StateType());
}

void
IntersectActorBase::deleteInitialState(void)
{
    if(getState() == NULL)
    {
        SWARNING << "IntersectActorBase::deleteInitalState: State is NULL."
                 << endLog;
    }

    delete getState();

    setState(NULL);
}


//----------------------------------------------------------------------------
//    State Class
//----------------------------------------------------------------------------

/*! Destructor.
 */

IntersectActorBase::IntersectActorBaseState::~IntersectActorBaseState(void)
{
}

//----------------------------------------------------------------------------
//    Constructors
//----------------------------------------------------------------------------

/*! Default Constructor.
 */

IntersectActorBase::IntersectActorBase(void)
    : Inherited(),
      _stateHitDistance(0.0),
      _stateHit(false),
      _stateHitObject(NullFC),
      _stateHitTriangleIndex(0),
      _stateHitNormal(),
      _stateMaxDistance(),
      _instanceEnterStore(),
      _instanceLeaveStore()
{
    if(_pClassEnterStore == NULL)
        _pClassEnterStore = new EnterStoreType();

    if(_pClassLeaveStore == NULL)
        _pClassLeaveStore = new LeaveStoreType();

    setEnterNodeFlag(true);
    setLeaveNodeFlag(true);
}

//----------------------------------------------------------------------------
//    Event Notification
//----------------------------------------------------------------------------

/*! Called when the actor is attached to an action. This method can
 *  be overridden in derived classes, but the inherited version must be called.
 */

void
IntersectActorBase::addEvent(NewActionBase *pAction, UInt32 uiActorId)
{
    Inherited::addEvent(pAction, uiActorId);
}

/*! Called when the actor is detached from an action. This method can
 *  be overridden in derived classes, but the inherited version must be called.
 */

void
IntersectActorBase::subEvent(NewActionBase *pAction, UInt32 uiActorId)
{
    Inherited::subEvent(pAction, uiActorId);
}

/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning(disable : 177)
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGIntersectActorBase.cpp,v 1.6 2004/09/17 14:09:47 neumannc Exp $";
    static Char8 cvsid_hpp       [] = OSGINTERSECTACTORBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGINTERSECTACTORBASE_INLINE_CVSID;
}

#ifdef OSG_LINUX_ICC
#pragma warning(enable : 177)
#endif

#ifdef OSG_SGI_CC
#pragma reset woff 1174
#endif
