/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ShadowMapViewport!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESHADOWMAPVIEWPORTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGShadowMapViewportBase.h"
#include "OSGShadowMapViewport.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  ShadowMapViewportBase::OffBiasFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::OffBiasFieldId);

const OSG::BitVector  ShadowMapViewportBase::OffFactorFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::OffFactorFieldId);

const OSG::BitVector  ShadowMapViewportBase::SceneRootFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::SceneRootFieldId);

const OSG::BitVector  ShadowMapViewportBase::ShadowColorFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::ShadowColorFieldId);

const OSG::BitVector  ShadowMapViewportBase::MapSizeFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::MapSizeFieldId);

const OSG::BitVector  ShadowMapViewportBase::LightNodesFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::LightNodesFieldId);

const OSG::BitVector  ShadowMapViewportBase::ExcludeNodesFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::ExcludeNodesFieldId);

const OSG::BitVector  ShadowMapViewportBase::ShadowOnFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::ShadowOnFieldId);

const OSG::BitVector  ShadowMapViewportBase::MapAutoUpdateFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::MapAutoUpdateFieldId);

const OSG::BitVector  ShadowMapViewportBase::ShadowMapTextureIndexFieldMask = 
    (TypeTraits<BitVector>::One << ShadowMapViewportBase::ShadowMapTextureIndexFieldId);

const OSG::BitVector ShadowMapViewportBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Real32          ShadowMapViewportBase::_sfOffBias
    Offset-Bias for Polygon-Offset. Needs to be used with Polygon-Chunk
*/
/*! \var Real32          ShadowMapViewportBase::_sfOffFactor
    Offset-Factor for Polygon-Offset. Needs to be used with Polygon-Chunk
*/
/*! \var NodePtr         ShadowMapViewportBase::_sfSceneRoot
    Scene root node.
*/
/*! \var Color4f         ShadowMapViewportBase::_sfShadowColor
    
*/
/*! \var UInt32          ShadowMapViewportBase::_sfMapSize
    
*/
/*! \var NodePtr         ShadowMapViewportBase::_mfLightNodes
    
*/
/*! \var NodePtr         ShadowMapViewportBase::_mfExcludeNodes
    
*/
/*! \var bool            ShadowMapViewportBase::_sfShadowOn
    
*/
/*! \var bool            ShadowMapViewportBase::_sfMapAutoUpdate
    
*/
/*! \var UInt32          ShadowMapViewportBase::_sfShadowMapTextureIndex
    Renders the shadow map in texture unit x default is 3.
*/

//! ShadowMapViewport description

FieldDescription *ShadowMapViewportBase::_desc[] = 
{
    new FieldDescription(SFReal32::getClassType(), 
                     "offBias", 
                     OffBiasFieldId, OffBiasFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFOffBias),
    new FieldDescription(SFReal32::getClassType(), 
                     "offFactor", 
                     OffFactorFieldId, OffFactorFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFOffFactor),
    new FieldDescription(SFNodePtr::getClassType(), 
                     "sceneRoot", 
                     SceneRootFieldId, SceneRootFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFSceneRoot),
    new FieldDescription(SFColor4f::getClassType(), 
                     "shadowColor", 
                     ShadowColorFieldId, ShadowColorFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFShadowColor),
    new FieldDescription(SFUInt32::getClassType(), 
                     "mapSize", 
                     MapSizeFieldId, MapSizeFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFMapSize),
    new FieldDescription(MFNodePtr::getClassType(), 
                     "lightNodes", 
                     LightNodesFieldId, LightNodesFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getMFLightNodes),
    new FieldDescription(MFNodePtr::getClassType(), 
                     "excludeNodes", 
                     ExcludeNodesFieldId, ExcludeNodesFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getMFExcludeNodes),
    new FieldDescription(SFBool::getClassType(), 
                     "shadowOn", 
                     ShadowOnFieldId, ShadowOnFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFShadowOn),
    new FieldDescription(SFBool::getClassType(), 
                     "mapAutoUpdate", 
                     MapAutoUpdateFieldId, MapAutoUpdateFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFMapAutoUpdate),
    new FieldDescription(SFUInt32::getClassType(), 
                     "shadowMapTextureIndex", 
                     ShadowMapTextureIndexFieldId, ShadowMapTextureIndexFieldMask,
                     false,
                     (FieldAccessMethod) &ShadowMapViewportBase::getSFShadowMapTextureIndex)
};


FieldContainerType ShadowMapViewportBase::_type(
    "ShadowMapViewport",
    "StereoBufferViewport",
    NULL,
    (PrototypeCreateF) &ShadowMapViewportBase::createEmpty,
    ShadowMapViewport::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ShadowMapViewportBase, ShadowMapViewportPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ShadowMapViewportBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ShadowMapViewportBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ShadowMapViewportBase::shallowCopy(void) const 
{ 
    ShadowMapViewportPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ShadowMapViewport *>(this)); 

    return returnValue; 
}

UInt32 ShadowMapViewportBase::getContainerSize(void) const 
{ 
    return sizeof(ShadowMapViewport); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ShadowMapViewportBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ShadowMapViewportBase *) &other, whichField);
}
#else
void ShadowMapViewportBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ShadowMapViewportBase *) &other, whichField, sInfo);
}
void ShadowMapViewportBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ShadowMapViewportBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfLightNodes.terminateShare(uiAspect, this->getContainerSize());
    _mfExcludeNodes.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ShadowMapViewportBase::ShadowMapViewportBase(void) :
    _sfOffBias                (Real32(4)), 
    _sfOffFactor              (Real32(10)), 
    _sfSceneRoot              (), 
    _sfShadowColor            (Color4f(0,0,0,1)), 
    _sfMapSize                (UInt32(512)), 
    _mfLightNodes             (), 
    _mfExcludeNodes           (), 
    _sfShadowOn               (bool(true)), 
    _sfMapAutoUpdate          (bool(true)), 
    _sfShadowMapTextureIndex  (UInt32(3)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ShadowMapViewportBase::ShadowMapViewportBase(const ShadowMapViewportBase &source) :
    _sfOffBias                (source._sfOffBias                ), 
    _sfOffFactor              (source._sfOffFactor              ), 
    _sfSceneRoot              (source._sfSceneRoot              ), 
    _sfShadowColor            (source._sfShadowColor            ), 
    _sfMapSize                (source._sfMapSize                ), 
    _mfLightNodes             (source._mfLightNodes             ), 
    _mfExcludeNodes           (source._mfExcludeNodes           ), 
    _sfShadowOn               (source._sfShadowOn               ), 
    _sfMapAutoUpdate          (source._sfMapAutoUpdate          ), 
    _sfShadowMapTextureIndex  (source._sfShadowMapTextureIndex  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ShadowMapViewportBase::~ShadowMapViewportBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ShadowMapViewportBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (OffBiasFieldMask & whichField))
    {
        returnValue += _sfOffBias.getBinSize();
    }

    if(FieldBits::NoField != (OffFactorFieldMask & whichField))
    {
        returnValue += _sfOffFactor.getBinSize();
    }

    if(FieldBits::NoField != (SceneRootFieldMask & whichField))
    {
        returnValue += _sfSceneRoot.getBinSize();
    }

    if(FieldBits::NoField != (ShadowColorFieldMask & whichField))
    {
        returnValue += _sfShadowColor.getBinSize();
    }

    if(FieldBits::NoField != (MapSizeFieldMask & whichField))
    {
        returnValue += _sfMapSize.getBinSize();
    }

    if(FieldBits::NoField != (LightNodesFieldMask & whichField))
    {
        returnValue += _mfLightNodes.getBinSize();
    }

    if(FieldBits::NoField != (ExcludeNodesFieldMask & whichField))
    {
        returnValue += _mfExcludeNodes.getBinSize();
    }

    if(FieldBits::NoField != (ShadowOnFieldMask & whichField))
    {
        returnValue += _sfShadowOn.getBinSize();
    }

    if(FieldBits::NoField != (MapAutoUpdateFieldMask & whichField))
    {
        returnValue += _sfMapAutoUpdate.getBinSize();
    }

    if(FieldBits::NoField != (ShadowMapTextureIndexFieldMask & whichField))
    {
        returnValue += _sfShadowMapTextureIndex.getBinSize();
    }


    return returnValue;
}

void ShadowMapViewportBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (OffBiasFieldMask & whichField))
    {
        _sfOffBias.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OffFactorFieldMask & whichField))
    {
        _sfOffFactor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SceneRootFieldMask & whichField))
    {
        _sfSceneRoot.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShadowColorFieldMask & whichField))
    {
        _sfShadowColor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MapSizeFieldMask & whichField))
    {
        _sfMapSize.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LightNodesFieldMask & whichField))
    {
        _mfLightNodes.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ExcludeNodesFieldMask & whichField))
    {
        _mfExcludeNodes.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShadowOnFieldMask & whichField))
    {
        _sfShadowOn.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MapAutoUpdateFieldMask & whichField))
    {
        _sfMapAutoUpdate.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShadowMapTextureIndexFieldMask & whichField))
    {
        _sfShadowMapTextureIndex.copyToBin(pMem);
    }


}

void ShadowMapViewportBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (OffBiasFieldMask & whichField))
    {
        _sfOffBias.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OffFactorFieldMask & whichField))
    {
        _sfOffFactor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SceneRootFieldMask & whichField))
    {
        _sfSceneRoot.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShadowColorFieldMask & whichField))
    {
        _sfShadowColor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MapSizeFieldMask & whichField))
    {
        _sfMapSize.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LightNodesFieldMask & whichField))
    {
        _mfLightNodes.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ExcludeNodesFieldMask & whichField))
    {
        _mfExcludeNodes.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShadowOnFieldMask & whichField))
    {
        _sfShadowOn.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MapAutoUpdateFieldMask & whichField))
    {
        _sfMapAutoUpdate.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShadowMapTextureIndexFieldMask & whichField))
    {
        _sfShadowMapTextureIndex.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ShadowMapViewportBase::executeSyncImpl(      ShadowMapViewportBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (OffBiasFieldMask & whichField))
        _sfOffBias.syncWith(pOther->_sfOffBias);

    if(FieldBits::NoField != (OffFactorFieldMask & whichField))
        _sfOffFactor.syncWith(pOther->_sfOffFactor);

    if(FieldBits::NoField != (SceneRootFieldMask & whichField))
        _sfSceneRoot.syncWith(pOther->_sfSceneRoot);

    if(FieldBits::NoField != (ShadowColorFieldMask & whichField))
        _sfShadowColor.syncWith(pOther->_sfShadowColor);

    if(FieldBits::NoField != (MapSizeFieldMask & whichField))
        _sfMapSize.syncWith(pOther->_sfMapSize);

    if(FieldBits::NoField != (LightNodesFieldMask & whichField))
        _mfLightNodes.syncWith(pOther->_mfLightNodes);

    if(FieldBits::NoField != (ExcludeNodesFieldMask & whichField))
        _mfExcludeNodes.syncWith(pOther->_mfExcludeNodes);

    if(FieldBits::NoField != (ShadowOnFieldMask & whichField))
        _sfShadowOn.syncWith(pOther->_sfShadowOn);

    if(FieldBits::NoField != (MapAutoUpdateFieldMask & whichField))
        _sfMapAutoUpdate.syncWith(pOther->_sfMapAutoUpdate);

    if(FieldBits::NoField != (ShadowMapTextureIndexFieldMask & whichField))
        _sfShadowMapTextureIndex.syncWith(pOther->_sfShadowMapTextureIndex);


}
#else
void ShadowMapViewportBase::executeSyncImpl(      ShadowMapViewportBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (OffBiasFieldMask & whichField))
        _sfOffBias.syncWith(pOther->_sfOffBias);

    if(FieldBits::NoField != (OffFactorFieldMask & whichField))
        _sfOffFactor.syncWith(pOther->_sfOffFactor);

    if(FieldBits::NoField != (SceneRootFieldMask & whichField))
        _sfSceneRoot.syncWith(pOther->_sfSceneRoot);

    if(FieldBits::NoField != (ShadowColorFieldMask & whichField))
        _sfShadowColor.syncWith(pOther->_sfShadowColor);

    if(FieldBits::NoField != (MapSizeFieldMask & whichField))
        _sfMapSize.syncWith(pOther->_sfMapSize);

    if(FieldBits::NoField != (ShadowOnFieldMask & whichField))
        _sfShadowOn.syncWith(pOther->_sfShadowOn);

    if(FieldBits::NoField != (MapAutoUpdateFieldMask & whichField))
        _sfMapAutoUpdate.syncWith(pOther->_sfMapAutoUpdate);

    if(FieldBits::NoField != (ShadowMapTextureIndexFieldMask & whichField))
        _sfShadowMapTextureIndex.syncWith(pOther->_sfShadowMapTextureIndex);


    if(FieldBits::NoField != (LightNodesFieldMask & whichField))
        _mfLightNodes.syncWith(pOther->_mfLightNodes, sInfo);

    if(FieldBits::NoField != (ExcludeNodesFieldMask & whichField))
        _mfExcludeNodes.syncWith(pOther->_mfExcludeNodes, sInfo);


}

void ShadowMapViewportBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (LightNodesFieldMask & whichField))
        _mfLightNodes.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ExcludeNodesFieldMask & whichField))
        _mfExcludeNodes.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ShadowMapViewportPtr>::_type("ShadowMapViewportPtr", "StereoBufferViewportPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ShadowMapViewportPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ShadowMapViewportPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGShadowMapViewportBase.cpp,v 1.13 2006/07/27 13:43:08 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGSHADOWMAPVIEWPORTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSHADOWMAPVIEWPORTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSHADOWMAPVIEWPORTFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

