/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Image!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEIMAGEINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGImageBase.h"
#include "OSGImage.h"

#include <OSGGL.h>                        // DataType default header

OSG_BEGIN_NAMESPACE

const OSG::BitVector  ImageBase::ParentsFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ParentsFieldId);

const OSG::BitVector  ImageBase::DimensionFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::DimensionFieldId);

const OSG::BitVector  ImageBase::WidthFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::WidthFieldId);

const OSG::BitVector  ImageBase::HeightFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::HeightFieldId);

const OSG::BitVector  ImageBase::DepthFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::DepthFieldId);

const OSG::BitVector  ImageBase::BppFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::BppFieldId);

const OSG::BitVector  ImageBase::MipMapCountFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::MipMapCountFieldId);

const OSG::BitVector  ImageBase::FrameCountFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::FrameCountFieldId);

const OSG::BitVector  ImageBase::FrameDelayFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::FrameDelayFieldId);

const OSG::BitVector  ImageBase::PixelFormatFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::PixelFormatFieldId);

const OSG::BitVector  ImageBase::PixelFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::PixelFieldId);

const OSG::BitVector  ImageBase::FrameSizeFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::FrameSizeFieldId);

const OSG::BitVector  ImageBase::NameFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::NameFieldId);

const OSG::BitVector  ImageBase::DataTypeFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::DataTypeFieldId);

const OSG::BitVector  ImageBase::ComponentSizeFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ComponentSizeFieldId);

const OSG::BitVector  ImageBase::SideCountFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::SideCountFieldId);

const OSG::BitVector  ImageBase::SideSizeFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::SideSizeFieldId);

const OSG::BitVector  ImageBase::ForceCompressedDataFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ForceCompressedDataFieldId);

const OSG::BitVector  ImageBase::ForceAlphaChannelFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ForceAlphaChannelFieldId);

const OSG::BitVector  ImageBase::ForceColorChannelFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ForceColorChannelFieldId);

const OSG::BitVector  ImageBase::ForceAlphaBinaryFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ForceAlphaBinaryFieldId);

const OSG::BitVector  ImageBase::ResXFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ResXFieldId);

const OSG::BitVector  ImageBase::ResYFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ResYFieldId);

const OSG::BitVector  ImageBase::ResUnitFieldMask = 
    (TypeTraits<BitVector>::One << ImageBase::ResUnitFieldId);

const OSG::BitVector ImageBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var FieldContainerPtr ImageBase::_mfParents
    
*/
/*! \var Int32           ImageBase::_sfDimension
    image dimension, 0 for invalid, 1 for 1D, 2 for 2D and     3 for 3D data.
*/
/*! \var Int32           ImageBase::_sfWidth
    
*/
/*! \var Int32           ImageBase::_sfHeight
    
*/
/*! \var Int32           ImageBase::_sfDepth
    
*/
/*! \var Int32           ImageBase::_sfBpp
    
*/
/*! \var Int32           ImageBase::_sfMipMapCount
    
*/
/*! \var Int32           ImageBase::_sfFrameCount
    
*/
/*! \var Time            ImageBase::_sfFrameDelay
    
*/
/*! \var UInt32          ImageBase::_sfPixelFormat
    
*/
/*! \var UInt8           ImageBase::_mfPixel
    
*/
/*! \var Int32           ImageBase::_sfFrameSize
    
*/
/*! \var std::string     ImageBase::_sfName
    Texture file path
*/
/*! \var Int32           ImageBase::_sfDataType
    Type of image data
*/
/*! \var Int32           ImageBase::_sfComponentSize
    Size (in byte) of a single component of the image. Necessary         for High Dynamic Range and other higher-level image types.
*/
/*! \var Int32           ImageBase::_sfSideCount
    
*/
/*! \var Int32           ImageBase::_sfSideSize
    
*/
/*! \var bool            ImageBase::_sfForceCompressedData
    Set to true if using the image to keep unknown data for textures.         Generally used in conjunction with TextureChunk::externalFormat.
*/
/*! \var bool            ImageBase::_sfForceAlphaChannel
    Set to true if using the image to keep unknown data for textures.         Generally used in conjunction with TextureChunk::externalFormat.
*/
/*! \var bool            ImageBase::_sfForceColorChannel
    Set to true if using the image to keep unknown data for textures.         Generally used in conjunction with TextureChunk::externalFormat.
*/
/*! \var bool            ImageBase::_sfForceAlphaBinary
    Set to true if using the image to prevent depth sorting for          SimpleTexturedMaterials using this Image.
*/
/*! \var Real32          ImageBase::_sfResX
    
*/
/*! \var Real32          ImageBase::_sfResY
    
*/
/*! \var UInt16          ImageBase::_sfResUnit
    resolution unit (none=1, inch=2, centimeter=3)
*/

//! Image description

FieldDescription *ImageBase::_desc[] = 
{
    new FieldDescription(MFFieldContainerPtr::getClassType(), 
                     "parents", 
                     ParentsFieldId, ParentsFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getMFParents),
    new FieldDescription(SFInt32::getClassType(), 
                     "dimension", 
                     DimensionFieldId, DimensionFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFDimension),
    new FieldDescription(SFInt32::getClassType(), 
                     "width", 
                     WidthFieldId, WidthFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFWidth),
    new FieldDescription(SFInt32::getClassType(), 
                     "height", 
                     HeightFieldId, HeightFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFHeight),
    new FieldDescription(SFInt32::getClassType(), 
                     "depth", 
                     DepthFieldId, DepthFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFDepth),
    new FieldDescription(SFInt32::getClassType(), 
                     "bpp", 
                     BppFieldId, BppFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFBpp),
    new FieldDescription(SFInt32::getClassType(), 
                     "mipMapCount", 
                     MipMapCountFieldId, MipMapCountFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFMipMapCount),
    new FieldDescription(SFInt32::getClassType(), 
                     "frameCount", 
                     FrameCountFieldId, FrameCountFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFFrameCount),
    new FieldDescription(SFTime::getClassType(), 
                     "frameDelay", 
                     FrameDelayFieldId, FrameDelayFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFFrameDelay),
    new FieldDescription(SFUInt32::getClassType(), 
                     "pixelFormat", 
                     PixelFormatFieldId, PixelFormatFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFPixelFormat),
    new FieldDescription(MFUInt8::getClassType(), 
                     "pixel", 
                     PixelFieldId, PixelFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getMFPixel),
    new FieldDescription(SFInt32::getClassType(), 
                     "frameSize", 
                     FrameSizeFieldId, FrameSizeFieldMask,
                     true,
                     (FieldAccessMethod) &ImageBase::getSFFrameSize),
    new FieldDescription(SFString::getClassType(), 
                     "name", 
                     NameFieldId, NameFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFName),
    new FieldDescription(SFInt32::getClassType(), 
                     "dataType", 
                     DataTypeFieldId, DataTypeFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFDataType),
    new FieldDescription(SFInt32::getClassType(), 
                     "componentSize", 
                     ComponentSizeFieldId, ComponentSizeFieldMask,
                     true,
                     (FieldAccessMethod) &ImageBase::getSFComponentSize),
    new FieldDescription(SFInt32::getClassType(), 
                     "sideCount", 
                     SideCountFieldId, SideCountFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFSideCount),
    new FieldDescription(SFInt32::getClassType(), 
                     "sideSize", 
                     SideSizeFieldId, SideSizeFieldMask,
                     true,
                     (FieldAccessMethod) &ImageBase::getSFSideSize),
    new FieldDescription(SFBool::getClassType(), 
                     "forceCompressedData", 
                     ForceCompressedDataFieldId, ForceCompressedDataFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFForceCompressedData),
    new FieldDescription(SFBool::getClassType(), 
                     "forceAlphaChannel", 
                     ForceAlphaChannelFieldId, ForceAlphaChannelFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFForceAlphaChannel),
    new FieldDescription(SFBool::getClassType(), 
                     "forceColorChannel", 
                     ForceColorChannelFieldId, ForceColorChannelFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFForceColorChannel),
    new FieldDescription(SFBool::getClassType(), 
                     "forceAlphaBinary", 
                     ForceAlphaBinaryFieldId, ForceAlphaBinaryFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFForceAlphaBinary),
    new FieldDescription(SFReal32::getClassType(), 
                     "resX", 
                     ResXFieldId, ResXFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFResX),
    new FieldDescription(SFReal32::getClassType(), 
                     "resY", 
                     ResYFieldId, ResYFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFResY),
    new FieldDescription(SFUInt16::getClassType(), 
                     "resUnit", 
                     ResUnitFieldId, ResUnitFieldMask,
                     false,
                     (FieldAccessMethod) &ImageBase::getSFResUnit)
};


FieldContainerType ImageBase::_type(
    "Image",
    "AttachmentContainer",
    NULL,
    (PrototypeCreateF) &ImageBase::createEmpty,
    Image::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ImageBase, ImagePtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ImageBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ImageBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ImageBase::shallowCopy(void) const 
{ 
    ImagePtr returnValue; 

    newPtr(returnValue, dynamic_cast<const Image *>(this)); 

    return returnValue; 
}

UInt32 ImageBase::getContainerSize(void) const 
{ 
    return sizeof(Image); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ImageBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ImageBase *) &other, whichField);
}
#else
void ImageBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ImageBase *) &other, whichField, sInfo);
}
void ImageBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ImageBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfParents.terminateShare(uiAspect, this->getContainerSize());
    _mfPixel.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ImageBase::ImageBase(void) :
    _mfParents                (), 
    _sfDimension              (Int32(0)), 
    _sfWidth                  (Int32(0)), 
    _sfHeight                 (Int32(1)), 
    _sfDepth                  (Int32(1)), 
    _sfBpp                    (Int32(1)), 
    _sfMipMapCount            (Int32(1)), 
    _sfFrameCount             (Int32(1)), 
    _sfFrameDelay             (Time(0)), 
    _sfPixelFormat            (UInt32(0)), 
    _mfPixel                  (), 
    _sfFrameSize              (Int32(0)), 
    _sfName                   (), 
    _sfDataType               (Int32(GL_UNSIGNED_BYTE)), 
    _sfComponentSize          (Int32(1)), 
    _sfSideCount              (Int32(1)), 
    _sfSideSize               (Int32(0)), 
    _sfForceCompressedData    (bool(false)), 
    _sfForceAlphaChannel      (bool(false)), 
    _sfForceColorChannel      (bool(false)), 
    _sfForceAlphaBinary       (bool(false)), 
    _sfResX                   (Real32(72.0f)), 
    _sfResY                   (Real32(72.0f)), 
    _sfResUnit                (UInt16(2)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ImageBase::ImageBase(const ImageBase &source) :
    _mfParents                (source._mfParents                ), 
    _sfDimension              (source._sfDimension              ), 
    _sfWidth                  (source._sfWidth                  ), 
    _sfHeight                 (source._sfHeight                 ), 
    _sfDepth                  (source._sfDepth                  ), 
    _sfBpp                    (source._sfBpp                    ), 
    _sfMipMapCount            (source._sfMipMapCount            ), 
    _sfFrameCount             (source._sfFrameCount             ), 
    _sfFrameDelay             (source._sfFrameDelay             ), 
    _sfPixelFormat            (source._sfPixelFormat            ), 
    _mfPixel                  (source._mfPixel                  ), 
    _sfFrameSize              (source._sfFrameSize              ), 
    _sfName                   (source._sfName                   ), 
    _sfDataType               (source._sfDataType               ), 
    _sfComponentSize          (source._sfComponentSize          ), 
    _sfSideCount              (source._sfSideCount              ), 
    _sfSideSize               (source._sfSideSize               ), 
    _sfForceCompressedData    (source._sfForceCompressedData    ), 
    _sfForceAlphaChannel      (source._sfForceAlphaChannel      ), 
    _sfForceColorChannel      (source._sfForceColorChannel      ), 
    _sfForceAlphaBinary       (source._sfForceAlphaBinary       ), 
    _sfResX                   (source._sfResX                   ), 
    _sfResY                   (source._sfResY                   ), 
    _sfResUnit                (source._sfResUnit                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ImageBase::~ImageBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ImageBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ParentsFieldMask & whichField))
    {
        returnValue += _mfParents.getBinSize();
    }

    if(FieldBits::NoField != (DimensionFieldMask & whichField))
    {
        returnValue += _sfDimension.getBinSize();
    }

    if(FieldBits::NoField != (WidthFieldMask & whichField))
    {
        returnValue += _sfWidth.getBinSize();
    }

    if(FieldBits::NoField != (HeightFieldMask & whichField))
    {
        returnValue += _sfHeight.getBinSize();
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        returnValue += _sfDepth.getBinSize();
    }

    if(FieldBits::NoField != (BppFieldMask & whichField))
    {
        returnValue += _sfBpp.getBinSize();
    }

    if(FieldBits::NoField != (MipMapCountFieldMask & whichField))
    {
        returnValue += _sfMipMapCount.getBinSize();
    }

    if(FieldBits::NoField != (FrameCountFieldMask & whichField))
    {
        returnValue += _sfFrameCount.getBinSize();
    }

    if(FieldBits::NoField != (FrameDelayFieldMask & whichField))
    {
        returnValue += _sfFrameDelay.getBinSize();
    }

    if(FieldBits::NoField != (PixelFormatFieldMask & whichField))
    {
        returnValue += _sfPixelFormat.getBinSize();
    }

    if(FieldBits::NoField != (PixelFieldMask & whichField))
    {
        returnValue += _mfPixel.getBinSize();
    }

    if(FieldBits::NoField != (FrameSizeFieldMask & whichField))
    {
        returnValue += _sfFrameSize.getBinSize();
    }

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        returnValue += _sfName.getBinSize();
    }

    if(FieldBits::NoField != (DataTypeFieldMask & whichField))
    {
        returnValue += _sfDataType.getBinSize();
    }

    if(FieldBits::NoField != (ComponentSizeFieldMask & whichField))
    {
        returnValue += _sfComponentSize.getBinSize();
    }

    if(FieldBits::NoField != (SideCountFieldMask & whichField))
    {
        returnValue += _sfSideCount.getBinSize();
    }

    if(FieldBits::NoField != (SideSizeFieldMask & whichField))
    {
        returnValue += _sfSideSize.getBinSize();
    }

    if(FieldBits::NoField != (ForceCompressedDataFieldMask & whichField))
    {
        returnValue += _sfForceCompressedData.getBinSize();
    }

    if(FieldBits::NoField != (ForceAlphaChannelFieldMask & whichField))
    {
        returnValue += _sfForceAlphaChannel.getBinSize();
    }

    if(FieldBits::NoField != (ForceColorChannelFieldMask & whichField))
    {
        returnValue += _sfForceColorChannel.getBinSize();
    }

    if(FieldBits::NoField != (ForceAlphaBinaryFieldMask & whichField))
    {
        returnValue += _sfForceAlphaBinary.getBinSize();
    }

    if(FieldBits::NoField != (ResXFieldMask & whichField))
    {
        returnValue += _sfResX.getBinSize();
    }

    if(FieldBits::NoField != (ResYFieldMask & whichField))
    {
        returnValue += _sfResY.getBinSize();
    }

    if(FieldBits::NoField != (ResUnitFieldMask & whichField))
    {
        returnValue += _sfResUnit.getBinSize();
    }


    return returnValue;
}

void ImageBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ParentsFieldMask & whichField))
    {
        _mfParents.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DimensionFieldMask & whichField))
    {
        _sfDimension.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WidthFieldMask & whichField))
    {
        _sfWidth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (HeightFieldMask & whichField))
    {
        _sfHeight.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        _sfDepth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BppFieldMask & whichField))
    {
        _sfBpp.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MipMapCountFieldMask & whichField))
    {
        _sfMipMapCount.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FrameCountFieldMask & whichField))
    {
        _sfFrameCount.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FrameDelayFieldMask & whichField))
    {
        _sfFrameDelay.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PixelFormatFieldMask & whichField))
    {
        _sfPixelFormat.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PixelFieldMask & whichField))
    {
        _mfPixel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FrameSizeFieldMask & whichField))
    {
        _sfFrameSize.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        _sfName.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DataTypeFieldMask & whichField))
    {
        _sfDataType.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ComponentSizeFieldMask & whichField))
    {
        _sfComponentSize.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SideCountFieldMask & whichField))
    {
        _sfSideCount.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SideSizeFieldMask & whichField))
    {
        _sfSideSize.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ForceCompressedDataFieldMask & whichField))
    {
        _sfForceCompressedData.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ForceAlphaChannelFieldMask & whichField))
    {
        _sfForceAlphaChannel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ForceColorChannelFieldMask & whichField))
    {
        _sfForceColorChannel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ForceAlphaBinaryFieldMask & whichField))
    {
        _sfForceAlphaBinary.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ResXFieldMask & whichField))
    {
        _sfResX.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ResYFieldMask & whichField))
    {
        _sfResY.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ResUnitFieldMask & whichField))
    {
        _sfResUnit.copyToBin(pMem);
    }


}

void ImageBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ParentsFieldMask & whichField))
    {
        _mfParents.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DimensionFieldMask & whichField))
    {
        _sfDimension.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WidthFieldMask & whichField))
    {
        _sfWidth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (HeightFieldMask & whichField))
    {
        _sfHeight.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        _sfDepth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BppFieldMask & whichField))
    {
        _sfBpp.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MipMapCountFieldMask & whichField))
    {
        _sfMipMapCount.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FrameCountFieldMask & whichField))
    {
        _sfFrameCount.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FrameDelayFieldMask & whichField))
    {
        _sfFrameDelay.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PixelFormatFieldMask & whichField))
    {
        _sfPixelFormat.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PixelFieldMask & whichField))
    {
        _mfPixel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FrameSizeFieldMask & whichField))
    {
        _sfFrameSize.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        _sfName.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DataTypeFieldMask & whichField))
    {
        _sfDataType.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ComponentSizeFieldMask & whichField))
    {
        _sfComponentSize.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SideCountFieldMask & whichField))
    {
        _sfSideCount.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SideSizeFieldMask & whichField))
    {
        _sfSideSize.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ForceCompressedDataFieldMask & whichField))
    {
        _sfForceCompressedData.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ForceAlphaChannelFieldMask & whichField))
    {
        _sfForceAlphaChannel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ForceColorChannelFieldMask & whichField))
    {
        _sfForceColorChannel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ForceAlphaBinaryFieldMask & whichField))
    {
        _sfForceAlphaBinary.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ResXFieldMask & whichField))
    {
        _sfResX.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ResYFieldMask & whichField))
    {
        _sfResY.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ResUnitFieldMask & whichField))
    {
        _sfResUnit.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ImageBase::executeSyncImpl(      ImageBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ParentsFieldMask & whichField))
        _mfParents.syncWith(pOther->_mfParents);

    if(FieldBits::NoField != (DimensionFieldMask & whichField))
        _sfDimension.syncWith(pOther->_sfDimension);

    if(FieldBits::NoField != (WidthFieldMask & whichField))
        _sfWidth.syncWith(pOther->_sfWidth);

    if(FieldBits::NoField != (HeightFieldMask & whichField))
        _sfHeight.syncWith(pOther->_sfHeight);

    if(FieldBits::NoField != (DepthFieldMask & whichField))
        _sfDepth.syncWith(pOther->_sfDepth);

    if(FieldBits::NoField != (BppFieldMask & whichField))
        _sfBpp.syncWith(pOther->_sfBpp);

    if(FieldBits::NoField != (MipMapCountFieldMask & whichField))
        _sfMipMapCount.syncWith(pOther->_sfMipMapCount);

    if(FieldBits::NoField != (FrameCountFieldMask & whichField))
        _sfFrameCount.syncWith(pOther->_sfFrameCount);

    if(FieldBits::NoField != (FrameDelayFieldMask & whichField))
        _sfFrameDelay.syncWith(pOther->_sfFrameDelay);

    if(FieldBits::NoField != (PixelFormatFieldMask & whichField))
        _sfPixelFormat.syncWith(pOther->_sfPixelFormat);

    if(FieldBits::NoField != (PixelFieldMask & whichField))
        _mfPixel.syncWith(pOther->_mfPixel);

    if(FieldBits::NoField != (FrameSizeFieldMask & whichField))
        _sfFrameSize.syncWith(pOther->_sfFrameSize);

    if(FieldBits::NoField != (NameFieldMask & whichField))
        _sfName.syncWith(pOther->_sfName);

    if(FieldBits::NoField != (DataTypeFieldMask & whichField))
        _sfDataType.syncWith(pOther->_sfDataType);

    if(FieldBits::NoField != (ComponentSizeFieldMask & whichField))
        _sfComponentSize.syncWith(pOther->_sfComponentSize);

    if(FieldBits::NoField != (SideCountFieldMask & whichField))
        _sfSideCount.syncWith(pOther->_sfSideCount);

    if(FieldBits::NoField != (SideSizeFieldMask & whichField))
        _sfSideSize.syncWith(pOther->_sfSideSize);

    if(FieldBits::NoField != (ForceCompressedDataFieldMask & whichField))
        _sfForceCompressedData.syncWith(pOther->_sfForceCompressedData);

    if(FieldBits::NoField != (ForceAlphaChannelFieldMask & whichField))
        _sfForceAlphaChannel.syncWith(pOther->_sfForceAlphaChannel);

    if(FieldBits::NoField != (ForceColorChannelFieldMask & whichField))
        _sfForceColorChannel.syncWith(pOther->_sfForceColorChannel);

    if(FieldBits::NoField != (ForceAlphaBinaryFieldMask & whichField))
        _sfForceAlphaBinary.syncWith(pOther->_sfForceAlphaBinary);

    if(FieldBits::NoField != (ResXFieldMask & whichField))
        _sfResX.syncWith(pOther->_sfResX);

    if(FieldBits::NoField != (ResYFieldMask & whichField))
        _sfResY.syncWith(pOther->_sfResY);

    if(FieldBits::NoField != (ResUnitFieldMask & whichField))
        _sfResUnit.syncWith(pOther->_sfResUnit);


}
#else
void ImageBase::executeSyncImpl(      ImageBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (DimensionFieldMask & whichField))
        _sfDimension.syncWith(pOther->_sfDimension);

    if(FieldBits::NoField != (WidthFieldMask & whichField))
        _sfWidth.syncWith(pOther->_sfWidth);

    if(FieldBits::NoField != (HeightFieldMask & whichField))
        _sfHeight.syncWith(pOther->_sfHeight);

    if(FieldBits::NoField != (DepthFieldMask & whichField))
        _sfDepth.syncWith(pOther->_sfDepth);

    if(FieldBits::NoField != (BppFieldMask & whichField))
        _sfBpp.syncWith(pOther->_sfBpp);

    if(FieldBits::NoField != (MipMapCountFieldMask & whichField))
        _sfMipMapCount.syncWith(pOther->_sfMipMapCount);

    if(FieldBits::NoField != (FrameCountFieldMask & whichField))
        _sfFrameCount.syncWith(pOther->_sfFrameCount);

    if(FieldBits::NoField != (FrameDelayFieldMask & whichField))
        _sfFrameDelay.syncWith(pOther->_sfFrameDelay);

    if(FieldBits::NoField != (PixelFormatFieldMask & whichField))
        _sfPixelFormat.syncWith(pOther->_sfPixelFormat);

    if(FieldBits::NoField != (FrameSizeFieldMask & whichField))
        _sfFrameSize.syncWith(pOther->_sfFrameSize);

    if(FieldBits::NoField != (NameFieldMask & whichField))
        _sfName.syncWith(pOther->_sfName);

    if(FieldBits::NoField != (DataTypeFieldMask & whichField))
        _sfDataType.syncWith(pOther->_sfDataType);

    if(FieldBits::NoField != (ComponentSizeFieldMask & whichField))
        _sfComponentSize.syncWith(pOther->_sfComponentSize);

    if(FieldBits::NoField != (SideCountFieldMask & whichField))
        _sfSideCount.syncWith(pOther->_sfSideCount);

    if(FieldBits::NoField != (SideSizeFieldMask & whichField))
        _sfSideSize.syncWith(pOther->_sfSideSize);

    if(FieldBits::NoField != (ForceCompressedDataFieldMask & whichField))
        _sfForceCompressedData.syncWith(pOther->_sfForceCompressedData);

    if(FieldBits::NoField != (ForceAlphaChannelFieldMask & whichField))
        _sfForceAlphaChannel.syncWith(pOther->_sfForceAlphaChannel);

    if(FieldBits::NoField != (ForceColorChannelFieldMask & whichField))
        _sfForceColorChannel.syncWith(pOther->_sfForceColorChannel);

    if(FieldBits::NoField != (ForceAlphaBinaryFieldMask & whichField))
        _sfForceAlphaBinary.syncWith(pOther->_sfForceAlphaBinary);

    if(FieldBits::NoField != (ResXFieldMask & whichField))
        _sfResX.syncWith(pOther->_sfResX);

    if(FieldBits::NoField != (ResYFieldMask & whichField))
        _sfResY.syncWith(pOther->_sfResY);

    if(FieldBits::NoField != (ResUnitFieldMask & whichField))
        _sfResUnit.syncWith(pOther->_sfResUnit);


    if(FieldBits::NoField != (ParentsFieldMask & whichField))
        _mfParents.syncWith(pOther->_mfParents, sInfo);

    if(FieldBits::NoField != (PixelFieldMask & whichField))
        _mfPixel.syncWith(pOther->_mfPixel, sInfo);


}

void ImageBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ParentsFieldMask & whichField))
        _mfParents.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (PixelFieldMask & whichField))
        _mfPixel.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ImagePtr>::_type("ImagePtr", "AttachmentContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ImagePtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ImagePtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGIMAGEBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGIMAGEBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGIMAGEFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

