/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class FresnelMaterial!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &FresnelMaterialBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 FresnelMaterialBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
FresnelMaterialPtr FresnelMaterialBase::create(void) 
{
    FresnelMaterialPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = FresnelMaterialPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
FresnelMaterialPtr FresnelMaterialBase::createEmpty(void) 
{ 
    FresnelMaterialPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the FresnelMaterial::_sfAmbient field.
inline
SFColor3f *FresnelMaterialBase::getSFAmbient(void)
{
    return &_sfAmbient;
}

//! Get the FresnelMaterial::_sfDiffuse field.
inline
SFColor3f *FresnelMaterialBase::getSFDiffuse(void)
{
    return &_sfDiffuse;
}

//! Get the FresnelMaterial::_sfSpecular field.
inline
SFColor3f *FresnelMaterialBase::getSFSpecular(void)
{
    return &_sfSpecular;
}

//! Get the FresnelMaterial::_sfShininess field.
inline
SFReal32 *FresnelMaterialBase::getSFShininess(void)
{
    return &_sfShininess;
}

//! Get the FresnelMaterial::_sfEmission field.
inline
SFColor3f *FresnelMaterialBase::getSFEmission(void)
{
    return &_sfEmission;
}

//! Get the FresnelMaterial::_sfTransparency field.
inline
SFReal32 *FresnelMaterialBase::getSFTransparency(void)
{
    return &_sfTransparency;
}

//! Get the FresnelMaterial::_sfLit field.
inline
SFBool *FresnelMaterialBase::getSFLit(void)
{
    return &_sfLit;
}

//! Get the FresnelMaterial::_sfColorMaterial field.
inline
SFGLenum *FresnelMaterialBase::getSFColorMaterial(void)
{
    return &_sfColorMaterial;
}

//! Get the FresnelMaterial::_sfIndex field.
inline
SFReal32 *FresnelMaterialBase::getSFIndex(void)
{
    return &_sfIndex;
}

//! Get the FresnelMaterial::_sfScale field.
inline
SFReal32 *FresnelMaterialBase::getSFScale(void)
{
    return &_sfScale;
}

//! Get the FresnelMaterial::_sfBias field.
inline
SFReal32 *FresnelMaterialBase::getSFBias(void)
{
    return &_sfBias;
}

//! Get the FresnelMaterial::_sfImage field.
inline
SFImagePtr *FresnelMaterialBase::getSFImage(void)
{
    return &_sfImage;
}


//! Get the value of the FresnelMaterial::_sfAmbient field.
inline
Color3f &FresnelMaterialBase::getAmbient(void)
{
    return _sfAmbient.getValue();
}

//! Get the value of the FresnelMaterial::_sfAmbient field.
inline
const Color3f &FresnelMaterialBase::getAmbient(void) const
{
    return _sfAmbient.getValue();
}

//! Set the value of the FresnelMaterial::_sfAmbient field.
inline
void FresnelMaterialBase::setAmbient(const Color3f &value)
{
    _sfAmbient.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfDiffuse field.
inline
Color3f &FresnelMaterialBase::getDiffuse(void)
{
    return _sfDiffuse.getValue();
}

//! Get the value of the FresnelMaterial::_sfDiffuse field.
inline
const Color3f &FresnelMaterialBase::getDiffuse(void) const
{
    return _sfDiffuse.getValue();
}

//! Set the value of the FresnelMaterial::_sfDiffuse field.
inline
void FresnelMaterialBase::setDiffuse(const Color3f &value)
{
    _sfDiffuse.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfSpecular field.
inline
Color3f &FresnelMaterialBase::getSpecular(void)
{
    return _sfSpecular.getValue();
}

//! Get the value of the FresnelMaterial::_sfSpecular field.
inline
const Color3f &FresnelMaterialBase::getSpecular(void) const
{
    return _sfSpecular.getValue();
}

//! Set the value of the FresnelMaterial::_sfSpecular field.
inline
void FresnelMaterialBase::setSpecular(const Color3f &value)
{
    _sfSpecular.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfShininess field.
inline
Real32 &FresnelMaterialBase::getShininess(void)
{
    return _sfShininess.getValue();
}

//! Get the value of the FresnelMaterial::_sfShininess field.
inline
const Real32 &FresnelMaterialBase::getShininess(void) const
{
    return _sfShininess.getValue();
}

//! Set the value of the FresnelMaterial::_sfShininess field.
inline
void FresnelMaterialBase::setShininess(const Real32 &value)
{
    _sfShininess.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfEmission field.
inline
Color3f &FresnelMaterialBase::getEmission(void)
{
    return _sfEmission.getValue();
}

//! Get the value of the FresnelMaterial::_sfEmission field.
inline
const Color3f &FresnelMaterialBase::getEmission(void) const
{
    return _sfEmission.getValue();
}

//! Set the value of the FresnelMaterial::_sfEmission field.
inline
void FresnelMaterialBase::setEmission(const Color3f &value)
{
    _sfEmission.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfTransparency field.
inline
Real32 &FresnelMaterialBase::getTransparency(void)
{
    return _sfTransparency.getValue();
}

//! Get the value of the FresnelMaterial::_sfTransparency field.
inline
const Real32 &FresnelMaterialBase::getTransparency(void) const
{
    return _sfTransparency.getValue();
}

//! Set the value of the FresnelMaterial::_sfTransparency field.
inline
void FresnelMaterialBase::setTransparency(const Real32 &value)
{
    _sfTransparency.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfLit field.
inline
bool &FresnelMaterialBase::getLit(void)
{
    return _sfLit.getValue();
}

//! Get the value of the FresnelMaterial::_sfLit field.
inline
const bool &FresnelMaterialBase::getLit(void) const
{
    return _sfLit.getValue();
}

//! Set the value of the FresnelMaterial::_sfLit field.
inline
void FresnelMaterialBase::setLit(const bool &value)
{
    _sfLit.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfColorMaterial field.
inline
GLenum &FresnelMaterialBase::getColorMaterial(void)
{
    return _sfColorMaterial.getValue();
}

//! Get the value of the FresnelMaterial::_sfColorMaterial field.
inline
const GLenum &FresnelMaterialBase::getColorMaterial(void) const
{
    return _sfColorMaterial.getValue();
}

//! Set the value of the FresnelMaterial::_sfColorMaterial field.
inline
void FresnelMaterialBase::setColorMaterial(const GLenum &value)
{
    _sfColorMaterial.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfIndex field.
inline
Real32 &FresnelMaterialBase::getIndex(void)
{
    return _sfIndex.getValue();
}

//! Get the value of the FresnelMaterial::_sfIndex field.
inline
const Real32 &FresnelMaterialBase::getIndex(void) const
{
    return _sfIndex.getValue();
}

//! Set the value of the FresnelMaterial::_sfIndex field.
inline
void FresnelMaterialBase::setIndex(const Real32 &value)
{
    _sfIndex.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfScale field.
inline
Real32 &FresnelMaterialBase::getScale(void)
{
    return _sfScale.getValue();
}

//! Get the value of the FresnelMaterial::_sfScale field.
inline
const Real32 &FresnelMaterialBase::getScale(void) const
{
    return _sfScale.getValue();
}

//! Set the value of the FresnelMaterial::_sfScale field.
inline
void FresnelMaterialBase::setScale(const Real32 &value)
{
    _sfScale.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfBias field.
inline
Real32 &FresnelMaterialBase::getBias(void)
{
    return _sfBias.getValue();
}

//! Get the value of the FresnelMaterial::_sfBias field.
inline
const Real32 &FresnelMaterialBase::getBias(void) const
{
    return _sfBias.getValue();
}

//! Set the value of the FresnelMaterial::_sfBias field.
inline
void FresnelMaterialBase::setBias(const Real32 &value)
{
    _sfBias.setValue(value);
}

//! Get the value of the FresnelMaterial::_sfImage field.
inline
ImagePtr &FresnelMaterialBase::getImage(void)
{
    return _sfImage.getValue();
}

//! Get the value of the FresnelMaterial::_sfImage field.
inline
const ImagePtr &FresnelMaterialBase::getImage(void) const
{
    return _sfImage.getValue();
}

//! Set the value of the FresnelMaterial::_sfImage field.
inline
void FresnelMaterialBase::setImage(const ImagePtr &value)
{
    _sfImage.setValue(value);
}


OSG_END_NAMESPACE

#define OSGFRESNELMATERIALBASE_INLINE_CVSID "@(#)$Id: OSGFresnelMaterialBase.inl,v 1.5 2006/02/20 17:04:43 dirk Exp $"

