/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Particles!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &ParticlesBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 ParticlesBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
ParticlesPtr ParticlesBase::create(void) 
{
    ParticlesPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = ParticlesPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
ParticlesPtr ParticlesBase::createEmpty(void) 
{ 
    ParticlesPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the Particles::_sfMode field.
inline
SFUInt32 *ParticlesBase::getSFMode(void)
{
    return &_sfMode;
}

//! Get the Particles::_sfPositions field.
inline
SFGeoPositionsPtr *ParticlesBase::getSFPositions(void)
{
    return &_sfPositions;
}

//! Get the Particles::_mfSizes field.
inline
MFVec3f *ParticlesBase::getMFSizes(void)
{
    return &_mfSizes;
}

//! Get the Particles::_sfSecPositions field.
inline
SFGeoPositionsPtr *ParticlesBase::getSFSecPositions(void)
{
    return &_sfSecPositions;
}

//! Get the Particles::_sfColors field.
inline
SFGeoColorsPtr *ParticlesBase::getSFColors(void)
{
    return &_sfColors;
}

//! Get the Particles::_sfNormals field.
inline
SFGeoNormalsPtr *ParticlesBase::getSFNormals(void)
{
    return &_sfNormals;
}

//! Get the Particles::_mfIndices field.
inline
MFInt32 *ParticlesBase::getMFIndices(void)
{
    return &_mfIndices;
}

//! Get the Particles::_mfTextureZs field.
inline
MFReal32 *ParticlesBase::getMFTextureZs(void)
{
    return &_mfTextureZs;
}

//! Get the Particles::_sfDrawOrder field.
inline
SFUInt32 *ParticlesBase::getSFDrawOrder(void)
{
    return &_sfDrawOrder;
}

//! Get the Particles::_sfDynamic field.
inline
SFBool *ParticlesBase::getSFDynamic(void)
{
    return &_sfDynamic;
}

//! Get the Particles::_sfPump field.
inline
SFUInt32 *ParticlesBase::getSFPump(void)
{
    return &_sfPump;
}

//! Get the Particles::_sfBsp field.
inline
SFParticleBSPTree *ParticlesBase::getSFBsp(void)
{
    return &_sfBsp;
}

//! Get the Particles::_sfNumParticles field.
inline
SFInt32 *ParticlesBase::getSFNumParticles(void)
{
    return &_sfNumParticles;
}


//! Get the value of the Particles::_sfMode field.
inline
UInt32 &ParticlesBase::getMode(void)
{
    return _sfMode.getValue();
}

//! Get the value of the Particles::_sfMode field.
inline
const UInt32 &ParticlesBase::getMode(void) const
{
    return _sfMode.getValue();
}

//! Set the value of the Particles::_sfMode field.
inline
void ParticlesBase::setMode(const UInt32 &value)
{
    _sfMode.setValue(value);
}

//! Get the value of the Particles::_sfPositions field.
inline
GeoPositionsPtr &ParticlesBase::getPositions(void)
{
    return _sfPositions.getValue();
}

//! Get the value of the Particles::_sfPositions field.
inline
const GeoPositionsPtr &ParticlesBase::getPositions(void) const
{
    return _sfPositions.getValue();
}

//! Set the value of the Particles::_sfPositions field.
inline
void ParticlesBase::setPositions(const GeoPositionsPtr &value)
{
    _sfPositions.setValue(value);
}

//! Get the value of the Particles::_sfSecPositions field.
inline
GeoPositionsPtr &ParticlesBase::getSecPositions(void)
{
    return _sfSecPositions.getValue();
}

//! Get the value of the Particles::_sfSecPositions field.
inline
const GeoPositionsPtr &ParticlesBase::getSecPositions(void) const
{
    return _sfSecPositions.getValue();
}

//! Set the value of the Particles::_sfSecPositions field.
inline
void ParticlesBase::setSecPositions(const GeoPositionsPtr &value)
{
    _sfSecPositions.setValue(value);
}

//! Get the value of the Particles::_sfColors field.
inline
GeoColorsPtr &ParticlesBase::getColors(void)
{
    return _sfColors.getValue();
}

//! Get the value of the Particles::_sfColors field.
inline
const GeoColorsPtr &ParticlesBase::getColors(void) const
{
    return _sfColors.getValue();
}

//! Set the value of the Particles::_sfColors field.
inline
void ParticlesBase::setColors(const GeoColorsPtr &value)
{
    _sfColors.setValue(value);
}

//! Get the value of the Particles::_sfNormals field.
inline
GeoNormalsPtr &ParticlesBase::getNormals(void)
{
    return _sfNormals.getValue();
}

//! Get the value of the Particles::_sfNormals field.
inline
const GeoNormalsPtr &ParticlesBase::getNormals(void) const
{
    return _sfNormals.getValue();
}

//! Set the value of the Particles::_sfNormals field.
inline
void ParticlesBase::setNormals(const GeoNormalsPtr &value)
{
    _sfNormals.setValue(value);
}

//! Get the value of the Particles::_sfDrawOrder field.
inline
UInt32 &ParticlesBase::getDrawOrder(void)
{
    return _sfDrawOrder.getValue();
}

//! Get the value of the Particles::_sfDrawOrder field.
inline
const UInt32 &ParticlesBase::getDrawOrder(void) const
{
    return _sfDrawOrder.getValue();
}

//! Set the value of the Particles::_sfDrawOrder field.
inline
void ParticlesBase::setDrawOrder(const UInt32 &value)
{
    _sfDrawOrder.setValue(value);
}

//! Get the value of the Particles::_sfDynamic field.
inline
bool &ParticlesBase::getDynamic(void)
{
    return _sfDynamic.getValue();
}

//! Get the value of the Particles::_sfDynamic field.
inline
const bool &ParticlesBase::getDynamic(void) const
{
    return _sfDynamic.getValue();
}

//! Set the value of the Particles::_sfDynamic field.
inline
void ParticlesBase::setDynamic(const bool &value)
{
    _sfDynamic.setValue(value);
}

//! Get the value of the Particles::_sfPump field.
inline
UInt32 &ParticlesBase::getPump(void)
{
    return _sfPump.getValue();
}

//! Get the value of the Particles::_sfPump field.
inline
const UInt32 &ParticlesBase::getPump(void) const
{
    return _sfPump.getValue();
}

//! Set the value of the Particles::_sfPump field.
inline
void ParticlesBase::setPump(const UInt32 &value)
{
    _sfPump.setValue(value);
}

//! Get the value of the Particles::_sfBsp field.
inline
ParticleBSPTree &ParticlesBase::getBsp(void)
{
    return _sfBsp.getValue();
}

//! Get the value of the Particles::_sfBsp field.
inline
const ParticleBSPTree &ParticlesBase::getBsp(void) const
{
    return _sfBsp.getValue();
}

//! Set the value of the Particles::_sfBsp field.
inline
void ParticlesBase::setBsp(const ParticleBSPTree &value)
{
    _sfBsp.setValue(value);
}

//! Get the value of the Particles::_sfNumParticles field.
inline
Int32 &ParticlesBase::getNumParticles(void)
{
    return _sfNumParticles.getValue();
}

//! Get the value of the Particles::_sfNumParticles field.
inline
const Int32 &ParticlesBase::getNumParticles(void) const
{
    return _sfNumParticles.getValue();
}

//! Set the value of the Particles::_sfNumParticles field.
inline
void ParticlesBase::setNumParticles(const Int32 &value)
{
    _sfNumParticles.setValue(value);
}


//! Get the value of the \a index element the Particles::_mfSizes field.
inline
Vec3f &ParticlesBase::getSizes(const UInt32 index)
{
    return _mfSizes[index];
}

//! Get the Particles::_mfSizes field.
inline
MFVec3f &ParticlesBase::getSizes(void)
{
    return _mfSizes;
}

//! Get the Particles::_mfSizes field.
inline
const MFVec3f &ParticlesBase::getSizes(void) const
{
    return _mfSizes;
}

//! Get the value of the \a index element the Particles::_mfIndices field.
inline
Int32 &ParticlesBase::getIndices(const UInt32 index)
{
    return _mfIndices[index];
}

//! Get the Particles::_mfIndices field.
inline
MFInt32 &ParticlesBase::getIndices(void)
{
    return _mfIndices;
}

//! Get the Particles::_mfIndices field.
inline
const MFInt32 &ParticlesBase::getIndices(void) const
{
    return _mfIndices;
}

//! Get the value of the \a index element the Particles::_mfTextureZs field.
inline
Real32 &ParticlesBase::getTextureZs(const UInt32 index)
{
    return _mfTextureZs[index];
}

//! Get the Particles::_mfTextureZs field.
inline
MFReal32 &ParticlesBase::getTextureZs(void)
{
    return _mfTextureZs;
}

//! Get the Particles::_mfTextureZs field.
inline
const MFReal32 &ParticlesBase::getTextureZs(void) const
{
    return _mfTextureZs;
}

OSG_END_NAMESPACE

#define OSGPARTICLESBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

