/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/


#include "OSGTextFace.h"


OSG_BEGIN_NAMESPACE


inline TextTXFParam::TextTXFParam()
: size(46), gap(1), textureWidth(0),
  _characters(_defaultCharacters)
{}


inline void TextTXFParam::setCharacters(const std::string &utf8Characters)
{
    TextFace::convertUTF8ToUnicode(utf8Characters, _characters);
    normalizeCharacters();
}


inline void TextTXFParam::setCharacters(const std::wstring &characters)
{
    _characters = characters;
    normalizeCharacters();
}


inline const std::wstring &TextTXFParam::getCharacters() const { return _characters; }


OSG_END_NAMESPACE


#define OSGTEXTTXFPARAM_INLINE_CVSID "@(#)$Id: OSGTextTXFParam.inl,v 1.1 2005/03/03 13:43:07 a-m-z Exp $"
