/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/


#include <OSGConfig.h>

#include <OSGBaseTypes.h>

#include "OSGLogoData.h"

OSG_USING_NAMESPACE

/*! \file OSGLogoData.cpp
    The file containing the data array for the "Powered by OpenSG" logo.
 */
 
/*! \var osg::LogoData
    \ingroup GrpSystemWindow
    
    Binary data for a "Powered by OpenSG" logo image. Use with 
    ImageFileType::restore to turn it into an Image.
 */

OSG_BEGIN_NAMESPACE
UChar8 LogoData[] = {

#ifndef OSG_DO_DOC

77, 84, 68, 0, 1, 0, 0, 0, 
25, 8, 0, 223, 0, 38, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 1, 0x14, 0x01, 2, 2, 
0, 0, 0, 0, 1, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 2, 2, 
2, 2, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 3, 3, 3, 3, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 4, 4, 
4, 4, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 4, 4, 
4, 4, 2, 2, 2, 2, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 46, 46, 46, 46, 111, 111, 
111, 111, 120, 120, 120, 120, 120, 120, 
120, 120, 115, 115, 115, 115, 61, 61, 
61, 61, 6, 6, 6, 6, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 20, 20, 
20, 20, 89, 89, 89, 89, 117, 117, 
117, 117, 118, 118, 118, 118, 117, 117, 
117, 117, 91, 91, 91, 91, 33, 33, 
33, 33, 5, 5, 5, 5, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 14, 14, 14, 14, 137, 137, 
137, 137, 239, 239, 239, 240, 243, 242, 
243, 247, 243, 242, 243, 247, 241, 241, 
241, 243, 169, 169, 169, 169, 25, 25, 
25, 25, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 2, 2, 
2, 2, 73, 73, 73, 73, 215, 215, 
215, 215, 245, 245, 245, 245, 246, 246, 
246, 246, 245, 245, 245, 245, 231, 231, 
231, 231, 171, 171, 171, 171, 59, 59, 
59, 59, 5, 5, 5, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 17, 17, 
17, 17, 156, 156, 156, 156, 229, 229, 
230, 252, 95, 98, 101, 255, 93, 98, 
100, 255, 214, 215, 215, 254, 189, 189, 
189, 189, 30, 30, 30, 30, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 3, 3, 3, 3, 87, 87, 
87, 87, 234, 234, 234, 234, 167, 167, 
167, 255, 67, 67, 67, 255, 110, 110, 
110, 255, 226, 226, 226, 255, 246, 246, 
246, 246, 159, 159, 159, 159, 27, 27, 
27, 27, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 17, 17, 17, 17, 156, 156, 
156, 156, 228, 228, 228, 252, 87, 91, 
93, 255, 85, 90, 92, 255, 212, 213, 
213, 254, 189, 189, 189, 189, 30, 30, 
30, 30, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 4, 4, 
4, 4, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 3, 3, 
3, 3, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 4, 4, 
4, 4, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 4, 4, 4, 4, 2, 2, 
2, 2, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 3, 3, 3, 3, 4, 4, 
4, 4, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 4, 4, 4, 4, 2, 2, 
2, 2, 1, 1, 1, 1, 0, 0, 
0, 0, 1, 1, 1, 1, 2, 2, 
2, 2, 4, 4, 4, 4, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 3, 3, 
3, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 4, 4, 
4, 4, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 4, 4, 4, 4, 5, 5, 
5, 5, 87, 87, 87, 87, 234, 234, 
234, 234, 124, 124, 124, 255, 28, 28, 
28, 255, 4, 4, 4, 255, 65, 65, 
65, 255, 238, 238, 238, 255, 220, 220, 
220, 220, 73, 73, 73, 73, 3, 3, 
3, 3, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 3, 3, 3, 3, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 4, 4, 
4, 4, 2, 2, 2, 2, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 17, 17, 
17, 17, 156, 156, 156, 156, 228, 228, 
229, 252, 87, 92, 93, 255, 85, 90, 
92, 255, 212, 212, 213, 254, 190, 190, 
190, 190, 34, 34, 34, 34, 5, 5, 
5, 5, 4, 4, 4, 4, 2, 2, 
2, 2, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 3, 3, 3, 3, 5, 5, 
5, 5, 5, 5, 5, 5, 4, 4, 
4, 4, 3, 3, 3, 3, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 3, 3, 3, 3, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 4, 4, 4, 4, 3, 3, 
3, 3, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 4, 4, 
4, 4, 5, 5, 5, 5, 5, 5, 
5, 5, 5, 5, 5, 5, 5, 5, 
5, 5, 4, 4, 4, 4, 3, 3, 
3, 3, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 7, 7, 7, 7, 28, 28, 
28, 28, 33, 33, 33, 33, 33, 33, 
33, 33, 32, 32, 32, 32, 19, 19, 
19, 19, 2, 2, 2, 2, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 28, 28, 
28, 28, 93, 93, 93, 93, 108, 108, 
108, 108, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 107, 107, 
107, 107, 74, 74, 74, 74, 23, 23, 
23, 23, 3, 3, 3, 3, 1, 1, 
1, 1, 6, 6, 6, 6, 27, 27, 
27, 27, 33, 33, 33, 33, 33, 33, 
33, 33, 32, 32, 32, 32, 20, 20, 
20, 20, 9, 9, 9, 9, 27, 27, 
27, 27, 33, 33, 33, 33, 33, 33, 
33, 33, 32, 32, 32, 32, 21, 21, 
21, 21, 3, 3, 3, 3, 1, 1, 
1, 1, 6, 6, 6, 6, 36, 36, 
36, 36, 91, 91, 91, 91, 108, 108, 
108, 108, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 100, 100, 
100, 100, 48, 48, 48, 48, 11, 11, 
11, 11, 6, 6, 6, 6, 26, 26, 
26, 26, 33, 33, 33, 33, 32, 32, 
32, 32, 21, 21, 21, 21, 4, 4, 
4, 4, 1, 1, 1, 1, 2, 2, 
2, 2, 16, 16, 16, 16, 61, 61, 
61, 61, 104, 104, 104, 104, 109, 109, 
109, 109, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 100, 100, 
100, 100, 43, 43, 43, 43, 6, 6, 
6, 6, 2, 2, 2, 2, 15, 15, 
15, 15, 60, 60, 60, 60, 104, 104, 
104, 104, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 108, 108, 
108, 108, 81, 81, 81, 81, 39, 39, 
39, 39, 33, 33, 33, 33, 22, 22, 
22, 22, 4, 4, 4, 4, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 24, 24, 
24, 24, 32, 32, 32, 32, 40, 40, 
40, 40, 86, 86, 86, 86, 108, 108, 
108, 108, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 101, 101, 
101, 101, 49, 49, 49, 49, 84, 84, 
84, 84, 224, 224, 224, 224, 242, 242, 
242, 253, 235, 235, 235, 255, 122, 122, 
122, 255, 3, 3, 3, 255, 166, 166, 
166, 255, 241, 241, 241, 241, 122, 122, 
122, 122, 12, 12, 12, 12, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 6, 6, 6, 6, 23, 23, 
23, 23, 38, 38, 38, 38, 81, 81, 
81, 81, 108, 108, 108, 108, 109, 109, 
109, 109, 109, 109, 109, 109, 108, 108, 
108, 108, 88, 88, 88, 88, 41, 41, 
41, 41, 27, 27, 27, 27, 10, 10, 
10, 10, 3, 3, 3, 3, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 17, 17, 17, 17, 156, 156, 
156, 156, 228, 228, 228, 252, 87, 91, 
93, 255, 85, 90, 92, 255, 210, 212, 
212, 254, 218, 218, 218, 218, 126, 126, 
126, 126, 109, 109, 109, 109, 90, 90, 
90, 90, 41, 41, 41, 41, 15, 15, 
15, 15, 2, 2, 2, 2, 1, 1, 
1, 1, 2, 2, 2, 2, 12, 12, 
12, 12, 38, 38, 38, 38, 84, 84, 
84, 84, 108, 108, 108, 108, 109, 109, 
109, 109, 107, 107, 107, 107, 82, 82, 
82, 82, 40, 40, 40, 40, 33, 33, 
33, 33, 33, 33, 33, 33, 33, 33, 
33, 33, 33, 33, 33, 33, 31, 31, 
31, 31, 16, 16, 16, 16, 2, 2, 
2, 2, 10, 10, 10, 10, 29, 29, 
29, 29, 33, 33, 33, 33, 33, 33, 
33, 33, 32, 32, 32, 32, 17, 17, 
17, 17, 4, 4, 4, 4, 12, 12, 
12, 12, 33, 33, 33, 33, 75, 75, 
75, 75, 107, 107, 107, 107, 109, 109, 
109, 109, 109, 109, 109, 109, 106, 106, 
106, 106, 68, 68, 68, 68, 29, 29, 
29, 29, 8, 8, 8, 8, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 3, 3, 3, 3, 10, 10, 
10, 10, 29, 29, 29, 29, 47, 47, 
47, 47, 98, 98, 98, 98, 109, 109, 
109, 109, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 107, 107, 
107, 107, 70, 70, 70, 70, 34, 34, 
34, 34, 21, 21, 21, 21, 6, 6, 
6, 6, 3, 3, 3, 3, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 65, 65, 
65, 65, 176, 176, 176, 176, 194, 194, 
194, 194, 194, 194, 194, 194, 193, 193, 
193, 193, 137, 137, 137, 137, 22, 22, 
22, 22, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 29, 29, 
29, 29, 139, 139, 139, 139, 230, 230, 
230, 230, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 241, 241, 241, 241, 220, 220, 
220, 220, 146, 146, 146, 146, 37, 37, 
37, 37, 8, 8, 8, 8, 71, 71, 
71, 71, 172, 172, 172, 172, 194, 194, 
194, 194, 194, 194, 194, 194, 193, 193, 
193, 193, 148, 148, 148, 148, 97, 97, 
97, 97, 172, 172, 172, 172, 194, 194, 
194, 194, 194, 194, 194, 194, 193, 193, 
193, 193, 144, 144, 144, 144, 30, 30, 
30, 30, 7, 7, 7, 7, 68, 68, 
68, 68, 176, 176, 176, 176, 231, 231, 
231, 231, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 237, 237, 237, 237, 195, 195, 
195, 195, 96, 96, 96, 96, 68, 68, 
68, 68, 167, 167, 167, 167, 194, 194, 
194, 194, 193, 193, 193, 193, 147, 147, 
147, 147, 33, 33, 33, 33, 2, 2, 
2, 2, 23, 23, 23, 23, 121, 121, 
121, 121, 207, 207, 207, 207, 239, 239, 
239, 239, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 236, 236, 236, 236, 173, 173, 
173, 173, 82, 82, 82, 82, 37, 37, 
37, 37, 118, 118, 118, 118, 206, 206, 
206, 206, 239, 239, 239, 239, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 225, 225, 
225, 225, 198, 198, 198, 198, 193, 193, 
193, 193, 152, 152, 152, 152, 39, 39, 
39, 39, 1, 1, 1, 1, 0, 0, 
0, 0, 1, 1, 1, 1, 47, 47, 
47, 47, 160, 160, 160, 160, 193, 193, 
193, 193, 199, 199, 199, 199, 228, 228, 
228, 228, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 237, 237, 237, 237, 173, 173, 
173, 173, 83, 83, 83, 83, 122, 122, 
122, 122, 177, 177, 177, 177, 239, 239, 
239, 239, 212, 212, 212, 255, 23, 23, 
23, 255, 85, 85, 85, 255, 249, 249, 
249, 252, 175, 175, 175, 175, 30, 30, 
30, 30, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 7, 7, 
7, 7, 34, 34, 34, 34, 91, 91, 
91, 91, 162, 162, 162, 162, 197, 197, 
197, 197, 225, 225, 225, 225, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 229, 229, 
229, 229, 199, 199, 199, 199, 175, 175, 
175, 175, 118, 118, 118, 118, 59, 59, 
59, 59, 16, 16, 16, 16, 3, 3, 
3, 3, 1, 1, 1, 1, 17, 17, 
17, 17, 156, 156, 156, 156, 227, 228, 
228, 252, 85, 91, 93, 255, 85, 90, 
92, 255, 208, 211, 212, 255, 252, 252, 
252, 252, 244, 244, 244, 244, 242, 242, 
242, 242, 230, 230, 230, 230, 195, 195, 
195, 195, 122, 122, 122, 122, 25, 25, 
25, 25, 5, 5, 5, 5, 39, 39, 
39, 39, 119, 119, 119, 119, 189, 189, 
189, 189, 226, 226, 226, 226, 242, 242, 
242, 242, 242, 242, 242, 242, 241, 241, 
241, 241, 226, 226, 226, 226, 199, 199, 
199, 199, 194, 194, 194, 194, 194, 194, 
194, 194, 194, 194, 194, 194, 194, 194, 
194, 194, 190, 190, 190, 190, 121, 121, 
121, 121, 21, 21, 21, 21, 80, 80, 
80, 80, 181, 181, 181, 181, 194, 194, 
194, 194, 194, 194, 194, 194, 190, 190, 
190, 190, 133, 133, 133, 133, 86, 86, 
86, 86, 128, 128, 128, 128, 186, 186, 
186, 186, 221, 221, 221, 221, 241, 241, 
241, 241, 242, 242, 242, 242, 242, 242, 
242, 242, 240, 240, 240, 240, 216, 216, 
216, 216, 178, 178, 178, 178, 103, 103, 
103, 103, 27, 27, 27, 27, 2, 2, 
2, 2, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 21, 21, 21, 21, 71, 71, 
71, 71, 121, 121, 121, 121, 182, 182, 
182, 182, 203, 203, 203, 203, 235, 235, 
235, 235, 242, 242, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 242, 242, 242, 
242, 242, 241, 241, 241, 241, 218, 218, 
218, 218, 194, 194, 194, 194, 158, 158, 
158, 158, 110, 110, 110, 110, 68, 68, 
68, 68, 19, 19, 19, 19, 2, 2, 
2, 2, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 120, 120, 120, 120, 246, 246, 
246, 246, 195, 195, 195, 254, 162, 162, 
162, 254, 236, 236, 236, 254, 213, 213, 
213, 213, 44, 44, 44, 44, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 27, 27, 
27, 27, 137, 137, 137, 137, 235, 235, 
235, 235, 231, 231, 231, 254, 133, 133, 
133, 255, 60, 60, 60, 255, 34, 34, 
34, 255, 81, 81, 81, 255, 169, 169, 
169, 255, 245, 245, 245, 254, 240, 240, 
240, 240, 127, 127, 127, 127, 41, 41, 
41, 41, 175, 175, 175, 175, 249, 249, 
249, 249, 175, 175, 175, 254, 162, 162, 
162, 254, 236, 236, 236, 254, 243, 243, 
243, 243, 227, 227, 227, 227, 249, 249, 
249, 249, 181, 181, 181, 254, 162, 162, 
162, 254, 235, 235, 235, 254, 221, 221, 
221, 221, 72, 72, 72, 72, 70, 70, 
70, 70, 191, 191, 191, 191, 248, 248, 
248, 248, 199, 199, 199, 255, 102, 102, 
102, 255, 46, 46, 46, 255, 50, 50, 
50, 255, 106, 106, 106, 255, 200, 200, 
200, 255, 251, 251, 251, 252, 216, 216, 
216, 216, 187, 187, 187, 187, 244, 244, 
244, 244, 174, 174, 174, 254, 195, 195, 
195, 254, 221, 221, 221, 221, 63, 63, 
63, 63, 8, 8, 8, 8, 93, 93, 
93, 93, 223, 223, 223, 223, 249, 249, 
249, 253, 186, 186, 186, 255, 96, 96, 
96, 255, 41, 41, 41, 255, 56, 56, 
56, 255, 116, 116, 116, 255, 212, 212, 
212, 255, 249, 249, 249, 249, 215, 215, 
215, 215, 171, 171, 171, 171, 227, 227, 
227, 227, 246, 246, 246, 253, 168, 168, 
168, 255, 76, 76, 76, 255, 37, 37, 
37, 255, 78, 78, 78, 255, 164, 164, 
164, 255, 240, 240, 240, 255, 174, 174, 
174, 254, 221, 221, 221, 254, 225, 225, 
225, 225, 73, 73, 73, 73, 2, 2, 
2, 2, 0, 0, 0, 0, 3, 3, 
3, 3, 88, 88, 88, 88, 232, 232, 
232, 232, 197, 197, 197, 254, 188, 188, 
188, 254, 230, 230, 230, 255, 129, 129, 
129, 255, 51, 51, 51, 255, 46, 46, 
46, 255, 111, 111, 111, 255, 210, 210, 
210, 255, 245, 245, 245, 245, 174, 174, 
174, 174, 63, 63, 63, 63, 53, 53, 
53, 53, 190, 190, 190, 190, 250, 250, 
250, 253, 60, 60, 60, 255, 25, 25, 
25, 255, 216, 216, 216, 255, 218, 218, 
218, 218, 71, 71, 71, 71, 3, 3, 
3, 3, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 17, 17, 
17, 17, 86, 86, 86, 87, 170, 170, 
170, 172, 226, 226, 226, 227, 248, 248, 
248, 249, 241, 242, 242, 254, 209, 210, 
211, 255, 186, 189, 189, 255, 172, 174, 
175, 255, 169, 172, 172, 255, 180, 183, 
183, 255, 198, 199, 200, 255, 227, 228, 
228, 254, 249, 249, 249, 251, 240, 240, 
240, 240, 203, 203, 203, 205, 134, 134, 
134, 134, 53, 53, 53, 53, 6, 6, 
6, 6, 17, 17, 17, 17, 156, 156, 
156, 156, 228, 228, 229, 252, 87, 91, 
93, 255, 85, 91, 93, 255, 184, 186, 
187, 255, 186, 188, 189, 255, 169, 172, 
173, 255, 180, 182, 183, 255, 212, 213, 
214, 255, 248, 249, 249, 253, 229, 229, 
229, 229, 128, 128, 128, 128, 65, 65, 
65, 65, 160, 160, 160, 160, 237, 237, 
237, 237, 246, 247, 247, 253, 207, 209, 
209, 255, 178, 181, 182, 255, 169, 172, 
172, 255, 182, 183, 184, 255, 208, 210, 
210, 255, 246, 246, 246, 254, 254, 254, 
254, 254, 242, 242, 242, 254, 198, 200, 
200, 254, 202, 203, 204, 254, 248, 248, 
248, 252, 192, 192, 192, 192, 43, 43, 
43, 43, 140, 138, 140, 140, 242, 243, 
242, 249, 198, 200, 200, 254, 200, 202, 
202, 254, 241, 240, 241, 253, 236, 237, 
237, 238, 226, 226, 226, 227, 243, 243, 
243, 244, 247, 248, 249, 252, 211, 223, 
235, 255, 176, 198, 219, 255, 154, 183, 
209, 255, 153, 181, 209, 255, 178, 200, 
220, 255, 218, 227, 237, 254, 251, 251, 
251, 252, 228, 230, 229, 230, 136, 136, 
135, 136, 28, 28, 28, 28, 2, 2, 
2, 2, 1, 1, 1, 1, 7, 7, 
7, 8, 43, 42, 43, 44, 140, 140, 
140, 142, 215, 215, 215, 217, 242, 242, 
242, 243, 250, 250, 250, 252, 227, 234, 
241, 254, 190, 208, 226, 255, 169, 194, 
216, 255, 150, 179, 208, 255, 150, 180, 
208, 255, 162, 188, 213, 255, 177, 200, 
220, 255, 201, 215, 230, 254, 238, 242, 
246, 254, 248, 248, 248, 249, 240, 240, 
240, 241, 214, 214, 213, 215, 134, 135, 
134, 136, 29, 29, 29, 29, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 205, 205, 
205, 255, 218, 218, 218, 218, 46, 46, 
46, 46, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 4, 4, 
4, 4, 97, 97, 97, 97, 231, 231, 
231, 231, 228, 228, 228, 254, 59, 59, 
59, 255, 10, 10, 10, 255, 86, 86, 
86, 255, 117, 117, 117, 255, 59, 59, 
59, 255, 9, 9, 9, 255, 95, 95, 
95, 255, 247, 247, 247, 254, 204, 204, 
204, 204, 97, 97, 97, 97, 208, 208, 
208, 208, 232, 232, 232, 254, 19, 19, 
19, 255, 0, 0, 0, 255, 177, 177, 
177, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 237, 237, 237, 255, 25, 25, 
25, 255, 0, 0, 0, 255, 155, 155, 
155, 255, 245, 245, 245, 245, 158, 158, 
158, 158, 185, 185, 185, 185, 248, 248, 
248, 248, 163, 163, 163, 255, 20, 20, 
20, 255, 24, 24, 24, 255, 100, 100, 
100, 255, 108, 108, 108, 255, 36, 36, 
36, 255, 17, 17, 17, 255, 157, 157, 
157, 255, 252, 252, 252, 253, 250, 250, 
250, 250, 254, 254, 254, 254, 35, 35, 
35, 255, 92, 92, 92, 255, 225, 225, 
225, 225, 66, 66, 66, 66, 33, 33, 
33, 33, 172, 172, 172, 172, 250, 250, 
250, 250, 137, 137, 137, 255, 14, 14, 
14, 255, 33, 33, 33, 255, 107, 107, 
107, 255, 99, 99, 99, 255, 28, 28, 
28, 255, 26, 26, 26, 255, 179, 179, 
179, 255, 253, 253, 253, 253, 249, 249, 
249, 249, 251, 251, 251, 254, 115, 115, 
115, 255, 7, 7, 7, 255, 29, 29, 
29, 255, 78, 78, 78, 255, 63, 63, 
63, 255, 15, 15, 15, 255, 100, 100, 
100, 255, 21, 21, 21, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 46, 46, 46, 255, 62, 62, 
62, 255, 21, 21, 21, 255, 75, 75, 
75, 255, 65, 65, 65, 255, 9, 9, 
9, 255, 32, 32, 32, 255, 195, 195, 
195, 255, 243, 243, 243, 243, 145, 145, 
145, 145, 66, 66, 66, 66, 198, 198, 
198, 198, 228, 228, 228, 254, 37, 37, 
37, 255, 1, 1, 1, 255, 154, 154, 
154, 255, 241, 241, 241, 241, 121, 121, 
121, 121, 12, 12, 12, 12, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 17, 17, 
17, 17, 104, 104, 104, 104, 214, 214, 
214, 214, 248, 248, 248, 250, 218, 220, 
220, 255, 150, 153, 154, 255, 99, 104, 
105, 255, 84, 89, 91, 255, 81, 86, 
88, 255, 79, 85, 87, 255, 79, 85, 
87, 255, 80, 86, 88, 255, 82, 87, 
89, 255, 90, 94, 96, 255, 119, 124, 
125, 255, 184, 186, 187, 255, 241, 241, 
242, 254, 242, 242, 242, 242, 181, 181, 
181, 181, 61, 61, 61, 61, 22, 22, 
22, 22, 157, 157, 157, 157, 228, 228, 
228, 252, 87, 91, 93, 255, 81, 87, 
89, 255, 84, 90, 91, 255, 77, 82, 
84, 255, 75, 80, 82, 255, 77, 83, 
85, 255, 84, 89, 91, 255, 126, 131, 
132, 255, 228, 229, 229, 254, 234, 234, 
234, 234, 210, 210, 210, 210, 243, 243, 
243, 243, 221, 222, 222, 255, 121, 126, 
126, 255, 83, 88, 91, 255, 80, 85, 
87, 255, 77, 83, 85, 255, 79, 84, 
87, 255, 83, 89, 91, 255, 107, 111, 
113, 255, 195, 196, 196, 255, 216, 217, 
218, 255, 75, 81, 83, 255, 89, 94, 
95, 255, 242, 242, 242, 254, 198, 198, 
198, 198, 45, 45, 45, 45, 145, 145, 
145, 145, 233, 233, 233, 251, 76, 81, 
83, 255, 84, 89, 91, 255, 216, 217, 
217, 255, 254, 254, 254, 255, 251, 252, 
253, 255, 181, 201, 221, 255, 86, 134, 
180, 255, 51, 108, 164, 255, 44, 104, 
161, 255, 43, 103, 160, 255, 43, 103, 
160, 255, 43, 104, 161, 255, 53, 110, 
164, 255, 112, 152, 190, 255, 228, 235, 
242, 254, 234, 234, 234, 234, 135, 135, 
135, 135, 27, 27, 27, 27, 11, 11, 
11, 11, 82, 82, 82, 82, 184, 184, 
184, 186, 240, 239, 239, 241, 244, 246, 
249, 254, 174, 197, 219, 255, 95, 140, 
183, 255, 55, 112, 166, 255, 45, 105, 
162, 255, 45, 104, 160, 255, 43, 103, 
160, 255, 42, 103, 161, 255, 43, 104, 
161, 255, 44, 104, 161, 255, 48, 107, 
163, 255, 62, 117, 169, 255, 112, 152, 
191, 255, 180, 202, 222, 255, 239, 243, 
247, 254, 234, 234, 234, 235, 103, 103, 
103, 103, 4, 4, 4, 4, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 91, 91, 91, 255, 0, 0, 
0, 255, 205, 205, 205, 255, 218, 218, 
218, 218, 46, 46, 46, 46, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 17, 17, 17, 17, 153, 153, 
153, 153, 249, 249, 249, 249, 105, 105, 
105, 255, 5, 5, 5, 255, 158, 158, 
158, 255, 251, 251, 251, 255, 253, 253, 
253, 253, 241, 241, 241, 255, 88, 88, 
88, 255, 3, 3, 3, 255, 171, 171, 
171, 255, 246, 246, 246, 246, 211, 211, 
211, 211, 241, 241, 241, 241, 176, 176, 
176, 255, 5, 5, 5, 255, 5, 5, 
5, 255, 115, 115, 115, 255, 254, 254, 
254, 255, 255, 255, 255, 255, 184, 184, 
184, 255, 8, 8, 8, 255, 0, 0, 
0, 255, 89, 89, 89, 255, 250, 250, 
250, 254, 234, 234, 234, 234, 243, 243, 
243, 243, 222, 222, 222, 255, 28, 28, 
28, 255, 35, 35, 35, 255, 204, 204, 
204, 255, 253, 253, 253, 255, 255, 255, 
255, 255, 214, 214, 214, 255, 41, 41, 
41, 255, 24, 24, 24, 255, 221, 221, 
221, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 35, 35, 35, 255, 92, 92, 
92, 255, 225, 225, 225, 225, 68, 68, 
68, 68, 84, 84, 84, 84, 226, 226, 
226, 226, 200, 200, 200, 255, 17, 17, 
17, 255, 54, 54, 54, 255, 216, 216, 
216, 255, 254, 254, 254, 255, 253, 253, 
253, 255, 198, 198, 198, 255, 26, 26, 
26, 255, 45, 45, 45, 255, 232, 232, 
232, 255, 255, 255, 255, 255, 184, 184, 
184, 255, 12, 12, 12, 255, 55, 55, 
55, 255, 212, 212, 212, 255, 248, 248, 
248, 253, 242, 242, 242, 254, 159, 159, 
159, 255, 15, 15, 15, 255, 1, 1, 
1, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 1, 1, 
1, 255, 42, 42, 42, 255, 204, 204, 
204, 255, 247, 247, 247, 253, 243, 243, 
243, 254, 175, 175, 175, 255, 19, 19, 
19, 255, 63, 63, 63, 255, 240, 240, 
240, 254, 198, 198, 198, 198, 137, 137, 
137, 137, 233, 233, 233, 233, 179, 179, 
179, 255, 3, 3, 3, 255, 0, 0, 
0, 255, 66, 66, 66, 255, 246, 246, 
246, 253, 191, 191, 191, 191, 47, 47, 
47, 47, 2, 2, 2, 2, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 17, 17, 
17, 17, 102, 103, 103, 103, 216, 216, 
216, 216, 243, 244, 244, 253, 163, 165, 
166, 255, 91, 96, 97, 255, 79, 85, 
87, 255, 80, 86, 88, 255, 79, 85, 
87, 255, 77, 83, 85, 255, 74, 81, 
82, 255, 74, 80, 81, 255, 75, 81, 
83, 255, 78, 83, 86, 255, 80, 85, 
88, 255, 81, 85, 88, 255, 80, 86, 
87, 255, 113, 117, 119, 255, 203, 205, 
206, 255, 246, 246, 246, 247, 181, 180, 
181, 181, 77, 77, 77, 77, 162, 162, 
162, 162, 228, 228, 228, 252, 87, 91, 
93, 255, 81, 87, 89, 255, 122, 126, 
128, 255, 181, 183, 184, 255, 202, 203, 
204, 255, 162, 165, 166, 255, 96, 100, 
102, 255, 78, 84, 86, 255, 110, 115, 
116, 255, 236, 237, 237, 255, 254, 254, 
254, 254, 236, 237, 237, 255, 107, 110, 
112, 255, 78, 84, 86, 255, 81, 87, 
88, 255, 121, 125, 127, 255, 152, 154, 
156, 255, 144, 147, 149, 255, 117, 122, 
123, 255, 80, 86, 87, 255, 120, 124, 
125, 255, 216, 217, 218, 255, 74, 80, 
82, 255, 87, 92, 94, 255, 242, 242, 
242, 254, 198, 198, 198, 198, 45, 45, 
45, 45, 145, 145, 145, 145, 232, 233, 
233, 251, 74, 80, 82, 255, 83, 88, 
90, 255, 216, 217, 217, 255, 253, 254, 
254, 255, 156, 184, 210, 255, 44, 104, 
161, 255, 43, 103, 160, 255, 42, 104, 
160, 255, 39, 101, 159, 255, 42, 102, 
159, 255, 42, 103, 160, 255, 40, 101, 
159, 255, 44, 104, 160, 255, 42, 103, 
160, 255, 79, 129, 176, 255, 232, 238, 
244, 254, 230, 230, 231, 231, 112, 112, 
112, 113, 88, 89, 87, 89, 203, 204, 
203, 204, 250, 249, 250, 251, 202, 217, 
231, 255, 87, 134, 180, 255, 43, 103, 
160, 255, 43, 103, 160, 255, 43, 103, 
161, 255, 39, 101, 159, 255, 40, 101, 
159, 255, 54, 111, 165, 255, 54, 111, 
166, 255, 40, 101, 159, 255, 40, 101, 
159, 255, 43, 103, 160, 255, 44, 104, 
161, 255, 43, 103, 160, 255, 43, 104, 
161, 255, 104, 147, 187, 255, 250, 250, 
250, 250, 126, 126, 126, 126, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 205, 205, 
205, 255, 218, 218, 218, 218, 47, 47, 
47, 47, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 35, 35, 
35, 35, 201, 201, 201, 201, 242, 242, 
242, 254, 20, 20, 20, 255, 66, 66, 
66, 255, 246, 246, 246, 255, 234, 234, 
234, 234, 187, 187, 187, 187, 235, 235, 
235, 235, 228, 228, 228, 255, 18, 18, 
18, 255, 70, 70, 70, 255, 248, 248, 
248, 255, 254, 254, 254, 254, 255, 255, 
255, 255, 104, 104, 104, 255, 11, 11, 
11, 255, 54, 54, 54, 255, 63, 63, 
63, 255, 246, 246, 246, 255, 255, 255, 
255, 255, 133, 133, 133, 255, 4, 4, 
4, 255, 62, 62, 62, 255, 29, 29, 
29, 255, 236, 236, 236, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 141, 141, 
141, 255, 2, 2, 2, 255, 169, 169, 
169, 255, 254, 254, 254, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 171, 171, 171, 255, 56, 56, 
56, 255, 186, 186, 186, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 35, 35, 
35, 255, 92, 92, 92, 255, 225, 225, 
225, 225, 69, 69, 69, 69, 103, 103, 
103, 103, 240, 240, 240, 240, 110, 110, 
110, 255, 6, 6, 6, 255, 194, 194, 
194, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 147, 147, 147, 255, 56, 56, 
56, 255, 210, 210, 210, 255, 255, 255, 
255, 255, 88, 88, 88, 255, 9, 9, 
9, 255, 192, 192, 192, 255, 245, 245, 
245, 245, 194, 194, 194, 194, 219, 219, 
219, 219, 248, 248, 248, 253, 92, 92, 
92, 255, 0, 0, 0, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 3, 3, 3, 255, 168, 168, 
168, 255, 246, 246, 246, 246, 195, 195, 
195, 195, 217, 217, 217, 217, 250, 250, 
250, 253, 117, 117, 117, 255, 5, 5, 
5, 255, 191, 191, 191, 255, 246, 246, 
246, 246, 227, 227, 227, 227, 250, 250, 
250, 250, 98, 98, 98, 255, 19, 19, 
19, 255, 67, 67, 67, 255, 18, 18, 
18, 255, 205, 205, 205, 255, 232, 232, 
232, 232, 91, 91, 91, 91, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 15, 15, 
15, 15, 101, 101, 101, 101, 214, 215, 
215, 215, 240, 240, 240, 252, 135, 138, 
139, 255, 80, 86, 88, 255, 81, 86, 
88, 255, 79, 85, 87, 255, 85, 90, 
92, 255, 130, 133, 135, 255, 175, 178, 
178, 255, 206, 208, 208, 255, 215, 217, 
217, 255, 200, 201, 202, 255, 165, 168, 
168, 255, 120, 124, 125, 255, 79, 85, 
87, 255, 80, 86, 88, 255, 79, 85, 
87, 255, 88, 93, 95, 255, 179, 181, 
182, 255, 245, 245, 245, 246, 194, 194, 
194, 194, 205, 205, 205, 205, 229, 229, 
230, 253, 87, 91, 93, 255, 85, 91, 
92, 255, 211, 212, 213, 255, 247, 247, 
247, 248, 238, 238, 238, 238, 249, 249, 
249, 251, 220, 221, 221, 255, 97, 101, 
103, 255, 80, 84, 87, 255, 156, 159, 
160, 255, 254, 254, 254, 255, 164, 167, 
167, 255, 78, 83, 86, 255, 86, 92, 
93, 255, 187, 189, 190, 255, 247, 248, 
248, 255, 249, 249, 249, 249, 247, 247, 
247, 248, 245, 246, 246, 255, 209, 211, 
211, 255, 160, 163, 163, 255, 216, 217, 
218, 255, 74, 80, 83, 255, 87, 92, 
95, 255, 241, 242, 242, 254, 198, 198, 
198, 198, 45, 45, 45, 45, 145, 145, 
145, 145, 233, 233, 234, 251, 74, 80, 
82, 255, 83, 89, 91, 255, 216, 216, 
218, 255, 253, 253, 254, 255, 122, 160, 
195, 255, 42, 103, 160, 255, 41, 102, 
159, 255, 95, 140, 183, 255, 167, 192, 
215, 255, 214, 225, 236, 255, 212, 224, 
235, 255, 155, 183, 209, 255, 62, 117, 
169, 255, 43, 103, 161, 255, 42, 103, 
160, 255, 115, 155, 192, 255, 252, 252, 
252, 253, 217, 217, 217, 219, 216, 217, 
216, 218, 250, 250, 250, 252, 174, 197, 
219, 255, 52, 110, 164, 255, 43, 103, 
161, 255, 43, 104, 161, 255, 40, 102, 
159, 255, 93, 139, 183, 255, 158, 184, 
211, 255, 209, 222, 233, 255, 223, 232, 
240, 254, 224, 232, 240, 254, 209, 222, 
234, 255, 159, 185, 211, 255, 108, 149, 
189, 255, 61, 116, 168, 255, 44, 104, 
161, 255, 43, 103, 161, 255, 86, 133, 
179, 255, 250, 250, 250, 250, 127, 127, 
127, 127, 5, 5, 5, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 91, 91, 91, 255, 0, 0, 
0, 255, 205, 205, 205, 255, 222, 222, 
222, 222, 69, 69, 69, 69, 28, 28, 
28, 28, 27, 27, 27, 27, 27, 27, 
27, 27, 27, 27, 27, 27, 17, 17, 
17, 17, 40, 40, 40, 40, 207, 207, 
207, 207, 199, 199, 199, 255, 7, 7, 
7, 255, 124, 124, 124, 255, 249, 249, 
249, 249, 156, 156, 156, 156, 57, 57, 
57, 57, 176, 176, 176, 176, 251, 251, 
251, 251, 68, 68, 68, 255, 19, 19, 
19, 255, 239, 239, 239, 255, 255, 255, 
255, 255, 251, 251, 251, 255, 38, 38, 
38, 255, 65, 65, 65, 255, 130, 130, 
130, 255, 13, 13, 13, 255, 231, 231, 
231, 255, 255, 255, 255, 255, 66, 66, 
66, 255, 40, 40, 40, 255, 143, 143, 
143, 255, 3, 3, 3, 255, 185, 185, 
185, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 86, 86, 86, 255, 16, 16, 
16, 255, 228, 228, 228, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 251, 251, 
251, 255, 240, 240, 240, 255, 248, 248, 
248, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 35, 35, 35, 255, 92, 92, 
92, 255, 225, 225, 225, 225, 69, 69, 
69, 69, 104, 104, 104, 104, 240, 240, 
240, 240, 54, 54, 54, 255, 42, 42, 
42, 255, 234, 234, 234, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 250, 250, 
250, 255, 239, 239, 239, 255, 250, 250, 
250, 255, 247, 247, 247, 255, 43, 43, 
43, 255, 55, 55, 55, 255, 239, 239, 
239, 254, 206, 206, 206, 206, 74, 74, 
74, 74, 120, 120, 120, 120, 236, 236, 
236, 236, 179, 179, 179, 255, 5, 5, 
5, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 28, 28, 
28, 255, 220, 220, 220, 254, 209, 209, 
209, 209, 78, 78, 78, 78, 114, 114, 
114, 114, 234, 234, 234, 234, 188, 188, 
188, 255, 6, 6, 6, 255, 142, 142, 
142, 255, 255, 255, 255, 255, 254, 254, 
254, 254, 230, 230, 230, 255, 39, 39, 
39, 255, 65, 65, 65, 255, 183, 183, 
183, 255, 9, 9, 9, 255, 129, 129, 
129, 255, 247, 247, 247, 247, 149, 149, 
149, 149, 19, 19, 19, 19, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 4, 4, 
4, 4, 70, 70, 70, 70, 206, 206, 
206, 207, 243, 244, 244, 252, 139, 143, 
143, 255, 79, 85, 87, 255, 81, 86, 
88, 255, 81, 85, 88, 255, 128, 132, 
134, 255, 216, 218, 218, 255, 247, 247, 
247, 253, 242, 242, 242, 242, 230, 230, 
230, 231, 228, 228, 228, 229, 230, 230, 
230, 231, 243, 244, 244, 244, 244, 245, 
245, 254, 204, 205, 206, 255, 112, 116, 
117, 255, 79, 84, 86, 255, 81, 86, 
88, 255, 85, 90, 92, 255, 185, 187, 
187, 255, 251, 251, 251, 251, 250, 250, 
250, 250, 231, 232, 232, 255, 87, 91, 
93, 255, 85, 91, 92, 255, 211, 213, 
213, 254, 208, 208, 208, 209, 121, 121, 
121, 122, 198, 198, 198, 199, 250, 250, 
250, 251, 173, 175, 176, 255, 77, 82, 
85, 255, 99, 104, 106, 255, 237, 237, 
237, 255, 109, 113, 115, 255, 79, 84, 
87, 255, 156, 159, 160, 255, 253, 253, 
253, 255, 254, 254, 254, 254, 233, 233, 
233, 233, 228, 228, 228, 228, 253, 253, 
253, 254, 254, 254, 255, 255, 251, 251, 
251, 255, 216, 217, 218, 255, 74, 80, 
83, 255, 87, 92, 95, 255, 241, 242, 
242, 254, 198, 198, 198, 198, 45, 45, 
45, 45, 145, 145, 145, 145, 233, 233, 
234, 251, 74, 80, 82, 255, 83, 89, 
91, 255, 216, 216, 218, 255, 253, 253, 
254, 255, 122, 160, 195, 255, 60, 115, 
168, 255, 179, 200, 221, 255, 242, 245, 
248, 253, 240, 238, 238, 240, 229, 228, 
228, 230, 232, 234, 234, 234, 249, 250, 
249, 251, 213, 224, 236, 255, 53, 111, 
165, 255, 43, 104, 161, 255, 53, 110, 
165, 255, 234, 240, 245, 255, 253, 252, 
253, 254, 252, 253, 252, 254, 184, 204, 
223, 255, 47, 106, 162, 255, 44, 104, 
161, 255, 43, 103, 161, 255, 69, 121, 
172, 255, 188, 207, 225, 255, 242, 245, 
248, 253, 245, 244, 245, 246, 230, 230, 
229, 230, 195, 195, 195, 196, 193, 193, 
192, 194, 226, 225, 225, 227, 241, 240, 
240, 242, 249, 250, 251, 254, 188, 207, 
224, 255, 38, 100, 158, 255, 43, 103, 
161, 255, 87, 133, 179, 255, 250, 250, 
250, 250, 127, 127, 127, 127, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 205, 205, 
205, 255, 244, 244, 244, 244, 194, 194, 
194, 194, 181, 181, 181, 181, 180, 180, 
180, 180, 180, 180, 180, 180, 179, 179, 
179, 179, 138, 138, 138, 138, 97, 97, 
97, 97, 214, 214, 214, 214, 179, 179, 
179, 255, 5, 5, 5, 255, 155, 155, 
155, 255, 230, 230, 230, 230, 79, 79, 
79, 79, 11, 11, 11, 11, 123, 123, 
123, 123, 246, 246, 246, 246, 103, 103, 
103, 255, 0, 0, 0, 255, 236, 236, 
236, 255, 255, 255, 255, 255, 208, 208, 
208, 255, 12, 12, 12, 255, 124, 124, 
124, 255, 190, 190, 190, 255, 9, 9, 
9, 255, 183, 183, 183, 255, 239, 239, 
239, 255, 23, 23, 23, 255, 94, 94, 
94, 255, 209, 209, 209, 255, 15, 15, 
15, 255, 116, 116, 116, 255, 254, 254, 
254, 255, 255, 255, 255, 255, 71, 71, 
71, 255, 12, 12, 12, 255, 87, 87, 
87, 255, 94, 94, 94, 255, 94, 94, 
94, 255, 94, 94, 94, 255, 94, 94, 
94, 255, 94, 94, 94, 255, 94, 94, 
94, 255, 153, 153, 153, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 35, 35, 
35, 255, 92, 92, 92, 255, 228, 228, 
228, 228, 78, 78, 78, 78, 105, 105, 
105, 105, 240, 240, 240, 240, 38, 38, 
38, 255, 22, 22, 22, 255, 89, 89, 
89, 255, 94, 94, 94, 255, 94, 94, 
94, 255, 94, 94, 94, 255, 94, 94, 
94, 255, 94, 94, 94, 255, 94, 94, 
94, 255, 174, 174, 174, 255, 227, 227, 
227, 255, 30, 30, 30, 255, 80, 80, 
80, 255, 251, 251, 251, 252, 165, 165, 
165, 165, 24, 24, 24, 24, 55, 55, 
55, 55, 204, 204, 204, 204, 201, 201, 
201, 254, 16, 16, 16, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 48, 48, 48, 255, 234, 234, 
234, 253, 172, 172, 172, 172, 28, 28, 
28, 28, 45, 45, 45, 45, 194, 194, 
194, 194, 207, 207, 207, 253, 20, 20, 
20, 255, 110, 110, 110, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 181, 181, 
181, 255, 4, 4, 4, 255, 140, 140, 
140, 255, 241, 241, 241, 255, 54, 54, 
54, 255, 55, 55, 55, 255, 240, 240, 
240, 254, 194, 194, 194, 194, 46, 46, 
46, 46, 2, 2, 2, 2, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 20, 20, 20, 21, 145, 145, 
145, 146, 245, 245, 244, 246, 181, 184, 
184, 255, 80, 86, 87, 255, 81, 87, 
89, 255, 81, 87, 88, 255, 150, 153, 
153, 255, 243, 244, 244, 254, 239, 239, 
239, 239, 187, 187, 187, 187, 127, 127, 
127, 127, 82, 82, 82, 82, 76, 76, 
76, 76, 81, 81, 81, 82, 136, 136, 
136, 136, 206, 206, 206, 206, 244, 244, 
244, 244, 233, 234, 234, 255, 127, 130, 
132, 255, 80, 85, 87, 255, 80, 86, 
88, 255, 92, 99, 100, 255, 221, 223, 
223, 255, 254, 254, 254, 255, 231, 232, 
232, 255, 87, 91, 93, 255, 85, 91, 
93, 255, 212, 213, 213, 254, 190, 190, 
190, 190, 40, 40, 40, 41, 98, 98, 
98, 98, 233, 233, 233, 233, 222, 222, 
223, 255, 82, 87, 90, 255, 87, 93, 
95, 255, 206, 207, 207, 255, 83, 89, 
91, 255, 84, 90, 92, 255, 210, 212, 
212, 255, 251, 252, 252, 255, 251, 252, 
252, 255, 247, 248, 248, 251, 246, 247, 
247, 250, 251, 251, 251, 255, 251, 252, 
252, 255, 252, 252, 252, 255, 215, 217, 
218, 255, 74, 80, 83, 255, 87, 92, 
95, 255, 241, 242, 242, 254, 198, 198, 
198, 198, 45, 45, 45, 45, 145, 145, 
145, 145, 233, 233, 234, 251, 74, 80, 
82, 255, 83, 89, 91, 255, 216, 216, 
217, 255, 252, 253, 253, 255, 145, 176, 
206, 255, 211, 224, 235, 255, 246, 246, 
246, 247, 194, 193, 194, 194, 117, 116, 
116, 117, 77, 77, 77, 78, 97, 98, 
98, 98, 203, 203, 202, 203, 251, 252, 
253, 254, 114, 155, 191, 255, 44, 103, 
161, 255, 44, 104, 160, 255, 200, 215, 
230, 255, 254, 255, 254, 255, 230, 237, 
243, 255, 58, 114, 166, 255, 45, 104, 
161, 255, 44, 103, 160, 255, 76, 127, 
175, 255, 226, 233, 241, 255, 247, 247, 
247, 248, 198, 197, 197, 198, 140, 140, 
139, 140, 84, 84, 84, 84, 49, 50, 
49, 50, 49, 48, 48, 49, 79, 78, 
78, 79, 140, 139, 139, 140, 241, 241, 
241, 241, 203, 217, 231, 255, 37, 99, 
158, 255, 43, 104, 161, 255, 87, 133, 
179, 255, 250, 250, 250, 250, 127, 127, 
127, 127, 5, 5, 5, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 91, 91, 91, 255, 0, 0, 
0, 255, 167, 167, 167, 255, 207, 207, 
207, 255, 206, 206, 206, 254, 205, 205, 
205, 253, 205, 205, 205, 253, 212, 212, 
212, 253, 244, 244, 244, 253, 244, 244, 
244, 244, 221, 221, 221, 221, 243, 243, 
243, 243, 179, 179, 179, 255, 5, 5, 
5, 255, 152, 152, 152, 255, 231, 231, 
231, 231, 84, 84, 84, 84, 13, 13, 
13, 13, 126, 126, 126, 126, 246, 246, 
246, 246, 95, 95, 95, 255, 3, 3, 
3, 255, 237, 237, 237, 255, 255, 255, 
255, 255, 144, 144, 144, 255, 1, 1, 
1, 255, 190, 190, 190, 255, 242, 242, 
242, 255, 24, 24, 24, 255, 118, 118, 
118, 255, 183, 183, 183, 255, 7, 7, 
7, 255, 151, 151, 151, 255, 250, 250, 
250, 255, 37, 37, 37, 255, 57, 57, 
57, 255, 243, 243, 243, 255, 255, 255, 
255, 255, 71, 71, 71, 255, 3, 3, 
3, 255, 64, 64, 64, 255, 71, 71, 
71, 255, 71, 71, 71, 255, 71, 71, 
71, 255, 71, 71, 71, 255, 63, 63, 
63, 255, 6, 6, 6, 255, 94, 94, 
94, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 35, 35, 35, 255, 92, 92, 
92, 255, 244, 244, 244, 244, 138, 138, 
138, 138, 120, 120, 120, 120, 240, 240, 
240, 240, 38, 38, 38, 255, 11, 11, 
11, 255, 65, 65, 65, 255, 71, 71, 
71, 255, 71, 71, 71, 255, 71, 71, 
71, 255, 71, 71, 71, 255, 56, 56, 
56, 255, 4, 4, 4, 255, 126, 126, 
126, 255, 227, 227, 227, 255, 30, 30, 
30, 255, 77, 77, 77, 255, 250, 250, 
250, 253, 167, 167, 167, 167, 28, 28, 
28, 28, 77, 77, 77, 77, 221, 221, 
221, 221, 197, 197, 197, 254, 13, 13, 
13, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 44, 44, 
44, 255, 232, 232, 232, 254, 190, 190, 
190, 190, 44, 44, 44, 44, 50, 50, 
50, 50, 197, 197, 197, 197, 204, 204, 
204, 254, 16, 16, 16, 255, 110, 110, 
110, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 101, 101, 101, 255, 18, 18, 
18, 255, 206, 206, 206, 255, 255, 255, 
255, 255, 124, 124, 124, 255, 10, 10, 
10, 255, 192, 192, 192, 255, 231, 231, 
231, 231, 90, 90, 90, 90, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 61, 61, 
61, 62, 208, 208, 208, 210, 234, 235, 
236, 254, 102, 107, 109, 255, 80, 86, 
88, 255, 79, 84, 87, 255, 139, 142, 
143, 255, 245, 245, 245, 253, 218, 218, 
218, 218, 135, 135, 135, 135, 47, 47, 
47, 48, 14, 14, 14, 14, 4, 4, 
4, 4, 2, 2, 2, 2, 4, 4, 
4, 4, 18, 18, 18, 18, 63, 63, 
63, 63, 152, 152, 152, 152, 236, 236, 
236, 237, 233, 234, 234, 255, 107, 112, 
113, 255, 80, 86, 88, 255, 79, 85, 
87, 255, 139, 142, 144, 255, 253, 253, 
253, 255, 231, 232, 232, 255, 87, 91, 
93, 255, 85, 91, 93, 255, 212, 213, 
213, 254, 189, 189, 189, 189, 33, 33, 
33, 33, 69, 69, 69, 69, 226, 226, 
226, 226, 230, 231, 231, 255, 88, 92, 
95, 255, 86, 92, 94, 255, 195, 196, 
197, 255, 72, 78, 80, 255, 82, 87, 
90, 255, 116, 120, 122, 255, 121, 125, 
127, 255, 121, 125, 127, 255, 121, 125, 
127, 255, 120, 125, 126, 255, 122, 126, 
128, 255, 124, 128, 129, 255, 139, 143, 
144, 255, 216, 217, 218, 255, 74, 80, 
83, 255, 87, 92, 95, 255, 241, 242, 
242, 254, 198, 198, 198, 198, 47, 47, 
47, 47, 148, 148, 148, 148, 233, 233, 
234, 251, 74, 80, 82, 255, 83, 89, 
91, 255, 216, 216, 218, 255, 254, 253, 
254, 255, 241, 244, 246, 253, 244, 244, 
244, 245, 177, 176, 177, 178, 58, 58, 
58, 59, 12, 12, 12, 12, 6, 6, 
6, 6, 40, 40, 40, 40, 178, 178, 
178, 178, 250, 251, 252, 253, 115, 155, 
192, 255, 44, 103, 161, 255, 43, 103, 
160, 255, 194, 210, 226, 255, 252, 253, 
253, 255, 132, 166, 199, 255, 42, 102, 
160, 255, 44, 104, 161, 255, 55, 112, 
166, 255, 220, 230, 239, 255, 246, 247, 
247, 248, 182, 182, 181, 183, 62, 62, 
61, 62, 17, 17, 17, 17, 11, 11, 
11, 11, 57, 57, 57, 57, 90, 90, 
90, 90, 93, 93, 93, 93, 127, 127, 
127, 127, 233, 233, 233, 233, 203, 218, 
231, 255, 37, 99, 158, 255, 43, 104, 
161, 255, 87, 133, 179, 255, 250, 250, 
250, 250, 127, 127, 127, 127, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 16, 16, 
16, 255, 19, 19, 19, 255, 19, 19, 
19, 255, 19, 19, 19, 255, 19, 19, 
19, 255, 25, 25, 25, 255, 64, 64, 
64, 255, 196, 196, 196, 255, 253, 253, 
253, 254, 255, 255, 255, 255, 212, 212, 
212, 255, 9, 9, 9, 255, 109, 109, 
109, 255, 249, 249, 249, 250, 164, 164, 
164, 164, 85, 85, 85, 85, 192, 192, 
192, 192, 252, 252, 252, 252, 52, 52, 
52, 255, 37, 37, 37, 255, 243, 243, 
243, 255, 255, 255, 255, 255, 65, 65, 
65, 255, 16, 16, 16, 255, 234, 234, 
234, 255, 255, 255, 255, 255, 66, 66, 
66, 255, 66, 66, 66, 255, 113, 113, 
113, 255, 3, 3, 3, 255, 214, 214, 
214, 255, 255, 255, 255, 255, 102, 102, 
102, 255, 8, 8, 8, 255, 219, 219, 
219, 255, 255, 255, 255, 255, 107, 107, 
107, 255, 3, 3, 3, 255, 215, 215, 
215, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 201, 201, 201, 255, 14, 14, 
14, 255, 105, 105, 105, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 35, 35, 
35, 255, 63, 63, 63, 255, 243, 243, 
243, 254, 215, 215, 215, 215, 182, 182, 
182, 182, 246, 246, 246, 246, 75, 75, 
75, 255, 24, 24, 24, 255, 226, 226, 
226, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 178, 178, 178, 255, 6, 6, 
6, 255, 138, 138, 138, 255, 249, 249, 
249, 255, 45, 45, 45, 255, 42, 42, 
42, 255, 232, 232, 232, 254, 216, 216, 
216, 216, 104, 104, 104, 104, 137, 137, 
137, 137, 242, 242, 242, 242, 156, 156, 
156, 255, 1, 1, 1, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 20, 20, 20, 255, 211, 211, 
211, 255, 234, 234, 234, 234, 121, 121, 
121, 121, 128, 128, 128, 128, 236, 236, 
236, 236, 173, 173, 173, 255, 2, 2, 
2, 255, 147, 147, 147, 255, 255, 255, 
255, 255, 232, 232, 232, 255, 40, 40, 
40, 255, 63, 63, 63, 255, 245, 245, 
245, 255, 255, 255, 255, 255, 198, 198, 
198, 255, 13, 13, 13, 255, 114, 114, 
114, 255, 247, 247, 247, 247, 152, 152, 
152, 152, 23, 23, 23, 23, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 7, 7, 
7, 7, 100, 100, 100, 101, 235, 235, 
235, 236, 186, 188, 189, 255, 78, 84, 
86, 255, 80, 86, 88, 255, 97, 102, 
103, 255, 227, 228, 228, 254, 222, 222, 
222, 222, 104, 104, 104, 104, 21, 21, 
21, 22, 2, 2, 2, 3, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 3, 3, 3, 3, 37, 37, 
37, 38, 151, 151, 151, 152, 243, 243, 
243, 244, 196, 197, 198, 255, 81, 87, 
89, 255, 81, 86, 88, 255, 91, 96, 
98, 255, 225, 227, 227, 255, 231, 232, 
232, 255, 87, 91, 93, 255, 85, 90, 
93, 255, 212, 212, 213, 254, 196, 196, 
196, 196, 69, 69, 69, 69, 124, 124, 
124, 124, 235, 235, 235, 235, 212, 213, 
213, 255, 79, 85, 86, 255, 89, 95, 
96, 255, 215, 217, 217, 255, 85, 90, 
92, 255, 82, 87, 89, 255, 148, 151, 
152, 255, 173, 175, 176, 255, 173, 175, 
176, 255, 173, 175, 176, 255, 173, 176, 
176, 255, 148, 152, 152, 255, 77, 83, 
85, 255, 106, 111, 112, 255, 216, 217, 
218, 255, 74, 80, 82, 255, 87, 92, 
94, 255, 241, 242, 242, 254, 202, 202, 
202, 203, 78, 78, 78, 78, 180, 181, 
181, 181, 235, 236, 236, 253, 74, 80, 
82, 255, 82, 88, 90, 255, 216, 216, 
217, 255, 236, 236, 236, 237, 179, 179, 
178, 180, 148, 148, 148, 148, 55, 55, 
55, 56, 5, 5, 5, 6, 10, 10, 
10, 10, 60, 60, 60, 60, 147, 147, 
148, 148, 236, 236, 236, 237, 228, 235, 
243, 255, 54, 111, 166, 255, 44, 104, 
160, 255, 46, 105, 162, 255, 218, 227, 
237, 255, 239, 244, 248, 255, 53, 110, 
165, 255, 44, 104, 161, 255, 42, 103, 
160, 255, 155, 183, 210, 255, 248, 248, 
248, 249, 182, 184, 183, 184, 59, 59, 
59, 60, 5, 6, 5, 6, 1, 1, 
1, 1, 33, 32, 33, 33, 179, 179, 
179, 180, 233, 234, 233, 234, 235, 235, 
235, 235, 239, 239, 239, 239, 252, 252, 
252, 252, 203, 218, 231, 255, 37, 99, 
158, 255, 43, 104, 161, 255, 87, 133, 
179, 255, 250, 250, 250, 250, 127, 127, 
127, 127, 5, 5, 5, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 91, 91, 91, 255, 0, 0, 
0, 255, 87, 87, 87, 255, 108, 108, 
108, 255, 108, 108, 108, 255, 108, 108, 
108, 255, 101, 101, 101, 255, 53, 53, 
53, 255, 2, 2, 2, 255, 19, 19, 
19, 255, 213, 213, 213, 255, 255, 255, 
255, 255, 249, 249, 249, 255, 35, 35, 
35, 255, 37, 37, 37, 255, 238, 238, 
238, 255, 238, 238, 238, 238, 217, 217, 
217, 217, 248, 248, 248, 248, 202, 202, 
202, 255, 10, 10, 10, 255, 92, 92, 
92, 255, 251, 251, 251, 255, 231, 231, 
231, 255, 19, 19, 19, 255, 69, 69, 
69, 255, 247, 247, 247, 255, 255, 255, 
255, 255, 122, 122, 122, 255, 14, 14, 
14, 255, 42, 42, 42, 255, 38, 38, 
38, 255, 239, 239, 239, 255, 255, 255, 
255, 255, 165, 165, 165, 255, 4, 4, 
4, 255, 153, 153, 153, 255, 255, 255, 
255, 255, 169, 169, 169, 255, 6, 6, 
6, 255, 125, 125, 125, 255, 252, 252, 
252, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 126, 126, 
126, 255, 2, 2, 2, 255, 169, 169, 
169, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 35, 35, 35, 255, 10, 10, 
10, 255, 184, 184, 184, 255, 251, 251, 
251, 252, 247, 247, 247, 247, 254, 254, 
254, 254, 140, 140, 140, 255, 2, 2, 
2, 255, 156, 156, 156, 255, 254, 254, 
254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 253, 253, 253, 255, 97, 97, 
97, 255, 5, 5, 5, 255, 197, 197, 
197, 255, 255, 255, 255, 255, 106, 106, 
106, 255, 4, 4, 4, 255, 166, 166, 
166, 255, 251, 251, 251, 252, 224, 224, 
224, 224, 229, 229, 229, 229, 242, 242, 
242, 253, 66, 66, 66, 255, 0, 0, 
0, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 0, 0, 
0, 255, 126, 126, 126, 255, 251, 251, 
251, 253, 226, 226, 226, 226, 228, 228, 
228, 228, 245, 245, 245, 253, 76, 76, 
76, 255, 8, 8, 8, 255, 195, 195, 
195, 255, 255, 255, 255, 255, 183, 183, 
183, 255, 5, 5, 5, 255, 137, 137, 
137, 255, 255, 255, 255, 255, 254, 254, 
254, 254, 245, 245, 245, 255, 61, 61, 
61, 255, 41, 41, 41, 255, 232, 232, 
232, 254, 214, 214, 214, 214, 67, 67, 
67, 67, 3, 3, 3, 3, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 18, 18, 18, 18, 151, 150, 
151, 151, 248, 248, 248, 249, 131, 134, 
135, 255, 80, 85, 88, 255, 78, 84, 
86, 255, 152, 155, 156, 255, 247, 247, 
247, 248, 157, 157, 157, 157, 26, 26, 
26, 26, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 3, 3, 3, 3, 62, 62, 
62, 62, 206, 206, 206, 206, 244, 244, 
244, 254, 114, 118, 120, 255, 80, 86, 
88, 255, 79, 84, 87, 255, 183, 186, 
186, 255, 231, 232, 232, 255, 87, 91, 
93, 255, 85, 90, 92, 255, 213, 213, 
214, 255, 235, 235, 235, 235, 199, 199, 
199, 199, 232, 232, 232, 233, 248, 248, 
248, 253, 142, 145, 146, 255, 78, 84, 
86, 255, 120, 123, 124, 255, 245, 245, 
245, 255, 117, 121, 123, 255, 79, 85, 
87, 255, 166, 169, 169, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 254, 254, 
254, 255, 255, 255, 255, 255, 181, 184, 
184, 255, 76, 82, 84, 255, 143, 147, 
148, 255, 216, 217, 218, 255, 74, 80, 
82, 255, 87, 92, 94, 255, 238, 239, 
239, 255, 235, 235, 235, 236, 185, 185, 
185, 186, 234, 234, 234, 235, 226, 227, 
228, 255, 74, 80, 82, 255, 84, 89, 
91, 255, 224, 225, 225, 254, 206, 206, 
206, 206, 54, 54, 54, 54, 19, 19, 
19, 19, 11, 11, 11, 11, 33, 34, 
34, 34, 97, 97, 97, 98, 193, 193, 
193, 195, 244, 243, 243, 244, 232, 238, 
244, 255, 93, 139, 182, 255, 43, 103, 
161, 255, 43, 104, 160, 255, 76, 126, 
176, 255, 250, 251, 252, 255, 190, 208, 
225, 255, 39, 100, 159, 255, 45, 104, 
161, 255, 54, 110, 165, 255, 234, 239, 
245, 255, 220, 220, 220, 221, 73, 73, 
73, 73, 6, 6, 6, 6, 0, 0, 
0, 0, 0, 0, 0, 0, 45, 45, 
45, 46, 216, 215, 214, 217, 226, 234, 
242, 255, 161, 188, 213, 255, 164, 190, 
214, 255, 164, 190, 214, 255, 137, 170, 
201, 255, 40, 101, 159, 255, 43, 103, 
161, 255, 87, 133, 179, 255, 250, 250, 
250, 250, 127, 127, 127, 127, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 205, 205, 
205, 255, 252, 252, 252, 252, 238, 238, 
238, 238, 235, 235, 235, 235, 243, 243, 
243, 243, 241, 241, 241, 254, 90, 90, 
90, 255, 1, 1, 1, 255, 97, 97, 
97, 255, 252, 252, 252, 255, 255, 255, 
255, 255, 141, 141, 141, 255, 3, 3, 
3, 255, 112, 112, 112, 255, 231, 231, 
231, 255, 250, 250, 250, 254, 211, 211, 
211, 255, 52, 52, 52, 255, 12, 12, 
12, 255, 199, 199, 199, 255, 255, 255, 
255, 255, 175, 175, 175, 255, 5, 5, 
5, 255, 132, 132, 132, 255, 254, 254, 
254, 255, 255, 255, 255, 255, 182, 182, 
182, 255, 7, 7, 7, 255, 0, 0, 
0, 255, 92, 92, 92, 255, 252, 252, 
252, 255, 255, 255, 255, 255, 218, 218, 
218, 255, 17, 17, 17, 255, 82, 82, 
82, 255, 249, 249, 249, 255, 244, 244, 
244, 255, 63, 63, 63, 255, 17, 17, 
17, 255, 165, 165, 165, 255, 244, 244, 
244, 255, 241, 241, 241, 255, 169, 169, 
169, 255, 21, 21, 21, 255, 54, 54, 
54, 255, 234, 234, 234, 255, 254, 254, 
254, 254, 255, 255, 255, 255, 35, 35, 
35, 255, 45, 45, 45, 255, 37, 37, 
37, 255, 138, 138, 138, 255, 197, 197, 
197, 255, 249, 249, 249, 255, 228, 228, 
228, 255, 47, 47, 47, 255, 29, 29, 
29, 255, 183, 183, 183, 255, 247, 247, 
247, 255, 237, 237, 237, 255, 150, 150, 
150, 255, 12, 12, 12, 255, 79, 79, 
79, 255, 242, 242, 242, 255, 254, 254, 
254, 254, 207, 207, 207, 255, 25, 25, 
25, 255, 27, 27, 27, 255, 171, 171, 
171, 255, 226, 226, 226, 254, 217, 217, 
217, 255, 108, 108, 108, 255, 10, 10, 
10, 255, 3, 3, 3, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 4, 4, 4, 255, 27, 27, 
27, 255, 157, 157, 157, 255, 224, 224, 
224, 254, 219, 219, 219, 255, 124, 124, 
124, 255, 8, 8, 8, 255, 72, 72, 
72, 255, 243, 243, 243, 255, 255, 255, 
255, 255, 104, 104, 104, 255, 16, 16, 
16, 255, 205, 205, 205, 255, 244, 244, 
244, 244, 222, 222, 222, 222, 249, 249, 
249, 249, 135, 135, 135, 255, 5, 5, 
5, 255, 174, 174, 174, 255, 239, 239, 
239, 239, 114, 114, 114, 114, 10, 10, 
10, 10, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 20, 20, 
20, 20, 165, 165, 165, 166, 240, 240, 
240, 252, 107, 112, 113, 255, 80, 87, 
89, 255, 83, 88, 90, 255, 205, 207, 
207, 255, 232, 232, 232, 233, 96, 96, 
96, 96, 6, 6, 6, 6, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 18, 18, 18, 18, 136, 136, 
136, 136, 244, 244, 244, 244, 158, 160, 
161, 255, 79, 84, 87, 255, 80, 84, 
87, 255, 145, 148, 149, 255, 231, 232, 
232, 255, 87, 91, 93, 255, 84, 90, 
92, 255, 196, 198, 198, 255, 232, 233, 
233, 255, 229, 229, 229, 254, 212, 213, 
213, 255, 144, 147, 148, 255, 81, 87, 
89, 255, 86, 91, 93, 255, 200, 201, 
202, 255, 254, 254, 254, 255, 179, 181, 
182, 255, 77, 84, 86, 255, 96, 101, 
102, 255, 216, 217, 217, 255, 253, 253, 
253, 255, 253, 253, 253, 255, 224, 225, 
225, 255, 105, 110, 111, 255, 82, 87, 
89, 255, 202, 203, 203, 255, 216, 217, 
218, 255, 74, 80, 83, 255, 81, 86, 
89, 255, 150, 153, 154, 255, 241, 242, 
242, 254, 250, 250, 250, 251, 251, 251, 
251, 254, 169, 172, 172, 255, 77, 83, 
85, 255, 100, 105, 107, 255, 245, 245, 
245, 254, 198, 198, 198, 198, 35, 35, 
35, 35, 17, 17, 17, 17, 74, 75, 
75, 75, 171, 171, 171, 171, 228, 228, 
228, 229, 248, 249, 249, 252, 200, 215, 
229, 255, 82, 131, 178, 255, 42, 103, 
160, 255, 44, 104, 161, 255, 45, 105, 
161, 255, 176, 198, 219, 255, 255, 255, 
254, 255, 152, 180, 208, 255, 42, 102, 
160, 255, 43, 103, 161, 255, 90, 137, 
182, 255, 252, 251, 251, 252, 179, 179, 
179, 180, 28, 28, 28, 28, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 45, 45, 45, 46, 216, 216, 
216, 218, 189, 207, 224, 255, 32, 96, 
156, 255, 39, 101, 159, 255, 39, 100, 
159, 255, 41, 102, 160, 255, 44, 104, 
161, 255, 43, 103, 161, 255, 87, 133, 
179, 255, 250, 250, 250, 250, 127, 127, 
127, 127, 5, 5, 5, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 91, 91, 91, 255, 0, 0, 
0, 255, 205, 205, 205, 255, 231, 231, 
231, 231, 121, 121, 121, 121, 93, 93, 
93, 93, 149, 149, 149, 149, 241, 241, 
241, 241, 196, 196, 196, 255, 6, 6, 
6, 255, 45, 45, 45, 255, 247, 247, 
247, 255, 254, 254, 254, 254, 245, 245, 
245, 255, 105, 105, 105, 255, 9, 9, 
9, 255, 42, 42, 42, 255, 64, 64, 
64, 255, 26, 26, 26, 255, 20, 20, 
20, 255, 147, 147, 147, 255, 252, 252, 
252, 255, 255, 255, 255, 255, 106, 106, 
106, 255, 0, 0, 0, 255, 194, 194, 
194, 255, 254, 254, 254, 254, 254, 254, 
254, 254, 231, 231, 231, 255, 18, 18, 
18, 255, 0, 0, 0, 255, 148, 148, 
148, 255, 253, 253, 253, 253, 248, 248, 
248, 248, 251, 251, 251, 254, 43, 43, 
43, 255, 26, 26, 26, 255, 235, 235, 
235, 255, 255, 255, 255, 255, 222, 222, 
222, 255, 64, 64, 64, 255, 15, 15, 
15, 255, 56, 56, 56, 255, 53, 53, 
53, 255, 11, 11, 11, 255, 55, 55, 
55, 255, 212, 212, 212, 255, 240, 240, 
240, 240, 224, 224, 224, 224, 251, 251, 
251, 251, 35, 35, 35, 255, 126, 126, 
126, 255, 102, 102, 102, 255, 5, 5, 
5, 255, 30, 30, 30, 255, 230, 230, 
230, 255, 255, 255, 255, 255, 205, 205, 
205, 255, 49, 49, 49, 255, 19, 19, 
19, 255, 59, 59, 59, 255, 48, 48, 
48, 255, 9, 9, 9, 255, 73, 73, 
73, 255, 225, 225, 225, 255, 242, 242, 
242, 242, 223, 223, 223, 223, 250, 250, 
250, 250, 159, 159, 159, 255, 26, 26, 
26, 255, 7, 7, 7, 255, 37, 37, 
37, 255, 26, 26, 26, 255, 24, 24, 
24, 255, 106, 106, 106, 255, 15, 15, 
15, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 22, 22, 
22, 255, 106, 106, 106, 255, 21, 21, 
21, 255, 35, 35, 35, 255, 28, 28, 
28, 255, 4, 4, 4, 255, 48, 48, 
48, 255, 204, 204, 204, 255, 255, 255, 
255, 255, 234, 234, 234, 255, 41, 41, 
41, 255, 54, 54, 54, 255, 239, 239, 
239, 253, 196, 196, 196, 196, 131, 131, 
131, 131, 231, 231, 231, 231, 205, 205, 
205, 255, 17, 17, 17, 255, 94, 94, 
94, 255, 249, 249, 249, 251, 166, 166, 
166, 166, 22, 22, 22, 22, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 20, 20, 20, 20, 166, 165, 
166, 166, 228, 228, 229, 252, 95, 100, 
102, 255, 81, 87, 89, 255, 90, 95, 
97, 255, 222, 223, 223, 254, 200, 200, 
200, 200, 50, 50, 50, 50, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 79, 79, 79, 79, 230, 230, 
230, 230, 186, 188, 188, 255, 78, 83, 
85, 255, 81, 85, 88, 255, 124, 127, 
129, 255, 231, 231, 231, 255, 86, 92, 
93, 255, 80, 87, 88, 255, 93, 97, 
100, 255, 97, 101, 103, 255, 95, 99, 
101, 255, 82, 86, 89, 255, 77, 83, 
85, 255, 90, 95, 97, 255, 177, 180, 
180, 255, 252, 252, 252, 254, 254, 254, 
254, 254, 245, 246, 246, 255, 130, 134, 
135, 255, 79, 84, 86, 255, 93, 98, 
99, 255, 137, 140, 142, 255, 139, 141, 
143, 255, 97, 102, 104, 255, 78, 83, 
86, 255, 135, 138, 140, 255, 251, 251, 
251, 255, 216, 217, 217, 255, 74, 79, 
82, 255, 82, 87, 89, 255, 95, 100, 
102, 255, 112, 117, 118, 255, 152, 155, 
155, 255, 138, 141, 143, 255, 86, 91, 
92, 255, 79, 84, 86, 255, 164, 167, 
168, 255, 250, 250, 250, 250, 164, 164, 
164, 164, 51, 51, 51, 51, 123, 123, 
123, 124, 206, 206, 205, 207, 248, 248, 
248, 250, 220, 229, 239, 255, 129, 165, 
199, 255, 51, 108, 163, 255, 43, 103, 
161, 255, 44, 104, 161, 255, 42, 103, 
160, 255, 127, 163, 198, 255, 251, 253, 
253, 255, 254, 254, 254, 255, 126, 162, 
197, 255, 43, 103, 161, 255, 43, 103, 
161, 255, 124, 161, 197, 255, 247, 247, 
247, 248, 127, 129, 129, 129, 8, 8, 
8, 8, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 45, 45, 
45, 46, 216, 216, 216, 218, 191, 208, 
225, 255, 43, 104, 161, 255, 49, 107, 
164, 255, 49, 107, 164, 255, 49, 107, 
164, 255, 49, 107, 164, 255, 49, 107, 
163, 255, 92, 137, 181, 255, 250, 250, 
249, 250, 127, 127, 127, 127, 5, 5, 
5, 5, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 205, 205, 
205, 255, 230, 230, 230, 230, 113, 113, 
113, 113, 84, 84, 84, 84, 143, 143, 
143, 143, 240, 240, 240, 240, 208, 208, 
208, 255, 7, 7, 7, 255, 41, 41, 
41, 255, 246, 246, 246, 254, 228, 228, 
228, 228, 236, 236, 236, 236, 246, 246, 
246, 253, 189, 189, 189, 255, 123, 123, 
123, 255, 97, 97, 97, 255, 144, 144, 
144, 255, 206, 206, 206, 255, 249, 249, 
249, 251, 242, 242, 242, 242, 250, 250, 
250, 250, 199, 199, 199, 253, 181, 181, 
181, 253, 244, 244, 244, 250, 215, 215, 
215, 215, 209, 209, 209, 209, 247, 247, 
247, 247, 188, 188, 188, 253, 181, 181, 
181, 253, 234, 234, 234, 253, 229, 229, 
229, 229, 189, 189, 189, 189, 243, 243, 
243, 243, 201, 201, 201, 253, 181, 181, 
181, 253, 243, 243, 243, 251, 242, 242, 
242, 242, 249, 249, 249, 249, 235, 235, 
235, 254, 171, 171, 171, 255, 110, 110, 
110, 255, 108, 108, 108, 255, 165, 165, 
165, 255, 230, 230, 230, 254, 238, 238, 
238, 238, 153, 153, 153, 153, 135, 135, 
135, 135, 238, 238, 238, 238, 191, 191, 
191, 253, 219, 219, 219, 253, 244, 244, 
244, 255, 162, 162, 162, 255, 125, 125, 
125, 255, 242, 242, 242, 255, 249, 249, 
249, 249, 250, 250, 250, 250, 228, 228, 
228, 255, 164, 164, 164, 255, 104, 104, 
104, 255, 112, 112, 112, 255, 175, 175, 
175, 255, 237, 237, 237, 254, 240, 240, 
240, 240, 157, 157, 157, 157, 114, 114, 
114, 114, 212, 212, 212, 212, 248, 248, 
248, 248, 211, 211, 211, 254, 139, 139, 
139, 255, 100, 100, 100, 255, 142, 142, 
142, 255, 209, 209, 209, 255, 201, 201, 
201, 255, 16, 16, 16, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 24, 24, 24, 255, 214, 214, 
214, 255, 196, 196, 196, 255, 125, 125, 
125, 255, 105, 105, 105, 255, 159, 159, 
159, 255, 227, 227, 227, 254, 248, 248, 
248, 248, 243, 243, 243, 243, 239, 239, 
239, 252, 187, 187, 187, 253, 204, 204, 
204, 253, 241, 241, 241, 241, 141, 141, 
141, 141, 60, 60, 60, 60, 186, 186, 
186, 186, 244, 244, 244, 250, 193, 193, 
193, 253, 197, 197, 197, 253, 248, 248, 
248, 250, 166, 166, 166, 166, 22, 22, 
22, 22, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 20, 20, 
20, 20, 166, 165, 166, 166, 225, 225, 
226, 252, 91, 96, 98, 255, 81, 86, 
88, 255, 92, 97, 99, 255, 225, 226, 
226, 253, 181, 181, 181, 181, 28, 28, 
28, 28, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 71, 71, 
71, 71, 227, 227, 227, 228, 196, 198, 
198, 255, 78, 83, 85, 255, 81, 85, 
88, 255, 120, 123, 125, 255, 233, 234, 
234, 255, 110, 115, 116, 255, 105, 110, 
111, 255, 105, 110, 112, 255, 105, 110, 
112, 255, 105, 110, 112, 255, 117, 121, 
123, 255, 151, 155, 155, 255, 219, 220, 
220, 255, 247, 247, 247, 248, 211, 211, 
212, 212, 197, 197, 197, 197, 239, 239, 
239, 239, 240, 241, 241, 254, 162, 165, 
165, 255, 102, 106, 109, 255, 87, 92, 
94, 255, 87, 92, 94, 255, 101, 105, 
107, 255, 157, 160, 161, 255, 243, 243, 
243, 255, 254, 254, 254, 254, 221, 222, 
223, 255, 99, 104, 106, 255, 111, 115, 
117, 255, 216, 218, 218, 255, 130, 134, 
135, 255, 92, 96, 98, 255, 86, 91, 
93, 255, 95, 100, 102, 255, 152, 155, 
156, 255, 245, 245, 245, 254, 225, 225, 
225, 226, 121, 121, 121, 121, 139, 139, 
139, 139, 232, 232, 231, 233, 245, 248, 
249, 254, 163, 188, 213, 255, 59, 114, 
167, 255, 41, 102, 160, 255, 44, 104, 
161, 255, 43, 103, 160, 255, 50, 108, 
163, 255, 146, 176, 206, 255, 247, 249, 
250, 254, 247, 246, 247, 248, 252, 252, 
252, 253, 119, 158, 195, 255, 44, 104, 
161, 255, 43, 103, 161, 255, 132, 167, 
200, 255, 246, 246, 246, 247, 120, 121, 
121, 121, 6, 6, 6, 6, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 42, 42, 42, 43, 209, 208, 
209, 210, 235, 240, 244, 253, 200, 215, 
228, 253, 202, 216, 229, 253, 202, 216, 
229, 253, 202, 216, 229, 253, 202, 216, 
229, 253, 201, 216, 229, 253, 212, 222, 
233, 253, 245, 246, 245, 246, 120, 120, 
120, 120, 5, 5, 5, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 91, 91, 91, 255, 0, 0, 
0, 255, 205, 205, 205, 255, 252, 252, 
252, 252, 235, 235, 235, 235, 231, 231, 
231, 231, 241, 241, 241, 241, 251, 251, 
251, 254, 120, 120, 120, 255, 1, 1, 
1, 255, 80, 80, 80, 255, 247, 247, 
247, 251, 160, 160, 160, 160, 129, 129, 
129, 129, 203, 203, 203, 203, 235, 235, 
235, 235, 236, 236, 236, 236, 236, 236, 
236, 236, 236, 236, 236, 236, 229, 229, 
229, 229, 180, 180, 180, 180, 123, 123, 
123, 123, 163, 163, 163, 163, 180, 180, 
180, 180, 180, 180, 180, 180, 168, 168, 
168, 168, 83, 83, 83, 83, 71, 71, 
71, 71, 158, 158, 158, 158, 180, 180, 
180, 180, 180, 180, 180, 180, 179, 179, 
179, 179, 132, 132, 132, 132, 78, 78, 
78, 78, 157, 157, 157, 157, 180, 180, 
180, 180, 180, 180, 180, 180, 169, 169, 
169, 169, 124, 124, 124, 124, 161, 161, 
161, 161, 204, 204, 204, 204, 234, 234, 
234, 234, 236, 236, 236, 236, 236, 236, 
236, 236, 236, 236, 236, 236, 213, 213, 
213, 213, 139, 139, 139, 139, 39, 39, 
39, 39, 51, 51, 51, 51, 153, 153, 
153, 153, 180, 180, 180, 180, 187, 187, 
187, 187, 223, 223, 223, 223, 236, 236, 
236, 236, 236, 236, 236, 236, 229, 229, 
229, 229, 171, 171, 171, 171, 170, 170, 
170, 170, 221, 221, 221, 221, 236, 236, 
236, 236, 236, 236, 236, 236, 236, 236, 
236, 236, 236, 236, 236, 236, 214, 214, 
214, 214, 143, 143, 143, 143, 42, 42, 
42, 42, 21, 21, 21, 21, 82, 82, 
82, 82, 162, 162, 162, 162, 220, 220, 
220, 220, 236, 236, 236, 236, 236, 236, 
236, 236, 239, 239, 239, 239, 250, 250, 
250, 250, 203, 203, 203, 255, 16, 16, 
16, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 41, 41, 
41, 255, 231, 231, 231, 255, 249, 249, 
249, 249, 238, 238, 238, 238, 237, 237, 
237, 237, 236, 236, 236, 236, 217, 217, 
217, 217, 156, 156, 156, 156, 130, 130, 
130, 130, 173, 173, 173, 173, 180, 180, 
180, 180, 179, 179, 179, 179, 145, 145, 
145, 145, 47, 47, 47, 47, 13, 13, 
13, 13, 92, 92, 92, 92, 172, 172, 
172, 172, 180, 180, 180, 180, 180, 180, 
180, 180, 172, 172, 172, 172, 93, 93, 
93, 93, 10, 10, 10, 10, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 20, 20, 20, 20, 166, 165, 
165, 166, 232, 232, 232, 252, 98, 103, 
105, 255, 80, 86, 88, 255, 88, 93, 
95, 255, 219, 220, 220, 254, 197, 197, 
197, 197, 46, 46, 46, 47, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 6, 6, 
6, 6, 92, 92, 92, 92, 233, 233, 
233, 233, 183, 185, 185, 255, 78, 83, 
85, 255, 80, 85, 87, 255, 125, 129, 
131, 255, 252, 253, 253, 255, 240, 241, 
241, 254, 238, 239, 239, 253, 239, 239, 
239, 253, 239, 239, 239, 253, 239, 240, 
240, 253, 248, 248, 248, 253, 244, 244, 
244, 244, 233, 233, 233, 233, 177, 177, 
177, 178, 73, 74, 74, 74, 52, 52, 
52, 52, 140, 140, 140, 140, 216, 216, 
216, 217, 250, 250, 250, 251, 236, 236, 
237, 253, 217, 218, 219, 253, 217, 218, 
218, 253, 234, 235, 235, 253, 249, 249, 
249, 249, 228, 228, 228, 229, 223, 223, 
223, 224, 248, 248, 248, 251, 238, 239, 
239, 253, 239, 240, 240, 253, 252, 252, 
252, 253, 249, 249, 250, 253, 225, 226, 
226, 253, 215, 217, 217, 253, 229, 230, 
230, 253, 249, 248, 249, 250, 223, 222, 
223, 223, 133, 133, 133, 134, 134, 134, 
135, 135, 232, 232, 233, 233, 242, 245, 
248, 254, 121, 159, 195, 255, 43, 103, 
160, 255, 44, 104, 160, 255, 44, 103, 
161, 255, 45, 105, 161, 255, 98, 142, 
184, 255, 198, 214, 230, 255, 251, 250, 
251, 251, 225, 224, 225, 226, 172, 171, 
172, 173, 233, 233, 233, 234, 137, 171, 
202, 255, 42, 102, 161, 255, 43, 103, 
161, 255, 117, 156, 194, 255, 249, 249, 
249, 250, 146, 146, 147, 147, 15, 15, 
15, 15, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 19, 18, 
18, 19, 123, 123, 123, 124, 179, 178, 
178, 179, 180, 180, 180, 180, 180, 180, 
180, 180, 180, 180, 180, 180, 180, 180, 
180, 180, 180, 180, 180, 180, 179, 180, 
179, 180, 179, 179, 179, 180, 162, 164, 
163, 164, 60, 60, 60, 60, 3, 3, 
3, 3, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 124, 124, 
124, 124, 249, 249, 249, 249, 91, 91, 
91, 255, 0, 0, 0, 255, 132, 132, 
132, 255, 164, 164, 164, 255, 164, 164, 
164, 255, 164, 164, 164, 255, 158, 158, 
158, 255, 99, 99, 99, 255, 7, 7, 
7, 255, 7, 7, 7, 255, 180, 180, 
180, 255, 242, 242, 242, 242, 113, 113, 
113, 113, 22, 22, 22, 22, 58, 58, 
58, 58, 92, 92, 92, 92, 95, 95, 
95, 95, 95, 95, 95, 95, 95, 95, 
95, 95, 86, 86, 86, 86, 38, 38, 
38, 38, 12, 12, 12, 12, 22, 22, 
22, 22, 27, 27, 27, 27, 27, 27, 
27, 27, 24, 24, 24, 24, 7, 7, 
7, 7, 5, 5, 5, 5, 22, 22, 
22, 22, 27, 27, 27, 27, 27, 27, 
27, 27, 27, 27, 27, 27, 17, 17, 
17, 17, 7, 7, 7, 7, 22, 22, 
22, 22, 27, 27, 27, 27, 27, 27, 
27, 27, 24, 24, 24, 24, 12, 12, 
12, 12, 23, 23, 23, 23, 56, 56, 
56, 56, 91, 91, 91, 91, 95, 95, 
95, 95, 95, 95, 95, 95, 94, 94, 
94, 94, 67, 67, 67, 67, 21, 21, 
21, 21, 3, 3, 3, 3, 5, 5, 
5, 5, 21, 21, 21, 21, 27, 27, 
27, 27, 35, 35, 35, 35, 78, 78, 
78, 78, 94, 94, 94, 94, 95, 95, 
95, 95, 87, 87, 87, 87, 38, 38, 
38, 38, 31, 31, 31, 31, 77, 77, 
77, 77, 94, 94, 94, 94, 95, 95, 
95, 95, 95, 95, 95, 95, 94, 94, 
94, 94, 69, 69, 69, 69, 22, 22, 
22, 22, 3, 3, 3, 3, 1, 1, 
1, 1, 5, 5, 5, 5, 28, 28, 
28, 28, 76, 76, 76, 76, 94, 94, 
94, 94, 95, 95, 95, 95, 112, 112, 
112, 112, 209, 209, 209, 209, 201, 201, 
201, 254, 16, 16, 16, 255, 163, 163, 
163, 255, 229, 229, 229, 229, 76, 76, 
76, 76, 3, 3, 3, 3, 0, 0, 
0, 0, 3, 3, 3, 3, 91, 91, 
91, 91, 236, 236, 236, 236, 97, 97, 
97, 255, 48, 48, 48, 255, 235, 235, 
235, 254, 200, 200, 200, 200, 108, 108, 
108, 108, 95, 95, 95, 95, 94, 94, 
94, 94, 72, 72, 72, 72, 25, 25, 
25, 25, 14, 14, 14, 14, 25, 25, 
25, 25, 27, 27, 27, 27, 27, 27, 
27, 27, 19, 19, 19, 19, 4, 4, 
4, 4, 1, 1, 1, 1, 10, 10, 
10, 10, 25, 25, 25, 25, 27, 27, 
27, 27, 27, 27, 27, 27, 25, 25, 
25, 25, 11, 11, 11, 11, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 20, 20, 
20, 20, 164, 164, 164, 165, 243, 243, 
243, 252, 111, 115, 117, 255, 80, 86, 
88, 255, 80, 86, 88, 255, 198, 199, 
200, 255, 236, 236, 236, 236, 111, 111, 
111, 112, 11, 11, 11, 11, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 31, 31, 31, 31, 163, 163, 
163, 163, 247, 247, 247, 248, 152, 154, 
156, 255, 79, 84, 86, 255, 79, 84, 
86, 255, 150, 153, 154, 255, 251, 251, 
251, 251, 211, 211, 211, 211, 184, 184, 
184, 184, 182, 182, 182, 182, 182, 182, 
182, 182, 182, 182, 182, 182, 178, 178, 
178, 178, 134, 134, 134, 134, 93, 93, 
93, 93, 47, 47, 47, 47, 6, 6, 
6, 6, 3, 3, 3, 3, 21, 21, 
21, 21, 89, 89, 89, 89, 171, 171, 
171, 171, 182, 182, 182, 182, 182, 182, 
182, 182, 182, 182, 182, 182, 182, 182, 
182, 182, 162, 162, 162, 162, 94, 94, 
94, 94, 96, 96, 96, 96, 171, 171, 
171, 171, 182, 182, 182, 182, 182, 182, 
182, 182, 182, 182, 182, 182, 182, 182, 
182, 182, 182, 182, 182, 182, 182, 182, 
182, 182, 182, 182, 182, 182, 163, 163, 
163, 163, 92, 92, 92, 92, 64, 64, 
64, 65, 191, 190, 192, 193, 249, 250, 
251, 253, 134, 169, 201, 255, 41, 102, 
160, 255, 45, 104, 161, 255, 43, 103, 
161, 255, 77, 127, 175, 255, 181, 202, 
222, 255, 247, 248, 250, 254, 242, 242, 
241, 243, 191, 191, 191, 191, 95, 95, 
95, 95, 73, 73, 73, 74, 219, 219, 
219, 220, 169, 193, 216, 255, 40, 101, 
160, 255, 45, 103, 161, 255, 79, 128, 
176, 255, 251, 252, 253, 254, 201, 201, 
201, 202, 41, 41, 41, 41, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 15, 15, 
15, 15, 27, 27, 27, 27, 27, 27, 
27, 27, 27, 27, 27, 27, 27, 27, 
27, 27, 27, 27, 27, 27, 27, 27, 
27, 27, 27, 27, 27, 27, 27, 27, 
27, 27, 23, 23, 23, 23, 6, 6, 
6, 6, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 5, 5, 
5, 5, 124, 124, 124, 124, 249, 249, 
249, 249, 101, 101, 101, 255, 0, 0, 
0, 255, 0, 0, 0, 255, 0, 0, 
0, 255, 0, 0, 0, 255, 0, 0, 
0, 255, 0, 0, 0, 255, 7, 7, 
7, 255, 31, 31, 31, 255, 151, 151, 
151, 255, 249, 249, 249, 252, 194, 194, 
194, 194, 48, 48, 48, 48, 2, 2, 
2, 2, 2, 2, 2, 2, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 2, 2, 
2, 2, 3, 3, 3, 3, 3, 3, 
3, 3, 30, 30, 30, 30, 183, 183, 
183, 183, 200, 200, 200, 253, 16, 16, 
16, 255, 163, 163, 163, 255, 229, 229, 
229, 229, 76, 76, 76, 76, 3, 3, 
3, 3, 0, 0, 0, 0, 3, 3, 
3, 3, 91, 91, 91, 91, 236, 236, 
236, 236, 97, 97, 97, 255, 48, 48, 
48, 255, 234, 234, 234, 253, 168, 168, 
168, 168, 24, 24, 24, 24, 3, 3, 
3, 3, 3, 3, 3, 3, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 15, 15, 15, 15, 141, 141, 
141, 142, 246, 246, 246, 246, 142, 146, 
147, 255, 79, 85, 87, 255, 79, 85, 
87, 255, 142, 145, 146, 255, 249, 249, 
249, 252, 187, 187, 187, 188, 50, 50, 
50, 50, 4, 4, 4, 4, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 11, 11, 11, 11, 95, 95, 
95, 95, 227, 227, 227, 227, 238, 239, 
239, 255, 104, 109, 111, 255, 81, 86, 
88, 255, 79, 85, 87, 255, 190, 192, 
192, 255, 238, 238, 238, 238, 113, 113, 
113, 113, 31, 31, 31, 31, 28, 28, 
28, 28, 28, 28, 28, 28, 28, 28, 
28, 28, 27, 27, 27, 27, 15, 15, 
15, 15, 4, 4, 4, 4, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 8, 8, 
8, 8, 25, 25, 25, 25, 28, 28, 
28, 28, 28, 28, 28, 28, 28, 28, 
28, 28, 28, 28, 28, 28, 22, 22, 
22, 22, 6, 6, 6, 6, 8, 8, 
8, 8, 25, 25, 25, 25, 28, 28, 
28, 28, 28, 28, 28, 28, 28, 28, 
28, 28, 28, 28, 28, 28, 28, 28, 
28, 28, 28, 28, 28, 28, 28, 28, 
28, 28, 23, 23, 23, 23, 11, 11, 
11, 11, 92, 92, 91, 92, 232, 231, 
232, 233, 213, 224, 235, 255, 40, 102, 
160, 255, 44, 104, 161, 255, 43, 104, 
161, 255, 111, 152, 191, 255, 235, 240, 
244, 254, 243, 243, 243, 244, 205, 206, 
205, 207, 134, 135, 134, 136, 57, 57, 
57, 57, 10, 10, 9, 10, 52, 52, 
52, 53, 218, 219, 219, 220, 215, 226, 
236, 255, 40, 101, 160, 255, 44, 103, 
161, 255, 46, 105, 162, 255, 215, 225, 
237, 255, 234, 233, 233, 234, 105, 106, 
105, 106, 10, 9, 9, 10, 0, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 2, 2, 2, 2, 1, 2, 
1, 2, 1, 2, 2, 2, 2, 1, 
1, 2, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 5, 5, 5, 5, 119, 119, 
119, 119, 245, 245, 245, 245, 215, 215, 
215, 254, 169, 169, 169, 254, 169, 169, 
169, 254, 169, 169, 169, 254, 169, 169, 
169, 254, 169, 169, 169, 254, 169, 169, 
169, 254, 182, 182, 182, 254, 228, 228, 
228, 254, 251, 251, 251, 251, 204, 204, 
204, 204, 82, 82, 82, 82, 9, 9, 
9, 9, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 26, 26, 
26, 26, 176, 176, 176, 176, 233, 233, 
233, 251, 174, 174, 174, 254, 222, 222, 
222, 253, 224, 224, 224, 224, 72, 72, 
72, 72, 2, 2, 2, 2, 0, 0, 
0, 0, 3, 3, 3, 3, 87, 87, 
87, 87, 231, 231, 231, 231, 200, 200, 
200, 253, 185, 185, 185, 254, 244, 244, 
244, 250, 161, 161, 161, 161, 20, 20, 
20, 20, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 4, 4, 
4, 4, 87, 87, 87, 88, 231, 231, 
231, 232, 199, 201, 201, 255, 80, 86, 
88, 255, 81, 86, 88, 255, 92, 97, 
99, 255, 221, 222, 222, 255, 241, 241, 
241, 241, 156, 156, 156, 156, 42, 42, 
42, 42, 5, 5, 5, 5, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 11, 11, 11, 11, 78, 78, 
78, 78, 197, 197, 197, 198, 250, 250, 
250, 251, 175, 177, 178, 255, 79, 84, 
86, 255, 81, 86, 88, 255, 95, 100, 
102, 255, 231, 231, 232, 254, 207, 207, 
207, 207, 57, 57, 57, 57, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 11, 11, 11, 11, 137, 137, 
136, 137, 247, 248, 248, 249, 137, 170, 
202, 255, 42, 102, 160, 255, 43, 104, 
160, 255, 102, 146, 186, 255, 247, 248, 
250, 254, 231, 231, 231, 232, 143, 143, 
143, 144, 61, 62, 61, 62, 17, 17, 
17, 18, 23, 23, 23, 23, 62, 62, 
62, 62, 105, 105, 106, 106, 228, 228, 
228, 229, 248, 250, 252, 255, 76, 127, 
175, 255, 44, 104, 161, 255, 43, 103, 
160, 255, 116, 155, 193, 255, 251, 252, 
251, 253, 195, 196, 196, 198, 60, 60, 
60, 61, 10, 11, 10, 11, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 2, 2, 
2, 2, 11, 11, 11, 11, 44, 44, 
44, 44, 67, 67, 67, 68, 67, 67, 
67, 68, 40, 39, 39, 40, 4, 4, 
4, 4, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 2, 2, 
2, 2, 63, 63, 63, 63, 172, 172, 
172, 172, 189, 189, 189, 189, 189, 189, 
189, 189, 189, 189, 189, 189, 189, 189, 
189, 189, 189, 189, 189, 189, 189, 189, 
189, 189, 189, 189, 189, 189, 189, 189, 
189, 189, 189, 189, 189, 189, 176, 176, 
176, 176, 82, 82, 82, 82, 10, 10, 
10, 10, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 12, 12, 12, 12, 105, 105, 
105, 105, 183, 183, 183, 183, 189, 189, 
189, 189, 189, 189, 189, 189, 148, 148, 
148, 148, 37, 37, 37, 37, 1, 1, 
1, 1, 0, 0, 0, 0, 1, 1, 
1, 1, 45, 45, 45, 45, 155, 155, 
155, 155, 189, 189, 189, 189, 189, 189, 
189, 189, 180, 180, 180, 180, 94, 94, 
94, 94, 10, 10, 10, 10, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 62, 62, 
62, 63, 211, 211, 211, 213, 241, 242, 
242, 254, 114, 119, 120, 255, 80, 86, 
88, 255, 79, 84, 87, 255, 132, 136, 
137, 255, 244, 244, 244, 255, 240, 240, 
240, 240, 158, 158, 158, 158, 63, 63, 
63, 63, 21, 21, 21, 21, 10, 10, 
10, 10, 6, 6, 6, 6, 14, 14, 
14, 14, 31, 31, 31, 31, 91, 91, 
91, 91, 197, 197, 197, 197, 249, 249, 
249, 250, 216, 217, 217, 255, 93, 98, 
100, 255, 80, 87, 89, 255, 79, 85, 
87, 255, 153, 155, 156, 255, 250, 250, 
250, 250, 164, 164, 164, 165, 24, 24, 
24, 24, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 11, 11, 
11, 11, 142, 143, 142, 143, 247, 248, 
249, 251, 105, 149, 188, 255, 45, 104, 
161, 255, 45, 104, 162, 255, 201, 216, 
230, 255, 240, 240, 239, 241, 143, 143, 
143, 145, 31, 30, 30, 31, 12, 12, 
12, 12, 30, 30, 30, 30, 122, 122, 
122, 122, 215, 215, 215, 215, 231, 231, 
230, 232, 250, 250, 250, 251, 254, 254, 
254, 255, 173, 196, 218, 255, 39, 100, 
158, 255, 44, 104, 161, 255, 45, 104, 
161, 255, 186, 205, 224, 255, 246, 246, 
246, 248, 188, 188, 188, 190, 101, 101, 
101, 101, 25, 25, 25, 25, 9, 9, 
9, 9, 3, 3, 3, 3, 3, 3, 
3, 3, 10, 10, 10, 10, 17, 17, 
17, 17, 44, 44, 44, 44, 113, 113, 
113, 113, 190, 190, 190, 190, 223, 223, 
223, 225, 224, 223, 223, 225, 163, 163, 
163, 165, 26, 26, 26, 26, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 6, 6, 
6, 6, 26, 26, 26, 26, 31, 31, 
31, 31, 31, 31, 31, 31, 31, 31, 
31, 31, 31, 31, 31, 31, 31, 31, 
31, 31, 31, 31, 31, 31, 31, 31, 
31, 31, 31, 31, 31, 31, 31, 31, 
31, 31, 27, 27, 27, 27, 8, 8, 
8, 8, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 13, 13, 13, 13, 29, 29, 
29, 29, 31, 31, 31, 31, 30, 30, 
30, 30, 21, 21, 21, 21, 4, 4, 
4, 4, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 4, 4, 
4, 4, 23, 23, 23, 23, 30, 30, 
30, 30, 31, 31, 31, 31, 28, 28, 
28, 28, 11, 11, 11, 11, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 22, 22, 22, 23, 147, 147, 
147, 148, 244, 244, 243, 244, 201, 203, 
203, 255, 83, 88, 90, 255, 81, 86, 
88, 255, 79, 85, 87, 255, 141, 144, 
145, 255, 239, 240, 240, 255, 245, 245, 
245, 245, 206, 206, 206, 207, 157, 157, 
157, 157, 115, 115, 115, 115, 88, 88, 
88, 88, 134, 134, 134, 134, 173, 173, 
173, 173, 226, 226, 226, 226, 249, 249, 
249, 251, 212, 213, 214, 255, 102, 107, 
108, 255, 80, 85, 87, 255, 80, 86, 
88, 255, 102, 107, 108, 255, 236, 237, 
237, 254, 223, 223, 224, 224, 91, 91, 
91, 92, 6, 6, 6, 6, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 11, 11, 11, 11, 142, 143, 
142, 143, 247, 249, 249, 251, 117, 156, 
193, 255, 43, 103, 161, 255, 46, 106, 
162, 255, 218, 228, 238, 255, 237, 238, 
237, 239, 157, 157, 157, 159, 80, 80, 
80, 81, 112, 112, 112, 113, 165, 166, 
165, 166, 230, 230, 230, 231, 243, 246, 
249, 254, 225, 233, 241, 255, 245, 244, 
244, 245, 234, 234, 235, 235, 247, 249, 
250, 254, 88, 135, 180, 255, 43, 103, 
161, 255, 43, 104, 160, 255, 54, 111, 
165, 255, 193, 211, 227, 255, 250, 250, 
252, 253, 224, 224, 225, 225, 161, 162, 
160, 162, 106, 107, 106, 107, 66, 67, 
66, 67, 66, 67, 66, 67, 109, 109, 
109, 110, 153, 153, 152, 153, 191, 190, 
191, 191, 238, 237, 237, 238, 251, 251, 
252, 253, 221, 230, 239, 255, 224, 233, 
240, 255, 211, 212, 211, 213, 40, 40, 
40, 40, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 54, 54, 54, 54, 190, 190, 
190, 190, 248, 248, 248, 252, 158, 161, 
162, 255, 79, 85, 86, 255, 81, 86, 
88, 255, 80, 84, 87, 255, 111, 115, 
117, 255, 202, 203, 204, 255, 240, 241, 
241, 254, 248, 248, 248, 251, 239, 239, 
239, 240, 231, 231, 231, 232, 245, 245, 
245, 246, 248, 248, 248, 253, 232, 233, 
233, 255, 164, 167, 167, 255, 88, 93, 
95, 255, 79, 86, 88, 255, 80, 85, 
88, 255, 89, 94, 96, 255, 203, 204, 
205, 255, 243, 243, 243, 243, 139, 139, 
139, 139, 23, 23, 23, 23, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 9, 9, 
9, 9, 122, 122, 121, 122, 243, 243, 
243, 244, 164, 190, 213, 255, 41, 100, 
159, 255, 44, 103, 160, 255, 124, 161, 
196, 255, 243, 246, 249, 254, 245, 246, 
246, 247, 229, 227, 229, 229, 239, 238, 
238, 240, 247, 249, 249, 252, 222, 232, 
240, 255, 100, 144, 185, 255, 164, 190, 
214, 255, 218, 218, 218, 218, 160, 159, 
160, 161, 239, 239, 238, 240, 223, 231, 
240, 255, 59, 116, 168, 255, 43, 103, 
160, 255, 43, 104, 161, 255, 47, 106, 
162, 255, 143, 174, 204, 255, 233, 239, 
245, 255, 247, 249, 249, 252, 236, 238, 
236, 238, 225, 225, 224, 226, 223, 224, 
224, 225, 238, 238, 237, 239, 248, 249, 
249, 251, 242, 245, 248, 254, 215, 227, 
237, 255, 132, 167, 200, 255, 50, 108, 
164, 255, 189, 207, 225, 255, 212, 212, 
212, 214, 40, 40, 40, 40, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 10, 10, 
10, 10, 101, 101, 101, 101, 219, 219, 
219, 220, 246, 246, 246, 253, 154, 157, 
158, 255, 82, 88, 89, 255, 80, 86, 
88, 255, 80, 86, 87, 255, 77, 83, 
85, 255, 102, 106, 108, 255, 142, 146, 
147, 255, 163, 165, 166, 255, 167, 169, 
169, 255, 158, 160, 161, 255, 130, 133, 
134, 255, 87, 92, 94, 255, 78, 83, 
85, 255, 80, 86, 89, 255, 80, 84, 
87, 255, 95, 99, 101, 255, 199, 200, 
201, 255, 248, 248, 248, 248, 186, 186, 
186, 186, 55, 55, 55, 55, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 64, 64, 
64, 65, 220, 219, 219, 221, 235, 241, 
246, 255, 58, 114, 167, 255, 44, 104, 
160, 255, 42, 102, 159, 255, 91, 138, 
182, 255, 159, 186, 211, 255, 191, 209, 
225, 255, 167, 192, 215, 255, 116, 156, 
193, 255, 47, 107, 163, 255, 42, 102, 
160, 255, 166, 191, 214, 254, 207, 207, 
207, 207, 71, 71, 71, 72, 153, 152, 
153, 154, 239, 239, 240, 241, 213, 225, 
236, 255, 69, 122, 171, 255, 42, 103, 
160, 255, 45, 104, 160, 255, 41, 102, 
160, 255, 55, 112, 166, 255, 119, 157, 
193, 255, 161, 186, 211, 255, 191, 209, 
225, 255, 189, 208, 225, 255, 162, 187, 
212, 255, 130, 165, 198, 255, 83, 131, 
178, 255, 38, 100, 158, 255, 41, 103, 
160, 255, 39, 101, 158, 255, 190, 208, 
225, 255, 212, 212, 213, 214, 40, 40, 
40, 40, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 19, 18, 
19, 19, 110, 110, 111, 111, 222, 221, 
222, 222, 250, 250, 250, 253, 190, 192, 
193, 255, 101, 105, 107, 255, 79, 85, 
87, 255, 79, 86, 88, 255, 81, 86, 
88, 255, 79, 86, 88, 255, 78, 85, 
86, 255, 79, 84, 86, 255, 79, 84, 
87, 255, 80, 86, 88, 255, 80, 86, 
88, 255, 80, 85, 87, 255, 82, 88, 
90, 255, 129, 133, 134, 255, 226, 227, 
227, 255, 248, 248, 248, 248, 189, 189, 
189, 189, 66, 66, 66, 66, 7, 7, 
7, 7, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 28, 28, 28, 28, 156, 155, 
156, 156, 242, 243, 242, 243, 197, 213, 
228, 255, 54, 111, 165, 255, 42, 103, 
160, 255, 43, 104, 160, 255, 41, 101, 
159, 255, 37, 99, 158, 255, 39, 101, 
159, 255, 43, 103, 161, 255, 44, 103, 
161, 255, 42, 102, 160, 255, 171, 194, 
216, 254, 205, 205, 206, 206, 38, 38, 
38, 39, 38, 37, 37, 38, 155, 155, 
155, 156, 240, 241, 241, 242, 231, 238, 
244, 255, 118, 157, 193, 255, 47, 107, 
162, 255, 43, 102, 160, 255, 44, 103, 
160, 255, 43, 103, 160, 255, 40, 101, 
159, 255, 38, 99, 159, 255, 37, 99, 
159, 255, 40, 101, 159, 255, 43, 103, 
160, 255, 44, 103, 160, 255, 43, 103, 
160, 255, 43, 104, 160, 255, 66, 120, 
170, 255, 211, 224, 235, 255, 212, 212, 
213, 214, 40, 40, 40, 40, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 19, 19, 
19, 19, 109, 109, 109, 109, 204, 204, 
204, 205, 246, 246, 246, 247, 238, 238, 
239, 254, 178, 180, 181, 255, 118, 122, 
123, 255, 86, 92, 94, 255, 81, 87, 
89, 255, 80, 86, 88, 255, 80, 86, 
88, 255, 81, 86, 89, 255, 82, 88, 
90, 255, 96, 100, 102, 255, 139, 142, 
144, 255, 204, 205, 206, 255, 250, 250, 
250, 254, 235, 236, 236, 236, 177, 177, 
177, 177, 67, 67, 67, 67, 7, 7, 
7, 7, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 42, 42, 42, 42, 162, 162, 
162, 162, 242, 241, 241, 243, 212, 224, 
235, 255, 105, 147, 188, 255, 50, 108, 
163, 255, 44, 104, 161, 255, 43, 103, 
160, 255, 44, 104, 161, 255, 47, 105, 
162, 255, 78, 127, 176, 255, 161, 187, 
212, 255, 245, 247, 249, 254, 201, 200, 
200, 202, 35, 35, 35, 36, 3, 3, 
3, 3, 38, 38, 38, 38, 153, 154, 
154, 155, 234, 235, 234, 236, 251, 251, 
252, 253, 206, 219, 233, 255, 125, 161, 
197, 255, 67, 120, 171, 255, 45, 105, 
162, 255, 45, 104, 161, 255, 43, 103, 
161, 255, 43, 103, 161, 255, 45, 105, 
161, 255, 45, 105, 162, 255, 61, 116, 
168, 255, 110, 152, 190, 255, 181, 202, 
222, 255, 244, 246, 249, 254, 248, 248, 
247, 249, 189, 189, 189, 191, 33, 33, 
33, 33, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 13, 13, 
13, 13, 63, 63, 63, 63, 163, 163, 
163, 164, 215, 215, 215, 215, 242, 242, 
242, 242, 251, 251, 251, 252, 238, 239, 
239, 254, 210, 211, 212, 254, 192, 194, 
194, 254, 187, 189, 189, 254, 198, 200, 
200, 254, 220, 222, 222, 254, 246, 247, 
247, 254, 249, 249, 249, 249, 235, 235, 
235, 235, 201, 202, 202, 202, 127, 127, 
127, 127, 37, 37, 37, 37, 6, 6, 
6, 6, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 42, 43, 43, 43, 161, 162, 
161, 163, 239, 240, 239, 240, 252, 252, 
253, 253, 231, 237, 243, 254, 191, 209, 
225, 254, 172, 196, 217, 254, 184, 204, 
222, 254, 219, 229, 238, 254, 250, 250, 
251, 253, 247, 247, 246, 247, 219, 219, 
219, 220, 134, 133, 133, 135, 18, 18, 
18, 19, 0, 0, 0, 0, 1, 2, 
2, 2, 33, 33, 33, 34, 114, 114, 
113, 115, 194, 195, 195, 196, 231, 231, 
232, 233, 248, 249, 249, 249, 249, 250, 
251, 254, 220, 229, 238, 254, 189, 208, 
225, 254, 173, 195, 217, 254, 173, 196, 
217, 254, 192, 209, 226, 254, 219, 228, 
238, 254, 247, 249, 250, 254, 250, 249, 
250, 250, 238, 238, 238, 239, 207, 208, 
208, 209, 156, 157, 157, 158, 71, 70, 
71, 72, 8, 8, 8, 8, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 4, 4, 
4, 4, 25, 25, 25, 25, 60, 60, 
60, 60, 116, 116, 116, 116, 174, 174, 
174, 174, 205, 205, 205, 205, 206, 206, 
206, 206, 206, 206, 206, 206, 206, 206, 
206, 206, 206, 206, 206, 206, 206, 206, 
206, 206, 200, 200, 200, 200, 151, 151, 
151, 151, 97, 97, 97, 97, 43, 43, 
43, 43, 16, 16, 16, 16, 2, 2, 
2, 2, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 3, 3, 
3, 3, 40, 40, 40, 40, 122, 122, 
122, 122, 189, 189, 189, 189, 206, 206, 
206, 206, 206, 206, 206, 206, 206, 206, 
206, 206, 206, 206, 206, 206, 206, 206, 
206, 206, 192, 192, 192, 192, 135, 135, 
135, 135, 74, 74, 74, 74, 20, 20, 
20, 20, 2, 2, 2, 2, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 10, 10, 10, 10, 41, 41, 
41, 41, 95, 95, 95, 95, 150, 150, 
150, 150, 199, 199, 199, 199, 206, 206, 
206, 206, 206, 206, 206, 206, 206, 206, 
206, 206, 206, 206, 206, 206, 206, 206, 
206, 206, 206, 206, 206, 206, 204, 204, 
204, 204, 161, 161, 161, 161, 107, 107, 
107, 107, 48, 48, 48, 48, 21, 21, 
21, 21, 3, 3, 3, 3, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 2, 2, 2, 2, 7, 7, 
7, 7, 26, 26, 26, 26, 37, 37, 
37, 37, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 35, 35, 
35, 35, 17, 17, 17, 17, 4, 4, 
4, 4, 1, 1, 1, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 10, 10, 10, 10, 31, 31, 
31, 31, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 32, 32, 
32, 32, 12, 12, 12, 12, 3, 3, 
3, 3, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 4, 4, 
4, 4, 17, 17, 17, 17, 35, 35, 
35, 35, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 37, 37, 
37, 37, 37, 37, 37, 37, 21, 21, 
21, 21, 5, 5, 5, 5, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0,

#endif

};
OSG_END_NAMESPACE

/*-------------------------------------------------------------------------*/
/*                              cvs id's                                   */

#ifdef __sgi
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static char cvsid_cpp       [] = "@(#)$Id: $";
    static char cvsid_hpp       [] = OSGLOGODATA_HEADER_CVSID;
}
