/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SolidBackground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &SolidBackgroundBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 SolidBackgroundBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
SolidBackgroundPtr SolidBackgroundBase::create(void) 
{
    SolidBackgroundPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = SolidBackgroundPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
SolidBackgroundPtr SolidBackgroundBase::createEmpty(void) 
{ 
    SolidBackgroundPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the SolidBackground::_sfColor field.
inline
SFColor3f *SolidBackgroundBase::getSFColor(void)
{
    return &_sfColor;
}

//! Get the SolidBackground::_sfClearStencilBit field.
inline
SFInt32 *SolidBackgroundBase::getSFClearStencilBit(void)
{
    return &_sfClearStencilBit;
}

//! Get the SolidBackground::_sfAlpha field.
inline
SFReal32 *SolidBackgroundBase::getSFAlpha(void)
{
    return &_sfAlpha;
}

//! Get the SolidBackground::_sfDepth field.
inline
SFReal32 *SolidBackgroundBase::getSFDepth(void)
{
    return &_sfDepth;
}


//! Get the value of the SolidBackground::_sfColor field.
inline
Color3f &SolidBackgroundBase::getColor(void)
{
    return _sfColor.getValue();
}

//! Get the value of the SolidBackground::_sfColor field.
inline
const Color3f &SolidBackgroundBase::getColor(void) const
{
    return _sfColor.getValue();
}

//! Set the value of the SolidBackground::_sfColor field.
inline
void SolidBackgroundBase::setColor(const Color3f &value)
{
    _sfColor.setValue(value);
}

//! Get the value of the SolidBackground::_sfClearStencilBit field.
inline
Int32 &SolidBackgroundBase::getClearStencilBit(void)
{
    return _sfClearStencilBit.getValue();
}

//! Get the value of the SolidBackground::_sfClearStencilBit field.
inline
const Int32 &SolidBackgroundBase::getClearStencilBit(void) const
{
    return _sfClearStencilBit.getValue();
}

//! Set the value of the SolidBackground::_sfClearStencilBit field.
inline
void SolidBackgroundBase::setClearStencilBit(const Int32 &value)
{
    _sfClearStencilBit.setValue(value);
}

//! Get the value of the SolidBackground::_sfAlpha field.
inline
Real32 &SolidBackgroundBase::getAlpha(void)
{
    return _sfAlpha.getValue();
}

//! Get the value of the SolidBackground::_sfAlpha field.
inline
const Real32 &SolidBackgroundBase::getAlpha(void) const
{
    return _sfAlpha.getValue();
}

//! Set the value of the SolidBackground::_sfAlpha field.
inline
void SolidBackgroundBase::setAlpha(const Real32 &value)
{
    _sfAlpha.setValue(value);
}

//! Get the value of the SolidBackground::_sfDepth field.
inline
Real32 &SolidBackgroundBase::getDepth(void)
{
    return _sfDepth.getValue();
}

//! Get the value of the SolidBackground::_sfDepth field.
inline
const Real32 &SolidBackgroundBase::getDepth(void) const
{
    return _sfDepth.getValue();
}

//! Set the value of the SolidBackground::_sfDepth field.
inline
void SolidBackgroundBase::setDepth(const Real32 &value)
{
    _sfDepth.setValue(value);
}


OSG_END_NAMESPACE

#define OSGSOLIDBACKGROUNDBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

