/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CarbonWindow!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECARBONWINDOWINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCarbonWindowBase.h"
#include "OSGCarbonWindow.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  CarbonWindowBase::ContextFieldMask = 
    (TypeTraits<BitVector>::One << CarbonWindowBase::ContextFieldId);

const OSG::BitVector CarbonWindowBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var AGLContext      CarbonWindowBase::_sfContext
    
*/

//! CarbonWindow description

FieldDescription *CarbonWindowBase::_desc[] = 
{
    new FieldDescription(SFAGLContext::getClassType(), 
                     "context", 
                     ContextFieldId, ContextFieldMask,
                     true,
                     (FieldAccessMethod) &CarbonWindowBase::getSFContext)
};


FieldContainerType CarbonWindowBase::_type(
    "CarbonWindow",
    "Window",
    NULL,
    (PrototypeCreateF) &CarbonWindowBase::createEmpty,
    CarbonWindow::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CarbonWindowBase, CarbonWindowPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CarbonWindowBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CarbonWindowBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CarbonWindowBase::shallowCopy(void) const 
{ 
    CarbonWindowPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const CarbonWindow *>(this)); 

    return returnValue; 
}

UInt32 CarbonWindowBase::getContainerSize(void) const 
{ 
    return sizeof(CarbonWindow); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CarbonWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CarbonWindowBase *) &other, whichField);
}
#else
void CarbonWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CarbonWindowBase *) &other, whichField, sInfo);
}
void CarbonWindowBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CarbonWindowBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CarbonWindowBase::CarbonWindowBase(void) :
    _sfContext                (AGLContext(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CarbonWindowBase::CarbonWindowBase(const CarbonWindowBase &source) :
    _sfContext                (source._sfContext                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CarbonWindowBase::~CarbonWindowBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CarbonWindowBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        returnValue += _sfContext.getBinSize();
    }


    return returnValue;
}

void CarbonWindowBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        _sfContext.copyToBin(pMem);
    }


}

void CarbonWindowBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        _sfContext.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CarbonWindowBase::executeSyncImpl(      CarbonWindowBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
        _sfContext.syncWith(pOther->_sfContext);


}
#else
void CarbonWindowBase::executeSyncImpl(      CarbonWindowBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
        _sfContext.syncWith(pOther->_sfContext);



}

void CarbonWindowBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CarbonWindowPtr>::_type("CarbonWindowPtr", "WindowPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(CarbonWindowPtr, OSG_WINDOWCARBONLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(CarbonWindowPtr, OSG_WINDOWCARBONLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGCarbonWindowBase.cpp,v 1.1 2006/08/04 09:18:18 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGCARBONWINDOWBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCARBONWINDOWBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCARBONWINDOWFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

