/*
 * libopensync - A synchronization framework
 * Copyright (C) 2004-2005  Armin Bauer <armin.bauer@opensync.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef _OPENSYNC_GROUP_ENV_PRIVATE_H
#define _OPENSYNC_GROUP_ENV_PRIVATE_H

/**
 * @defgroup OSyncGroupEnvPrivateAPI OpenSync Group Environment Private
 * @ingroup OSyncGroupPrivate
 * @brief The private part of the opensync environment
 * 
 */
/*@{*/

/** @brief Returns the next free number for a group in the environments configdir
 * 
 * Returns the next free number for a group in the environments configdir
 * 
 * @param env The osync environment
 * @returns The next free number
 * 
 */
static long long int osync_group_env_create_group_id(OSyncGroupEnv *env);

/*@}*/

#endif /* _OPENSYNC_GROUP_ENV_PRIVATE_H */
