class distcc ( $farmname = $uniqueid, $distcc = "3632" ){

  package { "build-essential": 
    ensure => installed
  }

  package { "distcc-pump": 
    alias => "distcc", 
    ensure => installed, 
    require => Package["build-essential"] 
  } -> File <<| tag == "distcc_${farmname}" |>>

  service {"distcc":
    ensure => running,
    enable => true,
    subscribe => [File["distcc_default"], File["distcc_hosts_config"]],
    hasstatus => true,
    restart   => "/etc/init.d/distcc restart",
    require => Package["distcc"]
  }

  file {"distcc_default":
    name    => "/etc/default/distcc",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    content => template("/etc/puppet/modules/orchestra-distcc/templates/distcc.erb"),
    require => Package["distcc"],
  }

  file {"distcc_hosts_config":
    name    => "/etc/distcc/hosts",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Package["distcc"],
  }

  exec{"create_distcc_dir":
    command => "mkdir -p /etc/distcc/farms",
    unless => "test -d /etc/distcc/farms",
    require => [File["distcc_hosts_config"], File["distcc_default"], Package["distcc"]]
  }

  @@file{ "${uniqueid}.${farmname}.deployment_data":
    name => "/etc/distcc/farms/${uniqueid}.${farmname}.deployment_data",
    content => "${ipaddress}:${distcc},cpp,lzo ", 
    tag => "distcc_${farmname}", 
    ensure => present,
    require => Exec["create_distcc_dir"],
    notify => Service["distcc"]
  } 

    exec{"distcc_var_update": 
    command => "cat /etc/distcc/farms/* > /etc/distcc/hosts",
    onlyif => "test -d /etc/distcc/farms",
    require => File["${uniqueid}.${farmname}.deployment_data"],
    notify => Service["distcc"]
  } 

  file{"distcc_farms_directory_update":
    name => "/etc/distcc/farms",
    ensure => directory,
    require => Package["distcc"],
    notify => Service["distcc"]
  }
	
} 
