class gearman_job_server($deploymentname = $uniqueid) {

  package{'gearman-job-server': ensure => installed}

  package{'libgearman-client-perl': ensure => installed, require => Package['gearman-job-server']}
  package{'libgearman-client-async-perl': ensure => installed, require => Package['libgearman-client-perl']}

  package{'python-gearman.libgearman': ensure => installed, require => Package['libgearman-client-async-perl']}

  package{'libgearman-dev': ensure => installed, require => Package['python-gearman.libgearman']}
  package{'uuid-dev': ensure => installed, require => Package['libgearman-dev']}
  package{'libev-libevent-dev': ensure => installed, require => Package['uuid-dev']}
  package{'php-pear': ensure => installed, require => Package['libev-libevent-dev']}
  package{'php5-dev': ensure => installed, require => Package['php-pear']}

  exec{ "libgearman-php":
    command => "pecl install \"channel://pecl.php.net/gearman-0.7.0\"",
    require => Package["php5-dev"],
    unless => "test -e /usr/lib/php5/20090626+lfs/gearman.so",
  }

  exec {"gearman_ini":
    command => "echo extension=gearman.so > /etc/php5/conf.d/gearman.ini",
    require => Exec["libgearman-php"],
    unless => "test -e /etc/php5/conf.d/gearman.ini",
  }

  file {"gearman_job_server_default":
    name    => "/etc/default/gearman-job-server",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Exec["gearman_ini"],
    notify => Service["gearman-job-server"],
  }

  service {"gearman-job-server":
    ensure => running,
    enable => true,
    subscribe => File["gearman_job_server_default"],
    hasstatus => false,
    restart   => "/etc/init.d/gearman-job-server restart",
    require => File["gearman_job_server_default"],
  }

  @@file{ "/etc/gearman/deployments/${deploymentname}.deployment_data": 
    content => "#GEARMAN JOB SERVER FOR ${deploymentname}\n${ipaddress} gearman-job-server", 
    tag => "gearman_${deploymentname}", 
    ensure => present,
    require => Service["gearman-job-server"],
  }

}
