# --
# Kernel/Language/zh_CN.pm -  provides Chinese Simple language translation
# Copyright (C) 2005 zuowei <j2ee at hirain-sh.com>
# Copyright (C) 2008-2010 Never Min <never at qnofae.org>
# Copyright (C) 2009 Bin Du <bindu2008 at gmail.com>,
# Copyright (C) 2009 Yiye Huang <yiyehuang at gmail.com>
# Copyright (C) 2009 Qingjiu Jia <jiaqj at yahoo.com>
# Copyright (C) 2011 Martin Liu <liuzh66 at gmail.com> http://martinliu.cn
# --
# $Id: zh_CN.pm,v 1.88.2.4 2011/06/30 11:34:33 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::zh_CN;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.88.2.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2011-03-21 17:28:54

    # possible charsets
    $Self->{Charset} = ['GBK', 'GB2312', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y.%M.%D %T';
    $Self->{DateFormatLong}      = ' %A %Y/%M/%D %T';
    $Self->{DateFormatShort}     = '%Y.%M.%D';
    $Self->{DateInputFormat}     = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    # csv separator
    $Self->{Separator} = '';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => '',
        'No' => '',
        'yes' => '',
        'no' => 'δ',
        'Off' => '',
        'off' => '',
        'On' => '',
        'on' => '',
        'top' => '',
        'end' => 'ײ',
        'Done' => 'ȷ',
        'Cancel' => 'ȡ',
        'Reset' => '',
        'last' => '',
        'before' => '',
        'Today' => '',
        'Tomorrow' => '',
        'Next Week' => '',
        'day' => '',
        'days' => '',
        'day(s)' => '',
        'd' => '',
        'hour' => 'Сʱ',
        'hours' => 'Сʱ',
        'hour(s)' => 'Сʱ',
        'Hours' => '',
        'h' => 'ʱ',
        'minute' => '',
        'minutes' => '',
        'minute(s)' => '',
        'Minutes' => '',
        'm' => '',
        'month' => '',
        'months' => '',
        'month(s)' => '',
        'week' => '',
        'week(s)' => '',
        'year' => '',
        'years' => '',
        'year(s)' => '',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        's' => '',
        'wrote' => 'д',
        'Message' => 'Ϣ',
        'Error' => '',
        'Bug Report' => 'Bug ',
        'Attention' => 'ע',
        'Warning' => '',
        'Module' => 'ģ',
        'Modulefile' => 'ģļ',
        'Subfunction' => 'ӹ',
        'Line' => '',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'ʾ',
        'Examples' => 'ʾ',
        'valid' => 'Ч',
        'invalid' => 'Ч',
        '* invalid' => '* Ч',
        'invalid-temporarily' => 'ʱЧ',
        ' 2 minutes' => ' 2 ',
        ' 5 minutes' => ' 5 ',
        ' 7 minutes' => ' 7 ',
        '10 minutes' => '10 ',
        '15 minutes' => '15 ',
        'Mr.' => '',
        'Mrs.' => '',
        'Next' => 'һ',
        'Back' => '',
        'Next...' => 'һ...',
        '...Back' => '...',
        '-none-' => '--',
        'none' => '',
        'none!' => '!',
        'none - answered' => ' - Ѵ𸴵',
        'please do not edit!' => 'Ҫ༭!',
        'Need Action' => '',
        'AddLink' => '',
        'Link' => '',
        'Unlink' => 'δ',
        'Linked' => '',
        'Link (Normal)' => ' ()',
        'Link (Parent)' => ' ()',
        'Link (Child)' => ' ()',
        'Normal' => '',
        'Parent' => '',
        'Child' => '',
        'Hit' => '',
        'Hits' => '',
        'Text' => '',
        'Standard' => '׼',
        'Lite' => '',
        'User' => 'û',
        'Username' => 'û',
        'Language' => '',
        'Languages' => '',
        'Password' => '',
        'Preferences' => '',
        'Salutation' => 'ν',
        'Salutations' => 'ν',
        'Signature' => 'ǩ',
        'Signatures' => 'ǩ',
        'Customer' => 'ͻ',
        'CustomerID' => 'ͻ',
        'CustomerIDs' => 'ͻ',
        'customer' => 'ͻ',
        'agent' => '֧Ա',
        'system' => 'ϵͳ',
        'Customer Info' => 'ͻϢ',
        'Customer Information' => 'ͻϢ',
        'Customer Company' => 'ͻλ',
        'Customer Companies' => 'ͻλ',
        'Company' => 'λ',
        'go!' => 'ʼ!',
        'go' => 'ʼ',
        'All' => 'ȫ',
        'all' => 'ȫ',
        'Sorry' => 'Բ',
        'update!' => '!',
        'update' => '',
        'Update' => '',
        'Updated!' => 'Ѹ',
        'submit!' => 'ύ!',
        'submit' => 'ύ',
        'Submit' => 'ύ',
        'change!' => '޸!',
        'Change' => '޸',
        'change' => '޸',
        'click here' => '',
        'Comment' => 'ע',
        'Valid' => 'Ч',
        'Invalid Option!' => 'Чѡ!',
        'Invalid time!' => 'Чʱ!',
        'Invalid date!' => 'Ч!',
        'Name' => '',
        'Group' => '',
        'Description' => '',
        'description' => '',
        'Theme' => '',
        'Created' => '',
        'Created by' => '',
        'Changed' => '޸',
        'Changed by' => '޸',
        'Search' => '',
        'and' => '',
        'between' => '',
        'Fulltext Search' => 'ȫ',
        'Data' => '',
        'Options' => 'ѡ',
        'Title' => 'ν',
        'Item' => 'Ŀ',
        'Delete' => 'ɾ',
        'Edit' => '༭',
        'View' => '鿴',
        'Number' => '',
        'System' => 'ϵͳ',
        'Contact' => 'ϵ',
        'Contacts' => 'ϵ',
        'Export' => '',
        'Up' => '',
        'Down' => '',
        'Add' => '',
        'Added!' => '!',
        'Category' => 'Ŀ¼',
        'Viewer' => '鿴',
        'Expand' => 'չ',
        'Small' => '',
        'Medium' => '',
        'Large' => 'ϸ',
        'Date picker' => 'ѡ',
        'New message' => 'Ϣ',
        'New message!' => 'Ϣ!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Ȼظ TicketȻصͼ!',
        'You have %s new message(s)!' => ' %s Ϣ!',
        'You have %s reminder ticket(s)!' => ' %s !',
        'The recommended charset for your language is %s!' => 'Եַ %s!',
        'Change your password.' => 'ı.',
        'Please activate %s first!' => 'ȼ %s',
        'No suggestions' => '޽',
        'Word' => '',
        'Ignore' => '',
        'replace with' => '滻',
        'There is no account with that login name.' => 'ûûʻϢ.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'ע',
        'Logout successful. Thank you for using OTRS!' => 'ɹעллʹ!',
        'Invalid SessionID!' => 'ЧĻỰʶ!',
        'Feature not active!' => 'δ!',
        'Agent updated!' => '',
        'Create Database' => 'ݿ',
        'System Settings' => 'ݿ ',
        'Mail Configuration' => '',
        'Finished' => '',
        'Login is needed!' => 'Ҫȵ¼!',
        'Password is needed!' => 'Ҫ!',
        'License' => '֤',
        'Take this Customer' => 'ȡͻ',
        'Take this User' => 'ȡû',
        'possible' => '',
        'reject' => 'ܾ',
        'reverse' => '',
        'Facility' => '',
        'Time Zone' => '',
        'Pending till' => 'ȴ',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Ҫʹ UserID 1 (ϵͳ˺)! 봴һµû!',
        'Dispatching by email To: field.' => 'ʼ: .',
        'Dispatching by selected Queue.' => 'ʼѡ.',
        'No entry found!' => '!',
        'Session has timed out. Please log in again.' => 'Ựʱµ¼.',
        'No Permission!' => 'Ȩ!',
        'To: (%s) replaced with database email!' => 'To: (%s) ݿʼַ',
        'Cc: (%s) added database email!' => 'Cc: (%s) ݿʼַ!',
        '(Click here to add)' => '(˴)',
        'Preview' => 'Ԥ',
        'Package not correctly deployed! You should reinstall the Package again!' => 'չ! Ҫһ°װ',
        '%s is not writable!' => '%s ǲд!',
        'Cannot create %s!' => '޷ %s!',
        'Customer %s added' => '',
        'Role added!' => 'ɫ!',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'ͬ',
        'Online Customer: %s' => '߿ͻ: %s',
        'Online Agent: %s' => '߼֧Ա%s',
        'Calendar' => '',
        'File' => 'ļ',
        'Filename' => 'ļ',
        'Type' => '',
        'Size' => 'С',
        'Upload' => 'ϴ',
        'Directory' => 'Ŀ¼',
        'Signed' => 'ǩ',
        'Sign' => 'ǩ',
        'Crypted' => 'Ѽ',
        'Crypt' => '',
        'PGP' => 'PGP',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => '',
        'S/MIME Certificate' => 'S/MIME ֤',
        'S/MIME Certificates' => 'S/MIME ֤',
        'Office' => '칫',
        'Phone' => '绰',
        'Fax' => '',
        'Mobile' => 'ֻ',
        'Zip' => 'ʱ',
        'City' => '',
        'Street' => 'ֵ',
        'Country' => '',
        'Location' => '',
        'installed' => 'Ѱװ',
        'uninstalled' => 'δװ',
        'Security Note: You should activate %s because application is already running!' => 'ȫʾ: ܼ %s, ΪӦѾ!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '༭ϵͳ',
        'printed at' => 'ӡ',
        'Loading...' => '',
        'Dear Mr. %s,' => '𾴵 %s :',
        'Dear Mrs. %s,' => '𾴵 %s Ůʿ:',
        'Dear %s,' => '𾴵 %s:',
        'Hello %s,' => ', %s:',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => '뷵һ.',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => '¼',
        'Event' => '¼',
        'Events' => '¼',
        'Invalid Token!' => 'Ƿı',
        'more' => '',
        'For more info see:' => 'Ϣ뿴',
        'Package verification failed!' => '֤ʧ',
        'Collapse' => '',
        'Shown' => 'ʾ',
        'News' => '',
        'Product News' => 'Ʒ',
        'OTRS News' => 'OTRS ',
        '7 Day Stats' => ' 7 ͳ',
        'Bold' => '',
        'Italic' => 'б',
        'Underline' => '',
        'Font Color' => 'ɫ',
        'Background Color' => 'ɫ',
        'Remove Formatting' => 'ɾʽ',
        'Show/Hide Hidden Elements' => 'ʾ/ Ҫ',
        'Align Left' => '',
        'Align Center' => 'ж',
        'Align Right' => 'Ҷ',
        'Justify' => '',
        'Header' => 'Ϣͷ',
        'Indent' => '',
        'Outdent' => 'ͻ',
        'Create an Unordered List' => 'һб',
        'Create an Ordered List' => 'һб',
        'HTML Link' => 'HTML',
        'Insert Image' => 'ͼ',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'ԭ',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'һ',
        'Feb' => '',
        'Mar' => '',
        'Apr' => '',
        'May' => '',
        'Jun' => '',
        'Jul' => '',
        'Aug' => '',
        'Sep' => '',
        'Oct' => 'ʮ',
        'Nov' => 'ʮһ',
        'Dec' => 'ʮ',
        'January' => 'һ',
        'February' => '',
        'March' => '',
        'April' => '',
        'May_long' => '',
        'June' => '',
        'July' => '',
        'August' => '',
        'September' => '',
        'October' => 'ʮ',
        'November' => 'ʮһ',
        'December' => 'ʮ',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'ø³ɹ!',
        'User Profile' => 'ƫ',
        'Email Settings' => '֪ͨʼ',
        'Other Settings' => '',
        'Change Password' => '޸',
        'Current Password' => 'ǰ',
        'New password' => '',
        'Verify password' => '',
        'Spelling Dictionary' => 'ƴдֵ',
        'Default spelling dictionary' => 'Ĭֵ',
        'Max. shown Tickets a page in Overview.' => 'ÿһҳʾ Tickets Ŀ.',
        'The current password is not correct. Please try again!' => 'ǰ벻ȷ. !',
        'Can\'t update password, your new passwords do not match. Please try again!' => '޷, ܲƥ. !',
        'Can\'t update password, it contains invalid characters!' => '޷, 벻ܰǳַ!',
        'Can\'t update password, it must be at least %s characters long!' => '޷,  %s ַĳ!',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => '޷,  2 Сд 2 дĸ!',
        'Can\'t update password, it must contain at least 1 digit!' => '޷,  1 !',
        'Can\'t update password, it must contain at least 2 characters!' => '޷,  2 ĸ!',
        'Can\'t update password, this password has already been used. Please choose a new one!' => '޷, ѱʹ. ѡһ!',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'ͳ',
        'Sum' => '',
        'Please fill out the required fields!' => 'дֶ',
        'Please select a file!' => 'ѡһļ!',
        'Please select an object!' => 'ѡһ!',
        'Please select a graph size!' => 'ѡͼƬߴ!',
        'Please select one element for the X-axis!' => 'ѡһԪصX-',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'ֻѡһԪػرձѡ\'Fixed\'ť',
        'If you use a checkbox you have to select some attributes of the select field!' => 'ʹøѡѡѡһЩ!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'ѡһֵر\'Fixed\'ѡ',
        'The selected end time is before the start time!' => 'ѡĽʱڿʼʱ䣡',
        'You have to select one or more attributes from the select field!' => 'ӱѡѡһԣ',
        'The selected Date isn\'t valid!' => 'ѡڲЧ',
        'Please select only one or two elements via the checkbox!' => 'ͨѡֻѡһҪأ',
        'If you use a time scale element you can only select one element!' => 'ʹõʱ߶Ҫֻѡһɲ',
        'You have an error in your time selection!' => 'һʱѡ',
        'Your reporting time interval is too small, please use a larger time scale!' => 'ıʱ̫Сʹøļ',
        'The selected start time is before the allowed start time!' => 'ѡĿʼʱĿʼʱ',
        'The selected end time is after the allowed end time!' => 'ѡĽʱĽʱ',
        'The selected time period is larger than the allowed time period!' => 'ѡʱδʱ',
        'Common Specification' => 'ͬ淶',
        'X-axis' => 'X',
        'Value Series' => 'ֵϵ',
        'Restrictions' => '',
        'graph-lines' => 'ͼ',
        'graph-bars' => '״ͼ',
        'graph-hbars' => 'H״ͼ',
        'graph-points' => 'ͼ',
        'graph-lines-points' => 'ͼߵ',
        'graph-area' => 'ͼ',
        'graph-pie' => 'ͼ',
        'extended' => 'չ',
        'Agent/Owner' => '',
        'Created by Agent/Owner' => '֧Ա',
        'Created Priority' => 'ȼ',
        'Created State' => '״̬',
        'Create Time' => 'ʱ',
        'CustomerUserLogin' => 'ͻ½',
        'Close Time' => 'رʱ',
        'TicketAccumulation' => 'Ticket',
        'Attributes to be printed' => 'Ҫӡ',
        'Sort sequence' => '',
        'Order by' => '˳',
        'Limit' => '',
        'Ticketlist' => 'Ticket嵥',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '۵',
        'Total Time' => 'ʱ',
        'Ticket Average' => 'Ticketƽʱ',
        'Ticket Min Time' => 'TicketСʱ',
        'Ticket Max Time' => 'Ticketʱ',
        'Number of Tickets' => 'TicketĿ',
        'Article Average' => 'Articleƽʱ',
        'Article Min Time' => 'ArticleСʱ',
        'Article Max Time' => 'Articleʱ',
        'Number of Articles' => 'Article',
        'Accounted time by Agent' => '֧ԱTicketõʱ',
        'Ticket/Article Accounted Time' => 'Ticket/Articleռõʱ',
        'TicketAccountedTime' => 'Ticketռõʱ',
        'Ticket Create Time' => 'Ticketʱ',
        'Ticket Close Time' => 'Ticketرʱ',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => '',
        'Unlock' => '',
        'History' => 'ʷ',
        'Zoom' => 'ʼչ',
        'Age' => 'ʱ',
        'Bounce' => '',
        'Forward' => 'ת',
        'From' => '',
        'To' => 'ռ',
        'Cc' => '',
        'Bcc' => '',
        'Subject' => '',
        'Move' => 'ƶ',
        'Queue' => '',
        'Queues' => '',
        'Priority' => 'ȼ',
        'Priorities' => 'ȼ',
        'Priority Update' => 'ȼ',
        'SLA' => '񼶱Э(SLA)',
        'Service Level Agreement' => '',
        'Service Level Agreements' => 'ƷЭ(SLA)',
        'Service' => 'Ŀ¼',
        'Services' => '',
        'State' => '״̬',
        'States' => '״̬',
        'Status' => '״̬',
        'Statuses' => '״̬',
        'Ticket Type' => 'Ticket ',
        'Ticket Types' => 'Ticket ',
        'Compose' => '׫д',
        'Pending' => 'ȴ',
        'Owner' => '',
        'Owner Update' => '',
        'Responsible' => '',
        'Responsible Update' => '¸',
        'Sender' => '',
        'Article' => 'ż',
        'Ticket' => 'Ticket',
        'Createtime' => 'ʱ',
        'plain' => 'ı',
        'Email' => 'ʼַ',
        'email' => 'E-Mail',
        'Close' => 'ر',
        'Action' => '',
        'Attachment' => '',
        'Attachments' => '',
        'This message was written in a character set other than your own.' => 'ʼַ뱾ϵͳַ',
        'If it is not displayed correctly,' => 'ʾȷ,',
        'This is a' => 'һ',
        'to open it in a new window.' => '´д',
        'This is a HTML email. Click here to show it.' => 'һHTMLʽʼʾ.',
        'Free Fields' => 'Ϣ',
        'Merge' => 'ϲ',
        'merged' => 'Ѻϲ',
        'closed successful' => 'ɹر',
        'closed unsuccessful' => 'رʧ',
        'Locked Tickets Total' => 'Ʊ',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'Ticket',
        'Tickets available' => ' Ticket',
        'Escalation' => '',
        'last-search' => '',
        'QueueView' => 'ͼ',
        'Ticket Escalation View' => '鿴 Ticket',
        'new' => '½',
        'open' => '',
        'Open' => '',
        'closed' => 'ر',
        'Closed' => 'ر',
        'removed' => 'ɾ',
        'pending reminder' => 'ȴ',
        'pending auto' => 'Զȴ',
        'pending auto close+' => 'ȴԶر+',
        'pending auto close-' => 'ȴԶر-',
        'email-external' => 'ⲿ E-Mail ',
        'email-internal' => 'ڲ E-Mail ',
        'note-external' => 'ⲿע',
        'note-internal' => 'ڲע',
        'note-report' => 'עⱨ',
        'phone' => '绰',
        'sms' => '',
        'webrequest' => 'Web',
        'lock' => '',
        'unlock' => 'δ',
        'very low' => 'ǳ',
        'low' => '',
        'normal' => '',
        'high' => '',
        'very high' => 'ǳ',
        '1 very low' => '1 ǳ',
        '2 low' => '2 ',
        '3 normal' => '3 ',
        '4 high' => '4 ',
        '5 very high' => '5 ǳ',
        'Ticket "%s" created!' => 'Ticket "%s" Ѵ!',
        'Ticket Number' => 'Ticket ',
        'Ticket Object' => 'Ticket ',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Ticket "%s" ڣܴ!',
        'Don\'t show closed Tickets' => 'ʾѹرյ Tickets',
        'Show closed Tickets' => 'ʾѹرյ Tickets',
        'New Article' => '',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'ʼ Ticket',
        'Create new Email Ticket' => 'µʼ Ticket',
        'Phone-Ticket' => '绰 Ticket',
        'Search Tickets' => ' Tickets',
        'Edit Customer Users' => '༭ͻʻ',
        'Edit Customer Company' => '༭ͻλ',
        'Bulk Action' => '',
        'Bulk Actions on Tickets' => ' Tickets',
        'Send Email and create a new Ticket' => ' Email һµ Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'µ Ticketͳȥ',
        'Create new Phone Ticket (Inbound)' => 'µĵ绰TicketTicket',
        'Overview of all open Tickets' => 'п Tickets ſ',
        'Locked Tickets' => ' Ticket',
        'My Locked Tickets' => ' Ticket',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => ' Tickets',
        'Watched' => '',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'ʼ !',
        'Unlock to give it back to the queue!' => 'ͻض!',
        'Shows the ticket history!' => 'ʾ Ticket ʷ״!',
        'Print this ticket!' => 'ӡ Ticket !',
        'Change the ticket priority!' => '޸ Ticket ȼ',
        'Change the ticket free fields!' => '޸ Ticket Ϣ',
        'Link this ticket to an other objects!' => 'Ӹ Ticket !',
        'Change the ticket owner!' => '޸ Ticket !',
        'Change the ticket customer!' => '޸ Ticket ͻ!',
        'Add a note to this ticket!' => ' Ticket ע!',
        'Merge this ticket!' => 'ϲ Ticket!',
        'Set this ticket to pending!' => ' Ticket תȴ״̬',
        'Close this ticket!' => 'رո Ticket!',
        'Look into a ticket!' => '鿴 Ticket ',
        'Delete this ticket!' => 'ɾ Ticket!',
        'Mark as Spam!' => 'Ϊ!',
        'My Queues' => 'ҵĶ',
        'Shown Tickets' => 'ʾ Tickets',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'ʼ "<OTRS_TICKET>" ϲ "<OTRS_MERGE_TO_TICKET>" !',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: һӦʱѺʱ(%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: һӦʱ佫ʱ(%s)!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: ʱѺʱ(%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: ʱ佫ʱ(%s)!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: Ѻʱ(%s)!',
        'Ticket %s: solution time will be over in %s!' => 'ʱ(%s)!',
        'There are more escalated tickets!' => 'иtickets',
        'Plain Format' => 'ı',
        'Reply All' => 'ظ',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'New ticket notification' => ' Ticket ֪ͨ',
        'Send me a notification if there is a new ticket in "My Queues".' => 'ҵĶµ Ticket֪ͨ.',
        'Send new ticket notifications' => ' Ticket ֪ͨ',
        'Ticket follow up notification' => 'Ticket ֪ͨ',
        'Ticket lock timeout notification' => 'Ticket ʱ֪ͨ ',
        'Send me a notification if a ticket is unlocked by the system.' => ' Ticket ϵͳ֪ͨ.',
        'Send ticket lock timeout notifications' => ' Ticket ʱ֪ͨ',
        'Ticket move notification' => 'Ticket ƶ֪ͨ',
        'Send me a notification if a ticket is moved into one of "My Queues".' => ' Ticket תҵĶУ֪ͨ.',
        'Send ticket move notifications' => ' Ticket ƶ֪ͨ',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'öУʼüõöе״̬֪ͨ.',
        'Custom Queue' => 'ͻ',
        'QueueView refresh time' => 'ͼˢʱ',
        'If enabled, the QueueView will automatically refresh after the specified time.' => 'ô˹, ͼԶָʱԶˢ.',
        'Refresh QueueView after' => 'ͼúˢ',
        'Screen after new ticket' => ' Ticket ͼ',
        'Show this screen after I created a new ticket' => 'һµ Ticket ֮󷵻ش Ticket ҳ滹չ Ticket',
        'Closed Tickets' => 'ر Tickets',
        'Show closed tickets.' => 'ʾѹر Tickets.',
        'Max. shown Tickets a page in QueueView.' => 'ͼÿҳʾ Ticket .',
        'Ticket Overview "Small" Limit' => '"ģʽ" Ticket ͼ',
        'Ticket limit per page for Ticket Overview "Small"' => '"ģʽ"ÿҳʾ Ticket ',
        'Ticket Overview "Medium" Limit' => '"ģʽ" Ticket ͼ',
        'Ticket limit per page for Ticket Overview "Medium"' => '"ģʽ"ÿҳʾ Ticket ',
        'Ticket Overview "Preview" Limit' => '"Ԥģʽ" Ticket ͼ',
        'Ticket limit per page for Ticket Overview "Preview"' => '"Ԥģʽ"ÿҳʾ Ticket ',
        'Ticket watch notification' => 'Ticket ֪ͨ',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => 'Ҷĵ Ticket б䶯ʱ Ticket һ֪ͨ.',
        'Send ticket watch notifications' => 'Ͷ֪ͨ',
        'Out Of Office Time' => 'ڰ칫ҵʱ',
        'New Ticket' => 'µ Ticket',
        'Create new Ticket' => 'µ Ticket',
        'Customer called' => 'ͻµ',
        'phone call' => '绰',
        'Phone Call Outbound' => '绰',
        'Reminder Reached' => 'Ѵ',
        'Reminder Tickets' => 'ѵ Ticket',
        'Escalated Tickets' => 'Ticket',
        'New Tickets' => 'µTicket',
        'Open Tickets / Need to be answered' => '򿪵Tickets/Ҫش',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Ticket Ƶ "%s" (%s) Ӷ "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => '·񼶱Э to %s (ID=%s).',
        'History::NewTicket' => 'New ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'Զܾ͸ "%s".',
        'History::SendAutoReply' => 'Զظ͸ "%s".',
        'History::SendAutoFollowUp' => 'Զٷ͸ "%s".',
        'History::Forward' => 'ת "%s".',
        'History::Bounce' => '˵ "%s".',
        'History::SendAnswer' => 'ż͸ "%s".',
        'History::SendAgentNotification' => '"%s"-Benachrichtigung versand an "%s".',
        'History::SendCustomerNotification' => '֪ͨ͸ "%s".',
        'History::EmailAgent' => 'ʼͻ.',
        'History::EmailCustomer' => 'Add mail. %s',
        'History::PhoneCallAgent' => 'Called customer',
        'History::PhoneCallCustomer' => 'ͻѴ绰',
        'History::AddNote' => 'ע (%s)',
        'History::Lock' => 'Ticket .',
        'History::Unlock' => 'Ticket .',
        'History::TimeAccounting' => '%s time unit(d) counted. Totaly %s time unit(s) counted.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Refreshed: %s',
        'History::PriorityUpdate' => 'ȼ£  "%s" (%s)  "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop protection! sent no auto answer to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Refreshed: %s',
        'History::StateUpdate' => 'Before "%s" : "%s"',
        'History::TicketFreeTextUpdate' => 'Refreshed: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'ͻ.',
        'History::TicketLinkAdd' => 'Link to "%s" established.',
        'History::TicketLinkDelete' => 'Link to "%s" removed.',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => '',
        'Mon' => 'һ',
        'Tue' => '',
        'Wed' => '',
        'Thu' => '',
        'Fri' => '',
        'Sat' => '',

        # Template: AdminAttachment
        'Attachment Management' => '',
        'Actions' => '',
        'Go to overview' => 'ظ',
        'Add attachment' => '',
        'List' => 'б',
        'No data found.' => 'ûҵ.',
        'Download file' => 'ļ',
        'Delete this attachment' => 'ɾø',
        'Add Attachment' => 'Ӹ',
        'Edit Attachment' => '༭',
        'This field is required.' => 'ֶǱ.',
        'or' => '',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Զظ',
        'Add auto response' => 'Զظ',
        'Add Auto Response' => 'Զظ',
        'Edit Auto Response' => '༭Զظ',
        'Response' => 'ظ',
        'Auto response from' => 'Զظķ',
        'Reference' => 'زο',
        'You can use the following tags' => 'ʹµı',
        'To get the first 20 character of the subject.' => 'ʾǰ20ֽ',
        'To get the first 5 lines of the email.' => 'ʾʵǰ',
        'To get the realname of the sender (if given).' => 'ʾ˵ʵ',
        'To get the article attribute' => 'ȡżһЩ',
        ' e. g.' => '',
        'Options of the current customer user data' => 'ͻصһЩ',
        'Ticket owner options' => 'Ticket ߵ',
        'Ticket responsible options' => 'صһЩ',
        'Options of the current user who requested this action' => '뵱ʱصһЩ',
        'Options of the ticket data' => ' Ticket йصһЩ',
        'Config options' => 'ϵͳйصѡ',
        'Example response' => 'һ',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'ͻλ',
        'Wildcards are allowed.' => 'ʹͨ.',
        'Add customer company' => 'ӿͻλ',
        'Please enter a search term to look for customer companies.' => 'һѰҿͻĵλ.',
        'Add Customer Company' => 'ӿͻλ',

        # Template: AdminCustomerUser
        'Customer Management' => 'ͻϵ',
        'Add customer' => 'ӿͻ',
        'Select' => 'ѡ',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => 'һѰҿͻ.',
        'Last Login' => 'һε¼',
        'Add Customer' => 'ӿͻ',
        'Edit Customer' => '༭ͻ',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '',
        'Notice' => '',
        'This feature is disabled!' => 'ùѹر',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => '򿪸ù',
        'Search for customers (wildcards are allowed).' => '',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => '',
        'Customers' => 'ͻ',
        'Groups' => '',
        'No matches found.' => 'ûҵƥ.',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => '',
        'No changes can be made to these groups.' => '',
        'ro' => 'ֻ',
        'Read only access to the ticket in this group/queue.' => 'е Ticket ֻ.',
        'rw' => 'д',
        'Full read and write access to the tickets in this group/queue.' => 'е Ticket /д.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => '',
        'Filter for Services' => '',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => '',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Ա֪ͨ',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => 'Ϣѱ͵',
        'Send message to users' => 'Ϣעû',
        'Send message to group members' => 'ϢԱ',
        'Group members need to have permission' => 'ԱҪȨ',
        'Send message to role members' => 'ϢɫԱ',
        'Also send to customers in groups' => 'ͬ͵Ŀͻ',
        'Body' => '',
        'Send' => '',

        # Template: AdminGenericAgent
        'Generic Agent' => 'ƻ',
        'Add job' => '',
        'Last run' => '',
        'Run Now!' => '!',
        'Delete this task' => 'ɾ',
        'Run this task' => 'ִ',
        'Job Settings' => '',
        'Job name' => '',
        'Currently this generic agent job will not run automatically.' => 'ĿǰһͨAgentҵԶ',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Զִѡһֵӣʱ',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => '  : 10*5144  105658*',
        '(e. g. 234321)' => ': 234321',
        'Customer login' => '',
        '(e. g. U5150)' => ': U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => '֧Ա',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Ticket ',
        'Create times' => 'ʱ',
        'No create time settings.' => 'ûдʱ',
        'Ticket created' => 'ʱ',
        'Ticket created between' => ' ʱ',
        'Close times' => 'رʱ',
        'No close time settings.' => 'û趨رʱ.',
        'Ticket closed' => 'رյ Ticket',
        'Ticket closed between' => 'Ticket رʱ',
        'Pending times' => 'ȴʱ',
        'No pending time settings.' => 'ûôʱ',
        'Ticket pending time reached' => 'ʱѵTicket',
        'Ticket pending time reached between' => 'ڴʱڵTicket ',
        'Escalation times' => '',
        'No escalation time settings.' => 'ûʱ',
        'Ticket escalation time reached' => 'ѵʱTicket',
        'Ticket escalation time reached between' => 'ʱڵTicket',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => '״λظʱѵTicket',
        'Ticket first response time reached between' => '״λظʱڵTicket',
        'Escalation - update time' => '',
        'Ticket update time reached' => 'ʱѵTicket',
        'Ticket update time reached between' => 'ڸʱڵTicket',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => 'ʱѵTicket',
        'Ticket solution time reached between' => 'ڷʱѵTicket',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'µ Ticket ',
        'Archive selected tickets' => '',
        'Add Note' => 'ע',
        'Time units' => 'ʱ䵥Ԫ',
        ' (work units)' => 'Ԫ',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'ʹ/ͻ֪ͨ',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'ִ, һ Ticket ţڶ Ticket ıʶ.',
        'Delete tickets' => 'ɾ Tickets',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => '',
        'Results' => '',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '棺\'\'ʱSysConfigӦı仯֮ǰ㽫סSQLĻص\'admin\'',
        'Group Management' => '',
        'Add group' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Admin Խϵͳ, Stats Խͳƹ',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'µ',
        'Edit Group' => '',

        # Template: AdminLog
        'System Log' => 'ϵͳ־',
        'Here you will find log information about your system.' => '',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'ʱ',

        # Template: AdminMailAccount
        'Mail Account Management' => 'ʼʺŹ',
        'Add mail account' => 'ʼʺ',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'һʼ˺ŵʼᱻַѡ!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'ʻֵģеX-OTRS⵽ʱ䣨ȣ ... ʹãʼʹ',
        'Host' => '',
        'Delete account' => 'ɾʺ',
        'Fetch mail' => 'ʼ',
        'Add Mail Account' => 'ʼʺ',
        'Example: mail.example.com' => '',
        'Trusted' => 'Ƿ',
        'Dispatching' => '',
        'Edit Mail Account' => '༭ʼʺ',

        # Template: AdminNavigationBar
        'Admin' => 'ϵͳ',
        'Agent Management' => 'Ա',
        'Queue Settings' => '',
        'Ticket Settings' => 'Ticket ',
        'System Administration' => 'ϵͳԱ',

        # Template: AdminNotification
        'Notification Management' => '֪ͨ',
        'Select a different language' => '',
        'Filter for Notification' => 'ض֪ͨ',
        'Notifications are sent to an agent or a customer.' => '֪ͨ͵֧Ա߿ͻ.',
        'Notification' => 'ϵͳ֪ͨ',
        'Edit Notification' => '༭֪ͨ',
        'e. g.' => '',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '֪ͨ',
        'Delete this notification' => 'ɾ֪ͨ',
        'Add Notification' => '֪ͨ',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => '',
        'Only for ArticleCreate event' => '',
        'Subject match' => 'ƥ',
        'Body match' => 'ƥ',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => 'ȡԱʼǰ 20 ַ.',
        'To get the first 5 lines of the body (of the latest agent article).' => 'ȡԱʼǰ 5 .',
        'To get the first 20 character of the subject (of the latest customer article).' => 'ȡͻʼǰ 20 ַ.',
        'To get the first 5 lines of the body (of the latest customer article).' => 'ȡʼǰ 5 .',

        # Template: AdminPGP
        'PGP Management' => 'PGP ',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'ַʽֱӱ༭SysConfigõļ',
        'Introduction to PGP' => '',
        'Result' => '',
        'Identifier' => 'ʶ',
        'Bit' => 'λ',
        'Key' => 'ֶ',
        'Fingerprint' => 'ָ',
        'Expires' => '',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => '',
        'Uninstall package' => 'ж',
        'Version' => '汾',
        'Do you really want to uninstall this package?' => 'Ƿȷжظ?',
        'Reinstall package' => '°װ',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => 'ȷҪ°װ? иģֹýʧ.',
        'Continue' => '',
        'Install' => 'װ',
        'Install Package' => 'װ',
        'Update repository information' => 'ֿϢ',
        'Online Repository' => 'ֿ',
        'Vendor' => 'ṩ',
        'Module documentation' => 'ģĵ',
        'Upgrade' => '',
        'Local Repository' => 'ֿ',
        'Uninstall' => 'ж',
        'Package not correctly deployed! You should reinstall the package again!' => 'ûȷչ! Ӧ°װ!',
        'Reinstall' => '°װ',
        'Download package' => 'ظ',
        'Rebuild package' => '±',
        'Metadata' => 'Ԫ',
        'Change Log' => '¼¼',
        'Date' => '',
        'List of Files' => 'ļ嵥',
        'Permission' => 'Ȩ',
        'Download' => '',
        'Download file from package!' => 'ļ',
        'Required' => '',
        'PrimaryKey' => 'ؼKey',
        'AutoIncrement' => 'Զ',
        'SQL' => 'SQL',
        'File differences for file %s' => 'ļ %s ļ',

        # Template: AdminPerformanceLog
        'Performance Log' => 'ϵͳ',
        'This feature is enabled!' => 'ù',
        'Just use this feature if you want to log each request.' => 'ϸ¼ÿ, ʹøù.',
        'Activating this feature might affect your system performance!' => 'ùܿӰϵͳ',
        'Disable it here!' => 'رոù',
        'Logfile too large!' => '־ļ',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'ſ',
        'Range' => 'Χ',
        'Interface' => '',
        'Requests' => '',
        'Min Response' => 'СӦ',
        'Max Response' => 'Ӧ',
        'Average Response' => 'ƽӦ',
        'Period' => '',
        'Min' => 'С',
        'Max' => '',
        'Average' => 'ƽ',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'ʼ˹',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'ƥemail ַ ʹEMAILADDRESS:info@example.com in From, To or Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'The name is required.' => '',
        'Stop after match' => '',
        'Filter Condition' => '',
        'Value' => 'ֵ',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => '',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Ȩ',
        'Add priority' => '',
        'Add Priority' => 'Ȩ',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Զʱ',
        '0 = no unlock' => '0 = Զ  ',
        'Only business hours are counted.' => 'ϰʱ',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => '֪ͨ',
        '0 = no escalation' => '0 = ʱ  ',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'ѡ',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'ȷԺTicket Զ',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'ظʼõķߵַ',
        'Default sign key' => '',
        'The salutation for email answers.' => 'ظʼóν.',
        'The signature for email answers.' => 'ظʼǩ.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => 'ԶظĶӦϵ',
        'Filter for Queues' => 'λ',
        'Filter for Auto Responses' => 'λԶظ',
        'Auto Responses' => 'Զظ',
        'Change Auto Response Relations for Queue' => 'ıöеԶظ',
        'settings' => '',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => 'ظеĶӦϵ',
        'Filter' => '',
        'Filter for Responses' => 'ٶλ',
        'Responses' => 'ظ',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => 'ظ',
        'Add response' => 'ӻظ',
        'A response is default text to write faster answer (with default text) to customers.' => 'Ϊ˿ٻظظݶÿظظ.',
        'Don\'t forget to add a new response a queue!' => 'ҪһµĻظݵ!',
        'Delete this entry' => 'ɾĿ',
        'Add Response' => 'ӻظ',
        'Edit Response' => '༭ظ',
        'The current ticket state is' => 'ǰ Ticket ״̬',
        'Your email address is' => 'ʼַ',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => 'ظ͸ĶӦϵ',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'ɫ',
        'Add role' => 'ӽɫ',
        'Create a role and put groups in it. Then add the role to the users.' => 'һɫɫ,Ȼ󽫽ɫû.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => 'ûнɫ. ʹ \'\' ťһµĽɫ',
        'Add Role' => 'ӽɫ',
        'Edit Role' => '༭ɫ',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => 'ɫͷԱĹϵ',
        'Filter for Roles' => 'ٶλɫ',
        'Roles' => 'ɫ',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'ƶ',
        'Permissions to move tickets into this group/queue.' => 'ƶ Tickets /.',
        'create' => '',
        'Permissions to create tickets in this group/queue.' => 'ڸ/д Tickets Ȩ.',
        'priority' => 'ȼ',
        'Permissions to change the ticket priority in this group/queue.' => 'ڸ/޸ Tickets ȼȨ.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => 'ҷԱ',
        'Agents' => 'Ա',
        'Manage Role-Agent Relations' => 'ɫԱĹϵ',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => '񼶱Э(SLA)',
        'Add SLA' => 'ӷ񼶱Э(SLA)',
        'Edit SLA' => '༭ SLA',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'S/MIME ',
        'Add certificate' => '֤',
        'Add private key' => '˽',
        'In this way you can directly edit the certification and private keys in file system.' => 'ַʽֱӱ༭֤˽',
        'See also' => 'μ',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => '',
        'Add Private Key' => '˽',
        'Secret' => '',

        # Template: AdminSalutation
        'Salutation Management' => 'ƺ',
        'Add salutation' => '',
        'Add Salutation' => 'ӳƺ',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'ڳʼװ󣬰ȫģʽͨ',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'ΪWeb 氲װȫģʽdisabled',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'SQLѯ',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => 'ʽ',
        'Run Query' => 'ִвѯ',

        # Template: AdminService
        'Service Management' => '',
        'Add service' => '',
        'Add Service' => 'ӷ',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Ự',
        'All sessions' => 'лỰ',
        'Agent sessions' => 'ԱỰ',
        'Customer sessions' => 'ͻỰ',
        'Unique agents' => 'ʵʷԱ',
        'Unique customers' => 'ʵ߿ͻ',
        'Kill all sessions' => 'ֹлỰ',
        'Session' => 'Ự',
        'Kill' => 'ֹ',
        'Kill this session' => 'ֹûỰ',
        'Detail View for SessionID' => 'ûỰϸ¼',

        # Template: AdminSignature
        'Signature Management' => 'ǩ',
        'Add signature' => 'ǩ',
        'Add Signature' => 'ǩ',
        'Edit Signature' => '༭ǩ',
        'Example signature' => 'ǩ',

        # Template: AdminState
        'State Management' => '״̬',
        'Add state' => '״̬',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'ͬʱ Kernel/Config.pm еȱʡ״̬!',
        'Add State' => '״̬',
        'Edit State' => '༭״̬',
        'State type' => '״̬',

        # Template: AdminSysConfig
        'SysConfig' => 'ϵͳ',
        'Navigate by searching in %s settings' => '',
        'Navigate by selecting config groups' => '',
        'Download all system config changes' => '(Ĭ)',
        'Export settings' => '',
        'Load SysConfig settings from file' => 'ָļϵͳ',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => '',
        'Please enter a search term to look for settings.' => 'ؼص.',
        'Subgroup' => '',
        'Elements' => 'Ԫ',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '༭ϵͳ',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => 'Ĭֵ',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'ֵ',
        'Remove this entry' => 'ɾĿ',
        'Add entry' => 'Ŀ',
        'Remove entry' => 'ɾĿ',
        'Add new entry' => 'Ŀ',
        'Create new entry' => 'Ŀ',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => '',
        'NavBar' => '',
        'LinkOption' => '',
        'Block' => '',
        'AccessKey' => 'Կ',
        'Add NavBar entry' => 'ӵĿ',
        'Year' => '',
        'Month' => '',
        'Day' => '',
        'Invalid year' => 'Ƿ',
        'Invalid month' => 'Ƿ·',
        'Invalid day' => 'Ƿ',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'ϵͳʼַ',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => '͹',
        'Add ticket type' => '',
        'Add Type' => '',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => 'λһλԱ',
        'Agents will be needed to handle tickets.' => 'ԱҪ Ticket.',
        'Don\'t forget to add a new agent to groups and/or roles!' => 'ӷԱȺ  ɫ!',
        'Please enter a search term to look for agents.' => 'һԿҵԱĵ¼Ϣ.',
        'Last login' => 'һε¼',
        'Login as' => '¼',
        'Switch to agent' => '',
        'Add Agent' => 'ӷԱ',
        'Edit Agent' => '༭Ա',
        'Firstname' => '',
        'Lastname' => '',
        'Password is required.' => '',
        'Start' => 'ʼ',
        'End' => '',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => '',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'ַ',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'ͻ',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Ǳ',
        'Show or hide the content' => 'ʾ',

        # Template: AgentDashboardCalendarOverview
        'in' => '֮',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '汾ע',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => ' %s ֮ǰ',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => '',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Ӷ: %s',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => 'Ӷ',
        'with' => '',
        'Unlink Object: %s' => 'δӶ %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '༭ĸƫ',

        # Template: AgentSpelling
        'Spell Checker' => 'ƴд',
        'spelling error(s)' => 'ƴд',
        'Apply these changes' => 'ӦЩı',

        # Template: AgentStatsDelete
        'Delete stat' => 'ɾͳ',
        'Stat#' => 'ͳƺ',
        'Do you really want to delete this stat?' => 'ȷҪɾͳ?',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'ѡֵϵеҪ',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'ΪͳƶƲ',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'ɾڡ̶ѡɸͳƵļִ֧ԸıӦҪص',
        'Fixed' => '',
        'Please select only one element or turn off the button \'Fixed\'.' => 'ֻѡһԪػرձѡ\'Fixed\'ť',
        'Absolute Period' => '',
        'Between' => '',
        'Relative Period' => '',
        'The last' => '',
        'Finish' => '',

        # Template: AgentStatsEditSpecification
        'Permissions' => '',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'ʹõͼεʽѡһͼεĴС',
        'Sum rows' => 'ܺ',
        'Sum columns' => 'ܺ',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'ͳϿԻ,⽫ӿһͳƵչʾ.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => '߶',
        'minimal' => 'С',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'סȶļֵϵҪXĳ߶ȣX -=>£ ValueSeries =>꣩ ',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => '',
        'minimal scale' => 'С߶',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'ļһͳ',
        'No File selected' => 'ûļѡ',

        # Template: AgentStatsOverview
        'Stats' => 'ͳ',
        'Object' => '',

        # Template: AgentStatsPrint
        'Print' => 'ӡ',
        'No Element selected.' => 'ûԪرѡ',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'ʽ',
        'Graphsize' => 'ͼλ',
        'Cache' => '',
        'Exchange Axis' => 'ת',
        'Configurable params of static stat' => '̬ͳƵò',
        'No element selected.' => 'ûбѡ',
        'maximal period from' => 'ڱ',
        'to' => '',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'ô״̬',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => '',
        'Please set a new owner!' => '',
        'Previous Owner' => 'ǰһ',
        'Inform Agent' => '֪֧ͨԱ',
        'Optional' => 'ѡ',
        'Inform involved Agents' => '֪ͨؼ֧Ա',
        'Spell check' => '',
        'Note type' => 'ע',
        'Next state' => 'Ticket ״̬',
        'Pending date' => '',
        'Date invalid!' => 'Ч!',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => '˵ ',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Tickets ״̬',
        'Inform sender' => '֪ͨ',
        'Send mail!' => '!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Ticket ',
        'Merge to' => 'ϲ',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'ϲϵ',
        'Link together' => 'ϲһ',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => '׫д,Ticket ',
        'Need a valid email address.' => '',
        'Address book' => 'ַ',
        'Pending Date' => 'ȴ״̬',
        'for pending* states' => 'Եȴ״̬',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => '޸ Tickets ͻ',
        'Customer Data' => 'ͻ',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => 'Զ',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'ʷ',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Ticket ϲ',
        'You need to use a ticket number!' => 'Ҫʹһ Ticket !',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'ƶ Ticket',
        'New Queue' => '¶',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => '״αʱ',
        'Service Time' => 'ʱ',
        'Update Time' => 'ʱ',
        'Solution Time' => 'ʱ',
        'Move ticket to a different queue' => 'ƶ Ticket ͬĶ',
        'Change queue' => 'ı',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => '޸ѡ',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'ʱ',
        'Locked' => '״̬',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => 'µĵ绰 Ticket',
        'From customer' => 'Կͻ',
        'To queue' => '',
        'Create' => '',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => '绰',

        # Template: AgentTicketPlain
        'Email Text Plain View' => 'Դıʽʾʼ',
        'Plain' => 'ı',
        'Download this email' => 'ظʼ',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'TicketϢ',
        'Accounted time' => 'ʱ',
        'Linked-Object' => 'Ӷ',
        'by' => '',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'ģ',
        'Create New' => '',
        'Create Template' => 'ģ',
        'Save changes in template' => '',
        'Add another attribute' => 'һ',
        'Output' => 'ʾΪ',
        'Fulltext' => 'ȫ',
        'Remove' => 'ɾ',
        'Customer User Login' => 'ͻû¼Ϣ',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'ڶｨ',
        'Lock state' => '״̬',
        'Watcher' => '',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '߼',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Article Type' => 'Article ',
        'Sender Type' => '',
        'Save filter settings as default' => 'Ϊȱʡֵ',
        'Ticket Information' => 'Ticket ',
        'Linked Objects' => 'ӵĶ',
        'Article(s)' => 'Ϣ',
        'Change Queue' => 'ı',
        'Article Filter' => '',
        'Add Filter' => 'ӹ',
        'Set' => '',
        'Reset Filter' => 'ù',
        'Show one article' => 'ʾһż',
        'Show all articles' => 'ʾż',
        'Unread articles' => 'δż',
        'No.' => '',
        'Unread Article!' => 'δż!',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => '׷',

        # Template: CustomerFooter
        'Powered by' => '',
        'One or more errors occurred!' => '',
        'Close this dialog' => 'رոöԻ',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => '¼',
        'User name' => 'û',
        'Your user name' => 'û',
        'Your password' => '',
        'Forgot password?' => '?',
        'Log In' => '',
        'Not yet registered?' => 'ûע?',
        'Sign up now' => 'ȥע',
        'Request new password' => '',
        'Your User Name' => 'û',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'ʻ',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => 'ʲôֵ¼ϵͳ',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '༭ϲ',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'Welcome!' => '',
        'Please click the button below to create your first ticket.' => '',
        'Create your first ticket' => '',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'Լ',
        'e. g. 10*5155 or 105658*' => ': 10*5155  105658*',
        'Customer ID' => 'ͻ',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => ' Ticket ȫ (: "John*n"  "Will*")',
        'Recipient' => 'ռ',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => 'Ϊģ',
        'Template Name' => 'ģ',
        'Output to' => 'Ϊ',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => '',
        'Page' => 'ҳ',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => 'ظ',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => 'ǰ',
        'Sunday' => '',
        'Monday' => 'һ',
        'Tuesday' => 'ڶ',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => 'һ',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => ', һ.',
        'Error Message' => 'Ϣ',
        'You can' => '',
        'Send a bugreport' => 'һ󱨸',
        'go back to the previous page' => 'һҳ',
        'Error Details' => 'ϸϢ',

        # Template: Footer
        'Top of page' => 'ҳ',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '뿪ҳ, еĴҲ֮ر!',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'ѵ¼Ϊ',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => 'JavaScript û',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => 'Ҫʹ OTRS JavaScript .',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'ӭʹ %s',
        'Web site' => '',
        'Database check successful.' => 'ݿ.',
        'Mail check successful.' => 'ʼü',
        'Error in the mail settings. Please correct and try again.' => 'ʼô, .',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => 'վʼ',
        'Outbound mail type' => 'ռʼ',
        'Select outbound mail type.' => 'ѡʼ.',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => 'ַ',
        'SMTP host.' => 'ʼַ',
        'SMTP authentication' => 'SMTP ֤',
        'Does your SMTP host need authentication?' => 'ȷʼǷҪ֤ļ',
        'SMTP auth user' => 'û',
        'Username for SMTP auth.' => ' SMTP û',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => ' SMTP ',
        'Configure Inbound Mail' => 'վʼ',
        'Inbound mail type' => 'ʼ',
        'Select inbound mail type.' => 'ѡʼ',
        'Inbound mail host' => 'ļַ',
        'Inbound mail host.' => 'ռʼַ',
        'Inbound mail user' => 'û',
        'User for inbound mail.' => 'ռû',
        'Inbound mail password' => '',
        'Password for inbound mail.' => 'ռ',
        'Result of mail configuration check' => '֤ʼý',
        'Check mail configuration' => 'ҵʼ',
        'Skip this step' => 'ʱһ',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'ݿ root , , , 뱣հ. ڰȫ, ǽΪ root һ, Ϣοݿĵ.',
        'Currently only MySQL is supported in the web installer.' => 'Web װĿǰ֧ MySQL',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'ݿû',
        'New' => '½',
        'A new database user with limited rights will be created for this OTRS system.' => 'ѾΪ OTRS ϵͳһµݿû',
        'default \'hot\'' => 'Ĭ \'hot\'',
        'DB--- host' => '',
        'Database' => 'ݿ',
        'Check database settings' => 'ݿ',
        'Result of database check' => 'ݿⰲװ',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'ΪܹʹOTRS, root(Terminal/Shell).',
        'Restart your webserver' => ' webserver.',
        'After doing so your OTRS is up and running.' => 'ɺ OTRS ϵͳ.',
        'Start page' => 'ʼҳ',
        'Your OTRS Team' => ' OTRS С.',

        # Template: InstallerLicense
        'Accept license' => 'ͬ',
        'Don\'t accept license' => 'ͬ',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'ϵͳID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'ϵͳ',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'Աַ',
        'Email address of the system administrator.' => '',
        'Organization' => '֯',
        'Log' => '־',
        'LogModule' => '־ģ',
        'Log backend to use.' => '',
        'LogFile' => '־ļ',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Web ǰ',
        'Default language' => 'Ĭ',
        'Default language.' => '',
        'CheckMXRecord' => ' MX ¼',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => 'û JavaScript',
        'Browser Warning' => 'ʾ',
        'The browser you are using is too old.' => 'ʹõ̫.',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => 'OTRS ȷеʾ, һϲõ֮.',
        'Please see the documentation or ask your admin for further information.' => 'йؽһϢ, Ĺѯʻοĵ.',
        'Lost your password?' => '?',
        'Request New Password' => '',
        'Back to login' => 'µ¼',

        # Template: Motd
        'Message of the Day' => 'Ϣ',

        # Template: NoPermission
        'Insufficient Rights' => 'û㹻Ȩ',
        'Back to the previous page' => 'һҳ',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => 'ַ',

        # Template: PrintHeader
        'printed by' => 'ӡ',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS ҳ',
        'Welcome %s' => 'ӭ %s',
        'Counter' => '',

        # Template: Warning
        'Go back to the previous page' => 'һҳ',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => 'Ա֪ͨ',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => 'Ա <-> Ⱥ',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => ' <-> ظ',
        'Auto Responses <-> Queues' => 'Զظ <-> ',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => 'ı',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => 'ת HTML ʼΪıϢ.',
        'Create and manage Service Level Agreements (SLAs).' => '͹ƷЭ (SLA)',
        'Create and manage agents.' => '͹Ա.',
        'Create and manage attachments.' => '͹.',
        'Create and manage companies.' => '͹ͻλ.',
        'Create and manage customers.' => '͹ͻ.',
        'Create and manage event based notifications.' => '͹¼֪ͨ.',
        'Create and manage groups.' => '͹Ⱥ.',
        'Create and manage notifications that are sent to agents.' => '͹ϵͳԱ֪ͨ.',
        'Create and manage queues.' => '͹.',
        'Create and manage response templates.' => '͹ظģ.',
        'Create and manage responses that are automatically sent.' => '͹Զ͵Ļظ.',
        'Create and manage roles.' => '͹ɫ.',
        'Create and manage salutations.' => '͹ʼͷʺ.',
        'Create and manage services.' => '͹',
        'Create and manage signatures.' => '͹ǩ',
        'Create and manage ticket priorities.' => '͹ Ticket ȼ.',
        'Create and manage ticket states.' => '͹ Ticket ͳ.',
        'Create and manage ticket types.' => '͹ Ticket . ',
        'Create new email ticket and send this out (outbound)' => 'µʼ Ticket ͸û ()',
        'Create new phone ticket (inbound)' => 'µĵ绰 Ticket ()',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => 'ͻ <-> Ⱥ',
        'Customers <-> Services' => 'ͻ <-> ',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'Email ַ',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => 'ִ SQL ',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => 'յʼ.',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => 'Խ',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'ƻ',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => 'ӷԱȺ.',
        'Link agents to roles.' => 'ӷԱɫ.',
        'Link attachments to responses templates.' => 'Ӹظģ.',
        'Link customers to groups.' => 'ӿͻȺ.',
        'Link customers to services.' => 'ӿͻ.',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => 'ӻظģ嵽',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => 'ûʼܵ PGP Կ.',
        'Manage POP3 or IMAP accounts to fetch email from.' => 'ȡʼ POP3  IMAP ʺ.',
        'Manage S/MIME certificates for email encryption.' => 'ʼ S/MIME ֤.',
        'Manage existing sessions.' => 'ǰ¼Ự.',
        'Manage periodic tasks.' => 'ִе.',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => 'µʼ Ticket',
        'New phone ticket' => 'µĵ绰 Ticket',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '֪ͨ¼',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => 'ռ',
        'PostMaster Mail Accounts' => 'ʼʺŹ',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => 'ͼ',
        'QueueView Refresh Time' => 'ͼˢʱ',
        'Refresh interval' => 'ˢ¼ʱ',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'ظ <-> ',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'ɫ <-> ',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => 'ϴ S/MIME ֤',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => '.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '˻ظ Ticket , ߸ Ticket δҵĶ, 뷢һ֪ͨ.',
        'Send notifications to users.' => '֪ͨû.',
        'Send ticket follow up notifications' => ' Ticket ֪ͨ',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => 'Ϊϵͳüļ˵ʼַ.',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => 'Ƥ',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => 'ͳ',
        'Status view' => '״̬ͼ',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => 'Ʊһ',
        'Tickets' => 'Ʊ',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '»װϵͳģ.',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '鿴ܻ׼Խ.',
        'View system log messages.' => '鿴ϵͳ־Ϣ',
        'Wear this frontend skin' => 'ǰʹõƤ',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',
        'New Year\'s Day' => '',
        'International Workers\' Day' => '',
        'Christmas Eve' => '',
        'First Christmas Day' => '',
        'Second Christmas Day' => '',
        'New Year\'s Eve' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => '%s Tickets ܵӰ! ȷҪʹƻ?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'ͨ׫дùĵʼַMX¼OTRSڲŽĵ벻ҪʹCheckMXRecord!',
        '(Email of the system admin)' => '(ϵͳԱʼַ)',
        '(Full qualified domain name of your system)' => '(ϵͳ)',
        '(Logfile just needed for File-LogModule!)' => '(ֻм File-LogModule ʱҪ Logfile!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'עȡİװٶ̬ʹ',
        '(Note: Useful for big databases and low performance server)' => 'עڴݿ͵ܵķ',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(ϵͳʶ. Ticket ź http Ựʶͷ)',
        '(Used default language)' => '(ʹȱʡ)',
        '(Used log backend)' => 'ʹ־',
        '(Used ticket number format)' => '(ʹ Ticket Ÿʽ)',
        'A article should have a title!' => '±б!',
        'A message must be spell checked!' => 'Ϣ뾭ƴд!',
        'A message should have a To: recipient!' => 'ʼռ!',
        'A message should have a body!' => 'ʼ!',
        'A message should have a subject!' => 'ʼб!',
        'A new password will be sent to your e-mail adress.' => 'һѾ͵',
        'A required field is:' => 'ֶ',
        'A web calendar' => 'Web ',
        'A web file manager' => 'Web ļ',
        'A web mail client' => 'WebMail ͻ',
        'About OTRS' => ' OTRS',
        'Absolut Period' => '',
        'Add Customer User' => 'ӿ',
        'Add System Address' => 'ϵͳʼַ',
        'Add User' => 'Ա',
        'Add a new Agent.' => 'һµԱ',
        'Add a new Customer Company.' => 'ӿ˵λ',
        'Add a new Group.' => 'һ',
        'Add a new Notification.' => 'һ֪ͨ.',
        'Add a new Priority.' => 'һµȨ',
        'Add a new Role.' => 'һɫ',
        'Add a new SLA.' => 'һ񼶱Э(SLA).',
        'Add a new Salutation.' => 'һµĳƺ',
        'Add a new Service.' => 'һ',
        'Add a new Signature.' => 'һǩ',
        'Add a new State.' => 'һµ״̬',
        'Add a new System Address.' => 'һµϵͳʼַ.',
        'Add a new Type.' => 'һµ',
        'Add new attachment' => 'µĸ',
        'Add note to ticket' => 'ע⵽ Ticket',
        'Added User "%s"' => 'û "%s".',
        'Admin-Area' => '',
        'Admin-Password' => 'Ա',
        'Admin-User' => 'ݿԱ',
        'Admin-password' => 'Ա',
        'Agent Mailbox' => '֧Ա',
        'Agent Preferences' => '',
        'Agent based' => 'ڼִ֧',
        'Agent-Area' => '֧Ա',
        'All Agent variables.' => 'еļԱ',
        'All Agents' => 'м֧Ա',
        'All Customer variables like defined in config option CustomerUser.' => 'пͻѡCustomerUserж',
        'All customer tickets.' => 'ÿͻ Tickets ¼.',
        'All email addresses get excluded on replaying on composing and email.' => 'бȡ׫дʼܵʼַ',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'з͵ռ˵ϢתѡĶ',
        'All messages' => 'Ϣ',
        'All new tickets!' => 'µtickets',
        'All tickets where the reminder date has reached!' => 'ѵڵTicket',
        'All tickets which are escalated!' => 'tickets',
        'Allocate CustomerUser to service' => 'ָɿͻ',
        'Allocate services to CustomerUser' => 'ͻ',
        'Answer' => 'ظ',
        'Article Create Times' => 'żʱ',
        'Article Create Times (between)' => 'żָʱ䷶Χ',
        'Article created between' => 'żָʱ䷶Χ',
        'Article filter settings' => 'Article ',
        'Attach' => '',
        'Attribute' => '',
        'Auto Response From' => 'Զظ',
        'Bounce ticket' => ' Ticket ',
        'Can not create link with %s!' => 'Ϊ %s ',
        'Can not delete link with %s!' => 'ɾ %s ',
        'Can\'t update password, invalid characters!' => '޷룬Чַ.',
        'Can\'t update password, must be at least %s characters!' => '޷룬볤%sλ.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => '޷룬ٰ2дַ2Сдַ.',
        'Can\'t update password, needs at least 1 digit!' => '޷룬ٰ1λ',
        'Can\'t update password, needs at least 2 characters!' => '޷룬ٰ2ĸ!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'β޷£',
        'Category Tree' => 'Ŀ¼',
        'Change %s settings' => '޸ %s ',
        'Change Times' => 'ıʱ',
        'Change free text of ticket' => '޸ Ticket Ϣ',
        'Change owner of ticket' => '޸ Ticket ',
        'Change priority of ticket' => ' Ticket ȼ',
        'Change responsible of ticket' => ' Ticket ĸ',
        'Change user <-> group settings' => '޸ û <->  ',
        'ChangeLog' => 'ı¼',
        'Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behind a dial-up line!' => ' MX ¼Уʼַȷ,  OTRS ϵͳʹðκŷʽ뻥, 벻Ҫ򿪴˹!',
        'Child-Object' => 'Ӷ',
        'Clear From' => '',
        'Clear To' => '',
        'Click here to report a bug!' => 'ﱨһ Bug!',
        'Close Times' => 'رʱ',
        'Close ticket' => 'ر Ticket',
        'Close type' => 'ر',
        'Close!' => 'ر!',
        'Collapse View' => '۵',
        'Comment (internal)' => 'ע (ڲ)',
        'CompanyTickets' => '˾Tickets',
        'Compose Answer' => '׫д',
        'Compose Email' => '׫д Email',
        'Compose Follow up' => '׫дٴ',
        'Config Options' => 'ѡ',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'ѡ (: &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'ѡ (:<OTRS_CONFIG_HttpType>)',
        'Contact customer' => 'ϵͻ',
        'Create New Template' => 'µģ',
        'Create Times' => 'ʱ',
        'Create new Phone Ticket' => 'µĵ绰 Ticket',
        'Create new database' => 'µݿ',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'µƲͬĴȡȨ',
        'CreateTicket' => ' Ticket',
        'Customer Move Notify' => 'Ticket ƶͻ֪ͨ',
        'Customer Owner Notify' => 'ͻͨ',
        'Customer State Notify' => 'Ticket ״̬ͻ֪ͨ',
        'Customer User' => 'ͻû',
        'Customer User Management' => 'ͻû',
        'Customer Users' => 'ͻû',
        'Customer Users <-> Groups' => 'ͻû <-> ',
        'Customer Users <-> Groups Management' => 'ͻû <->  ',
        'Customer Users <-> Services' => 'ͻʺ <-> ',
        'Customer Users <-> Services Management' => 'ͻʺ <-> ',
        'Customer history' => 'ͻʷ',
        'Customer history search' => 'ͻʷ',
        'Customer history search (e. g. "ID342425").' => 'ͻʷ (磺 "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'ͻûһ˺Ŵӿͻ¼ҳ¼ϵͳ.',
        'CustomerUser' => 'ͻû',
        'D' => '',
        'DB Admin Password' => 'ϵͳԱ',
        'DB Admin User' => 'ݿԱû',
        'DB Host' => 'ݿ',
        'DB Type' => 'ݿ',
        'DB connect host' => '',
        'Days' => '',
        'Default' => 'ȱʡ',
        'Default Charset' => 'ȱʡַ',
        'Default Language' => 'ȱʡ',
        'Delete old database' => 'ɾݿ',
        'Detail' => 'ϸ',
        'Diff' => 'Ƚ',
        'Discard all changes and return to the compose screen' => '޸,ص׫дҳ',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => ' X-Headers ˣʹʽ.',
        'Do you really want to delete this Object?' => 'Ƿȷɾö?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Ƿ׼°װЩ (ֹý᲻)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Ҫһûͽɫ!',
        'Don\'t forget to add a new user to groups!' => 'Ҫµû!',
        'Download Settings' => '',
        'Download all system config changes.' => 'еϵͳñ仯.',
        'Drop Database' => 'ɾݿ',
        'Dynamic-Object' => '̬',
        'Edit Article' => '༭ż',
        'Edit default services.' => '༭ĬϷ',
        'Email based' => 'ڵʵ',
        'Email of the system admin.' => 'Աʼַ',
        'Escalation - First Response Time' => ' - ״λظʱ',
        'Escalation - Solution Time' => ' - ʱ',
        'Escalation - Update Time' => ' - µʱ',
        'Escalation Times' => 'ʱ',
        'Escalation time' => 'ʱʱ',
        'Event is required!' => 'Ҫ¼',
        'Expand View' => 'չ',
        'Explanation' => '',
        'Export Config' => '',
        'FileManager' => 'ļ',
        'Filelist' => 'ļ嵥',
        'Filter for Language' => 'ض',
        'Filtername' => '',
        'Follow up' => '',
        'Follow up notification' => '֪ͨ',
        'For very complex stats it is possible to include a hardcoded file.' => 'ڷǳӵͳпܰһӲļ',
        'Frontend' => 'ǰ˽',
        'Full qualified domain name of your system.' => 'Ϊϵͳָһ(FQDN)',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'ȫ (: "Mar*in"  "Baue*")',
        'General Catalog' => 'Ŀ¼',
        'Go' => 'ִ',
        'Group Ro' => 'ֻȨ޵',
        'Group based' => '',
        'Group selection' => 'ѡ',
        'Hash' => 'Hash',
        'Have a lot of fun!' => 'Have a lot of fun!',
        'Have you lost your password?' => '?',
        'Help' => '',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ԶһϵеֵпѡһԪءȻѡԪصԡÿԽʾΪһֵѡκ, ôһͳƵʱԪصԽʹáһµԱµϴ',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ԶxᡣѡһͨѡťûѡԪصԽʹõһͳƵʱ򡣲һµԱµϴ',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ԶxᡣѡһͨѡťȻѡԪϵԡѡκ, ôһͳƵʱԪصԽʹáһµԱµϴ',
        'Here you can insert a description of the stat.' => 'ԲͳƵ',
        'Here you can select the dynamic object you want to use.' => 'ѡҪʹõĶ̬',
        'Home' => 'ҳ',
        'How we should adress you' => 'Ӧγƺ?',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'ģʽûбͨϵͳΪOTRSѾ',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'һµӲļڣɴԽʾѡһ',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => ' Ticket Ѿڹر״̬ͻͷһ Ticketô Ticket ᱻֱӼ߱Ϊԭ',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'öֻʾ涨ʱûб Ticket',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => '֧Ա Ticket,һʱûлظ Ticket ᱻԶеļ֧Ա.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'ѡûȨ (޷ Ticket)',
        'If you need the sum of every column select yes.' => 'Ҫÿеܺѡyes',
        'If you need the sum of every row select yes' => 'Ҫÿеܺѡ yes',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'RegExpҲʹƥֵin () as [***] in \'Set\'',
        'If you want to install OTRS on other database systems, please refer to the file README.database.' => 'ϵͳϰװ OTRS, ο README.database ļ.',
        'Image' => 'ͼƬ',
        'Important' => 'Ҫ',
        'In order to experience OTRS, you\'ll need to enable Javascript in your browser.' => 'OTRS Ҫ JavaScript ',
        'In this form you can select the basic specifications.' => 'ʽѡ淶',
        'Information about the Stat' => 'ͳƵϢ',
        'Insert of the common specifications' => '빲ͬ淶',
        'Is Job Valid' => 'Ч',
        'Is Job Valid?' => 'ǷЧ?',
        'It\'s useful for ASP solutions.' => 'һЧӦ÷ṩ(ASP).',
        'It\'s useful for a lot of users and groups.' => 'дûʱ򣬽ɫǳʺ.',
        'Job-List' => 'б',
        'Keyword' => 'ؼ',
        'Keywords' => 'ؼ',
        'Last update' => '',
        'Link auto responses to queues.' => 'Զظ.',
        'Link groups to roles.' => 'Ⱥ鵽ɫ.',
        'Link to Parent' => 'ϲһ',
        'LinkType' => '',
        'Linked as' => 'Ϊ',
        'Load' => '',
        'Load Settings' => '',
        'Loading' => 'װ',
        'Logfile' => '־ļ',
        'Logfile too large, you need to reset it!' => '־ļ, Ҫ',
        'Login failed! Your username or password was entered incorrectly.' => '¼ʧܣû벻ȷ.',
        'Mail Management' => 'ʼ',
        'Mailbox' => '',
        'Match' => 'ƥ',
        'Message for new Owner' => 'ߵϢ',
        'Message sent to' => 'Ϣ͸',
        'Misc' => 'ۺ',
        'Modified' => '޸',
        'Move notification' => 'ƶ֪ͨ',
        'Multiple selection of the output format.' => 'ʽĶѡ',
        'My Queue' => 'ҵĶ',
        'MyTickets' => 'ҵ Tickets',
        'Name is required!' => 'Ҫ!',
        'New Agent' => '¼֧Ա',
        'New Customer' => '¿ͻ',
        'New Group' => '',
        'New Group Ro' => 'µֻȨ޵',
        'New Password' => '',
        'New Priority' => 'ȼ',
        'New SLA' => 'µķ񼶱Э(SLA)',
        'New Service' => 'µķ񼶱',
        'New State' => '״̬',
        'New Ticket Lock' => ' Ticket ',
        'New Title' => 'µı',
        'New Type' => 'µ',
        'New account created. Sent Login-Account to %s.' => 'µʺѴ, ֪ͨ %s.',
        'New messages' => 'Ϣ',
        'New password again' => 'ظ',
        'No * possible!' => 'ʹͨ "*" !',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'ԴûӦҪĿܣĿ',
        'No Packages or no new Packages in selected Online Repository!' => 'ѡԴУûִµ',
        'No Permission' => 'Ȩ',
        'No change time settings.' => 'ıʱ',
        'No matches found' => 'ûƥ',
        'No means, send agent and customer notifications on changes.' => 'иıʱ֪ͨԱͻ.',
        'No time settings.' => 'ʱԼ.',
        'Note' => 'ע',
        'Note Text' => 'ע',
        'Notification (Customer)' => '֪ͨ(ͻ)',
        'Notifications' => 'ϵͳ֪ͨ',
        'OTRS DB Name' => 'ݿ',
        'OTRS DB Password' => 'OTRS û',
        'OTRS DB User' => 'OTRS ݿû',
        'OTRS DB connect host' => 'OTRS ݿ',
        'OTRS sends an notification email to the customer if the ticket is moved.' => ' Ticket ƶϵͳᷢһ֪ͨʼͻ',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => ' Ticket ߸ı䣬ϵͳ֪ᷢͨʼͻ.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => ' Ticket ״̬ı䣬ϵͳ֪ᷢͨʼͻ',
        'Object already linked as %s.' => 'ӵ %s.',
        'Of couse this feature will take some system performance it self!' => 'Ȼ, ùܻռһϵͳԴ, ϵͳĸ!',
        'One or more errors occured!' => 'һ!',
        'Online' => 'Ա',
        'Only for ArticleCreate Event.' => ' ArticleCreate ¼',
        'Open Tickets' => ' Tickets',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'ǰͻûϢ (: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'ǰͻϢĿѡ (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'ѡǰû˭Ҫ (: &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Ϣ (: <OTRS_CURRENT_UserFirstname>)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'ѡ ticket  (: &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'ѡ ticket  (: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'ѡ ticket  (: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Order' => '',
        'Other Options' => 'ѡ',
        'Out Of Office' => 'ڰ칫',
        'POP3 Account Management' => 'POP3 ʻ',
        'Package' => '',
        'Param 1' => ' 1',
        'Param 2' => ' 2',
        'Param 3' => ' 3',
        'Param 4' => ' 4',
        'Param 5' => ' 5',
        'Param 6' => ' 6',
        'Parent-Object' => '',
        'Password is already in use! Please use an other password!' => '뱻ʹãʹ!',
        'Password is already used! Please use an other password!' => '뱻ʹãʹ!',
        'Passwords doesn\'t match! Please try it again!' => '벻!',
        'Pending Times' => 'ʱ',
        'Pending messages' => 'Ϣתȴ״̬',
        'Pending type' => '',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Ȩáѡһ壬ͬļִ֧ɿõͳ',
        'Permissions to change the ticket owner in this group/queue.' => 'ڸ/޸ Tickets ߵȨ.',
        'PhoneView' => '绰ͼ',
        'Please contact your admin' => 'ϵϵͳԱ',
        'Please enter subject.' => '',
        'Please provide a name.' => 'ṩһ',
        'PostMaster Filter' => 'ʼݹ',
        'PostMaster Mail Account' => 'ʼʺŹ',
        'Prio' => 'ȼ',
        'Problem' => '',
        'Queue <-> Auto Responses Management' => ' <-> Զظ',
        'Queue ID' => 'б',
        'Queue Management' => 'й',
        'Queue is required.' => 'Ҫָһ.',
        'QuickSearch' => '',
        'Realname' => 'ʵ',
        'Rebuild' => '¹',
        'Recipients' => 'ռ',
        'Refresh' => 'ˢ',
        'Reminder' => '',
        'Reminder messages' => 'Ϣ',
        'Remove this Search Term.' => 'ɾؼ',
        'Required Field' => 'ֶ',
        'Required!' => '!',
        'Response Management' => 'ظݹ',
        'Responses <-> Attachments Management' => 'ظ <-> ',
        'Responses <-> Queue Management' => 'ظ <-> й',
        'Return to the compose screen' => 'ص׫дҳ',
        'Role' => 'ɫ',
        'Roles <-> Agents' => 'ɫ <-> Ա',
        'Roles <-> Groups Management' => 'ɫ <-> ',
        'Roles <-> Users' => 'ɫ <-> û',
        'Roles <-> Users Management' => 'ɫ <-> û',
        'Save Job as?' => '湤Ϊ?',
        'Save Search-Profile as Template?' => 'Ϊģ',
        'Schedule' => '',
        'Search Result' => '',
        'Search for' => '',
        'Secure Mode need to be enabled!' => 'ȫģʽҪ',
        'Select Box' => 'ѡ񷽿',
        'Select Box Result' => 'ѯ',
        'Select Group' => 'ѡ',
        'Select Source (for add)' => 'ѡԴ(ӹʹ)',
        'Select group' => 'ѡ',
        'Select the customeruser:service relations.' => 'ѡͻͷϵ.',
        'Select the element, which will be used at the X-axis' => 'ѡxԪ',
        'Select the restrictions to characterise the stat' => 'ѡƲʹͳ',
        'Select the role:user relations.' => 'ѡ ɫ:û .',
        'Select the user:group permissions.' => 'ѡ û: Ȩ.',
        'Select your QueueView refresh time.' => 'ͼˢʱ.',
        'Select your default spelling dictionary.' => 'ѡĬϵƴдֵ.',
        'Select your frontend Charset.' => 'ַ.',
        'Select your frontend QueueView.' => 'ͼ.',
        'Select your frontend language.' => '',
        'Select your out of office time.' => 'ѡ㲻ڰ칫ҵʱ',
        'Select your screen after creating a new ticket.' => 'ѡ Ticket ʾͼ.',
        'Selection needed' => 'ѡҪ',
        'Send Administrative Message to Agents' => '͹ϵϢԱ',
        'Send Notification' => '֪ͨ',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'ͻ Ticket ظǸ Ticket .',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'עticketticketӵһҲһ֪ͨ',
        'Send no notifications' => '֪ͨ',
        'Sent new password to: %s' => 'µ뵽: %s',
        'Sent password token to: %s' => '뵽: %s',
        'Sessions' => 'Ự',
        'Set customer user and customer id of a ticket' => ' Ticket ͻû',
        'Show' => 'ʾ',
        'Show or hide the content.' => 'ʾظ.',
        'Site' => 'վ',
        'Solution' => '',
        'Sort by' => '',
        'Source' => 'Դ',
        'Spell Check' => 'ƴд',
        'Split' => 'ֽ',
        'State Type' => '״̬',
        'Static-File' => '̬ļ',
        'Stats-Area' => 'ͳ',
        'Sub-Queue of' => 'Ӷ',
        'Sub-Service of' => 'ӷ',
        'Subscribe' => '',
        'Symptom' => '֢״',
        'System History' => 'ϵͳʷ',
        'System State Management' => 'ϵͳ״̬',
        'Systemaddress' => 'ϵͳʼַ',
        'The customer is required.' => 'ͻֶǱ.',
        'The field is required.' => 'ֶǱ',
        'The identify of the system. Each ticket number and each http session id starts with this number.' => 'ϵͳıʶ. ÿһ Ticket  http Ựʹô.',
        'The message being composed has been closed.  Exiting.' => 'Ϣ׫дĴѾر,˳.',
        'The ticket was locked' => 'Ʊ',
        'These values are read-only.' => 'ֻ.',
        'These values are required.' => 'Ŀд.',
        'This account exists.' => 'ʻѴ',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ƿǳõģ㲻˵õͳƵĽͳƽ',
        'This window must be called from compose window' => 'ôڱ׫дڵ',
        'Ticket Change Times (before/after)' => 'Ticket ʱ (֮ǰ/֮)',
        'Ticket Change Times (between)' => 'Ticket ʱ (ʱ䷶Χ)',
        'Ticket Change Times (from moment)' => 'Ticket ʱ (·)',
        'Ticket Close Times (before/after)' => 'Ticket رʱ',
        'Ticket Close Times (between)' => 'Ticket رʱ (ʱ䷶Χ)',
        'Ticket Close Times (from moment)' => 'Ticket رʱ (·)',
        'Ticket Create Times (before/after)' => 'Ticket ʱ (֮ǰ/֮)',
        'Ticket Create Times (between)' => 'Ticket ʱ (ʱ䷶Χ)',
        'Ticket Create Times (from moment)' => 'Ticket ʱ (·)',
        'Ticket Lock' => 'Ticket ״̬',
        'Ticket Number Generator' => 'Ticket ',
        'Ticket Search' => 'Ticket ',
        'Ticket Status View' => 'Ticket ״̬ͼ',
        'Ticket Type is required!' => 'Ticket Ǳ!',
        'Ticket escalation!' => 'Ticket ʱ!',
        'Ticket locked!' => 'Ticket !',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'õ Ticket Ϣ (: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Ticket ѡ (: <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'TicketӵߵĿѡ e. g. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Ticketѡ (e. g. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'ѡн Tickets',
        'Ticket unlock!' => ' Ticket!',
        'Ticket#' => 'Ticket ',
        'Ticket-Area' => 'Ticket',
        'TicketFreeText' => 'Ticket Ϣ',
        'TicketZoom' => 'Ticket չ',
        'Tickets shown' => 'ʾ Ticket',
        'Tickets which need to be answered!' => 'Ҫش Ticket',
        'Time units is a required field.' => 'ʱ䵥λΪֶ.',
        'Timeover' => '',
        'Times' => 'ʱ',
        'Title of the stat.' => 'ͳƵı',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'ȡż (: <OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'Top of Page' => 'ҳ涥',
        'Total hits' => '',
        'U' => '',
        'Unable to parse Online Repository index document!' => 'ܷԴĵ',
        'Uniq' => 'һ',
        'Unlock Tickets' => ' Tickets',
        'Unsubscribe' => '˶',
        'Use utf-8 it your database supports it!' => 'ݿ֧֣ʹUTF-8ַ!',
        'Useable options' => 'ú',
        'Used default language.' => 'ָĬ.',
        'User Management' => 'Ա',
        'User will be needed to handle tickets.' => 'Ҫû Tickets.',
        'Users' => 'û',
        'Users <-> Groups' => 'û <-> ',
        'Users <-> Groups Management' => 'û <-> ',
        'Verify Password' => 'ȷ',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => '!  Ticket ݿɾ޷ָ!',
        'Watch notification' => 'ע֪ͨ',
        'Web-Installer' => 'WEB װ',
        'WebMail' => 'WebMail',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'ЧͳƲͳ',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'ͨѡֶΣ԰ͳơ޸ı༭ЩͳҪͳϹԱá',
        'Yes means, send no agent and customer notifications on changes.' => 'иıʱ֪ͨԱͻ.',
        'Yes, save it with name' => ', Ϊ',
        'You got new message!' => 'Ϣ!',
        'You have to select two or more attributes from the select field!' => 'ѡֶѡϵ',
        'You need a email address (e. g. customer@example.com) in To:!' => 'ռϢʼַ(磺customer@example.com)',
        'You need min. one selected Ticket!' => 'Ҫѡһ Ticket!',
        'You need to account time!' => 'Ҫ¼ʱ',
        'You need to activate %s first to use it!' => '%s ʹ֮ǰȼ!',
        'Your Password' => '',
        'Your email address is new' => 'ʼַµ',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'ʼ : "<OTRS_TICKET>" ˵ "<OTRS_BOUNCE_TO>" . ϵµַȡϸϢ.',
        'Your own Ticket' => 'Լ Ticket',
        'customer realname' => 'ͻʵ',
        'delete' => 'ɾ',
        'down' => '',
        'false' => '',
        'for agent firstname' => '֧Ա ',
        'for agent lastname' => '֧Ա ',
        'for agent login' => '֧Ա ¼',
        'for agent user id' => '֧Ա û',
        'kill all sessions' => 'ֹлỰ',
        'kill session' => 'ֹỰ',
        'maximal period form' => 'ڱ',
        'modified' => '޸',
        'new ticket' => '½ Ticket',
        'next step' => 'һ',
        'not rated' => '',
        'send' => '',
        'sort downward' => '',
        'sort upward' => '',
        'to get the first 20 character of the subject' => 'ʼǰ20ַ',
        'to get the first 5 lines of the email' => 'ʼǰ5',
        'to get the from line of the email' => 'ʼ',
        'to get the realname of the sender (if given)' => 'ʼ˵ʵ ()',
        'up' => '',
        'utf8' => 'UTF-8',
        'x' => 'x',

    };
    # $$STOP$$
    return;
}

1;
