//
// $Id: Criteria.h 4579 2008-01-02 17:39:07Z bakerj $
//
//****************************************************************************************//
// Copyright (c) 2002-2008, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef CRITERIA_H
#define CRITERIA_H

#include "AbsCriteria.h"
#include "ExtendedDefinition.h"
#include "Criterion.h"
#include "Analyzer.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;

class AbsCriteria;
typedef vector < AbsCriteria*, allocator<AbsCriteria*> > AbsCriteriaVector;

/**
	This class represent criteria in an oval definition.
	Criteria objects may have any number of child AbsCriteria abjects.
*/
class Criteria : public AbsCriteria {

public:
	Criteria(bool negate = false, OvalEnum::ResultEnumeration result = OvalEnum::RESULT_ERROR, string comment = "", OvalEnum::Operator op = OvalEnum::OPERATOR_AND);
	~Criteria();

	void Write(DOMElement* parent);
	void Parse(DOMElement* criteriaElm);
	OvalEnum::ResultEnumeration Analyze();
	OvalEnum::ResultEnumeration NotEvaluated();

	string GetComment();
	void SetComment(string comment);

	OvalEnum::Operator GetOperator();
	void SetOperator(OvalEnum::Operator op);

	AbsCriteriaVector* GetChildCriteria();
	void SetChildCriteria(AbsCriteriaVector* childCriteria);
	void AppendChildCriteria(AbsCriteria* childCriteria);

private:
	string comment;
	AbsCriteriaVector childCriteria;
	OvalEnum::Operator op;
};

#endif
