#include <stdio.h>
#include <string.h>

#include <gmodule.h>

#include "papaya/system.h"

void * findFunction(GModule * handle, char * name) {
  void * (*function)() = NULL;

  if (g_module_symbol(handle, name, (void *)&function)) {
    return function;
  }

  return NULL;
}

int find_symbol(GModule * handle, char * name, void ** ptr) {
  void (*function)(void **) = NULL;
  
  if (g_module_symbol(handle, name, (void *)&function)) {
    (function)(ptr);
    return 1;
  }
  
  return 0;
}

int findTurf(GModule * handle, void ** ptr) {
  return find_symbol(handle, "turf_protocol_get_turf", ptr);
}

GModule * plugin_handler_find_plugin(char *);

typedef unsigned char bool;
#define false 0

bool turf_protocol_is_supported(void * c) {
  bool (*function)(void *);
  GModule * turf_handle = plugin_handler_find_plugin("TurfProtocol");
  if (!turf_handle) {
    return false;
  }
  
  if (g_module_symbol(turf_handle, "turf_is_supported", (void *)&function)) {
    return (function)(c);
  }

  return false;
}

void turf_protocol_add_command(void * c, char * cmd, void * callback, gpointer data) {

  // Find the symbol for turf_add_command and execute it with our arguments.
  
  void (*function)(void *, char *, void *, gpointer) = NULL;
  
  GModule * turf_handle = plugin_handler_find_plugin("TurfProtocol");
  if (!turf_handle) {
    return;
  }
  
  if (g_module_symbol(turf_handle, "turf_add_command", (void *)&function)) {
    (function)(c, cmd, callback, data);
  }
  
}

void dl_call_func_int_ret(GModule * handle, char * name, char * alias, void * data, void * args) {
  int (*function)(char *, void *, void *) = NULL;
  int retval;

  if (g_module_symbol(handle, name, (void *)&function)) {
    retval = (function)(alias, data, args);
    return;
  }
}

void dl_call_func_int(GModule * handle, char * name, int * retval) {
  int (*function)(void) = NULL;

  if (g_module_symbol(handle, name, (void *)&function)) {
    *retval = (*function)();
    return;
  }
}

void dl_call_func_ret(GModule * handle, char * name, char * retval) {
  char * (*function)(void) = NULL;
  char * string;

  if (g_module_symbol(handle, name, (void *)&function)) {
    string = (*function)();

    snprintf(retval, 1024, "%s", string);
    return;
  }

  snprintf(retval, 1024, "");
  return;
}


typedef (*init_function)(void *);



init_function dl_get_init_function(GModule * handle) {



	init_function function;



	if (g_module_symbol(handle, "plugin_init", (void *)&function)) {

		return function;

	}



	return NULL;

}


void dl_call_func(GModule * handle, char * name) {
  void (*function)(void) = NULL;

  if (g_module_symbol(handle, name, (void *)&function)) {
    (*function)();
    return;
  }

  return;
}
