#include "MXPElement.h"

#include "Win32PluginAPI.cpp"

/**
 * Class to handle MXP Element parsing.
 */

/**
 * Turns text bold.
 */

bool mxp_element_bold(Connection * conn, char * element, char ** output_ptr, bool open) {
  char * output = *output_ptr;

  *output = '\0';

  if (open)
    strcat(output, "<TAG NAME=\"bold\">");
  else
    strcat(output, "</TAG>");

  *output_ptr = output + strlen(output);

  return true;
}

bool mxp_element_version(Connection * conn, char * element, char ** output_ptr, bool open) {

  char buf[1024];
  snprintf(buf, 1024, "<VERSION MXP=0.4 STYLE=0 CLIENT=papaya VERSION=\"0.97 (MXP Plugin Version 0.1)\" REGISTERED=yes>\n");
  socket_write(connection_get_socket(conn), buf, strlen(buf));
  
  return true;
}

bool mxp_element_send(Connection * conn, char * element, char ** output_ptr, bool open) {

  char * output = *output_ptr;

  *output = '\0';

  if (open)
    strcat(output, "<tag name=\"clickable\" callback=\"mxp_send_clicked\">");
  else
    strcat(output, "</tag>");

  *output_ptr = (output + strlen(output));
}


struct mxp_element mxp_element_table[] = {

  { "B", mxp_element_bold, MXP_OPEN },
  { "BOLD", mxp_element_bold, MXP_OPEN },
  { "STRONG", mxp_element_bold, MXP_OPEN },
  /*
  { "I", mxp_element_italic, MXP_OPEN },
  { "ITALIC", mxp_element_italic, MXP_OPEN },
  { "EM", mxp_element_italic, MXP_OPEN },

  { "U", mxp_element_underline, MXP_OPEN },
  { "UNDERLINE", mxp_element_underline, MXP_OPEN },

  { "S", mxp_element_strikeout, MXP_OPEN },
  { "STRIKEOUT", mxp_element_strikeout, MXP_OPEN },

  { "C", mxp_element_colour, MXP_OPEN },
  { "COLOR", mxp_element_colour, MXP_OPEN },

  { "H", mxp_element_highlight, MXP_OPEN },
  { "HIGH", mxp_element_highlight, MXP_OPEN },

  { "FONT", mxp_element_font, MXP_OPEN },


  { "NOBR", mxp_element_nobr, MXP_SECURE },

  { "P", mxp_element_paragraph, MXP_SECURE },

  { "BR", mxp_element_linebreak, MXP_SECURE },

  { "SBR", mxp_element_soft_linebreak, MXP_SECURE },

  { "A", mxp_element_a, MXP_SECURE },

  */
  { "SEND", mxp_element_send, MXP_SECURE },
  /*
  { "EXPIRE", mxp_element_expire, MXP_SECURE },
  { "VERSION", mxp_element_version, MXP_SECURE },
  /*
  { "SUPPORT", mxp_element_support, MXP_SECURE },

  // MUD Sound Protocol stuff, should hook into MSP plugin.
  { "SOUND", mxp_element_sound, MXP_SECURE },
  { "MUSIC", mxp_element_music, MXP_SECURE },

  { "H1", mxp_element_heading_one, MXP_SECURE },
  { "H2", mxp_element_heading_two, MXP_SECURE },
  { "H3", mxp_element_heading_three, MXP_SECURE },
  { "H4", mxp_element_heading_four, MXP_SECURE },
  { "H5", mxp_element_heading_five, MXP_SECURE },
  { "H6", mxp_element_heading_six, MXP_SECURE },
  { "HR", mxp_element_horizontal_rule, MXP_SECURE },
  { "SMALL", mxp_element_small_text, MXP_SECURE },
  { "TT", mxp_element_tt, MXP_SECURE },

  { "GUAGE", mxp_element_guage, MXP_SECURE },
  { "STAT", mxp_element_stat, MXP_SECURE },
  { "FRAME", mxp_element_frame, MXP_SECURE },
  { "DEST", mxp_element_dest, MXP_SECURE },

  { "RELOCATE", mxp_element_relocate, MXP_SECURE },
  { "USER", mxp_element_user, MXP_SECURE },
  { "PASSWORD", mxp_element_pass, MXP_SECURE },

  { "IMAGE", mxp_element_image, MXP_SECURE },
  { "FILTER", mxp_element_image, MXP_SECURE },
  { "SCRIPT", mxp_element_script, MXP_SECURE }, // obsolete as of 0.4

  { "!--", mxp_element_comment, MXP_SECURE },
  { "!ELEMENT", mxp_element_define_element, MXP_SECURE },
  { "!ATTLIST", mxp_element_define_attlist, MXP_SECURE },
  { "!ENTITY", mxp_element_define_entity, MXP_SECURE },
  { "VAR", mxp_element_define_var, MXP_SECURE },
  */
  { NULL, NULL, MXP_OPEN }
};

void mxp_element_parse(Connection * conn, char * element, char ** output_ptr) {

  char * arguments = NULL;
  char * space = strchr(element, ' ');
  if (space)
    *space = '\0';
  else
    arguments = space + 1;

  struct mxp_element * mxp_element = mxp_element_table;
  element++; // Skip past the <

  while (mxp_element->name) {

    if (!strcasecmp(mxp_element->name, element)) {
      mxp_element->element_handler(conn, arguments, output_ptr, true);
      return;
    }

    if (*element == '/' && !strcasecmp(mxp_element->name, element + 1)) {
      mxp_element->element_handler(conn, arguments, output_ptr, false);
      return;
    }

    mxp_element++;
  }

}
