/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSequencerNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseSequencerNode
extends AbstractNode
implements VRMLSequencerNodeType {
    protected static final int FIELD_NEXT = 1;
    protected static final int FIELD_PREVIOUS = 3;
    protected static final int FIELD_SET_FRACTION = 3;
    protected static final int FIELD_KEY = 4;
    protected static final int FIELD_KEY_VALUE = 5;
    protected static final int FIELD_VALUE_CHANGED = 6;
    protected static final int LAST_SEQUENCER_INDEX = 6;
    protected float vfFraction = 0.0f;
    protected float[] vfKey = FieldConstants.EMPTY_MFFLOAT;
    protected int numKey;

    public BaseSequencerNode(String string) {
        super(string);
    }

    protected void copy(VRMLSequencerNodeType vRMLSequencerNodeType) {
        float[] fArray = vRMLSequencerNodeType.getKey();
        this.vfKey = new float[fArray.length];
        System.arraycopy(fArray, 0, this.vfKey, 0, fArray.length);
    }

    public void setNext() {
        int n = this.findKey() + 1;
        if (n > this.numKey) {
            n = 0;
        }
        this.setFraction(this.vfKey[n]);
    }

    public void setPrevious() {
        int n = this.findKey() - 1;
        if (n < 0) {
            n = this.numKey - 1;
        }
        this.setFraction(this.vfKey[n]);
    }

    public int getPrimaryType() {
        return 68;
    }

    public float getFraction() {
        return this.vfFraction;
    }

    public void setKey(float[] fArray, int n) {
        if (this.vfKey.length < n) {
            this.vfKey = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfKey, 0, n);
        this.numKey = n;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public int getNumKey() {
        return this.numKey;
    }

    public float[] getKey() {
        return this.vfKey;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfKey;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numKey;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfFraction;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfKey, this.numKey);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseBooleanSequencer sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseBooleanSequencer sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setNext();
                break;
            }
            case 3: {
                this.setPrevious();
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setKey(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private int findKey() {
        int n = 0;
        for (int i = 0; i < this.numKey; ++i) {
            if (!(this.vfFraction > this.vfKey[i])) continue;
            n = i - 1;
            break;
        }
        if (n == 0 && this.vfFraction > this.vfKey[this.numKey - 1]) {
            n = this.numKey - 1;
        }
        return n;
    }
}

