/*=========================================================================

   Program: ParaView
   Module:    $RCSfile: pqExtractCTHPartsPanel.cxx,v $

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2. 

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "pqExtractCTHPartsPanel.h"
#include <QTreeWidget>
#include <QHeaderView>
#include "vtkSMStringVectorProperty.h"
#include "vtkSMArrayListDomain.h"

const char *pqExtractCTHPartsPanelNames[3] =
  {
  "AddDoubleVolumeArrayName",
  "AddFloatVolumeArrayName",
  "AddUnsignedCharVolumeArrayName"
  };

pqExtractCTHPartsPanel::pqExtractCTHPartsPanel(pqProxy* object_proxy, QWidget* p) :
  pqAutoGeneratedObjectPanel(object_proxy, p)
{
  QTreeWidget* arrays;
  QHeaderView *header;

  arrays = this->findChild<QTreeWidget*>(pqExtractCTHPartsPanelNames[0]);
  header = arrays->header();
  QObject::connect(arrays, SIGNAL(itemClicked(QTreeWidgetItem *, int)),
                   this, SLOT(dArrayEnabled(QTreeWidgetItem *, int)));
  QObject::connect(header, SIGNAL(sectionClicked(int)),
                   this, SLOT(dArrayEnabled(int)));

  arrays = this->findChild<QTreeWidget*>(pqExtractCTHPartsPanelNames[1]);
  header = arrays->header();
  QObject::connect(arrays, SIGNAL(itemClicked(QTreeWidgetItem *, int)),
                   this, SLOT(fArrayEnabled(QTreeWidgetItem *, int)));
  QObject::connect(header, SIGNAL(sectionClicked(int)),
                   this, SLOT(fArrayEnabled(int)));

  arrays = this->findChild<QTreeWidget*>(pqExtractCTHPartsPanelNames[2]);
  header = arrays->header();
  QObject::connect(arrays, SIGNAL(itemClicked(QTreeWidgetItem *, int)),
                   this, SLOT(cArrayEnabled(QTreeWidgetItem *, int)));
  QObject::connect(header, SIGNAL(sectionClicked(int)),
                   this, SLOT(cArrayEnabled(int)));


  //disable all arrays to start off in order to make sure we don't have
  //selections in more than one group
  //also select arrays that have "Material volume fraction" in the name
  this->enableMaterialNamedArrays(0);
  this->enableMaterialNamedArrays(1);
  this->enableMaterialNamedArrays(2);
}

//-----------------------------------------------------------------------------
//there must be a more elegant way to ignore the signals parameters, all I
//care about is which QTreeWidget threw it...
void pqExtractCTHPartsPanel::dArrayEnabled(int)
{
  this->arrayEnabled(0);
}

void pqExtractCTHPartsPanel::fArrayEnabled(int)
{
  this->arrayEnabled(1);
}
void pqExtractCTHPartsPanel::cArrayEnabled(int)
{
  this->arrayEnabled(2);
}
  
void pqExtractCTHPartsPanel::dArrayEnabled(QTreeWidgetItem *, int )
{
  this->arrayEnabled(0);
}

void pqExtractCTHPartsPanel::fArrayEnabled(QTreeWidgetItem *, int )
{
  this->arrayEnabled(1);
}

void pqExtractCTHPartsPanel::cArrayEnabled(QTreeWidgetItem *, int )
{
  this->arrayEnabled(2);
}

void pqExtractCTHPartsPanel::arrayEnabled(int which)
{
  QTreeWidget *otherWidgets[2];
  int loc = 0;
  int i;
  for (i = 0; i<3; i++)
    {
    if (i!=which)
      {
      otherWidgets[loc] = 
        this->findChild<QTreeWidget*>(pqExtractCTHPartsPanelNames[i]);
      loc++;
      }   
    }

  //there must be a more elegant way to uncheck everything...
  otherWidgets[0]->selectAll();
  QList<QTreeWidgetItem*> l = otherWidgets[0]->selectedItems();
  for (i = 0; i < l.size(); i++)
    {
    QTreeWidgetItem *n = l.at(i);
    n->setCheckState(0, Qt::Unchecked);
    }
  otherWidgets[0]->clearSelection();

  otherWidgets[1]->selectAll();
  l = otherWidgets[1]->selectedItems();
  for (i = 0; i < l.size(); i++)
    {
    QTreeWidgetItem *n = l.at(i);
    n->setCheckState(0,  Qt::Unchecked);
    }
  otherWidgets[1]->clearSelection();
}

//----------------------------------------------------------------------------
int pqExtractCTHPartsPanel::enableMaterialNamedArrays(int which)
{
  //disable any selections in the other sets
  vtkSMStringVectorProperty *myProp;
  myProp = vtkSMStringVectorProperty::SafeDownCast(
    this->proxy()->GetProperty(pqExtractCTHPartsPanelNames[which]));
  myProp->SetNumberOfElements(0);
  vtkSMArrayListDomain *myDomain = vtkSMArrayListDomain::SafeDownCast(
    myProp->GetDomain("array_list"));
  
  int foundone = 0;
  for (unsigned int i = 0; i < myDomain->GetNumberOfStrings(); i++)
    {
    if (strstr(myDomain->GetString(i), "raction")) //{F|f}raction
      {
      foundone = 1;
      myProp->SetNumberOfElements(i+1);
      myProp->SetElement(i, myDomain->GetString(i));
      }
    }

  if (foundone) 
    {
    arrayEnabled(which);
    }

  return foundone;
}


