# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be)
# for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from lib.reverse_translation import _t
from lib.openImage import open as open_image
from lib.imtools import has_transparency

#---Pil
def init():
    global Image, ImageMath
    import Image
    import ImageMath
    
def put_highlight(image,highlight,resample_highlight,opacity,
        cache=None):
    if cache is None:
        cache   = {}
    resample_highlight  = getattr(Image,resample_highlight)
    id      = 'highlight_%s_w%d_h%d_o%d'\
        %(highlight,image.size[0],image.size[1],opacity)
    try:
        highlight    = cache[id]
    except KeyError:
        highlight    = open_image(highlight)\
            .convert('RGBA').resize(image.size,resample_highlight)
        if opacity < 100:
            #apply opacity
            highlight_alpha = highlight.split()[3]
            opacity         = (255*opacity)/100
            highlight.putalpha(ImageMath.eval("convert((a*o)/255, 'L')", 
                a=highlight_alpha, o=opacity))
        #store in cache
        cache[id]   = highlight
    if not has_transparency(image):
        image = image.convert('RGBA')
    else:
        if has_transparency(image):
            image = image.convert('RGBA')
        alpha = image.split()[-1]
        highlight = highlight.copy()
        highlight_alpha = highlight.split()[3]
        highlight.putalpha(ImageMath.eval("convert(min(a, b), 'L')", 
            a=alpha, b=highlight_alpha))

    overlay = highlight.convert('RGB')
    image.paste(overlay, mask=highlight)
    return image

#---Phatch
class Action(models.Action):
    """Apply a transparency highlight"""
    
    label       = _t('Highlight')
    author      = 'Nadia Alramli'
    cache       = True
    email       = 'mail@nadiana.com'
    init        = staticmethod(init)
    pil         = staticmethod(put_highlight)
    version     = '0.1'
    tags        = [_t('filter')]
    __doc__     = _t('Apply a transparency highlight')
    
    def interface(self,fields):
        fields[_t('Highlight')]          = self.HighlightFileField('Sphere Top')
        fields[_t('Resample Highlight')] = self.ImageResampleField('antialias')
        fields[_t('Opacity')]            = self.SliderField(100,0,100)
        
    icon  = \
'x\xda\x01\x16\x0c\xe9\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\
\x00\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\
\x08\x08|\x08d\x88\x00\x00\x0b\xcdIDATh\x81\xcd\x9ai\x90\\\xd7U\xc7\x7f\xe7\
\xde\xfbz\x9d\x9eU#\x8d\xac\xb1v)\xdee\x13KX\xc6\x10\x8b"\xc6\xc1\x86\x98T\
\xe2\x00\x05)\xa0\xd8R&!\xc5\x07\x9b\xf0\x01\xc3\x07\x8aJ\xc0\x05T\xc5\tUvQ\
\x80\x8b\x80\x81\x908\xc1\xc1\xc6K\x82c\x82%\'Q\xd9\x89\x8cdY#\xcb\xd1\xaeY\
\xba{\xba\xa7\xfb-\xf7\x1e>\xbc\x19i4\xf2X\x8be\x97N\xd5\xfd\xf2^\xf7\xbb\
\xff\xffY\xee;\xcb\x13.PDD\x8c`5\xa8\x0f\xa0\xb3W\x81\x02\x14\n\x85B\xd1\xd5\
\n\xd6\x94\x00\x12\x1f\xbaI\x9c5I\x92\x14\x12\xe6~n@\xc4\x88\r\x8aWU\xbd \
\x1c\x17\x04\x1c5^\xf1\xf9\x85\x12K\x96\xf4\xae\xbfay\xf9\xe6\x1b\x86\xcd\
\xe6+\xfa\xc2\xd5+J\xd9h\xbf\xf3}E\x13J\x00q0\xddzf\x1b\x87:\xee\xe0\xee\xa6\
\xd9\xf5\xbd\xe3a\xc7\xce\xa3\x9doO\x8c7\xf7\xa1]\x00\xac`\x03\x04U\xce\x8b\
\xc8y\x110"6\xa8z\x80\xa868p\xfb\xc6\x81\xbb\xef^\xab\xbftK\x7fk\xebr;\x1d9\
\xdf%\xc9\x94$@\x1a \xccB\xb1\x02\xce@\xc1@\xc1\t\x99-q\xd8\xd7\x92\xe7\xeb=\
/<:\xc6?>\xb9\xa7\xfe/Yk\xb2\xbep\x8f\x8bF`\xbe\xd6Mu\xa0\xe7\x97\xaf_\xf2{\
\xf7l\xe8~\xfc\xfa\xd2\xf8\n\xdf\xed\xd0H\xa0\x1d\xf0!\xa0\x12\x10\xa3\x88\
\x11d\xee\xe1\n\x04E\x83\xa0jPc\x90\xaa\xc1\xf6\x17\xc0\x94\xca\xec\xec.9\
\xf8\xb9\xbd\xa5\x07\xbf\xb8\xf3\xc4\xe7\xc2L\xbde\x05\xebU\x02\x9c\xdd\xad\
\xceJ \xc7\xaeA\x89\xd8z\xf5\xe8]\x7fvc\xf8\xec-\xa5\xa3\x1b\x9a\xed\x98\xc9\
\x14\x1f\xc4P\xd0`J \x85j\x01\xd7?\x82\xed\x1f\xc1T\x07\x90B\t\x144\xed\x12\
\xdaS\xf8\xfaQ\xb2\xfa\x11\x92vJ\x174\x11\x13\x8c\x06\x06#lo\xb5\xc8s\x9d\
\xe5\xaf~\xfa;r\xef\xf6W~\xf8\x98\x90\x81\x88Q\xd5p\xc1\x04\x8c\x88\t\xaa\
\x81Ro\xe9\x0fo\x1d\xf9\xcbO\xaf9\xf6;\xdajp4&\x13klU\x82\x94\x05J\xcbF\x89\
\xd6\xde\x88\x19\xd9\x88T\x07\xc1\x15\xf2\'\xeb\xbc]\x14\xc8\x12\xb4=\x81?\
\xf2*\xd9\xfe\xef\xd0=v\x88\x8eB[\x8d\xaa\x0f~\xa4\x84\xa3\xda\xcf\x9f\x8e-}\
\xf03\xdf<\xfa\xfb\xc4\xcd\xe4l.\xb5(\x81\xb9?\xd6\x06\x86\x97?t{\xdf\xbf}\
\xb4\xf7\xf5\x9b\xdfhd\xbe\xab"=\x91\x98\x1e\x02\xe5\xbe>\xdc5?\x85\x8c^\x9b\
\x83\xceR\x08\x19,\xa641`\x1c\xb8(\'\xf3\xc3\x97\xc9v=M\xa7\xd1dZ\x0c\xedDCI\
TW\xf69\xfb\xc5\xc6\xea\xe7\x7f\xeb\x89\xfa\x87\xdb\xf5\xf1coE\xe2M\t\xcci~`\
\xc9\xb2\x95\xffzG\xe5\xa9[\xdd\xfe\x8dc\xd3\xa4\xceJ\xd4[\x10z\x08\x14V\xac\
G\xae\xffY(\xd5 \xe9\xe4\xee*\xc2)\xcf_DTO\xfd\xb6P\x81N\x03}\xe9k$\x87\xf6\
\xd1\xc2\xd0L\x94\xcck\xba\xb6F\xf4l\xba\xe6\xd5\xbb\x1fo\xbf\xbf>q\xfc\x8d\
\x93\xdep6\x02\xb3>\xaf\x95\xbe\xa1\xe1\xaf\xdc\xd5\xfb\xad\xf7\x99\xfd\x1b\
\xc7\xda\x92U"u\xfdE\xa1\xa2\x8a\xbd\xfcJ\xb8\xee\x0e\x08\x1e|\x9ak\xf6\xbcO\
d\xcd-e#0\x16^\xfa\x0f\xfc\xc1\xdd\xcc\x88P\xef*3\x99d\xeb\xaa\xea\x9e\xf1k\
\xf6|\xe8\xb1\xe6\x8fu\x1a\x13\x93\x88\xc8\xc2\x98\xb0\xa7\x83\xcf\x8d\x1c\n\
=\xe6\xe1;\x87\xbf\xfes\xe5\xb1\x1b\xf6\xb5$\xeb\x89\xd4\r\x94\x84*\x8a\x19^\
\x01\xd7~\x00\xd2\x18\xb2$\x07\x11|\xee:\xe7\xb5|\xfe\xdf,\xc9\x95\xb0t\x1d\
\xa6y\x88Bg\x1a\xe7\x04\xafj\x8e\xc5\x92m.O-]1:\xba\xe5\xb1\xd7\xe2GlHd\xa1\
\x9eN#`E\xacW\xeb?y\xeb\xaa\x07\xee]\xb1\xff\xee\xb1FH\xcb\x11\xd1`\x11*V\
\x90B\x01\xae\xfe\xe9\\\xe3~>\xf8\xb7\xb1t\xd6\x8a\x1a\xa0o\x049\xbe\x97\x88\
\x803\x90)\xe6D\x87t\xdb`s\xddD\xcf\xaa\xca\xf6\xfdSOZ\xc1\xea\xa9\xe3\xe1\
\x14\x81\xb9@\xb9n\xfd\xe5\xdb\xfen\xf3\xc4\x17\xc6\x1b\x9dL\x8cDCE\xa8\x14\
\x04\xc9\x14F\xaf\x82\xa1\x95\x90\xcc\\\x1c\xf0\xf3W\x16\xe71\x91\xc5H\xfd8\
\x91\x13\x8c@7\x88iw\x83\xbfm\x85\xbf\xe5\xf1\xc9%\xcf\x1e\x9bj\xbcnDN\x92\
\x98# " \x85\x9e\xe8\xa1\xdb\xaa_[\xe7\x8f\rOe\xc2PQ\xa5\x16\x81\x01p\x16V\
\xde\x90\x07\xe0y\xbb\xcb9\xac9KDe\x98\xdc\x8f\x10\x88L\x8e\xad\x99\x89\x0eh\
\xd7\xac\xb9lp\xf3\xa3{\xd2\x87%$s/\xf9\x9c\x805\xe2\x82\xe2\xef\xb8~\xf4\
\xd7\xfe`\xf5\xe1_?\xd4\xf2Y\xad\x80\xed/\x82\xb3\x02\x1e\xe8\x19\x84\xa1U\
\xb9\xa6.\xa6\xe6\xe7/\x9f\xe6A\xdd:\x0eq\x07\xb1\x82\x13\xf0\x8a\x99\x8a\
\xc9~\xa4\xaf3\xf2\xddt\xe4\xc0\xde#\xf5\xefY\x11\xa7\x10\x1c !\xa87\xc5\x9e\
\xe2\'\xaeL\xef\xeb\xb4c5FL-\xd29\r\xe4R\xac\xe6\x1bd\xc9\xd9\x8f\xca\x0b\
\x15Up\n\x85*\xe8$\x00\x91\x81Z\x04\xedLLw&\xd6O\\\xe5\xef{rW\xf5\x91\x90\
\xb4S@\x9c5b}\xd0\xec\xa6\xb5\x83?sSe|\xfd\x89:\xbe\xa7\xa8\xb6\xe4\x16<\\\
\x0c\xa4\xdd<x\xdfI\x02\x1a\xc0\x98\xd3.\x97\x1c\xf4Dj&c\xfc\xcd\xfd\x13\x1b\
n\\;t\xfb\x8e\xdd\xed\xafZ#\xce\xa1\xaa\xe0\xf8\xc8z\xfb1\x97\xce\xa8\x1a\
\xd1\x8aS\xdc\xfcLL\x80\x90\xe6\x04B\xca\x05d\xe1\xe7\xca\x00B\x00\x9f\x9d\
\x96\x8a8\x81\xaa\x83\xe9\x14\x8d\xd2\xb6~x\xdd\xd2_\xdd\xb1\xdb~\x15\xf5\
\xea\xbc\xe2K\xb5\xda\xe0\xfb\x86:\xdb\x9a1R\xb4\xd8\xa2}\x93g\']\xc8\xbay\
\xc0\xbd\x93\x04\x8c\x87\xb4s\xc6\x9d\xa2\x85\x92\x15;\x1d\xabl\x1b\xeel+Vk\
\xfdq\xbb^w\x00W,\xabl^]h\xf45:\x84ZQ\x8d\x93\x05\x0f\x15 i\xcf\x1e\x9f\x17T\
8\x9d\xbbH\x02q{VG\xa7\xf6r\x02e\xab2\x1d\x13\xd6\x14Z\xfd\xefY\xd6\xfb\xde\
\x97\xc7\xea\xcf8\x80\xeb\x96\xb8-\xe5\xd0a\x12B\xd1b\xccB\x05\x0b\xb9\xfbt\
\xa7\xf3\xa4\xed\x9d"!\x92\x1f\x12Y|\x86\x91\x8d\xe4V\xa8C\xa8h\xc7\\;<\xb4\
\xe5\xe51\x9eq`\xb9\xa2\x9fk\x82\xf7\x18\x93WNo*\nt\xeaP\xee_<\xdb|\xdb\x04\
\x0c\xcc\xd4O\xc5\xdd\x02q\x92\x13\xd1\xccsE?\xd7\x80\xc1!\x11\xa3\x95\xb0*\
\xcb\xc0\x8a\x18+\x8bhW\xc8\xb3N\xb1`\xdd\xc5\xb7\x82H\x1e\xbcig\xd1\x10\xb3\
\x06\xac\x11\x93ze\xb4\x12V#\x05\x1c\xce\xd9\x81\xc8\xf7g\x9a\xd7\xae\x8b\
\x19\xe0\xa4$mp\xc5\x8b\x0b~N\xb2\xf8-o\x1br\x0bd\x01\x06\xa20\x80\xb3\xc6aM\
\xa5h\xb4\'\xe4)\xfa\x19\xd9\xde\x19\xa2\x9a\xc7\xc3\xc5~\x17\x9c\x8bEg]((\
\x14m(cL\xd1qF\xbc_\xc4\r\xdf\x051\xf8\xd0\xee\x06i\xcd\xba\xce\xa5\x81\xea-\
D\xc9]\xa9\xebM\x87\x10bC\x96\xf9\xa9\xc4\xd4\xad\xc9Ms\x89(\xf6ME5\xc7h\rL%\
f\x8a\xcc\x07\x83\xa6\x1c\x9c\xb1\x07\x9c\x05\x1f4\x84K\x98@\xd0\x1c\xa3\xb3\
pp\xc6\x1c@\x13\x0cx\xf64\xd8%\xd6jP\xf0\x970\x01?\xe7!\xd6\xb2\xa7\xc1\x0f \
\xe4\xa7\xe6\xcb\'\xb2\xed\x1d)\x89(&y\x87\xdeQ\x17C\x92\x00\xa2\x98\x19)\
\xf3\xfd\x13\xe9v\x98=\xf6w\x1f\x9fy\xf1\xf5\xb4\xa7Q2\x98\xae\x17\xbd\x14\
\xad\xe0\x15\xba^\xb4d0\xfb\x93\x9e\xfa\x9e\xe33\xdf\x050V\xb0\xdd\xe9\xe9\
\xc9\xe7&*\xdf\xa8\x16\xd0N\x86O/A+\xa4\x01:\x99\xfaj\x01\xfd\xe6x\xf9\x1bqk\
\xban\x05k\xf2j8\xe3K\xfb\xfc#IT\x91\x10T:\xfe\xd2:O\x15\xe8\xe4\r?\x89\xa3\
\x8a|y\xcc\xff=\xf8\xbc\x89\xe5\x83z\x01\xd916\xf9\xf8\x8e\x99\xa1\xb1^\x8b\
\x99N%\\JVH\x03Lg\x12j\x0e\xf3B{\xc9\xde\x17\xc7&\x9e\x10\x10\x1f\xd4\x1b@\
\x8d\x88\xf5q+\xfe\xfcn\xf7\xe7\x85JQ\xe2TC;\xbb4\xac\xa0@;\x83$\xd5\x10\x95\
\x8b\xf2\xf9\xdd\xf63!i\xc7F\xc4\x02j\x00\xbc\xaa7\x82\xf9\xcf]\'\xfe\xf6\
\xd9\xd6\xc8\xee\xc1\x08WO$\xc4\xd9\xbb\r\xf7\xcc\xfc\xaa\x9bA=\x960\x10\xe1\
\x9ei-\xff\xc1\x7f\xed:\xfe\x0fF0~\xb6\xd9;\x97|*\x88\x84\xb8\x95\xfc\xf1\
\x8b\xe1\x9e\xa4\xd2\x07\x99\x86z*\x9c\xe9J2\x9b\xaf\xbf\x03e\xe5\x82\xb7h\
\x1a\xa0\x91\nx\r\xddJ\x1f\xf7\xef\xf0\xf7\xe4\xdd\x089Y1\x9f\xac~\x15\xd4\
\x8a\xd8\xa3\x93\xad\xb1\xa4\x7ft\xf0\x83K\x9b[\xc7;!u\x06[\xb0\xe4eZ\x00.\
\xdf\x04\xdd&$i\xfeN\x7f\xbb\x8e&\xb3\n1\x06\x86WC\xbb\x0ey/\x88F\n\xf5.\xe9\
H\xcdE\xf7\xef\x1b}\xe0\xeb;\x0f<d\x84\xd3Z\xed\xa7\x97\xef\x02V\xd4n?\x9c<\
\xb5n\xf5\x8a\x9f\xfc\xd1\xf2\xd4\xea\x13\xb1d\xce`"k0\x99\xc2\x92QX\xbb\x15\
\x8e\xbf\x06i\x96\xdbP\xceZE,D}\xaa\x15\x9f\xcd\x96_\xd7~ \xefHL\x1c\xc1[\
\xc3t\xaaLt%[^&\xfa\xe7\xe6\xda\xe7\xfe\xe8\xe9#\xbfbCbTY\xbc;=\xab\x11!K\
\xfc3\x87\xcd\xe3[6,\xfb\xe0\x95\xae>|"\x96\xcc\x1aL\xe4\xc0\xb4&`\xf5{a\xf4\
\x9a\xdc\x123\xf5Y\x109\x8e\x1c\x989\x05\xf0\xb45\xbbG\x00\xe6t8\xb0\x1c6\
\xdd\t\x95~x\xe5)2\x02\xd3)\x8cw$[ZP\xf7\xdf~\xf5\x9e\xdf|\xa2q{6\xd3\x98Q\
\x11t\x81\xc9\xdf\xac\x81\xa2F\xc4\xc4\xdd\x99\xd6\x13\x87\x8b\x8fm^?|\xe7\
\x95Q}\xf8D\x87\x14#\xd6\x05\x8f\xad\x1fD.\xbb\nVn\x82\xbe\xe5\xe0\xdcl\xd7.\
\xce\xc9\x84\xc5\xd6,\xc9r\r\x86\xd7\xc0\xba\x9b\xe1=?\x9eo\xba\xf31\x92v\
\x8b\xba\x17\xa6:\x9a.+\x11=\x1fV\xbf\xfa\xb1\'fnkN\x8d\x1f1\x8b\xcc\xcb\xce\
e\xc4t\xd9\x83\xef\xef\xfd\xd2]\xd5\x037\x9dhg>*\x18\x190\xc1\x94k5\xec\xc6[\
`dc>6\x8a[\xd0\x9a\x84\xf6$t\x1by\xfd\xecS@\xf3~gT\xce\xa79\xd5A\xa8\x0eA\
\xb97\xef1\x1d\xddC\xb6\xe7y:\xad\x16S\xc1\x84,\t:\\u\xf6\xdf[\xab\xfe\xe7w\
\x9fj|\xa4U\x1f?r\xde#\xa6y$LP\rR\xea-\xdd\xfb\x13\xcb\xfe\xeaS+\x8f\xfd\xb6\
\xb4\x9b\xb4\x94\xacj\xb15\x87\x14\x87W`\x97_\x81\x0c^\x9e\x83\xb2s\x03\xbey\
\xc5\xc5\xfc\xd1S\x96\xe6c\xa5\xc97\xf0\x87w\x13\x8f\x1f\xa6\x99\xa13\x1e\
\xdf#8\xad\xf6\xf1\xc0\x81\xa5\x7f\xf3\x17\xdf:\xf6)\xba\xcdx\xb1\xd1\xd29\
\x11\xc8\xf7\x9e7f\xbdj\xc5\x87\xee\xbf!|vK\xe1\xe8\xbaN7\xa1\xab\xf8"Pu\x98\
b\xb5$\xae6\x84\xed\x19B*\xbdHT\xc9\xbb\x17\x00!E\xe3\x0e\xdai\xe2[\x13d\xcd\
q\xe2\x99X\xdb\x19!\x06\xca\x82-\x95\n\xbc\x10\x8f\xbc\xfa\';\xcd}\xdb\xff\
\xef\xd0W\x84\xf4\xed\x8fY\xe7\x9189\xe8v\xd5\x81\xde_\xd84\xf4\xc9\xdfX\xdb\
\xfd\xf85\x85\xf1\xcb4\xed\xd2\xc9 \x04\xbc\x01\x8d\x04q\x16\xb1\x92gY\x90\
\x1b\xc2+\x9ay4U4\x80\x18\x83-; *\xf3\xfdd\xe8\xd0\xc3\xfb\x8a_x\xf4\xe5\x89\
\xbf\xf6\xed\x8b<\xe8\x9e/\xf3}\xb1P\x1b\x1c\xbcmC\xdfG\x7f~\x15\xbf\xb8\xa5\
\xafu\xd3\x88iE.\xc4x\x1f\xf0a^\xf1A\xee=Vf\xfb:\xd6\x90\x99"GCO\xfaB\xa3\
\xe7\x7f\xbf|\x80\x7fzzo\xfd\xd1dzjj\xe1\x1e\xe7\xa4\xdc\xf3!\x90\x839\xf3c\
\x8f\xe1%\xb5\r\x9bF\xca[7\r\x99\xad\xeb{\xc3\x95\xcbK\xd9\x8a^\x9b\xf5\x17M\
\x88\x00\xe2`\xd2\xa6w\xf5#]who\xd3\xbc\xf2\xd2xx\xe1\xa5c\x9do\x8f\x8fO\xbf\
\xf6\xae~\xecq\x06\x91\xc5>\xb7)\x16\x8a\xa5\x82\xeb\x8d\xac)\x00$>$q\x925\
\x89\x93\xf8b\x7fn\xf3\xff\xa2G\xcb\xde\x01H\xa2F\x00\x00\x00\x00IEND\xaeB`\
\x82J\xc8\x17\x02'
