<?php

/*
	Phoronix Test Suite
	URLs: http://www.phoronix.com, http://www.phoronix-test-suite.com/
	Copyright (C) 2008 - 2009, Phoronix Media
	Copyright (C) 2008 - 2009, Michael Larabel

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class install_test implements pts_option_interface
{
	public static function required_function_sets()
	{
		return array("install");
	}
	public static function run($items_to_install)
	{
		if(count($items_to_install) == 0)
		{
			echo "\nThe test, suite name, or saved identifier must be supplied.\n";
		}
		else
		{
			$items_to_install = array_unique(array_map("strtolower", $items_to_install));

			/*
			foreach($items_to_install as $this_install)
			{
				if(strpos($this_install, "pcqs-") !== false && !pts_pcqs_is_installed())
				{
					// Install the Phoronix Certification & Qualification Suite
					$agreement = wordwrap(pts_pcqs_user_license(), 65);

					if(strpos($agreement, "PCQS") == false)
					{
						echo pts_string_header("An error occurred while connecting to the Phoronix Test Suite server. Try again later.");
						return false;
					}

					echo "\n\n" . $agreement;
					$agree = pts_bool_question("Do you agree to these terms in full and wish to proceed (y/n)?", false);

					if($agree)
					{
						pts_pcqs_install_package();
						break;
					}
					else
					{
						echo pts_string_header("In order to run PCQS you must agree to the listed terms.");
						return false;
					}
				}
			}
			*/

			echo "\n";

			// Any external dependencies?
			if(!pts_install_package_on_distribution($items_to_install))
			{
				echo "\nInstallation of needed test dependencies failed.\n\n";
				return false;
			}

			// Install tests
			pts_start_install($items_to_install);
		}
	}
}

?>
