<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:func="http://exslt.org/functions" xmlns:vldt="http://search.cpan.org/~wohl/XML-DTD/validate" version="1.0" extension-element-prefixes="func">

<!-- This DTD validation XSL stylesheet generated by dtdto,
     distributed with the XML::DTD Perl module available
     from http://search.cpan.org/~wohl/XML-DTD/. -->

  <xsl:output method="text"/>

  <xsl:template match="/">
    <xsl:variable name="result">
      <xsl:for-each select="*">
        <xsl:apply-templates select=".">
          <xsl:with-param name="p" select="concat('/',name(.))"/>
        </xsl:apply-templates>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$result=''">
        <xsl:text>valid</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$result"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*">
    <xsl:param name="p" select="''"/>
    <xsl:choose>
      <xsl:when test="vldt:valid(.)">
        <xsl:for-each select="*">
          <xsl:variable name="presib" select="count(preceding-sibling::*[name(.)=name(current())])"/>
          <xsl:variable name="folsib" select="count(following-sibling::*[name(.)=name(current())])"/>
          <xsl:variable name="posstr">
            <xsl:if test="$presib + $folsib &gt; 0">
              <xsl:value-of select="concat('[',$presib+1,']')"/>
            </xsl:if>
          </xsl:variable>
          <xsl:apply-templates select=".">
            <xsl:with-param name="p" select="concat($p,'/',name(.),$posstr)"/>
          </xsl:apply-templates>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat('invalid ',$p)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <func:function name="vldt:valid">
    <xsl:param name="x" select="/.."/>
    <xsl:variable name="eltdef" select="document('')//vldt:dtdvalidate/element[@name=name($x)]"/>
    <xsl:variable name="result">
      <xsl:choose>
        <xsl:when test="$eltdef/@type='any'">
          <xsl:value-of select="true()"/>
        </xsl:when>
        <xsl:when test="$eltdef/@type='empty'">
          <xsl:choose>
            <xsl:when test="*|text()">
              <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="true()"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$eltdef/@type='mixed'">
          <xsl:value-of select="vldt:validmixed($x,$eltdef/mixed)"/>
        </xsl:when>
        <xsl:when test="$eltdef/@type='element'">
          <xsl:value-of select="vldt:validelement($x,$eltdef/fsa)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="false()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <func:result select="$result='true'"/>
  </func:function>

  <func:function name="vldt:validmixed">
    <xsl:param name="x" select="/.."/>
    <xsl:param name="y" select="/.."/>
    <xsl:variable name="chldmatch">
      <xsl:for-each select="$x/*">
        <xsl:if test="not($y/child[@name=name(current())])">
          <xsl:text>1</xsl:text>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <func:result select="$chldmatch=''"/>
  </func:function>

  <func:function name="vldt:validelement">
    <xsl:param name="x" select="/.."/>
    <xsl:param name="y" select="/.."/>
    <xsl:param name="n" select="1"/>
    <xsl:param name="s" select="0"/>
    <xsl:variable name="state" select="$y/state[@index=$s]"/>
    <xsl:variable name="trans" select="$state/transition[@symbol=name($x/*[$n])]"/>
    <xsl:variable name="result">
      <xsl:choose>
        <xsl:when test="$n &gt; count($x/*)">
          <xsl:value-of select="$state/@final=1"/>
        </xsl:when>
        <xsl:when test="$trans">
          <xsl:value-of select="vldt:validelement($x, $y, $n+1,                                      number($trans/@destination))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="false()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <func:result select="$result='true'"/>
  </func:function>

  <vldt:dtdvalidate>
    <element name="address" type="mixed">
  </element>
    <element name="agitation" type="mixed">
  </element>
    <element name="altitude" type="mixed">
  </element>
    <element name="aperture" type="mixed">
  </element>
    <element name="area" type="mixed">
  </element>
    <element name="artistic" type="mixed">
  </element>
    <element name="azimuth" type="mixed">
  </element>
    <element name="bit-depth" type="mixed">
  </element>
    <element name="body" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="make" destination="1"/>
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="1" final="1" label="make_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="2" final="1" label="model_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="3" final="1" label="serial_rt">
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="4" final="1" label="type_rt">
        <transition symbol="note" destination="5"/>
      </state>
      <state index="5" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="body-attachment" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="device" destination="1"/>
      </state>
      <state index="1" final="1" label="device_rt">
        <transition symbol="device" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="2" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="camera" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="hardware" destination="1"/>
        <transition symbol="note" destination="3"/>
        <transition symbol="settings" destination="2"/>
      </state>
      <state index="1" final="1" label="hardware_rt">
        <transition symbol="note" destination="3"/>
        <transition symbol="settings" destination="2"/>
      </state>
      <state index="2" final="1" label="settings_rt">
        <transition symbol="note" destination="3"/>
      </state>
      <state index="3" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="caption" type="mixed">
  </element>
    <element name="city" type="mixed">
  </element>
    <element name="collection" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="description" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="1" final="1" label="description_rt">
        <transition symbol="note" destination="2"/>
      </state>
      <state index="2" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="command" type="mixed">
  </element>
    <element name="condition" type="mixed">
  </element>
    <element name="content" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="object" destination="2"/>
        <transition symbol="person" destination="1"/>
        <transition symbol="segment" destination="3"/>
      </state>
      <state index="1" final="1" label="person_rt">
        <transition symbol="object" destination="2"/>
        <transition symbol="person" destination="1"/>
      </state>
      <state index="2" final="1" label="object_rt">
        <transition symbol="object" destination="2"/>
        <transition symbol="person" destination="1"/>
      </state>
      <state index="3" final="1" label="segment_rt">
        <transition symbol="segment" destination="3"/>
      </state>
    </fsa>
  </element>
    <element name="coordinates" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="longitude" destination="2"/>
        <transition symbol="latitude" destination="1"/>
        <transition symbol="altitude" destination="3"/>
      </state>
      <state index="1" final="1" label="latitude_rt">
        <transition symbol="longitude" destination="2"/>
        <transition symbol="altitude" destination="3"/>
      </state>
      <state index="2" final="1" label="longitude_rt">
        <transition symbol="altitude" destination="3"/>
      </state>
      <state index="3" final="1" label="altitude_rt">
      </state>
    </fsa>
  </element>
    <element name="copyright" type="mixed">
  </element>
    <element name="country" type="mixed">
  </element>
    <element name="date" type="mixed">
  </element>
    <element name="defaults" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="history" destination="5"/>
        <transition symbol="film" destination="1"/>
        <transition symbol="frame" destination="3"/>
        <transition symbol="properties" destination="4"/>
        <transition symbol="processing" destination="2"/>
      </state>
      <state index="1" final="1" label="film_rt">
        <transition symbol="history" destination="5"/>
        <transition symbol="frame" destination="3"/>
        <transition symbol="properties" destination="4"/>
        <transition symbol="processing" destination="2"/>
      </state>
      <state index="2" final="1" label="processing_rt">
        <transition symbol="history" destination="5"/>
        <transition symbol="frame" destination="3"/>
        <transition symbol="properties" destination="4"/>
      </state>
      <state index="3" final="1" label="frame_rt">
        <transition symbol="history" destination="5"/>
        <transition symbol="properties" destination="4"/>
      </state>
      <state index="4" final="1" label="properties_rt">
        <transition symbol="history" destination="5"/>
      </state>
      <state index="5" final="1" label="history_rt">
      </state>
    </fsa>
  </element>
    <element name="description" type="mixed">
  </element>
    <element name="developer" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="make" destination="1"/>
        <transition symbol="name" destination="2"/>
        <transition symbol="dilution" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="1" final="1" label="make_rt">
        <transition symbol="name" destination="2"/>
        <transition symbol="dilution" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="2" final="1" label="name_rt">
        <transition symbol="dilution" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="dilution_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="developing" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="agitation" destination="5"/>
        <transition symbol="duration" destination="7"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="process" destination="1"/>
        <transition symbol="shift" destination="2"/>
        <transition symbol="developer" destination="3"/>
        <transition symbol="method" destination="4"/>
        <transition symbol="temperature" destination="6"/>
      </state>
      <state index="1" final="1" label="process_rt">
        <transition symbol="agitation" destination="5"/>
        <transition symbol="duration" destination="7"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="shift" destination="2"/>
        <transition symbol="developer" destination="3"/>
        <transition symbol="method" destination="4"/>
        <transition symbol="temperature" destination="6"/>
      </state>
      <state index="2" final="1" label="shift_rt">
        <transition symbol="developer" destination="3"/>
        <transition symbol="agitation" destination="5"/>
        <transition symbol="duration" destination="7"/>
        <transition symbol="method" destination="4"/>
        <transition symbol="temperature" destination="6"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="3" final="1" label="developer_rt">
        <transition symbol="agitation" destination="5"/>
        <transition symbol="duration" destination="7"/>
        <transition symbol="method" destination="4"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="temperature" destination="6"/>
      </state>
      <state index="4" final="1" label="method_rt">
        <transition symbol="agitation" destination="5"/>
        <transition symbol="duration" destination="7"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="temperature" destination="6"/>
      </state>
      <state index="5" final="1" label="agitation_rt">
        <transition symbol="duration" destination="7"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="temperature" destination="6"/>
      </state>
      <state index="6" final="1" label="temperature_rt">
        <transition symbol="duration" destination="7"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="7" final="1" label="duration_rt">
        <transition symbol="note" destination="8"/>
      </state>
      <state index="8" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="device" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="make" destination="1"/>
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="1" final="1" label="make_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="2" final="1" label="model_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="serial_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="digimage" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="idximage" destination="3"/>
        <transition symbol="history" destination="2"/>
        <transition symbol="note" destination="4"/>
        <transition symbol="properties" destination="1"/>
      </state>
      <state index="1" final="1" label="properties_rt">
        <transition symbol="idximage" destination="3"/>
        <transition symbol="history" destination="2"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="2" final="1" label="history_rt">
        <transition symbol="idximage" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="idximage_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="digimage-set" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="digimage-set" destination="3"/>
        <transition symbol="digimage" destination="2"/>
        <transition symbol="defaults" destination="1"/>
      </state>
      <state index="1" label="defaults_rt">
        <transition symbol="digimage-set" destination="3"/>
        <transition symbol="digimage" destination="2"/>
      </state>
      <state index="2" final="1" label="digimage_rt">
        <transition symbol="digimage-set" destination="3"/>
        <transition symbol="digimage" destination="2"/>
        <transition symbol="defaults" destination="4"/>
      </state>
      <state index="3" final="1" label="digimage-set_rt">
        <transition symbol="digimage-set" destination="3"/>
        <transition symbol="digimage" destination="2"/>
        <transition symbol="defaults" destination="4"/>
      </state>
      <state index="4" final="1" label="defaults_rt">
        <transition symbol="digimage-set" destination="3"/>
        <transition symbol="digimage" destination="2"/>
      </state>
    </fsa>
  </element>
    <element name="digital" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="frame-set" destination="5"/>
        <transition symbol="defaults" destination="3"/>
        <transition symbol="frame" destination="4"/>
        <transition symbol="collection" destination="1"/>
        <transition symbol="description" destination="2"/>
      </state>
      <state index="1" label="collection_rt">
        <transition symbol="frame-set" destination="5"/>
        <transition symbol="defaults" destination="3"/>
        <transition symbol="frame" destination="4"/>
        <transition symbol="collection" destination="1"/>
        <transition symbol="description" destination="2"/>
      </state>
      <state index="2" label="description_rt">
        <transition symbol="frame-set" destination="5"/>
        <transition symbol="defaults" destination="3"/>
        <transition symbol="frame" destination="4"/>
      </state>
      <state index="3" label="defaults_rt">
        <transition symbol="frame-set" destination="5"/>
        <transition symbol="frame" destination="4"/>
      </state>
      <state index="4" final="1" label="frame_rt">
        <transition symbol="frame-set" destination="5"/>
        <transition symbol="defaults" destination="3"/>
        <transition symbol="frame" destination="4"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="5" final="1" label="frame-set_rt">
        <transition symbol="frame-set" destination="5"/>
        <transition symbol="defaults" destination="3"/>
        <transition symbol="frame" destination="4"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="6" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="dilution" type="mixed">
  </element>
    <element name="direction" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="azimuth" destination="1"/>
        <transition symbol="elevation" destination="2"/>
      </state>
      <state index="1" final="1" label="azimuth_rt">
        <transition symbol="elevation" destination="2"/>
      </state>
      <state index="2" final="1" label="elevation_rt">
      </state>
    </fsa>
  </element>
    <element name="district" type="mixed">
  </element>
    <element name="duration" type="mixed">
  </element>
    <element name="editing" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="operations" destination="4"/>
        <transition symbol="software" destination="3"/>
        <transition symbol="time" destination="2"/>
        <transition symbol="date" destination="1"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="1" final="1" label="date_rt">
        <transition symbol="operations" destination="4"/>
        <transition symbol="software" destination="3"/>
        <transition symbol="time" destination="2"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="2" final="1" label="time_rt">
        <transition symbol="operations" destination="4"/>
        <transition symbol="software" destination="3"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="3" final="1" label="software_rt">
        <transition symbol="operations" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="4" final="1" label="operations_rt">
        <transition symbol="note" destination="5"/>
      </state>
      <state index="5" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="elevation" type="mixed">
  </element>
    <element name="email" type="mixed">
  </element>
    <element name="equipment" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="support" destination="6"/>
        <transition symbol="lens-attachment" destination="4"/>
        <transition symbol="lens" destination="3"/>
        <transition symbol="note" destination="7"/>
        <transition symbol="body" destination="1"/>
        <transition symbol="illumination" destination="5"/>
        <transition symbol="body-attachment" destination="2"/>
      </state>
      <state index="1" final="1" label="body_rt">
        <transition symbol="support" destination="6"/>
        <transition symbol="lens-attachment" destination="4"/>
        <transition symbol="lens" destination="3"/>
        <transition symbol="illumination" destination="5"/>
        <transition symbol="note" destination="7"/>
        <transition symbol="body-attachment" destination="2"/>
      </state>
      <state index="2" final="1" label="body-attachment_rt">
        <transition symbol="support" destination="6"/>
        <transition symbol="lens-attachment" destination="4"/>
        <transition symbol="lens" destination="3"/>
        <transition symbol="illumination" destination="5"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="3" final="1" label="lens_rt">
        <transition symbol="support" destination="6"/>
        <transition symbol="lens-attachment" destination="4"/>
        <transition symbol="illumination" destination="5"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="4" final="1" label="lens-attachment_rt">
        <transition symbol="support" destination="6"/>
        <transition symbol="illumination" destination="5"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="5" final="1" label="illumination_rt">
        <transition symbol="support" destination="6"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="6" final="1" label="support_rt">
        <transition symbol="note" destination="7"/>
      </state>
      <state index="7" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="evaluation" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="artistic" destination="1"/>
        <transition symbol="technical" destination="2"/>
      </state>
      <state index="1" final="1" label="artistic_rt">
        <transition symbol="technical" destination="2"/>
      </state>
      <state index="2" final="1" label="technical_rt">
      </state>
    </fsa>
  </element>
    <element name="event" type="mixed">
  </element>
    <element name="exp-comp" type="mixed">
  </element>
    <element name="expiry" type="mixed">
  </element>
    <element name="exposure" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="mode" destination="7"/>
        <transition symbol="flash-comp" destination="5"/>
        <transition symbol="aperture" destination="1"/>
        <transition symbol="note" destination="9"/>
        <transition symbol="exp-comp" destination="3"/>
        <transition symbol="shutter" destination="2"/>
        <transition symbol="rated-speed" destination="6"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="flash" destination="4"/>
      </state>
      <state index="1" final="1" label="aperture_rt">
        <transition symbol="mode" destination="7"/>
        <transition symbol="flash-comp" destination="5"/>
        <transition symbol="note" destination="9"/>
        <transition symbol="exp-comp" destination="3"/>
        <transition symbol="shutter" destination="2"/>
        <transition symbol="rated-speed" destination="6"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="flash" destination="4"/>
      </state>
      <state index="2" final="1" label="shutter_rt">
        <transition symbol="mode" destination="7"/>
        <transition symbol="flash-comp" destination="5"/>
        <transition symbol="note" destination="9"/>
        <transition symbol="exp-comp" destination="3"/>
        <transition symbol="rated-speed" destination="6"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="flash" destination="4"/>
      </state>
      <state index="3" final="1" label="exp-comp_rt">
        <transition symbol="rated-speed" destination="6"/>
        <transition symbol="mode" destination="7"/>
        <transition symbol="flash-comp" destination="5"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="note" destination="9"/>
        <transition symbol="flash" destination="4"/>
      </state>
      <state index="4" final="1" label="flash_rt">
        <transition symbol="rated-speed" destination="6"/>
        <transition symbol="mode" destination="7"/>
        <transition symbol="flash-comp" destination="5"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="note" destination="9"/>
      </state>
      <state index="5" final="1" label="flash-comp_rt">
        <transition symbol="rated-speed" destination="6"/>
        <transition symbol="mode" destination="7"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="note" destination="9"/>
      </state>
      <state index="6" final="1" label="rated-speed_rt">
        <transition symbol="mode" destination="7"/>
        <transition symbol="metering" destination="8"/>
        <transition symbol="note" destination="9"/>
      </state>
      <state index="7" final="1" label="mode_rt">
        <transition symbol="metering" destination="8"/>
        <transition symbol="note" destination="9"/>
      </state>
      <state index="8" final="1" label="metering_rt">
        <transition symbol="note" destination="9"/>
      </state>
      <state index="9" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="fax" type="mixed">
  </element>
    <element name="file-format" type="mixed">
  </element>
    <element name="file-hash" type="mixed">
  </element>
    <element name="film" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="make" destination="1"/>
        <transition symbol="name" destination="2"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="process" destination="4"/>
        <transition symbol="format" destination="6"/>
        <transition symbol="speed" destination="3"/>
        <transition symbol="type" destination="5"/>
      </state>
      <state index="1" final="1" label="make_rt">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="name" destination="2"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="process" destination="4"/>
        <transition symbol="format" destination="6"/>
        <transition symbol="speed" destination="3"/>
        <transition symbol="type" destination="5"/>
      </state>
      <state index="2" final="1" label="name_rt">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="format" destination="6"/>
        <transition symbol="speed" destination="3"/>
        <transition symbol="type" destination="5"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="process" destination="4"/>
      </state>
      <state index="3" final="1" label="speed_rt">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="format" destination="6"/>
        <transition symbol="type" destination="5"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="process" destination="4"/>
      </state>
      <state index="4" final="1" label="process_rt">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="format" destination="6"/>
        <transition symbol="type" destination="5"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="5" final="1" label="type_rt">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="format" destination="6"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="6" final="1" label="format_rt">
        <transition symbol="expiry" destination="7"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="7" final="1" label="expiry_rt">
        <transition symbol="note" destination="8"/>
      </state>
      <state index="8" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="firmware" type="mixed">
  </element>
    <element name="flash" type="mixed">
  </element>
    <element name="flash-comp" type="mixed">
  </element>
    <element name="focal-distance" type="mixed">
  </element>
    <element name="focal-length" type="mixed">
  </element>
    <element name="focus" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="focal-length" destination="1"/>
        <transition symbol="mode" destination="3"/>
        <transition symbol="focal-distance" destination="2"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="1" final="1" label="focal-length_rt">
        <transition symbol="mode" destination="3"/>
        <transition symbol="focal-distance" destination="2"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="2" final="1" label="focal-distance_rt">
        <transition symbol="mode" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="mode_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="format" type="mixed">
  </element>
    <element name="frame" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="ipr" destination="2"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="scene" destination="3"/>
        <transition symbol="focus" destination="6"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="size" destination="7"/>
        <transition symbol="photographer" destination="1"/>
        <transition symbol="exposure" destination="5"/>
        <transition symbol="equipment" destination="4"/>
        <transition symbol="condition" destination="9"/>
        <transition symbol="evaluation" destination="8"/>
      </state>
      <state index="1" final="1" label="photographer_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="ipr" destination="2"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="scene" destination="3"/>
        <transition symbol="focus" destination="6"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="size" destination="7"/>
        <transition symbol="exposure" destination="5"/>
        <transition symbol="equipment" destination="4"/>
        <transition symbol="evaluation" destination="8"/>
        <transition symbol="condition" destination="9"/>
      </state>
      <state index="2" final="1" label="ipr_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="scene" destination="3"/>
        <transition symbol="focus" destination="6"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="size" destination="7"/>
        <transition symbol="exposure" destination="5"/>
        <transition symbol="equipment" destination="4"/>
        <transition symbol="condition" destination="9"/>
        <transition symbol="evaluation" destination="8"/>
      </state>
      <state index="3" final="1" label="scene_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="focus" destination="6"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="size" destination="7"/>
        <transition symbol="exposure" destination="5"/>
        <transition symbol="equipment" destination="4"/>
        <transition symbol="condition" destination="9"/>
        <transition symbol="evaluation" destination="8"/>
      </state>
      <state index="4" final="1" label="equipment_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="focus" destination="6"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="size" destination="7"/>
        <transition symbol="exposure" destination="5"/>
        <transition symbol="condition" destination="9"/>
        <transition symbol="evaluation" destination="8"/>
      </state>
      <state index="5" final="1" label="exposure_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="focus" destination="6"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="size" destination="7"/>
        <transition symbol="evaluation" destination="8"/>
        <transition symbol="condition" destination="9"/>
      </state>
      <state index="6" final="1" label="focus_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="condition" destination="9"/>
        <transition symbol="evaluation" destination="8"/>
        <transition symbol="size" destination="7"/>
      </state>
      <state index="7" final="1" label="size_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="condition" destination="9"/>
        <transition symbol="evaluation" destination="8"/>
      </state>
      <state index="8" final="1" label="evaluation_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="note" destination="12"/>
        <transition symbol="condition" destination="9"/>
      </state>
      <state index="9" final="1" label="condition_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="digimage" destination="10"/>
        <transition symbol="note" destination="12"/>
      </state>
      <state index="10" final="1" label="digimage_rt">
        <transition symbol="idximage" destination="11"/>
        <transition symbol="note" destination="12"/>
      </state>
      <state index="11" final="1" label="idximage_rt">
        <transition symbol="note" destination="12"/>
      </state>
      <state index="12" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="frame-set" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="frame-set" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="frame" destination="2"/>
      </state>
      <state index="1" label="defaults_rt">
        <transition symbol="frame-set" destination="3"/>
        <transition symbol="frame" destination="2"/>
      </state>
      <state index="2" final="1" label="frame_rt">
        <transition symbol="frame-set" destination="3"/>
        <transition symbol="defaults" destination="4"/>
        <transition symbol="frame" destination="2"/>
      </state>
      <state index="3" final="1" label="frame-set_rt">
        <transition symbol="frame-set" destination="3"/>
        <transition symbol="defaults" destination="4"/>
        <transition symbol="frame" destination="2"/>
      </state>
      <state index="4" final="1" label="defaults_rt">
        <transition symbol="frame-set" destination="3"/>
        <transition symbol="frame" destination="2"/>
      </state>
    </fsa>
  </element>
    <element name="genre" type="mixed">
  </element>
    <element name="geometry" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="width" destination="1"/>
      </state>
      <state index="1" label="width_rt">
        <transition symbol="height" destination="2"/>
      </state>
      <state index="2" final="1" label="height_rt">
      </state>
    </fsa>
  </element>
    <element name="hardware" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="make" destination="1"/>
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="firmware" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="1" final="1" label="make_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="firmware" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="2" final="1" label="model_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="firmware" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="3" final="1" label="serial_rt">
        <transition symbol="firmware" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="4" final="1" label="firmware_rt">
        <transition symbol="note" destination="5"/>
      </state>
      <state index="5" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="height" type="mixed">
  </element>
    <element name="history" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="editing" destination="2"/>
        <transition symbol="origin" destination="1"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="1" final="1" label="origin_rt">
        <transition symbol="editing" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="2" final="1" label="editing_rt">
        <transition symbol="editing" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="3" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="icc-profile" type="mixed">
  </element>
    <element name="idximage" type="empty">
  </element>
    <element name="illumination" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="device" destination="1"/>
      </state>
      <state index="1" final="1" label="device_rt">
        <transition symbol="device" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="2" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="image-hash" type="mixed">
  </element>
    <element name="ipr" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="owner" destination="2"/>
        <transition symbol="copyright" destination="1"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="1" final="1" label="copyright_rt">
        <transition symbol="owner" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="2" final="1" label="owner_rt">
        <transition symbol="note" destination="3"/>
      </state>
      <state index="3" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="keywords" type="mixed">
  </element>
    <element name="lab" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="name" destination="1"/>
      </state>
      <state index="1" final="1" label="name_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="address" destination="2"/>
        <transition symbol="phone" destination="3"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="2" final="1" label="address_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="phone" destination="3"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="3" final="1" label="phone_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="4" final="1" label="fax_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="5" final="1" label="email_rt">
        <transition symbol="note" destination="6"/>
      </state>
      <state index="6" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="latitude" type="mixed">
  </element>
    <element name="lens" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="make" destination="1"/>
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="1" final="1" label="make_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="model" destination="2"/>
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="2" final="1" label="model_rt">
        <transition symbol="serial" destination="3"/>
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="3" final="1" label="serial_rt">
        <transition symbol="type" destination="4"/>
        <transition symbol="note" destination="5"/>
      </state>
      <state index="4" final="1" label="type_rt">
        <transition symbol="note" destination="5"/>
      </state>
      <state index="5" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="lens-attachment" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="device" destination="1"/>
      </state>
      <state index="1" final="1" label="device_rt">
        <transition symbol="device" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="2" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="load" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="time" destination="2"/>
        <transition symbol="date" destination="1"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="1" final="1" label="date_rt">
        <transition symbol="time" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="2" final="1" label="time_rt">
        <transition symbol="note" destination="3"/>
      </state>
      <state index="3" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="location" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="district" destination="4"/>
        <transition symbol="country" destination="1"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="region" destination="2"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="subregion" destination="3"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="city" destination="5"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="subcity" destination="6"/>
      </state>
      <state index="1" final="1" label="country_rt">
        <transition symbol="district" destination="4"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="region" destination="2"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="subregion" destination="3"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="city" destination="5"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="subcity" destination="6"/>
      </state>
      <state index="2" final="1" label="region_rt">
        <transition symbol="district" destination="4"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="subregion" destination="3"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="city" destination="5"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="subcity" destination="6"/>
      </state>
      <state index="3" final="1" label="subregion_rt">
        <transition symbol="district" destination="4"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="city" destination="5"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="subcity" destination="6"/>
      </state>
      <state index="4" final="1" label="district_rt">
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="city" destination="5"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="subcity" destination="6"/>
      </state>
      <state index="5" final="1" label="city_rt">
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="subcity" destination="6"/>
      </state>
      <state index="6" final="1" label="subcity_rt">
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
        <transition symbol="direction" destination="13"/>
        <transition symbol="subsubcity" destination="7"/>
        <transition symbol="road" destination="9"/>
      </state>
      <state index="7" final="1" label="subsubcity_rt">
        <transition symbol="direction" destination="13"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="area" destination="8"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="note" destination="14"/>
      </state>
      <state index="8" final="1" label="area_rt">
        <transition symbol="direction" destination="13"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="road" destination="9"/>
        <transition symbol="note" destination="14"/>
      </state>
      <state index="9" final="1" label="road_rt">
        <transition symbol="direction" destination="13"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="place" destination="10"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
      </state>
      <state index="10" final="1" label="place_rt">
        <transition symbol="direction" destination="13"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="description" destination="11"/>
        <transition symbol="note" destination="14"/>
      </state>
      <state index="11" final="1" label="description_rt">
        <transition symbol="direction" destination="13"/>
        <transition symbol="coordinates" destination="12"/>
        <transition symbol="note" destination="14"/>
      </state>
      <state index="12" final="1" label="coordinates_rt">
        <transition symbol="direction" destination="13"/>
        <transition symbol="note" destination="14"/>
      </state>
      <state index="13" final="1" label="direction_rt">
        <transition symbol="note" destination="14"/>
      </state>
      <state index="14" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="longitude" type="mixed">
  </element>
    <element name="make" type="mixed">
  </element>
    <element name="metering" type="mixed">
  </element>
    <element name="method" type="mixed">
  </element>
    <element name="mode" type="mixed">
  </element>
    <element name="model" type="mixed">
  </element>
    <element name="name" type="mixed">
  </element>
    <element name="note" type="mixed">
  </element>
    <element name="object" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="name" destination="1"/>
        <transition symbol="address" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="1" final="1" label="name_rt">
        <transition symbol="address" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="2" final="1" label="address_rt">
        <transition symbol="note" destination="3"/>
      </state>
      <state index="3" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="occasion" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="time" destination="2"/>
        <transition symbol="date" destination="1"/>
        <transition symbol="event" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="1" final="1" label="date_rt">
        <transition symbol="time" destination="2"/>
        <transition symbol="event" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="2" final="1" label="time_rt">
        <transition symbol="event" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="event_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="operation" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="description" destination="1"/>
        <transition symbol="note" destination="4"/>
        <transition symbol="command" destination="2"/>
        <transition symbol="settings" destination="3"/>
      </state>
      <state index="1" final="1" label="description_rt">
        <transition symbol="note" destination="4"/>
        <transition symbol="settings" destination="3"/>
        <transition symbol="command" destination="2"/>
      </state>
      <state index="2" final="1" label="command_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="settings_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="operations" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="operation" destination="1"/>
      </state>
      <state index="1" final="1" label="operation_rt">
        <transition symbol="operation" destination="1"/>
      </state>
    </fsa>
  </element>
    <element name="origin" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="source" destination="5"/>
        <transition symbol="time" destination="2"/>
        <transition symbol="date" destination="1"/>
        <transition symbol="scanner" destination="3"/>
        <transition symbol="camera" destination="4"/>
      </state>
      <state index="1" final="1" label="date_rt">
        <transition symbol="time" destination="2"/>
        <transition symbol="scanner" destination="3"/>
        <transition symbol="camera" destination="4"/>
      </state>
      <state index="2" final="1" label="time_rt">
        <transition symbol="camera" destination="4"/>
        <transition symbol="scanner" destination="3"/>
      </state>
      <state index="3" final="1" label="scanner_rt">
      </state>
      <state index="4" final="1" label="camera_rt">
      </state>
      <state index="5" final="1" label="source_rt">
        <transition symbol="source" destination="5"/>
      </state>
    </fsa>
  </element>
    <element name="owner" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="name" destination="1"/>
      </state>
      <state index="1" final="1" label="name_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="address" destination="2"/>
        <transition symbol="phone" destination="3"/>
      </state>
      <state index="2" final="1" label="address_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="phone" destination="3"/>
      </state>
      <state index="3" final="1" label="phone_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
      </state>
      <state index="4" final="1" label="fax_rt">
        <transition symbol="email" destination="5"/>
      </state>
      <state index="5" final="1" label="email_rt">
      </state>
    </fsa>
  </element>
    <element name="person" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="name" destination="1"/>
      </state>
      <state index="1" final="1" label="name_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="address" destination="2"/>
        <transition symbol="phone" destination="3"/>
      </state>
      <state index="2" final="1" label="address_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="phone" destination="3"/>
      </state>
      <state index="3" final="1" label="phone_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
      </state>
      <state index="4" final="1" label="fax_rt">
        <transition symbol="email" destination="5"/>
      </state>
      <state index="5" final="1" label="email_rt">
      </state>
    </fsa>
  </element>
    <element name="phone" type="mixed">
  </element>
    <element name="photo" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="roll" destination="2"/>
      </state>
      <state index="1" label="defaults_rt">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="roll" destination="2"/>
      </state>
      <state index="2" final="1" label="roll_rt">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="roll" destination="2"/>
      </state>
      <state index="3" final="1" label="sheet_rt">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="roll" destination="2"/>
      </state>
      <state index="4" final="1" label="digital_rt">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="roll" destination="2"/>
      </state>
      <state index="5" final="1" label="digimage_rt">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="roll" destination="2"/>
      </state>
      <state index="6" final="1" label="digimage-set_rt">
        <transition symbol="digital" destination="4"/>
        <transition symbol="digimage-set" destination="6"/>
        <transition symbol="digimage" destination="5"/>
        <transition symbol="sheet" destination="3"/>
        <transition symbol="defaults" destination="1"/>
        <transition symbol="roll" destination="2"/>
      </state>
    </fsa>
  </element>
    <element name="photographer" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="name" destination="1"/>
      </state>
      <state index="1" final="1" label="name_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="address" destination="2"/>
        <transition symbol="phone" destination="3"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="2" final="1" label="address_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="phone" destination="3"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="3" final="1" label="phone_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="fax" destination="4"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="4" final="1" label="fax_rt">
        <transition symbol="email" destination="5"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="5" final="1" label="email_rt">
        <transition symbol="note" destination="6"/>
      </state>
      <state index="6" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="place" type="mixed">
  </element>
    <element name="process" type="mixed">
  </element>
    <element name="processing" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="time" destination="4"/>
        <transition symbol="date" destination="3"/>
        <transition symbol="lab" destination="1"/>
        <transition symbol="developing" destination="5"/>
        <transition symbol="tag" destination="2"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="1" final="1" label="lab_rt">
        <transition symbol="time" destination="4"/>
        <transition symbol="date" destination="3"/>
        <transition symbol="developing" destination="5"/>
        <transition symbol="tag" destination="2"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="2" final="1" label="tag_rt">
        <transition symbol="time" destination="4"/>
        <transition symbol="date" destination="3"/>
        <transition symbol="developing" destination="5"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="3" final="1" label="date_rt">
        <transition symbol="time" destination="4"/>
        <transition symbol="developing" destination="5"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="4" final="1" label="time_rt">
        <transition symbol="developing" destination="5"/>
        <transition symbol="note" destination="6"/>
      </state>
      <state index="5" final="1" label="developing_rt">
        <transition symbol="note" destination="6"/>
      </state>
      <state index="6" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="properties" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="image-hash" destination="6"/>
        <transition symbol="icc-profile" destination="4"/>
        <transition symbol="bit-depth" destination="2"/>
        <transition symbol="file-format" destination="3"/>
        <transition symbol="note" destination="7"/>
        <transition symbol="file-hash" destination="5"/>
        <transition symbol="geometry" destination="1"/>
      </state>
      <state index="1" final="1" label="geometry_rt">
        <transition symbol="image-hash" destination="6"/>
        <transition symbol="icc-profile" destination="4"/>
        <transition symbol="bit-depth" destination="2"/>
        <transition symbol="file-format" destination="3"/>
        <transition symbol="file-hash" destination="5"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="2" final="1" label="bit-depth_rt">
        <transition symbol="image-hash" destination="6"/>
        <transition symbol="icc-profile" destination="4"/>
        <transition symbol="file-format" destination="3"/>
        <transition symbol="note" destination="7"/>
        <transition symbol="file-hash" destination="5"/>
      </state>
      <state index="3" final="1" label="file-format_rt">
        <transition symbol="image-hash" destination="6"/>
        <transition symbol="icc-profile" destination="4"/>
        <transition symbol="note" destination="7"/>
        <transition symbol="file-hash" destination="5"/>
      </state>
      <state index="4" final="1" label="icc-profile_rt">
        <transition symbol="image-hash" destination="6"/>
        <transition symbol="note" destination="7"/>
        <transition symbol="file-hash" destination="5"/>
      </state>
      <state index="5" final="1" label="file-hash_rt">
        <transition symbol="image-hash" destination="6"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="6" final="1" label="image-hash_rt">
        <transition symbol="note" destination="7"/>
      </state>
      <state index="7" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="publisher" type="mixed">
  </element>
    <element name="rated-speed" type="mixed">
  </element>
    <element name="region" type="mixed">
  </element>
    <element name="road" type="mixed">
  </element>
    <element name="roll" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="collection" destination="1"/>
        <transition symbol="description" destination="2"/>
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="film" destination="3"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="processing" destination="4"/>
      </state>
      <state index="1" label="collection_rt">
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="collection" destination="1"/>
        <transition symbol="description" destination="2"/>
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="film" destination="3"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="processing" destination="4"/>
      </state>
      <state index="2" label="description_rt">
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="film" destination="3"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="processing" destination="4"/>
      </state>
      <state index="3" label="film_rt">
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="processing" destination="4"/>
      </state>
      <state index="4" label="processing_rt">
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="load" destination="5"/>
      </state>
      <state index="5" label="load_rt">
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
      </state>
      <state index="6" label="defaults_rt">
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="frame" destination="7"/>
      </state>
      <state index="7" final="1" label="frame_rt">
        <transition symbol="unload" destination="9"/>
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="note" destination="10"/>
      </state>
      <state index="8" final="1" label="frame-set_rt">
        <transition symbol="unload" destination="9"/>
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="note" destination="10"/>
      </state>
      <state index="9" final="1" label="unload_rt">
        <transition symbol="frame-set" destination="8"/>
        <transition symbol="defaults" destination="6"/>
        <transition symbol="frame" destination="7"/>
        <transition symbol="load" destination="5"/>
        <transition symbol="note" destination="10"/>
      </state>
      <state index="10" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="scanner" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="software" destination="2"/>
        <transition symbol="hardware" destination="1"/>
        <transition symbol="note" destination="4"/>
        <transition symbol="settings" destination="3"/>
      </state>
      <state index="1" final="1" label="hardware_rt">
        <transition symbol="software" destination="2"/>
        <transition symbol="note" destination="4"/>
        <transition symbol="settings" destination="3"/>
      </state>
      <state index="2" final="1" label="software_rt">
        <transition symbol="note" destination="4"/>
        <transition symbol="settings" destination="3"/>
      </state>
      <state index="3" final="1" label="settings_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="scene" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="location" destination="2"/>
        <transition symbol="content" destination="7"/>
        <transition symbol="description" destination="3"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="genre" destination="5"/>
        <transition symbol="keywords" destination="6"/>
        <transition symbol="caption" destination="4"/>
        <transition symbol="occasion" destination="1"/>
      </state>
      <state index="1" final="1" label="occasion_rt">
        <transition symbol="location" destination="2"/>
        <transition symbol="content" destination="7"/>
        <transition symbol="description" destination="3"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="genre" destination="5"/>
        <transition symbol="keywords" destination="6"/>
        <transition symbol="caption" destination="4"/>
      </state>
      <state index="2" final="1" label="location_rt">
        <transition symbol="keywords" destination="6"/>
        <transition symbol="caption" destination="4"/>
        <transition symbol="content" destination="7"/>
        <transition symbol="description" destination="3"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="genre" destination="5"/>
      </state>
      <state index="3" final="1" label="description_rt">
        <transition symbol="keywords" destination="6"/>
        <transition symbol="caption" destination="4"/>
        <transition symbol="content" destination="7"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="genre" destination="5"/>
      </state>
      <state index="4" final="1" label="caption_rt">
        <transition symbol="keywords" destination="6"/>
        <transition symbol="content" destination="7"/>
        <transition symbol="note" destination="8"/>
        <transition symbol="genre" destination="5"/>
      </state>
      <state index="5" final="1" label="genre_rt">
        <transition symbol="keywords" destination="6"/>
        <transition symbol="content" destination="7"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="6" final="1" label="keywords_rt">
        <transition symbol="content" destination="7"/>
        <transition symbol="note" destination="8"/>
      </state>
      <state index="7" final="1" label="content_rt">
        <transition symbol="note" destination="8"/>
      </state>
      <state index="8" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="segment" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="object" destination="3"/>
        <transition symbol="person" destination="2"/>
        <transition symbol="segment" destination="1"/>
      </state>
      <state index="1" final="1" label="segment_rt">
        <transition symbol="object" destination="3"/>
        <transition symbol="person" destination="2"/>
        <transition symbol="segment" destination="1"/>
      </state>
      <state index="2" final="1" label="person_rt">
        <transition symbol="object" destination="3"/>
        <transition symbol="person" destination="2"/>
        <transition symbol="segment" destination="1"/>
      </state>
      <state index="3" final="1" label="object_rt">
        <transition symbol="object" destination="3"/>
        <transition symbol="person" destination="2"/>
        <transition symbol="segment" destination="1"/>
      </state>
    </fsa>
  </element>
    <element name="serial" type="mixed">
  </element>
    <element name="setting" type="mixed">
  </element>
    <element name="settings" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="setting" destination="1"/>
      </state>
      <state index="1" final="1" label="setting_rt">
        <transition symbol="setting" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="2" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="sheet" type="element">
    <fsa>
      <state index="0" label="Initial">
        <transition symbol="film" destination="2"/>
        <transition symbol="frame" destination="5"/>
        <transition symbol="collection" destination="1"/>
        <transition symbol="load" destination="4"/>
        <transition symbol="processing" destination="3"/>
      </state>
      <state index="1" label="collection_rt">
        <transition symbol="film" destination="2"/>
        <transition symbol="frame" destination="5"/>
        <transition symbol="collection" destination="1"/>
        <transition symbol="load" destination="4"/>
        <transition symbol="processing" destination="3"/>
      </state>
      <state index="2" label="film_rt">
        <transition symbol="frame" destination="5"/>
        <transition symbol="load" destination="4"/>
        <transition symbol="processing" destination="3"/>
      </state>
      <state index="3" label="processing_rt">
        <transition symbol="frame" destination="5"/>
        <transition symbol="load" destination="4"/>
      </state>
      <state index="4" label="load_rt">
        <transition symbol="frame" destination="5"/>
      </state>
      <state index="5" final="1" label="frame_rt">
        <transition symbol="unload" destination="6"/>
        <transition symbol="note" destination="7"/>
      </state>
      <state index="6" final="1" label="unload_rt">
        <transition symbol="note" destination="7"/>
      </state>
      <state index="7" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="shift" type="mixed">
  </element>
    <element name="shutter" type="mixed">
  </element>
    <element name="size" type="mixed">
  </element>
    <element name="software" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="version" destination="3"/>
        <transition symbol="name" destination="2"/>
        <transition symbol="publisher" destination="1"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="1" final="1" label="publisher_rt">
        <transition symbol="version" destination="3"/>
        <transition symbol="name" destination="2"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="2" final="1" label="name_rt">
        <transition symbol="version" destination="3"/>
        <transition symbol="note" destination="4"/>
      </state>
      <state index="3" final="1" label="version_rt">
        <transition symbol="note" destination="4"/>
      </state>
      <state index="4" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="source" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="image-hash" destination="2"/>
        <transition symbol="file-hash" destination="1"/>
      </state>
      <state index="1" final="1" label="file-hash_rt">
        <transition symbol="image-hash" destination="2"/>
      </state>
      <state index="2" final="1" label="image-hash_rt">
      </state>
    </fsa>
  </element>
    <element name="speed" type="mixed">
  </element>
    <element name="subcity" type="mixed">
  </element>
    <element name="subregion" type="mixed">
  </element>
    <element name="subsubcity" type="mixed">
  </element>
    <element name="support" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="device" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="1" final="1" label="device_rt">
        <transition symbol="device" destination="1"/>
        <transition symbol="note" destination="2"/>
      </state>
      <state index="2" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="tag" type="mixed">
  </element>
    <element name="technical" type="mixed">
  </element>
    <element name="temperature" type="mixed">
  </element>
    <element name="time" type="mixed">
  </element>
    <element name="type" type="mixed">
  </element>
    <element name="unload" type="element">
    <fsa>
      <state index="0" final="1" label="Initial">
        <transition symbol="time" destination="2"/>
        <transition symbol="date" destination="1"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="1" final="1" label="date_rt">
        <transition symbol="time" destination="2"/>
        <transition symbol="note" destination="3"/>
      </state>
      <state index="2" final="1" label="time_rt">
        <transition symbol="note" destination="3"/>
      </state>
      <state index="3" final="1" label="note_rt">
      </state>
    </fsa>
  </element>
    <element name="version" type="mixed">
  </element>
    <element name="width" type="mixed">
  </element>
  </vldt:dtdvalidate>

</xsl:stylesheet>
