Determine whether defaults are correctly combined in merge mode


XML for defaults expansion follows:
===def

<photo>

  <roll id="2001-01">
    
    <defaults>
      <frame>
	<scene>
	  <location>
	    <country>the-country</country>
            <road>the-street</road>
	  </location>
	</scene>
      </frame>
    </defaults>

    <frame id="01">
      <scene>
	<occasion>
	  <date>2001-01-02</date>
	</occasion>
      </scene>
    </frame>

    <defaults combine="merge">
      <frame>
	<scene>
	  <location>
	    <description>location-description</description>
	  </location>
	</scene>
      </frame>
    </defaults>

    <frame id="02">
      <scene>
	<occasion>
	  <date>2001-01-02</date>
	</occasion>
      </scene>
    </frame>

  </roll>
</photo>

===def

Expanded reference XML follows:
===ref

<photo>

  <roll id="2001-01">



    <frame id="01">
      <scene>
        <occasion>
          <date>2001-01-02</date>
        </occasion>
        <location>
            <country>the-country</country>
            <road>the-street</road>
          </location>
      </scene>
    </frame>



    <frame id="02">
      <scene>
        <occasion>
          <date>2001-01-02</date>
        </occasion>
        <location>
          <country>the-country</country>
	  <road>the-street</road>
          <description>location-description</description>
        </location>
      </scene>
    </frame>

  </roll>
</photo>

===ref
