<?php
/**
*
* common [Bulgarian]
*
* @package language
* @version $Id: common.php 9464 2009-04-17 15:52:40Z nacholibre $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
    'TRANSLATION_INFO'  => '<a href="http://papagal.bg">Хостинг и Домейни</a>',
    'DIRECTION'         => 'ltr',
    'DATE_FORMAT'       => '|d M Y|',    // 01 Jan 2007 (with Relative days enabled)
    'USER_LANG'         => 'bg',

    '1_DAY'         => '1 ден',
    '1_MONTH'       => '1 месец',
    '1_YEAR'        => '1 година',
    '2_WEEKS'       => '2 седмици',
    '3_MONTHS'      => '3 месеца',
    '6_MONTHS'      => '6 месеца',
    '7_DAYS'        => '7 дни',

    'ACCOUNT_ALREADY_ACTIVATED'     => 'Акаунта Ви вече е активиран',
    'ACCOUNT_DEACTIVATED'			=> 'Акаунта Ви беше ръчно спрян, само администратор може да го пусне отново.',
	'ACCOUNT_NOT_ACTIVATED'         => 'Акаунта Ви още не е активиран',
    'ACP'                           => 'Администраторски Панел',
    'ACTIVE'                        => 'Активно',
    'ACTIVE_ERROR'                  => 'Активирайте акаунта си и опитайте отново. Ако не можете да решите проблема свържете се с администратора на форума.',
    'ADMINISTRATOR'                 => 'Администратор',
    'ADMINISTRATORS'                => 'Администратори',
    'AGE'                           => 'Години',
    'AIM'                           => 'AIM',
    'ALLOWED'                       => 'Позволено',
    'ALL_FILES'                     => 'Всички файлове',
    'ALL_FORUMS'                    => 'Всички форуми',
    'ALL_MESSAGES'                  => 'Всички съобщения',
    'ALL_POSTS'                     => 'Всички мнения',
    'ALL_TIMES'                     => 'Часовете са според зоната %1$s %2$s',
    'ALL_TOPICS'                    => 'Всички теми',
    'AND'                           => 'и',
    'ARE_WATCHING_FORUM'            => 'Вие се абонирахте за форума.',
    'ARE_WATCHING_TOPIC'            => 'Вие се абонирахте за темата.',
    'ASCENDING'                     => 'Възходящ',
    'ATTACHMENTS'                   => 'Прикачени файлове',
    'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Изображението което се опитвате да прикачите е невалидно.',
	'AUTHOR'                        => 'Автор',
    'AUTH_NO_PROFILE_CREATED'       => 'Грешка при създаване на потребител',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Каченият файл е отхвърлен, защото може да представлява заплаха.',
    'AVATAR_DISALLOWED_EXTENSION'   => 'Разширението %s не е позволено',
    'AVATAR_EMPTY_REMOTE_DATA'      => 'Аватара не може да бъде качен.',
    'AVATAR_EMPTY_FILEUPLOAD'		=> 'Качения аватар е презен.',
	'AVATAR_INVALID_FILENAME'       => '%s е невалидно име на файл',
    'AVATAR_NOT_UPLOADED'           => 'Аватара не може да бъде качен.',
    'AVATAR_NO_SIZE'                => 'Височината или широчината на аватара не могат да бъдат засечени, въведете ги ръчно.',
    'AVATAR_PARTIAL_UPLOAD'         => 'Файла беше качен частично.',
    'AVATAR_PHP_SIZE_NA'            => 'Аватара е прекалено голям.<br />За промяна вижте php.ini.',
    'AVATAR_PHP_SIZE_OVERRUN'       => 'Аватара е прекалено голям, максималния размер е %d MB.<br />За промяна вижте php.ini.',
    'AVATAR_URL_INVALID'            => 'URL адреса е невалиден.',
    'AVATAR_URL_NOT_FOUND'          => 'Файла не може да бъде открит.',
    'AVATAR_WRONG_FILESIZE'         => 'Аватара трябва да е м/у 0 и %1d %2s.',
    'AVATAR_WRONG_SIZE'             => 'Аватара трябва да е поне %1$d пиксела широк, %2$d пиксела висок и най-много %3$d пиксела широк и %4$d пиксела висок. Изпратения аватар е %5$d пиксела широк и %6$d пиксела висок.',

    'BACK_TO_TOP'           => 'Върнете се в началото',
    'BACK_TO_PREV'          => 'Обратно към предишната страница',
    'BAN_TRIGGERED_BY_EMAIL'=> 'Бан по email адрес.',
    'BAN_TRIGGERED_BY_IP'   => 'Бан по IP адрес.',
    'BAN_TRIGGERED_BY_USER' => 'Бан по потребителско име.',
    'BBCODE_GUIDE'          => 'BBCode ръководство',
    'BCC'                   => 'Копие до',
    'BIRTHDAYS'             => 'Рожденници',
    'BOARD_BAN_PERM'        => 'Вие сте <strong>перманентно</strong> изгонен от този форум.<br /><br />Моля свържете се с %2$sадминистратора%3$s за повече информация.',
    'BOARD_BAN_REASON'      => 'Причина: <strong>%s</strong>',
    'BOARD_BAN_TIME'        => 'Вие сте изгонен от този форум до <strong>%1$s</strong>.<br /><br />Моля свържете се с %2$sадминистратора%3$s за повече информация.',
    'BOARD_DISABLE'         => 'Затворено за профилактика! Моля опитайте по-късно!',
    'BOARD_DISABLED'        => 'Форума е изключен',
    'BOARD_UNAVAILABLE'     => 'Форума е недостъпен, опитайте пак след няколко минути',
	'BROWSING_FORUM'		=> 'Потребители разглеждащи този форум: %1$s',
    'BROWSING_FORUM_GUEST'  => 'Потребители разглеждащи този форум: %1$s и %2$d госта',
    'BROWSING_FORUM_GUESTS' => 'Потребители разглеждащи този форум: %1$s и %2$d госта',
    'BYTES'                 => 'Байта',

    'CANCEL'                => 'Откажи',
    'CHANGE'                => 'Промени',
    'CHANGE_FONT_SIZE'      => 'Смени големината на шрифта',
    'CHANGING_PREFERENCES'  => 'Конфигурация на форума',
    'CHANGING_PROFILE'      => 'Промяна на профил',
    'CLICK_VIEW_PRIVMSG'    => '%sОтиди във входящата поща%s',
	'COLLAPSE_VIEW'			=> 'Прегледай отворено',
    'CLOSE_WINDOW'          => 'Затвори',
    'COLOUR_SWATCH'         => 'Палитра',
    'COMMA_SEPARATOR'       => ', ',    // Used in pagination and secret yet-to-be-release style, use localised comma if appropiate, eg: Ideographic or Arabic
    'CONFIRM'               => 'Потвърди',
    'CONFIRM_CODE'          => 'Код за потвърждение',
    'CONFIRM_CODE_EXPLAIN'  => 'Въведете кода от изображението.',
    'CONFIRM_CODE_WRONG'    => 'Кода е въведен погрешно.',
    'CONFIRM_OPERATION'     => 'Сигурен ли сте?',
    'CONGRATULATIONS'       => 'Поздравления',
    'CONNECTION_FAILED'     => 'Връзката неуспешна',
    'CONNECTION_SUCCESS'    => 'Връзката успешна!',
    'COOKIES_DELETED'       => 'Бисквитките са успешно изтрити.',
    'CURRENT_TIME'          => 'Дата и час: %s',

    'DAY'                   => 'Ден',
    'DAYS'                  => 'Дни',
    'DELETE'                => 'Изтрий',
    'DELETE_ALL'            => 'Изтрий всички',
    'DELETE_COOKIES'        => 'Изтрий всички бисквитки',
    'DELETE_MARKED'         => 'Изтрий маркираните',
    'DELETE_POST'           => 'Изтрий мнение',
    'DELIMITER'             => 'Делимитирай',
    'DESCENDING'            => 'Низходящ',
    'DISABLED'              => 'Изключено',
    'DISPLAY'               => 'Покажи',
    'DISPLAY_GUESTS'        => 'Покажи гости',
    'DISPLAY_MESSAGES'      => 'Покажи съобщенията от миналия',
    'DISPLAY_POSTS'         => 'Покажи мненията от миналия',
    'DISPLAY_TOPICS'        => 'Покажи темите от миналия',
    'DOWNLOADED'            => 'Свалено',
    'DOWNLOADING_FILE'      => 'Сваляне на файл',
    'DOWNLOAD_COUNT'        => '%d пъти',
    'DOWNLOAD_COUNTS'       => '%d пъти',
    'DOWNLOAD_COUNT_NONE'	=> 'Все още не е свалено',
	'VIEWED_COUNT'			=> 'Прегледано %d път',
	'VIEWED_COUNTS'			=> 'Прегледано %d пъти',
	'VIEWED_COUNT_NONE'		=> 'Все още не е преглеждано',

    'EDIT_POST'                         => 'Промени мнение',
    'EMAIL'                             => 'Email',
    'EMAIL_ADDRESS'                     => 'Email адрес',
    'EMAIL_SMTP_ERROR_RESPONSE'         => 'Проблем при изпращането на email <strong>Ред %1$s</strong>. Отговор: %2$s',
    'EMPTY_SUBJECT'                     => 'Трябва да въведете заглавие при пускане на нова тема.',
    'EMPTY_MESSAGE_SUBJECT'				=> 'Трябва да въведете заглавие.',
	'ENABLED'                           => 'Включено',
    'ENCLOSURE'                         => 'Ограждане',
    'ERR_CHANGING_DIRECTORY'            => 'Не мога да променя директорията',
    'ERR_CONNECTING_SERVER'             => 'Грешка при връзка със сървъра',
    'ERR_JAB_AUTH'                      => 'Не мога да се оторизирам в Jabber сървъра.',
    'ERR_JAB_CONNECT'                   => 'Не мога да се свържа към Jabber сървъра.',
    'ERR_UNABLE_TO_LOGIN'               => 'Грешка при вход. Името или паролата са грешни.',
	'ERR_UNWATCHING'					=> 'Грешка при опит за отписване от бюлетина.',
	'ERR_WATCHING'						=> 'Грешка при опит за абонамент.',
    'ERR_WRONG_PATH_TO_PHPBB'           => 'Пътя до phpBB форума е невалиден.',
    'EXPAND_VIEW'                       => 'Разгърни',
    'EXTENSION'                         => 'Разширение',
    'EXTENSION_DISABLED_AFTER_POSTING'  => 'Разширението <strong>%s</strong> беше деактивирано',

    'FAQ'                   => 'Въпроси/Отговори',
    'FAQ_EXPLAIN'           => 'Често задавани въпроси',
    'FILENAME'              => 'Име на файл',
    'FILESIZE'              => 'Размер на файл',
    'FILEDATE'              => 'Дата на файл',
    'FILE_COMMENT'          => 'Коментар на файл',
    'FILE_NOT_FOUND'        => 'Искания файл не може да бъде намерен',
    'FIND_USERNAME'         => 'Намери потребител',
    'FOLDER'                => 'Папка',
    'FORGOT_PASS'           => 'Забравих си паролата',
	'FORM_INVALID'          => 'Изпратената форма е невалидна, опитайте отново.',
    'FORUM'                 => 'Форум',
    'FORUMS'                => 'Форуми',
    'FORUMS_MARKED'         => 'Форумите са маркирани като прочетени',
    'FORUM_CAT'             => 'Форум категория',
    'FORUM_INDEX'           => 'Начало форум',
    'FORUM_LINK'            => 'Форум връзка',
    'FORUM_LOCATION'        => 'Форум място',
    'FORUM_LOCKED'          => 'Заключен форум',
    'FORUM_RULES'           => 'Правила на форума',
    'FORUM_RULES_LINK'      => 'Натиснете за да видите правилата',
    'FROM'                  => 'от',
    'FSOCK_DISABLED'        => 'Fsock функциите са изключени, операцията не може да бъде изпълнена.',

    'FTP_FSOCK_HOST'                => 'FTP host',
    'FTP_FSOCK_HOST_EXPLAIN'        => 'FTP сървър',
    'FTP_FSOCK_PASSWORD'            => 'FTP парола',
	'PIXEL'					=> 'px',
    'FTP_FSOCK_PASSWORD_EXPLAIN'    => 'Парола за FTP',
    'FTP_FSOCK_PORT'                => 'FTP порт',
    'FTP_FSOCK_PORT_EXPLAIN'        => 'Порт използван за връзка към вашия сървър',
    'FTP_FSOCK_ROOT_PATH'           => 'Път до phpBB',
    'FTP_FSOCK_ROOT_PATH_EXPLAIN'   => 'Път от root до phpBB board',
    'FTP_FSOCK_TIMEOUT'             => 'FTP timeout',
    'FTP_FSOCK_TIMEOUT_EXPLAIN'     => 'Времето за което системата чака за отговор.',
    'FTP_FSOCK_USERNAME'            => 'FTP потребителско име',
    'FTP_FSOCK_USERNAME_EXPLAIN'    => 'Потребителското име което се използва за връзка.',

    'FTP_HOST'                  => 'FTP хост',
    'FTP_HOST_EXPLAIN'          => 'FTP сървър използван за връзка към вашия сайт.',
    'FTP_PASSWORD'              => 'FTP парола',
    'FTP_PASSWORD_EXPLAIN'      => 'Парола за FTP',
    'FTP_PORT'                  => 'FTP порт',
    'FTP_PORT_EXPLAIN'          => 'Порт използван за връзка към вашия сървър',
    'FTP_ROOT_PATH'             => 'Път до phpBB',
    'FTP_ROOT_PATH_EXPLAIN'     => 'Път от root до phpBB board',
    'FTP_TIMEOUT'               => 'FTP timeout',
    'FTP_TIMEOUT_EXPLAIN'       => 'Времето за което системата чака за отговор.',
    'FTP_USERNAME'              => 'FTP потребителско име',
    'FTP_USERNAME_EXPLAIN'      => 'Потребителското име което се използва за връзка.',

    'GENERAL_ERROR'				=> 'Главна грешка',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'                        => 'Давай',
    'GOTO_PAGE'                 => 'Отиди на страница',
    'GROUP'                     => 'Група',
    'GROUPS'                    => 'Групи',
    'GROUP_ERR_TYPE'            => 'Неподходящ тип на групата.',
    'GROUP_ERR_USERNAME'        => 'Не е избрано име на групата.',
    'GROUP_ERR_USER_LONG'       => 'Името на групата е прекалено дълго.',
    'GUEST'                     => 'Гост',
    'GUEST_USERS_ONLINE'        => 'Има %d госта на линия',
    'GUEST_USERS_TOTAL'         => '%d гости',
    'GUEST_USERS_ZERO_ONLINE'   => 'Няма гости на линия',
    'GUEST_USERS_ZERO_TOTAL'    => '0 гости',
    'GUEST_USER_ONLINE'         => 'Има %d гости потребители на линия',
    'GUEST_USER_TOTAL'          => '%d гости',
    'G_ADMINISTRATORS'          => 'Администратори',
    'G_BOTS'                    => 'Ботове',
    'G_GUESTS'                  => 'Гости',
    'G_REGISTERED'              => 'Регистрирани потребители',
    'G_REGISTERED_COPPA'        => 'Регистрирани COPPA потребители',
    'G_GLOBAL_MODERATORS'       => 'Глобални модератори',
	'G_NEWLY_REGISTERED'		=> 'Новорегистрирани потребители',

    'HIDDEN_USERS_ONLINE'       => '%d скрити',
    'HIDDEN_USERS_TOTAL'        => '%d скрити',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d скрити и ',
    'HIDDEN_USERS_ZERO_ONLINE'  => '0 скрити потребители на линия',
    'HIDDEN_USERS_ZERO_TOTAL'   => '0 скрити и ',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 скрити и ',
    'HIDDEN_USER_ONLINE'        => '%d скрити потребители на линия',
    'HIDDEN_USER_TOTAL'         => '%d скрити',
	'HIDDEN_USER_TOTAL_AND'			=> '%d скрити и ',
    'HIDE_GUESTS'               => 'Скрий гостите',
    'HIDE_ME'                   => 'Скрий ме',
    'HOURS'                     => 'Часа',
    'HOME'                      => 'Начало',

    'ICQ'                        => 'ICQ',
    'ICQ_STATUS'                => 'ICQ статус',    
    'IF'                        => 'ако',
    'IMAGE'                        => 'Изображение',
    'IMAGE_FILETYPE_INVALID'    => 'Изображението за %d mimetype %s не се поддържа.',
    'IMAGE_FILETYPE_MISMATCH'    => 'Грешка: очаквано разширение %1$s, настоящо %2$s.',
    'IN'                        => 'в',
    'INDEX'                        => 'Начало',
    'INFORMATION'                => 'Информация',
    'INTERESTS'                    => 'Интереси',
    'INVALID_DIGEST_CHALLENGE'    => 'Грешка',
    'INVALID_EMAIL_LOG'            => '<strong>%s</strong> е невалиден email адрес?',
    'IP'                        => 'IP',
    'IP_BLACKLISTED'            => 'Вашия IP адрес %1$s е блокиран. За повече информация <a href="%2$s">%2$s</a>.',

    'JABBER'                => 'Jabber',
    'JOINED'                => 'Регистриран на',
    'JUMP_PAGE'                => 'Номер на страница',
    'JUMP_TO'                => 'Иди на',
    'JUMP_TO_PAGE'            => 'Натисни за да отидеш на страница…',

    'KB'                    => 'KB',
	'KIB'					=> 'KiB',

    'LAST_POST'                            => '&nbsp;Последно мнение',
    'LAST_UPDATED'                        => 'Последна промяна',
    'LAST_VISIT'                        => 'Последно посещение',
    'LDAP_NO_LDAP_EXTENSION'            => 'LDAP разширението не е валидно',
    'LDAP_NO_SERVER_CONNECTION'            => 'Грешка при връзка с LDAP сървъра',
	'LDAP_SEARCH_FAILED'            => 'Грешка при опит за търсене на LDAP директорията.',
    'LEGEND'                            => 'Легенда',
    'LOCATION'                            => 'Местоположение',
    'LOCK_POST'                            => 'Заключи мнението',
    'LOCK_POST_EXPLAIN'                    => 'Избегни промяна',
    'LOCK_TOPIC'                        => 'Заключи темата',
    'LOGIN'                                => 'Влез',
    'LOGIN_CHECK_PM'                    => 'Влезте за да видите съобщенията',
    'LOGIN_CONFIRMATION'                => 'Потвърждение за вход',
    'LOGIN_CONFIRM_EXPLAIN'                => 'За да се предотврати регистрирането на ботове, администратора изисква кодово потвърждение. Кода е показан на изображението долу. Ако по някаква причина не можете да видите изображението, моля свържете се с %sадминистратора%s.',
    'LOGIN_ERROR_ATTEMPTS'                => 'Вие достигнахте максималните опити за вход. Вече ще трябва да въвеждате код за потвърждение.',
    'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'    => 'Apache грешка.',
    'LOGIN_ERROR_PASSWORD'                => 'Паролата е грешна. Проверете паролата и опитайте отново. Ако не можете да решите проблема се свържете с %sадминистратора%s.',
    'LOGIN_ERROR_PASSWORD_CONVERT'        => 'Когато се обновяваше форума старата парола не можете да бъде запазена. Трябва да %sпоискате нова парола%s. Ако и след това имате проблеми свържете се с %sАдминистратора%s.',
	'LOGIN_ERROR_USERNAME'                => 'Потребителското име е грешно. Проверете името и опитайте отново. Ако не можете да решите проблема се свържете с %sадминистратора%s.',
    'LOGIN_FORUM'                        => 'За да видите/пишете в този форума трябва да въведете парола.',
    'LOGIN_INFO'                        => 'За да влизате като потребител, е необходимо да се регистрирате. Регистрирането отнема няколко минути, но регистрираните потребители могат да имат допълнителни права и възможности. Преди да влезете, прочетете внимателно всички правила и изисквания за участие.',
    'LOGIN_VIEWFORUM'                    => 'Администратора изисква да сте регистриран и влязъл в акаунта си за да виждате този форум.',
    'LOGIN_EXPLAIN_EDIT'                => 'За да променяте мнения трябва да бъдете регистриран и влязъл в акаунта си.',
    'LOGIN_EXPLAIN_VIEWONLINE'         => 'За да прегледате потребителите, които са на линия, трябва да се регистрирате и да влезете в акаунта си.',
	'LOGOUT'                            => 'Излез',
    'LOGOUT_USER'                        => 'Излез [ %s ]',
    'LOG_ME_IN'                            => 'Запомни ме',

    'MARK'                    => 'Маркирай',
    'MARK_ALL'                => 'Маркирай всички',
    'MARK_FORUMS_READ'        => 'Маркирай форума като прочетен',
	'MARK_SUBFORUMS_READ'   => 'Маркирай подфорума като прочетен',
    'MB'                    => 'MB',
	'MIB'					=> 'MiB',
    'MCP'                    => 'Модераторски панел',
    'MEMBERLIST'            => 'Потребители',
    'MEMBERLIST_EXPLAIN'    => 'Виж всички потребители',
	'MERGE'					=> 'Свържи',
	'MERGE_POSTS'			=> 'Свържи мненията',
    'MERGE_TOPIC'            => 'Свържи темата',
    'MESSAGE'                => 'Съобщение',
    'MESSAGES'                => 'Съобщения',
    'MESSAGE_BODY'            => 'Писане на мнение',
    'MINUTES'                => 'Минути',
    'MODERATE'                => 'Модерирай',
    'MODERATOR'                => 'Модератор',
    'MODERATORS'            => 'Модератори',
    'MONTH'                    => 'Месец',
    'MOVE'                    => 'Премести',
    'MSNM'                    => 'MSNM/WLM',    

    'NA'                        => 'няма',
    'NEWEST_USER'                => 'Най-нов <strong>%s</strong>',
    'NEW_MESSAGE'                => 'Ново съобщение',
    'NEW_MESSAGES'                => 'Нови съобщения',
    'NEW_PM'                    => '<strong>%d</strong> ново съобщение',
    'NEW_PMS'                    => '<strong>%d</strong> нови съобщения',
    'NEW_POST'                    => 'Ново мнение', //не се използва
    'NEW_POSTS'                    => 'Нови мнения', //не се използва
    'NEXT'                        => 'Следваща',
	'NEXT_STEP'					=> 'Напред',
    'NEVER'                        => 'Никога',
    'NO'                        => 'Не',
    'NOT_ALLOWED_MANAGE_GROUP'    => 'Вие не можете да контролирате групата от “Админ панела”.',
    'NOT_AUTHORISED'            => 'Нямате достъп.',
    'NOT_WATCHING_FORUM'        => 'Премахнат абонамент за форум.',
    'NOT_WATCHING_TOPIC'        => 'Премахнат абонамент за тема.',
    'NOTIFY_ADMIN'				=> 'Уведомете администратора или уеб-мастъра.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Уведомете администратора или уеб-мастъра: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'        => 'Нямате достъп до този файл.',
    'NO_ACTION'                    => 'Няма.',
    'NO_ADMINISTRATORS'            => 'Няма администратор на форума.',
    'NO_AUTH_ADMIN'                => 'Вие нямате достъп до админ панела.',
    'NO_AUTH_ADMIN_USER_DIFFER'    => 'Вие не можете да се идентифицирате като друг потребител.',
    'NO_AUTH_OPERATION'            => 'Нямате нужните права за да завършите тази операция.',
    'NO_CONNECT_TO_SMTP_HOST'    => 'Не мога да се свържа към smtp: %s : %s',
    'NO_BIRTHDAYS'                => 'Никой не празнува рожденния си ден днес',
    'NO_EMAIL_MESSAGE'            => 'Съобщението е празно',
    'NO_EMAIL_RESPONSE_CODE'    => 'Грешка с mail сървъра',
    'NO_EMAIL_SUBJECT'            => 'Липсва заглавие на съобщението',
    'NO_FORUM'                    => 'Форума, който сте избрали не съществува.',
    'NO_FORUMS'                    => 'Няма форуми',
    'NO_GROUP'                    => 'Потребителската група не съществува.',
    'NO_GROUP_MEMBERS'            => 'В групата няма потребители',
    'NO_IPS_DEFINED'            => 'Няма дефиниран IP адреси или хост имена',
    'NO_MEMBERS'                => 'Няма намерени потребители',
    'NO_MESSAGES'                => 'Няма съобщения',
    'NO_MODE'                    => 'Няма избран метод.',
    'NO_MODERATORS'                => 'Няма модератори на форума.',
    'NO_NEW_MESSAGES'            => 'Няма нови съобщения',
    'NO_NEW_PM'                    => '<strong>0</strong> нови съобщения',
    'NO_NEW_POSTS'                => 'Няма нови мнения', //не се използва
    'NO_ONLINE_USERS'            => '0 регистрирани',
    'NO_POSTS'                    => 'Няма мнения',
    'NO_POSTS_TIME_FRAME'        => 'Няма съществуващи мнения в това времево пространство.',
	'NO_FEED_ENABLED'			=> 'Фийдовете са изключени за този форум.',
	'NO_FEED'					=> 'Фийда не е наличен.',
	'NO_SUBJECT'				=> 'Няма въведено заглавие',								// Used for posts having no subject defined but displayed within management pages.
    'NO_SUCH_SEARCH_MODULE'        => 'Бекенда не съществува',
    'NO_SUPPORTED_AUTH_METHODS'    => 'Няма поддържащи ауторизиращи методи',
    'NO_TOPIC'                    => 'Темата не съществува.',
	'NO_TOPIC_FORUM'         => 'Темата или форума вече не съществуват.',
    'NO_TOPICS'                    => 'Няма теми или мнения в този форум.',
    'NO_TOPICS_TIME_FRAME'        => 'Няма съществуващи теми в това времево пространство.',
    'NO_UNREAD_PM'                => '<strong>0</strong> непрочетени съобщения',
	'NO_UNREAD_POSTS'         => 'Няма непрочетени мнения',
    'NO_UPLOAD_FORM_FOUND'        => 'Невалиден файл.',
    'NO_USER'                    => 'Потребителя не съществува.',
    'NO_USERS'                    => 'Потребителите не съществуват.',
    'NO_USER_SPECIFIED'            => 'Няма избрано име',
	
	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Няма мнения (опашка)',		// 0
		1			=> 'Едно мнение (опашка)',		// 1
		2			=> '%d мнения (опашка)',		// 2+
	),

    'OCCUPATION'                => 'Професия',
    'OFFLINE'                    => 'Offline',
    'ONLINE'                    => 'Online',
    'ONLINE_BUDDIES'            => 'Приятели на линия',
    'ONLINE_USERS_TOTAL'        => 'Общо на линия са <strong>%d</strong> потребители :: ',
    'ONLINE_USERS_ZERO_TOTAL'    => 'Общо на линия са <strong>0</strong> потребители :: ',
    'ONLINE_USER_TOTAL'            => 'Общо на линия e <strong>%d</strong> потребител :: ',
    'OPTIONS'                    => 'Настройки',

    'PAGE_OF'                => 'Страница <strong>%1$d</strong> от <strong>%2$d</strong>',
    'PASSWORD'                => 'Парола',
    'PLAY_QUICKTIME_FILE'    => 'Пусни quicktime файла',
    'PM'                    => 'ЛС',
	'PM_REPORTED'         => 'Натисни за да видиш доклад',
    'POSTING_MESSAGE'        => 'Съобщение в %s',
    'POSTING_PRIVATE_MESSAGE'    => 'Писане на лично съобщение',
    'POST'                    => 'Мнение',
    'POST_ANNOUNCEMENT'        => 'Направи важна',
    'POST_STICKY'            => 'Закачи темата',
    'POSTED'                => 'Публикувано на',
    'POSTED_IN_FORUM'        => 'в',
    'POSTED_ON_DATE'        => 'на',
    'POSTS'                    => 'Мнения',
    'POSTS_UNAPPROVED'        => 'Най-малко едно мнение в тази тема не е одобрено',
    'POST_BY_AUTHOR'        => 'от',
    'POST_BY_FOE'            => 'Това мнение е публикувано от <strong>%1$s</strong> които е във списъка с врагове. %2$sПокажи мнението%3$s.',
    'POST_DAY'                => '%.2f мнения на ден',
    'POST_DETAILS'            => 'Детайли',
    'POST_NEW_TOPIC'        => 'Напиши нова тема',
    'POST_PCT'                => '%.2f%% от всички мнения',
    'POST_PCT_ACTIVE'        => '%.2f%% от всички потребителски мнения',
    'POST_PCT_ACTIVE_OWN'    => '%.2f%% от всички ваши мнения',
    'POST_REPLY'			=> 'Добави отговор',
	'POST_REPORTED'            => 'Натиснете за да видите доклада',
    'POST_SUBJECT'            => 'Заглавие',
    'POST_TIME'                => 'Време',
	'POST_TOPIC'			=> 'Публикувай нова тема',
    'POST_UNAPPROVED'        => 'Мнението все още не е одобрено',
    'PREVIEW'                => 'Прегледай',
    'PREVIOUS'                => 'Предишна',
	'PREVIOUS_STEP'         => 'Предишна',
    'PRIVACY'                => 'Поверителност',
    'PRIVATE_MESSAGE'        => 'Лично съобщение',
    'PRIVATE_MESSAGES'        => 'Лични съобщения',
    'PRIVATE_MESSAGING'        => 'Комуникация',
    'PROFILE'                => 'Потребителски панел',

    'READING_FORUM'                => 'Чете тема в %s',
    'READING_GLOBAL_ANNOUNCE'    => 'Чете съобщение',
    'READING_LINK'                => 'Отива на %s',
    'READING_TOPIC'                => 'Чете тема в %s',
    'READ_PROFILE'                => 'Профил',
    'REASON'                    => 'Причина',
    'RECORD_ONLINE_USERS'        => 'На %2$s е имало общо <strong>%1$s</strong> посетители наведнъж.',
    'REDIRECT'                    => 'Пренасочване',
    'REDIRECTS'                    => 'Общо пренасочвания',
    'REGISTER'                    => 'Регистрация',
    'REGISTERED_USERS'            => 'Регистрирани потребители:',
    'REG_USERS_ONLINE'            => 'Има %d регистрирани потребители ',
    'REG_USERS_TOTAL'            => '%d регистрирани',
	'REG_USERS_TOTAL_AND'		=> '%d регистрирани и ',
    'REG_USERS_ZERO_ONLINE'        => 'Има 0 регистрирани потребители ',
    'REG_USERS_ZERO_TOTAL'        => '0 регистрирани',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 регистрирани и ',
    'REG_USER_ONLINE'            => 'Има %d регистриран потребител ',
    'REG_USER_TOTAL'            => '%d регистрирани',
	'REG_USER_TOTAL_AND'		=> '%d регистрирани и ',
    'REMOVE'                    => 'Премахни',
    'REMOVE_INSTALL'            => 'Моля премахнете install директорията, преди да използвате форума.',
    'REPLIES'                    => 'Отговори',
    'REPLY_WITH_QUOTE'            => 'Отговори с цитат',
    'REPLYING_GLOBAL_ANNOUNCE'    => 'Отговаря на съобщение',
    'REPLYING_MESSAGE'            => 'Отговаря на съобщение в %s',
    'REPORT_BY'                    => 'Сигнал от',
    'REPORT_POST'                => 'Докладвай',
    'REPORTING_POST'            => 'Докладвай за мнение',
    'RESEND_ACTIVATION'            => 'Препрати активиращ email',
    'RESET'                        => 'Изчисти',
    'RESTORE_PERMISSIONS'        => 'Възстанови права',
    'RETURN_INDEX'                => '%sВърни се на главната страница%s',
    'RETURN_FORUM'                => '%sВърни се обратно във форума%s',
    'RETURN_PAGE'                => '%sВърни се обратно%s',
    'RETURN_TOPIC'                => '%sВърни се обратно%s',
    'RETURN_TO'                    => 'Назад към',
	'FEED'						=> 'Фийд',
	'FEED_NEWS'					=> 'Новини',
 	'FEED_TOPICS_ACTIVE'		=> 'Активни Теми',
 	'FEED_TOPICS_NEW'			=> 'Нови Теми',
    'RULES_ATTACH_CAN'            => 'Вие <strong>можете</strong> да прикачвате файл',
    'RULES_ATTACH_CANNOT'        => 'Вие <strong>не можете</strong> да прикачвате файл',
    'RULES_DELETE_CAN'            => 'Вие <strong>можете</strong> да изтривате собствените си мнения',
    'RULES_DELETE_CANNOT'        => 'Вие <strong>не можете</strong> да изтривате собствените си мнения',
    'RULES_DOWNLOAD_CAN'        => 'Вие <strong>можете</strong> да сваляте прикачени файлове',
    'RULES_DOWNLOAD_CANNOT'        => 'Вие <strong>не можете</strong> да сваляте прикачени файлове',
    'RULES_EDIT_CAN'            => 'Вие <strong>можете</strong> да променяте собственото си мнение',
    'RULES_EDIT_CANNOT'            => 'Вие <strong>не можете</strong> да променяте собственото си мнение',
    'RULES_LOCK_CAN'            => 'Вие <strong>можете</strong> да заключвате темите си',
    'RULES_LOCK_CANNOT'            => 'Вие <strong>не можете</strong> да заключвате темите си',
    'RULES_POST_CAN'            => 'Вие <strong>можете</strong> да пускате нови теми',
    'RULES_POST_CANNOT'            => 'Вие <strong>не можете</strong> да пускате нови теми',
    'RULES_REPLY_CAN'            => 'Вие <strong>можете</strong> да отговаряте на теми',
    'RULES_REPLY_CANNOT'        => 'Вие <strong>не можете</strong> да отговаряте на теми',
    'RULES_VOTE_CAN'            => 'Вие <strong>можете</strong> да гласувате',
    'RULES_VOTE_CANNOT'            => 'Вие <strong>не можете</strong> да гласувате',

    'SEARCH'                    => 'Търсене',
    'SEARCH_MINI'                => 'Търсене…',
    'SEARCH_ADV'                => 'Разширено търсене',
    'SEARCH_ADV_EXPLAIN'        => 'Виж разширено търсене',
    'SEARCH_KEYWORDS'            => 'Търсене за ключови думи',
    'SEARCHING_FORUMS'            => 'Търсене форуми',
    'SEARCH_ACTIVE_TOPICS'        => 'Виж активните теми',
    'SEARCH_FOR'                => 'Търсене',
    'SEARCH_FORUM'                => 'Търси този форум…',    
    'SEARCH_NEW'                => 'Виж новите мнения',
    'SEARCH_POSTS_BY'            => 'Търси мнения от',
    'SEARCH_SELF'                => 'Виж собствените си мнения',
    'SEARCH_TOPIC'                => 'Търси тази тема…',
    'SEARCH_UNANSWERED'            => 'Виж темите без отговор',
	'SEARCH_UNREAD'				=> 'Виж непрочетените мнения',
	'SEARCH_USER_POSTS'         => 'Търси в потребителските мнения',
    'SECONDS'                    => 'Секунди',
    'SELECT'                    => 'Избери',
	'SELECT_ALL_CODE'			=> 'Избери целия код',
    'SELECT_DESTINATION_FORUM'    => 'Изберете форум',
    'SELECT_FORUM'                => 'Изберете форум',
    'SEND_EMAIL'                => 'Изпрати',
	'SEND_EMAIL_USER'         => 'Изпрати email до',
    'SEND_PRIVATE_MESSAGE'        => 'Изпрати лично съобщение',
    'SETTINGS'                    => 'Настройки',
    'SIGNATURE'                    => 'Сигнатура',
    'SKIP'                        => 'Пропусни',
    'SMTP_NO_AUTH_SUPPORT'        => 'SMTP сървъра не поддържа автентичност',
    'SORRY_AUTH_READ'            => 'Вие не можете да четете този форум',
    'SORRY_AUTH_VIEW_ATTACH'    => 'Вие не можете да сваляте прикачени файлове в този форум',
    'SORT_BY'                    => 'Сортирай по',
    'SORT_JOINED'                => 'Регистриран на',
    'SORT_LOCATION'                => 'Местоположение',
    'SORT_RANK'                    => 'Ранг',
	'SORT_POSTS'				=> 'Мнения',
    'SORT_TOPIC_TITLE'            => 'Заглавие на темата',
    'SORT_USERNAME'                => 'Потребителско име',
    'SPLIT_TOPIC'                => 'Раздели тема',
    'SQL_ERROR_OCCURRED'        => 'SQL грешка. Свържете се с %sадминистратора%s.',
    'STATISTICS'                => 'Статистика',
    'START_WATCHING_FORUM'        => 'Абонирайте се за форума',
    'START_WATCHING_TOPIC'        => 'Абонирайте се за темата',
    'STOP_WATCHING_FORUM'        => 'Премахни абонамент',
    'STOP_WATCHING_TOPIC'        => 'Премахни абонамент',
    'SUBFORUM'                    => 'Под форум',
    'SUBFORUMS'                    => 'Под форуми',
    'SUBJECT'                    => 'Заглавие',
    'SUBMIT'                    => 'Изпрати',

    'TERMS_USE'            => 'Условия за ползване',
    'TEST_CONNECTION'    => 'Тествай връзка',
    'THE_TEAM'            => 'Екип',
    'TIME'                => 'Време',
	'TOO_LARGE'                  => 'Въведената стойност е прекалено висока.',
    'TOO_LARGE_MAX_RECIPIENTS'      => 'Стойността за <strong>Максималният брой получатели при избращане на ЛС</strong> е прекалено висока.',

	'TOO_LONG'						=> 'Въведената стойност е прекалено дълга.',
	
    'TOO_LONG_AIM'                    => 'Името е прекалено дълго.',
    'TOO_LONG_CONFIRM_CODE'            => 'Кода за потвърждение е прекалено дълъг.',
	'TOO_LONG_DATEFORMAT'			=> 'Формата на датата е прекалено дълъг.',
    'TOO_LONG_ICQ'                    => 'ICQ номера който сте въвели е прекалено дълго.',
    'TOO_LONG_INTERESTS'            => 'Полето интереси е прекалено дълго.',
    'TOO_LONG_JABBER'                => 'Jabber акаунт името е прекалено дълго.',
    'TOO_LONG_LOCATION'                => 'Местоположението което сте въвели е прекалено дълго.',
    'TOO_LONG_MSN'                    => 'MSNM/WLM името е прекалено дълго.',
    'TOO_LONG_NEW_PASSWORD'            => 'Паролата, която сте въвели е прекалено дълга.',
    'TOO_LONG_OCCUPATION'            => 'Професията, която сте въвели е прекалено дълга.',
    'TOO_LONG_PASSWORD_CONFIRM'        => 'Потвърждението на паролата е прекалено дълго.',
    'TOO_LONG_USER_PASSWORD'        => 'Парола е прекалено дълга.',
    'TOO_LONG_USERNAME'                => 'Потребителското име е прекалено дълго.',
    'TOO_LONG_EMAIL'                => 'Email адреса е прекалено дълъг.',
    'TOO_LONG_EMAIL_CONFIRM'        => 'Потвърждението на email адреса е прекалено дълго.',
    'TOO_LONG_WEBSITE'                => 'Уеб-сайт адреса е прекалено дълъг.',
    'TOO_LONG_YIM'                    => 'Yahoo! Месинджър името е прекалено дълго.',

    'TOO_MANY_VOTE_OPTIONS'            => 'Грешка при гласуване.',

	'TOO_SHORT'						=> 'Въведената стойност е прекалено къса.',
	
    'TOO_SHORT_AIM'                    => 'Името е прекалено късо.',
    'TOO_SHORT_CONFIRM_CODE'        => 'Кода за потвърждение е прекалено къс.',
	'TOO_SHORT_DATEFORMAT'			=> 'Формата на датата е прекалено къс.',
    'TOO_SHORT_ICQ'                    => 'ICQ номера който сте въвели е прекалено къс.',
    'TOO_SHORT_INTERESTS'            => 'Полето интереси е прекалено късо.',
    'TOO_SHORT_JABBER'                => 'Jabber акаунт името е прекалено дълго.',
    'TOO_SHORT_LOCATION'            => 'Местоположението което сте въвели е прекалено късо.',
    'TOO_SHORT_MSN'                    => 'MSNM/WLM името е прекалено късо.',
    'TOO_SHORT_NEW_PASSWORD'        => 'Паролата, която сте въвели е прекалено къса.',
    'TOO_SHORT_OCCUPATION'            => 'Професията, която сте въвели е прекалено къса.',
    'TOO_SHORT_PASSWORD_CONFIRM'    => 'Потвърждението на паролата е прекалено късо.',
    'TOO_SHORT_USER_PASSWORD'        => 'Паролата е прекалено къса.',
    'TOO_SHORT_USERNAME'            => 'Потребителското име е прекалено късо.',
    'TOO_SHORT_EMAIL'                => 'Email адреса е прекалено къс.',
    'TOO_SHORT_EMAIL_CONFIRM'        => 'Потвърждението не email адреса е прекалено късо.',
    'TOO_SHORT_WEBSITE'                => 'Уеб-сайт адреса е прекалено дълъг.',
    'TOO_SHORT_YIM'                    => 'Yahoo! Месинджър името е прекалено дълго.',
	'TOO_SMALL'                  => 'Въведената стойност е прекалено ниска.',
   'TOO_SMALL_MAX_RECIPIENTS'      => 'Стойността за <strong>Максимален брой получатели при изпращане на ЛС</strong> е прекалено ниска.',


    'TOPIC'                => 'Тема',
    'TOPICS'            => 'Теми',
	'TOPICS_UNAPPROVED'	=> 'Най-малко една тема в този форум не е одобрена.',
    'TOPIC_ICON'        => 'Икона на темата',
    'TOPIC_LOCKED'        => 'Темата е заключена, не можете да променяте мнения.',
	'TOPIC_LOCKED_SHORT'=> 'Заключена',
    'TOPIC_MOVED'        => 'Преместена тема',
    'TOPIC_REVIEW'        => 'Преглед на тема',
    'TOPIC_TITLE'        => 'Заглавие на тема',
    'TOPIC_UNAPPROVED'    => 'Темата все още не е одобрена',
    'TOTAL_ATTACHMENTS'    => 'Прикачен файл/файлове',
    'TOTAL_LOG'            => '1 лог',
    'TOTAL_LOGS'        => '%d лог-а',
    'TOTAL_NO_PM'        => 'общо 0 лични съобщения',
    'TOTAL_PM'            => 'общо 1 лично съобщение',
    'TOTAL_PMS'            => 'общо $d лични съобщения',
    'TOTAL_POSTS'        => 'Общо мнения',
    'TOTAL_POSTS_OTHER'    => 'Общо мнения <strong>%d</strong>',
    'TOTAL_POSTS_ZERO'    => 'Общо мнения <strong>0</strong>',
    'TOPIC_REPORTED'    => 'Сигнала е изпратен',
    'TOTAL_TOPICS_OTHER'=> 'Общо теми <strong>%d</strong>',
    'TOTAL_TOPICS_ZERO'    => 'Общо теми <strong>0</strong>',
    'TOTAL_USERS_OTHER'    => 'Общо членове <strong>%d</strong>',
    'TOTAL_USERS_ZERO'    => 'Общо членове <strong>0</strong>',
    'TRACKED_PHP_ERROR'    => 'PHP грешка: %s',

    'UNABLE_GET_IMAGE_SIZE'    => 'Грешка при изображение.',
    'UNABLE_TO_DELIVER_FILE'=> 'Файла не може да бъде получен.',
    'UNKNOWN_BROWSER'        => 'Непознат браузър',
    'UNMARK_ALL'            => 'Демаркирай всички',
    'UNREAD_MESSAGES'        => 'Непрочетени съобщения',
    'UNREAD_PM'                => '<strong>%d</strong> непрочетено съобщение',
    'UNREAD_PMS'            => '<strong>%d</strong> непрочетени съобщения',
	'UNREAD_POST'         => 'Непрочетено мнение',
   'UNREAD_POSTS'         => 'Непрочетени мнения',
    'UNWATCHED_FORUMS'        => 'Вие вече не наблюдавате този форум.',
    'UNWATCHED_TOPICS'        => 'Вие вече не наблюдавате тази тема.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Вие успешно се отписахте от избраните раздели/теми.',
    'UPDATE'                => 'Обновяване',
    'UPLOAD_IN_PROGRESS'    => 'Качване..',
    'URL_REDIRECT'            => 'Вашия браузър не поддържа МЕТА пренасочване, моля натиснете %sТУК%s за да бъдете пренасочен.',
    'USERGROUPS'            => 'Групи',
    'USERNAME'                => 'Потребителско име',
    'USERNAMES'                => 'Потребителски имена',
    'USER_AVATAR'            => 'Аватар',
    'USER_CANNOT_READ'        => 'Вие не можете да четете мнения в този форум',
    'USER_POST'                => '%d Мнение',
    'USER_POSTS'            => '%d Мнения',
    'USERS'                    => 'Потребители',
    'USE_PERMISSIONS'        => 'Тествай потребителските права',
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Вие не сте оторизиран да използвате тази функция. Може би сте се регистрирали скоро.',


	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
    'VIEWED'                    => 'Прегледано',
    'VIEWING_FAQ'                => 'Преглежда Въпроси/Отговори',
    'VIEWING_MEMBERS'            => 'Преглежда детайли на потребител',
    'VIEWING_ONLINE'            => 'Преглежда online потребителите',
    'VIEWING_MCP'                => 'Модератор контролен панел',
    'VIEWING_MEMBER_PROFILE'    => 'Преглежда профил на потребител',
    'VIEWING_PRIVATE_MESSAGES'    => 'Преглежда личните съобщения',
    'VIEWING_REGISTER'            => 'Регистрира се',
    'VIEWING_UCP'                => 'Потребителски панел',
    'VIEWS'                        => 'Преглеждания',
    'VIEW_BOOKMARKS'            => 'Преглежда записки',
    'VIEW_FORUM_LOGS'            => 'Прегледай логовете',
    'VIEW_LATEST_POST'            => 'Преглежда последните мнения',
    'VIEW_NEWEST_POST'            => 'Преглежда непрочетените мнения',
    'VIEW_NOTES'                => 'Прегледай бележките',
    'VIEW_ONLINE_TIME'            => 'Информацията се обновява на всяка %d минута',
    'VIEW_ONLINE_TIMES'            => 'Информацията се обновява на всеки %d минути',
    'VIEW_TOPIC'                => 'Виж темата',
    'VIEW_TOPIC_ANNOUNCEMENT'    => 'Важна тема: ',
    'VIEW_TOPIC_GLOBAL'            => 'Съобщение: ',
    'VIEW_TOPIC_LOCKED'            => 'Заключена: ',
    'VIEW_TOPIC_LOGS'            => 'Виж логовете',
    'VIEW_TOPIC_MOVED'            => 'Преместена: ',
    'VIEW_TOPIC_POLL'            => 'Анкета: ',
    'VIEW_TOPIC_STICKY'            => 'Закачена: ',
    'VISIT_WEBSITE'                => 'Посети уеб-сайт',

    'WARNINGS'            => 'Предупреждения',
    'WARN_USER'            => 'Сложи предупреждение',
    'WELCOME_SUBJECT'    => 'Добре дошли в %s форуми',
    'WEBSITE'            => 'Уеб-сайт',
    'WHOIS'                => 'Провери го',
    'WHO_IS_ONLINE'        => 'Кой е на линия',
    'WRONG_PASSWORD'    => 'Въвели сте грешна парола.',

    'WRONG_DATA_ICQ'            => 'Невалиден ICQ номер.',
    'WRONG_DATA_JABBER'            => 'Невалидно Jabber акаунт име.',
    'WRONG_DATA_LANG'            => 'Езика, който сте избрали не е валиден.',
    'WRONG_DATA_WEBSITE'        => 'Адреса на уеб-сайта трябва да включва протокола. Пример http://www.example.com/.',
    'WROTE'                  => 'написа',
	
    'YEAR'                => 'Година',
	'YEAR_MONTH_DAY'	=> '(ГГГГ-ММ-ДД)',
    'YES'                => 'Да',
    'YIM'                => 'YIM',    
    'YOU_LAST_VISIT'    => 'Последно посещение: %s',
    'YOU_NEW_PM'        => 'Ново лично съобщение ви чака във входящата поща',
    'YOU_NEW_PMS'        => 'Нови лични съобщения ви чакат във входящата поща',
    'YOU_NO_NEW_PM'        => 'Няма нови съобщения във входящата поща',

    'datetime'            => array(
        'TODAY'        => 'Днес, ',
        'TOMORROW'    => 'Утре, ',
        'YESTERDAY'    => 'Вчера, ',
		'AGO'		=> array(
			0		=> 'преди по-малко от минута',
			1		=> 'преди %d минута',
			2		=> 'преди %d минути',
			60		=> 'преди един час',
		),

        'Sunday'    => 'Неделя',
        'Monday'    => 'Понеделник',
        'Tuesday'    => 'Вторник',
        'Wednesday'    => 'Сряда',
        'Thursday'    => 'Четвъртък',
        'Friday'    => 'Петък',
        'Saturday'    => 'Събота',

        'Sun'        => 'Нед',
        'Mon'        => 'Пон',
        'Tue'        => 'Вто',
        'Wed'        => 'Сря',
        'Thu'        => 'Чет',
        'Fri'        => 'Пет',
        'Sat'        => 'Съб',

        'January'    => 'Януари',
        'February'    => 'Февруари',
        'March'        => 'Март',
        'April'        => 'Април',
        'May'        => 'Май',
        'June'        => 'Юни',
        'July'        => 'Юли',
        'August'    => 'Август',
        'September' => 'Септември',
        'October'    => 'Октомври',
        'November'    => 'Ноември',
        'December'    => 'Декември',

        'Jan'        => 'Яну',
        'Feb'        => 'Фев',
        'Mar'        => 'Мар',
        'Apr'        => 'Апр',
        'May_short'    => 'Май',    // Short representation of "May". May_short used because in english the short and long date are the same for May.
        'Jun'        => 'Юни',
        'Jul'        => 'Юли',
        'Aug'        => 'Авг',
        'Sep'        => 'Сеп',
        'Oct'        => 'Окт',
        'Nov'        => 'Ное',
        'Dec'        => 'Дек',
    ),

    'tz'                => array(
        '-12'    => 'UTC - 12 часа',
        '-11'    => 'UTC - 11 часа',
        '-10'    => 'UTC - 10 часа',
        '-9.5'    => 'UTC - 9:30 часа',
        '-9'    => 'UTC - 9 часа',
        '-8'    => 'UTC - 8 часа',
        '-7'    => 'UTC - 7 часа',
        '-6'    => 'UTC - 6 часа',
        '-5'    => 'UTC - 5 часа',
		'-4.5'	=> 'UTC - 4:30 часа',
		'-4'    => 'UTC - 4 часа',
        '-3.5'    => 'UTC - 3:30 часа',
        '-3'    => 'UTC - 3 часа',
        '-2'    => 'UTC - 2 часа',
        '-1'    => 'UTC - 1 час',
        '0'        => 'UTC',
        '1'        => 'UTC + 1 час',
        '2'        => 'UTC + 2 часа',
        '3'        => 'UTC + 3 часа',
        '3.5'    => 'UTC + 3:30 часа',
        '4'        => 'UTC + 4 часа',
        '4.5'    => 'UTC + 4:30 часа',
        '5'        => 'UTC + 5 часа',
        '5.5'    => 'UTC + 5:30 часа',
        '5.75'    => 'UTC + 5:45 часа',
        '6'        => 'UTC + 6 часа',
        '6.5'    => 'UTC + 6:30 часа',
        '7'        => 'UTC + 7 часа',
        '8'        => 'UTC + 8 часа',
        '8.75'    => 'UTC + 8:45 часа',
        '9'        => 'UTC + 9 часа',
        '9.5'    => 'UTC + 9:30 часа',
        '10'    => 'UTC + 10 часа',
        '10.5'    => 'UTC + 10:30 часа',
        '11'    => 'UTC + 11 часа',
        '11.5'    => 'UTC + 11:30 часа',
        '12'    => 'UTC + 12 часа',
        '12.75'    => 'UTC + 12:45 часа',
        '13'    => 'UTC + 13 часа',
        '14'    => 'UTC + 14 часа',
        'dst'	=> '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
    ),

    'tz_zones'    => array(
        '-12'    => '[UTC - 12] Остров Бейкър',
        '-11'    => '[UTC - 11] Ниуе, Самоа (стандартно)',
        '-10'    => '[UTC - 10] Хавай-Алишън (стандартно), Кук Остров',
        '-9.5'    => '[UTC - 9:30] Маркизки острови',
        '-9'    => '[UTC - 9] Аляска (стандартно), Gambier Island',
        '-8'    => '[UTC - 8] Тихоокеански (стандартно)',
        '-7'    => '[UTC - 7] Планински (стандартно)',
        '-6'    => '[UTC - 6] Сентрал (стандартно)',
        '-5'    => '[UTC - 5] Източен (стандартно)',
		'-4.5'	=> '[UTC - 4:30] Венецуелски (стандартно)',
        '-4'    => '[UTC - 4] Атлантик (стандартно)',
        '-3.5'    => '[UTC - 3:30] Нюфаундленд (стандартно)',
        '-3'    => '[UTC - 3] Амазония (стандартно), Централна Гренландия',
        '-2'    => '[UTC - 2] Фернандо де Нороня, Южна Джорджия &amp; Южните Сандвичеви острови',
        '-1'    => '[UTC - 1] Азорските острови (стандартно), Кабо Верде, Източна Гренландия',
        '0'        => '[UTC] Западна Европа, По Гринуич',
        '1'        => '[UTC + 1] Централна Европа, Западна Африка',
        '2'        => '[UTC + 2] Източна Европа, Централна Африка',
        '3'        => '[UTC + 3] Москва (стандартно), Източна Африка',
        '3.5'    => '[UTC + 3:30] Иран (стандартно)',
        '4'        => '[UTC + 4] Персийския залив (стандартно), Самара (стандартно)',
        '4.5'    => '[UTC + 4:30] Афганистан',
        '5'        => '[UTC + 5] Пакистан (стандартно), Екатеринбург (стандартно)',
        '5.5'    => '[UTC + 5:30] Индийски (стандартно), Шри Ланка',
        '5.75'    => '[UTC + 5:45] Непал',
        '6'        => '[UTC + 6] Бангладеш, Бутан, Новосибирск (стандартно)',
        '6.5'    => '[UTC + 6:30] Кокосови Острови, Мианмар',
        '7'        => '[UTC + 7] Индокитай (стандартно), Красноярск (стандартно)',
        '8'        => '[UTC + 8] Китай (стандартно), Западна Австралия (стандартно), Иркутск (стандартно)',
        '8.75'    => '[UTC + 8:45] 	Югоизточна Западна Австралия (стандартно)',
        '9'        => '[UTC + 9] Япония (стандартно), Корея (стандартно), Чита (стандартно)',
        '9.5'    => '[UTC + 9:30] Австралийски Централен (стандартно)',
        '10'    => '[UTC + 10] Австралийски Източен (стандартно), Владивосток (стандартно)',
        '10.5'    => '[UTC + 10:30] Лорд Хюй (стандартно)',
        '11'    => '[UTC + 11] Соломонови острови, Магадан (станратно)',
        '11.5'    => '[UTC + 11:30] Остров Норфолк',
        '12'    => '[UTC + 12] Нова Зеландия, Фиджи, Камчатка (стандартно)',
        '12.75'    => '[UTC + 12:45] Чатъм острови',
        '13'    => '[UTC + 13] Тонга, Финикс острови',
        '14'    => '[UTC + 14] Линия Айлънд',
    ),

    // The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Яну 2007, 13:37',
		'd M Y H:i'				=> '01 Яну 2007 13:37',
		'M jS, \'y, H:i'		=> 'Първи Яну, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Пон Яну 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Първи Януари, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Днес, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Днес, 1:37 pm / Първи Януари, 2007, 1:37 pm'
	),

    // The default dateformat which will be used on new installs in this language
    // Translators should change this if a the usual date format is different
    'default_dateformat'    => 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));

?>