/*
Copyright (c) 2008-2010
	Lars-Dominik Braun <PromyLOPh@lavabit.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/* encryption key for xmlrpc */

#ifndef _CRYPT_KEY_OUTPUT_H
#define _CRYPT_KEY_OUTPUT_H

#include <stdint.h>

const unsigned int out_key_n = 16;

static const uint32_t out_key_p [16 + 2] = {
		0xA8C2B074L, 0x04EBC85BL, 0x014C6C28L, 0x7459BFA9L,
		0x279C0727L, 0xE1CB918EL, 0xA62CD534L, 0xAAC40A16L,
		0x5B8135BDL, 0xA8B52D3BL, 0x666C7F54L, 0x2FE61767L,
		0x25CAB584L, 0x8F84A1C5L, 0x2C8160F3L, 0x9AFFC1A2L,
		0xE9CCA78EL, 0x94660E31L,
		};

static const uint32_t out_key_s [4][256] = {{
		0xF6FD36CEL, 0xDEA5D22DL, 0x9E0AC68CL, 0x75F74BA9L,
		0x74284D49L, 0x5DFE096DL, 0x3DAE3A9AL, 0x8D34DFC3L,
		0x5867D829L, 0x2BAEE18BL, 0x49B320D8L, 0xDC2C4717L,
		0x199F9D68L, 0xD20C53CBL, 0xA4EA0E7DL, 0xC3EB485CL,
		0xD39E9820L, 0x9556A9B0L, 0xFDE0D7B6L, 0x373C3B71L,
		0xBF4E19DDL, 0xEA3EF460L, 0x7969CA78L, 0x70C3FBC0L,
		0x26B24C0FL, 0x2540F04BL, 0x95210013L, 0xD0202F2BL,
		0x0BADD392L, 0xB7071246L, 0xF4C98CC0L, 0x3DC9A8B8L,
		0x33464654L, 0x3F5203C2L, 0x5DA4027DL, 0x5FC202ACL,
		0x2C4384C2L, 0x4A6F1F9BL, 0x48137E49L, 0x0695BA36L,
		0xB95C35EBL, 0x0CA663EAL, 0x06B665EFL, 0x0434DEC6L,
		0x042B34D9L, 0xAF4ED3B4L, 0x7EF5B2BFL, 0xC6E08131L,
		0x10B5AF5EL, 0xC19E25E2L, 0x44A2BDDFL, 0xA064A4E7L,
		0x32D69E62L, 0xF040BDA3L, 0x8053CFDEL, 0x28B7909BL,
		0x05944456L, 0xD45F6184L, 0xFFA859C1L, 0x828181D2L,
		0xA4E03A60L, 0x7B3A0858L, 0x52A5CBF1L, 0x1049BDD3L,
		0x36CAD87CL, 0xA5E3FCC7L, 0x3824984DL, 0x046BFAF0L,
		0xD22E4EEFL, 0x02156DAEL, 0x3CF82E35L, 0xD3383EC6L,
		0xB79909C7L, 0x00DFE65CL, 0xA45C63A2L, 0xB571F38EL,
		0x79CFE3FEL, 0x64371D45L, 0xC5B62B8AL, 0xEF73CBE4L,
		0xC6603F28L, 0xE63BB420L, 0x9ECC7027L, 0xFDAC399EL,
		0xA7DEEE1AL, 0x5C9B6B93L, 0xB7C58225L, 0x7DBD4786L,
		0xB911E83AL, 0x9C2D7DBEL, 0xB95CAD1CL, 0x72A496FBL,
		0x75594B0CL, 0x972DE6BEL, 0xD350CA84L, 0x144E413BL,
		0x8DE0DE39L, 0x831D387AL, 0xA198D810L, 0xF0E0D069L,
		0x1A9127C3L, 0xDA0706A1L, 0x01CAC3A7L, 0x1FB05101L,
		0x6B14D8CEL, 0x6203C3F3L, 0x35FAAC06L, 0xD34D77C8L,
		0xD9571C22L, 0x21AE6FEFL, 0xB26157EBL, 0x90767E8CL,
		0xB7A908DEL, 0x8A4AEB7CL, 0x4EF9A3F7L, 0x8FEF6E86L,
		0x1DD098C5L, 0x2EA34733L, 0x12820E88L, 0xB5FA97A8L,
		0xFADB5158L, 0x09D75EDFL, 0xAEA19DEFL, 0xB2E711DEL,
		0xEABC8403L, 0x3CA2FAC9L, 0x98FE610DL, 0xAB777A49L,
		0xEB5749FFL, 0x95C5168FL, 0x5E7CF20DL, 0xF55D18E5L,
		0x9CBD14DFL, 0x138C5CEAL, 0x3A1F0B5EL, 0xFA3DE986L,
		0xB2F00E18L, 0x702833A7L, 0x17911203L, 0xD227F2CDL,
		0x21D03ABDL, 0x4735D4F8L, 0x705A8002L, 0xC39584FDL,
		0xEA4F29AAL, 0x6DC822A7L, 0x0D3E6D8EL, 0x95FF16A5L,
		0xDE5EDB12L, 0xF33BEBFDL, 0xA9C256ECL, 0x7879E9EFL,
		0xB80FA0CBL, 0x5541E9C8L, 0x53EC0760L, 0xE39ACBF4L,
		0x15F6F2B4L, 0x89582A6CL, 0x17611817L, 0xD612D44AL,
		0xB46C83B1L, 0x89F385F1L, 0x466BBD11L, 0xBB79FD92L,
		0xF617A3EBL, 0x3ED49DF8L, 0x802E0824L, 0x9B108110L,
		0x69FF76DBL, 0xA9F02162L, 0xE6D92161L, 0x78104590L,
		0xE6D33EB4L, 0x0B99AAECL, 0x78BD05F5L, 0xA3DD5738L,
		0xC1D275D9L, 0xBA5AD45CL, 0x3F438DB7L, 0x5A695F1CL,
		0x11843FB9L, 0x160B4E39L, 0x6D70134FL, 0xE46D07FBL,
		0x8ABA4857L, 0x61696980L, 0xAE2EEA72L, 0xC2609B77L,
		0xFD13E78EL, 0x001BDB3FL, 0xA41D589DL, 0x87D28135L,
		0x543DF838L, 0x2FE95D05L, 0x978FE4DFL, 0xF93C68A3L,
		0xD3123DE2L, 0x6672B62AL, 0xF17D6339L, 0xA74E19FBL,
		0x3A8AFEC1L, 0xC7E34355L, 0xF4341642L, 0xEC80CB21L,
		0x9A2857DCL, 0x367AF183L, 0xAB85D076L, 0x675F789BL,
		0x69AC7A11L, 0x45C072BAL, 0xFA2E7F52L, 0x40361F9FL,
		0x5E5B999EL, 0x935EF244L, 0x539AC9D9L, 0x44CDDF56L,
		0xD873EF96L, 0x02ACFFB3L, 0xE1132BE1L, 0x9C01FC6DL,
		0x6AF6C971L, 0x2FB5DFC9L, 0x52EF5A1FL, 0xF2604D6CL,
		0x2080717BL, 0xEA47F30DL, 0xDFE65FD5L, 0xB6CC4E4CL,
		0x1E39CA72L, 0xA8932695L, 0x29F24747L, 0x5F6692A6L,
		0x128DC7B0L, 0x94A008C8L, 0xDE0AC13FL, 0xA7E72050L,
		0x14FC696FL, 0x075D7348L, 0xD230F4BDL, 0xF057308FL,
		0x43D38F2BL, 0x300ECE1EL, 0xCBC9A1DCL, 0xD1DC2D9FL,
		0xF9DBB5C5L, 0xA6342B61L, 0x943AC415L, 0x18676FBFL,
		0x314919FBL, 0xC9570A0AL, 0xBD7A40EDL, 0x8A44ACF4L,
		0x354ABFCAL, 0x4D534A18L, 0xBFFEE160L, 0x35C18D93L,
		},{
		0x15DBCCCEL, 0x29A95713L, 0x5D890889L, 0x070DEA79L,
		0xF9B56896L, 0xF8784885L, 0xE0F748B1L, 0xA5A0C290L,
		0x16FD2DDAL, 0x681430F3L, 0xB9699967L, 0x6767C430L,
		0x0FD5F8D0L, 0xB43E99A8L, 0xEED1B054L, 0x5374A256L,
		0x7C0F049DL, 0x2819D817L, 0xE83CB003L, 0x9B02FE6DL,
		0xBFD783B2L, 0x7C3BF349L, 0xF8AA7001L, 0x2A87EDEFL,
		0xDCAA68AAL, 0xE2D13D6CL, 0x904DE7BDL, 0xBFF5CB87L,
		0x4E7C9B78L, 0xDF751DFAL, 0x8DCF87CFL, 0x2245A935L,
		0x7938A3C2L, 0x8D3FF426L, 0x34510A7AL, 0x6CFCE072L,
		0xCD60683BL, 0x1A03A627L, 0xD52501E1L, 0xA700BE5FL,
		0x4E661D53L, 0x19082F1BL, 0xA7139E35L, 0x1F483D14L,
		0xE92ECBD2L, 0xB3ECF92DL, 0x40A16636L, 0x7942F3CDL,
		0xABDC3431L, 0x0534D0EDL, 0xABF19574L, 0x40C6EB83L,
		0x95209166L, 0xBF8381F9L, 0xEDAA0255L, 0x5E0ACD29L,
		0x64AB8FB0L, 0xEFED8E62L, 0x0127B489L, 0xCD42E9DAL,
		0xF15A31DAL, 0x284C520AL, 0xCA5CE322L, 0xD5139D06L,
		0x1CA1134FL, 0x1351487CL, 0xC270EE91L, 0x535D5904L,
		0xFE1B86EAL, 0x3CA2AA59L, 0x0DC98AEBL, 0x6595181EL,
		0x2FD45C25L, 0x5A69EE66L, 0xD0006BA9L, 0xB22C37EFL,
		0x385E82D3L, 0xDC605157L, 0x5167F38AL, 0x56BBC682L,
		0x03609E08L, 0x6D1493F6L, 0x5A993E29L, 0xF3EE5E34L,
		0x066CF14CL, 0x87362267L, 0x446439FCL, 0xF940D038L,
		0xF6CA440BL, 0xCA6FA060L, 0x1C7E1197L, 0x01B9A238L,
		0x28B981B2L, 0xDD5B3F57L, 0x9265149DL, 0x7B4C3D75L,
		0x79C78911L, 0xE79EF7FCL, 0x5E9AB738L, 0xBBE234D8L,
		0xA65B3B3BL, 0x1BD51281L, 0x80E5E454L, 0x55050949L,
		0xE814A07DL, 0xCB815BB5L, 0xF0E1EFE7L, 0x52A4D76AL,
		0x5BEB1613L, 0x5CED5360L, 0xEC1E36BDL, 0x3418CBA4L,
		0xAC75B160L, 0xF506CB83L, 0x1F10C19CL, 0x07FEAD71L,
		0x2A8B0C8CL, 0xE426C985L, 0xF047A0BEL, 0xFA0D76A3L,
		0x040FB6B2L, 0x3FD46417L, 0x4BD840D8L, 0xC4CB3DB8L,
		0x114B557BL, 0x771C2219L, 0x6D337D4AL, 0xB6F394E9L,
		0xFF01229AL, 0x2296570DL, 0xDFE9F249L, 0x1D875F0EL,
		0x6FDDD772L, 0x157BD311L, 0x63D781C6L, 0xEAC5ABBEL,
		0x6CB1BA01L, 0x85AA1E24L, 0xC137C5D1L, 0xCD6A3D0BL,
		0x4A05D2FCL, 0x02335168L, 0x58EF5A40L, 0xF255CAEFL,
		0xE3D875D8L, 0xC38C2F9CL, 0x4B095C46L, 0x55BB061BL,
		0x81089166L, 0x8629DE9CL, 0x4515095DL, 0xB994B900L,
		0xABE9C314L, 0x3AA8014EL, 0x5AFEFF8FL, 0xF359DEA6L,
		0x753E9545L, 0x1547382DL, 0x52239C7EL, 0xB4740661L,
		0x83CD9095L, 0xB66AC441L, 0x0370D2B1L, 0x34D43CB4L,
		0xDF5AE400L, 0xCAE562C5L, 0xCDB1E51DL, 0x8E4EB2EDL,
		0xC3C96EC6L, 0x6A98C9F5L, 0x982AD390L, 0xEE47D043L,
		0x1C9F922EL, 0x2BCD36CFL, 0x4B4DCDA3L, 0x10BD2C62L,
		0xB72E38BBL, 0xC83AAEEBL, 0xD41414BEL, 0xDE95000EL,
		0x1374FF7DL, 0x07850398L, 0xDDFA07AAL, 0x7295DCF3L,
		0x1E703A64L, 0x80447FACL, 0x90950C82L, 0x0EE0D3C7L,
		0x8E9D3C34L, 0x70C7D56EL, 0x6619A322L, 0x6F60E73AL,
		0xA076FADAL, 0x88C1DAC3L, 0xD45A9516L, 0x870E8C4AL,
		0xD06021EBL, 0x32A45FCBL, 0xB4A25EA7L, 0xC6AE3360L,
		0xD9F5CCD4L, 0xB5E7AB55L, 0x56D47CE1L, 0xD229F5B1L,
		0x23F5C90EL, 0x610A1A1AL, 0x4B2FFCD2L, 0xFCCCDA4EL,
		0x97FAD1ABL, 0x406D14D0L, 0x83F94EFFL, 0x4F428BF5L,
		0x595EED25L, 0xB7E2284FL, 0xA3042BE9L, 0x90F761B1L,
		0x9D622C2AL, 0xC4C05E56L, 0x471C109DL, 0x435C35EAL,
		0x9418003CL, 0x36C8665BL, 0xEC4246E1L, 0xA73B6AD4L,
		0xA93E8EB9L, 0xAD0AA225L, 0x48A6D2F5L, 0xDF84B6B8L,
		0xC7B0368AL, 0xBBC8D83BL, 0x739BD3E6L, 0x5370B70EL,
		0x06518368L, 0xFE82BB7CL, 0x957FC02DL, 0x8C00659FL,
		0x4EED2414L, 0x2F79CE26L, 0xECB091A7L, 0xF4D8AC7FL,
		0xE946B22BL, 0x018EAB58L, 0x170DC0D5L, 0x9FB524EEL,
		0x3A242EB4L, 0xB02F62F1L, 0x5247A50EL, 0x9945BCC3L,
		0x251B5148L, 0x7669A6E0L, 0x5DB00878L, 0xC908B055L,
		0x9F7CA600L, 0xC6C34F95L, 0x4851894DL, 0x515E8E4EL,
		},{
		0x3BDF54EBL, 0x79424E44L, 0xFEDC2714L, 0x3A2D542AL,
		0xC90E1AE4L, 0x230D7AA1L, 0xE5FF077FL, 0x2CEACFA9L,
		0xEF800EC0L, 0xFDEB3C32L, 0xCEDB12AFL, 0xBBD63D05L,
		0x30A678FBL, 0xBD4B3C9DL, 0x3EE61F60L, 0x7795B124L,
		0xE20D7C42L, 0x28912105L, 0x901E965CL, 0x8BCEED8DL,
		0x369E317DL, 0x98733CE5L, 0x9CA3D724L, 0x1B0B2771L,
		0xC48F661FL, 0x4F134B8CL, 0xF5B509DFL, 0xBC818625L,
		0x9EC5C114L, 0x2AEBF364L, 0x496E1870L, 0x41DD2A62L,
		0x42C57C68L, 0x15885679L, 0x6B3C3B59L, 0x24E18DFBL,
		0x63DEE76AL, 0x4F0CA078L, 0x4269E797L, 0x06907DF4L,
		0x9979AA8CL, 0xB08794B5L, 0x83B83773L, 0xB0C133EDL,
		0x3746BDE6L, 0xCE3ED2AFL, 0x0805E55DL, 0xB968950FL,
		0x62309D14L, 0x07396EC8L, 0xB8A4CA12L, 0x186CAB69L,
		0x87DBEF27L, 0xF6776060L, 0xD807120BL, 0xCFD7CC4BL,
		0x7601C2E1L, 0xC2DEE931L, 0x99F22346L, 0xA7AF7010L,
		0x31ACB350L, 0x2755A8F2L, 0xD3183E5CL, 0x58641565L,
		0x215A59EFL, 0xBBAA2079L, 0xE6D44C36L, 0xA2651EE0L,
		0x08653601L, 0xD0AE8B02L, 0x7794C55EL, 0xB5CA01C8L,
		0x25D8BA7AL, 0x7B468EA9L, 0xD1CDB877L, 0xD2078BF5L,
		0x3D3E4D32L, 0x65D6C3BEL, 0x425DF64AL, 0x450A0ABFL,
		0x3F0BDB36L, 0x92989B0BL, 0x6204CF30L, 0x32A64C6AL,
		0x544FB5B9L, 0xEBB0CA06L, 0x480B642EL, 0x3E0284ADL,
		0x0BF0A61FL, 0x9BACD23BL, 0x252197AFL, 0x0442881DL,
		0x56258201L, 0x6EDCCDD8L, 0x038936DCL, 0x499966FFL,
		0xE003B235L, 0x70E2DCB2L, 0x70411309L, 0x9495803EL,
		0x2A6726EBL, 0x9DF1CA34L, 0x5241819AL, 0x1BBC4A88L,
		0x266CE104L, 0xE61598E6L, 0x075E26F5L, 0x82D889DEL,
		0x3351C0DBL, 0x8280DE84L, 0x34AB5BAEL, 0x5B5E1B6AL,
		0xA47C6195L, 0xDF918381L, 0xEA23D1D8L, 0xE127ABFAL,
		0x8A081347L, 0x55DD03CEL, 0x66E83947L, 0xE8EC3FFFL,
		0xB18EE74DL, 0x90B77AABL, 0x5D383DA2L, 0xBD60B102L,
		0x0B73C02BL, 0x6E34FD16L, 0x275E2BE7L, 0x36B32FDAL,
		0xF8DC2735L, 0x93E4690CL, 0x106F106DL, 0x2CFC8BFAL,
		0x415DF134L, 0xD9AAD4F2L, 0x6CEBFA2DL, 0xD65A7886L,
		0xF17CD2ACL, 0x4DDBBB47L, 0xBE4D5FA3L, 0xE3890B33L,
		0xE8EC9654L, 0x3EA7350DL, 0x5E505EC7L, 0x348CAAC6L,
		0xD85F61C3L, 0xB9D53FD9L, 0xAFF0AE61L, 0xC8C5AE39L,
		0x44C6AD0EL, 0xFBAA61E0L, 0x01DCDF26L, 0x5C0A9A4BL,
		0xBA2D2A79L, 0x8B0EE1ABL, 0xAF3A488AL, 0x14573086L,
		0xBA540B76L, 0x61F028A1L, 0x58A7A0C0L, 0xD9F310F1L,
		0x7DD0F3ABL, 0x01A1A3C4L, 0xD77E6370L, 0x41310B57L,
		0x0EF905E5L, 0x1AD6B697L, 0xC8E883A3L, 0x591BC606L,
		0x3325842DL, 0x1E09F853L, 0x18FDBF80L, 0x2FF07151L,
		0x6D0B2849L, 0x07A72B7CL, 0xEC716644L, 0xD608A530L,
		0x0AC40EB0L, 0xA1B748F2L, 0xC349D6B6L, 0x95112613L,
		0xD3B96139L, 0x91243914L, 0x2DB56986L, 0x949A0DE1L,
		0x0EC54412L, 0x0C4E2748L, 0x405315C5L, 0x032B58DFL,
		0xCC7F0950L, 0x43BAF130L, 0x76B95EA0L, 0x361C7B2AL,
		0x4BB1275EL, 0x75F93428L, 0xD522A1E6L, 0x13D9303AL,
		0xE06345FEL, 0x31521803L, 0xA54A0028L, 0x1F0116CEL,
		0xB08837EDL, 0x5EAC3E98L, 0xAB830BA0L, 0x3C62EF0DL,
		0xE4820552L, 0x080CE492L, 0xE3B4CC51L, 0x696A4418L,
		0xE50D8FF8L, 0x5026D64CL, 0x52C5605BL, 0xF87018DAL,
		0x05B88797L, 0x32E50E35L, 0x91A9CE2EL, 0x54E54C27L,
		0x3D0223E2L, 0x896A4611L, 0x4490278CL, 0x8A5685A5L,
		0xA3582430L, 0xC2F309F3L, 0x6396EE8CL, 0x1D52F5F2L,
		0x85E35B9EL, 0xDC997189L, 0xA81A8BFDL, 0x1236750BL,
		0x55AC08ADL, 0x06710DEFL, 0x5D9A9B4FL, 0x69EAEA69L,
		0x3C816E82L, 0x6C84BFEFL, 0xC15B9832L, 0xFFCA2311L,
		0xB65AD661L, 0x54FD8687L, 0xB8ACF8D0L, 0x50B268ADL,
		0x3544FA99L, 0x0F6135FCL, 0xA1761232L, 0x3F84EF74L,
		0x8F1424C9L, 0x7D431C2FL, 0x8DF7DA17L, 0x9F85FD1DL,
		0x18587869L, 0xAB575724L, 0x220380ABL, 0x98373C88L,
		0xE1366D67L, 0x82E57F36L, 0xD61BC4BEL, 0x07D58C4FL,
		},{
		0x683F7667L, 0xA541B488L, 0x6D7B2A23L, 0x22A41694L,
		0x714144A3L, 0xCEEB33DBL, 0x91F21FE6L, 0x02D76C99L,
		0x24806001L, 0xA4FD1A84L, 0x5D97E128L, 0x7788855AL,
		0xCA77B8B5L, 0x1B015B0AL, 0xD8F04F28L, 0x08320591L,
		0x8CF956C3L, 0x722B4883L, 0x672A9765L, 0x44305B25L,
		0x3051744FL, 0x416E06A9L, 0x9545B3E2L, 0x17790B0AL,
		0x85C17B98L, 0x06667AFBL, 0x4BA97BC6L, 0x0D6B04A4L,
		0x68034698L, 0x466B0160L, 0x521F80F7L, 0xA82BA4E0L,
		0xF5B637BFL, 0x67147E05L, 0x48E146A8L, 0xAF6A409AL,
		0xED6655A3L, 0x7C899717L, 0x981BA419L, 0x09AD7F2EL,
		0x33521C83L, 0xC2FA65F6L, 0xF3384E6BL, 0xDA0C80DFL,
		0x37FEF848L, 0xA848D525L, 0xB8E32C99L, 0x97B891E4L,
		0xDDD90DB7L, 0x3AA979B0L, 0x0474B23AL, 0x82287645L,
		0x8E204322L, 0xE6F54045L, 0xC5B4C06EL, 0x0057E113L,
		0x52275D2FL, 0xB8FC4D97L, 0xCFD4FB48L, 0xA0EBDB7CL,
		0x8F103E54L, 0x03DFB57EL, 0xF196BCE7L, 0x45440571L,
		0x663F7F17L, 0x5794CF8DL, 0xF0971B82L, 0x8906D80AL,
		0xCC877E57L, 0xCAB0DA5AL, 0xFC3ED8CAL, 0xD5C71E54L,
		0x3072110DL, 0xD3D246B5L, 0x0AE32773L, 0x8926C074L,
		0x5214AAB9L, 0xC66C04A2L, 0xE8CF3EAFL, 0x914062C4L,
		0x913D7238L, 0x45788958L, 0xBA9FA3B9L, 0x9BF41707L,
		0xAE411474L, 0x9C9E6C0EL, 0x758BA342L, 0xC96AEA50L,
		0xD3228F2DL, 0xEB7856BAL, 0x2B7EBA85L, 0x00DB5F30L,
		0xE347B374L, 0xC05A59C4L, 0x078F88FAL, 0x932CCC02L,
		0x67EE3843L, 0xC907DEF1L, 0x661259C1L, 0x17F329BCL,
		0x328482B5L, 0x7087FA30L, 0x769C4BC3L, 0xA0F9E397L,
		0xB0479075L, 0x3CA62A66L, 0x898C06AAL, 0x919C2B28L,
		0x19B88011L, 0x63E08F72L, 0x7045161BL, 0x68CF633EL,
		0x134DD266L, 0x786B683DL, 0x5BC3C5B5L, 0x4E9072C9L,
		0xFDC585DEL, 0x2BE541BCL, 0xA6CEC44DL, 0x8D020751L,
		0xC414CF1EL, 0x81C415E6L, 0x5F329C47L, 0x861851D0L,
		0x4A6AAD99L, 0xD8D65983L, 0xB888F747L, 0xEC13EE1FL,
		0xE663AC61L, 0x232989ABL, 0xB407B08BL, 0x11F493C4L,
		0x146267E9L, 0xCBBF47BAL, 0x437B1949L, 0xA05932A7L,
		0x880F0F71L, 0x61CAB909L, 0x60429F95L, 0x6FFB2F76L,
		0xC59FCE04L, 0x8243EA59L, 0xE4AE694BL, 0x9BEDD83FL,
		0x147655CCL, 0xBBE22CF5L, 0x65884C22L, 0x8A358C5CL,
		0xADE95F94L, 0x8A67DF41L, 0x714EBDBEL, 0xBD6E8098L,
		0xAC2794D8L, 0x319C107DL, 0x0C4BFC45L, 0xA0AD5B25L,
		0xFF685C69L, 0x5BF79FCFL, 0xBD68B5ACL, 0x7384C8BFL,
		0x10F1AFEEL, 0x2BE57199L, 0xE86677C9L, 0x812AEA9DL,
		0x29D8808BL, 0x9408E3F7L, 0xF6147637L, 0x40A95E51L,
		0x5D479F1BL, 0xF706187CL, 0x03EF65B3L, 0xA4C48800L,
		0xE2B52085L, 0x45AEC06CL, 0xAE12A7FBL, 0x276E2EE1L,
		0x52206B7EL, 0xDF57AA62L, 0xD67208F6L, 0x68D2527DL,
		0xC69C34D5L, 0xC024AC74L, 0x53AD47A7L, 0x3FC8927AL,
		0xBDDC1122L, 0x9FA5C189L, 0xB67A9150L, 0xB26B32C9L,
		0xE6C5F1B1L, 0xBA9CBE02L, 0xC8E2A99DL, 0x66C2E881L,
		0x3BD89574L, 0x39CE76DBL, 0x9308B021L, 0x58134C62L,
		0x81EA35E9L, 0x23D3E7ADL, 0xA3280D6DL, 0x169FD78EL,
		0xD8135C92L, 0x9968F791L, 0x6EB1E0D5L, 0xEB3FA664L,
		0x27B477D3L, 0x3B38A952L, 0x9E8C51F0L, 0xAB1DC97DL,
		0x8EB76F2CL, 0x22CBCFB6L, 0xEDB577D3L, 0x3368847CL,
		0xD1FFBA4EL, 0x1467FB27L, 0xF12F52EEL, 0xEBF55C9AL,
		0xB713E335L, 0xB35474A5L, 0x211205E5L, 0x72287E82L,
		0x207C5FDFL, 0x218B4FD8L, 0x7E3CCF50L, 0x4C37B4DBL,
		0xDC8C668EL, 0x475DE650L, 0x59CC9FA0L, 0x61898891L,
		0xED71E726L, 0x3D365153L, 0xFE19D1EBL, 0x0C01F55FL,
		0xF7D3CAAEL, 0x4FD118DBL, 0x64AA86DEL, 0xDFC8F017L,
		0x158FE3F0L, 0x14338AC2L, 0xB48F9853L, 0x528A8F6FL,
		0xF5283200L, 0x76BD3593L, 0x36BB2548L, 0x16790E0DL,
		0x9EF89147L, 0xC6DFA4ABL, 0xF38DAE04L, 0x873E8CE2L,
		0x1ECF63B2L, 0xF45B961AL, 0x6EF8B795L, 0x73AC9978L,
		0x81580E8DL, 0xD3602E83L, 0x419BE57AL, 0xF88AB76FL,
		}};

#endif /* _CRYPT_KEY_OUTPUT_H */
