#!/usr/bin/perl
#
# This script is (c) Sebastien Tricaud 2008
#

print "header {\n";
print "    title = \"Squid graph\";\n";
print "}\n";

print "axes {\n";
print "    timeline time [label=\"Time\"];\n";
print "    ipv4     srcip [label=\"Source IP\"];\n";
print "    string   login [label=\"Login\",relative=\"true\"];\n";
print "    string   url [label=\"URL\",relative=\"true\",print=\"false\"];\n";
print "    enum     request [label=\"Request\"];\n";
print "    enum     code [label=\"Code\"];\n";
print "    enum     mime [label=\"MIME\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {

        $line =~ s/,/ /g;    # We escape our quotes
	$line =~ s/\"/\\"/g; # We escape our quotes
        $line =~ s/&//g;     # We escape our quotes
        $line =~ s/<//g;     # We escape our quotes
        $line =~ s/>//g;     # We escape our quotes

# 1593802260.652    185 192.168.1.23 TCP_MISS/200 412 GET http://www.blah.com? anonymous FIRST_UP_PARENT/127.0.0.1 image/gif
	if ($line =~ m/(\d+.\d+).+(\d+) (\d+.\d+.\d+.\d+) (\S+)\/(\d+) (\d+) (\S+) (\S+) (\S+) (\S+)\/(\d+.\d+.\d+.\d+) (.*)/) {
		my $time = $1;
		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                               localtime($time);
		my $u1 = $2; # Unkown 1
		my $srcip = $3;
		my $u2 = $4;
		my $http_code = $5;
		my $u3 = $6;
		my $http_req = $7;
		my $url = $8;
		my $login = $9;
		my $u4 = $10;
		my $uip = $11;
		my $mime = $12;

		print "    time=\"$hour:$min:$sec\", srcip=\"$srcip\", login=\"$login\", url=\"$url\", request=\"$http_req\", code=\"$http_code\", mime=\"$mime\";\n";
	}
}
print "}\n";
