DEB_SOURCE_PACKAGE := $(shell dpkg-parsechangelog | sed -n 's/^Source: //p')

DEB_KUBUNTU_OVERRIDE_DH_CLEAN ?= override_dh_clean
$(DEB_KUBUNTU_OVERRIDE_DH_CLEAN): kubuntu_override_dh_clean_impl

kubuntu_override_dh_clean_impl:
	if [ -z $${KUBUNTU_NO_DELETE_POT} ]; then \
	    rm -rf po/*.pot; \
	fi;
	# clean up edited .desktop etc files
	if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  for file in `cat LIST`; do \
	     sed -i '/X-Ubuntu-Gettext-Domain=/d' $${file}; \
	  done; \
	  rm -f LIST; \
	fi
	dh_clean

#Kubuntu specific, Launchpad translations support, create .pot translation templates
#suggestions for a better override target to do this welcome
DEB_KUBUNTU_OVERRIDE_DH_INSTALLDOCS ?= override_dh_installdocs
$(DEB_KUBUNTU_OVERRIDE_DH_INSTALLDOCS): kubuntu_override_dh_installdocs_impl

kubuntu_override_dh_installdocs_impl:
	dh_installdocs
	mkdir -p po
	extract-messages.sh
	extract-xml.sh
	-for file in po/*pot; do \
		sed "s/charset=CHARSET/charset=UTF-8/" -i $$file; \
	done

	# generate .po files for .desktop etc files
	if [ -z $${KUBUNTU_DESKTOP_POT} ]; then \
		KUBUNTU_DESKTOP_POT=$(DEB_SOURCE_PACKAGE); \
	fi; \
	echo KUBUNTU_DESKTOP_POT: $${KUBUNTU_DESKTOP_POT}; \
	if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  cat LIST; \
	  perl /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl --file-list=LIST --base-dir=. > desktop.$${KUBUNTU_DESKTOP_POT}.tmp; \
	  msguniq --to-code=UTF-8 --no-wrap -o desktop.$${KUBUNTU_DESKTOP_POT} desktop.$${KUBUNTU_DESKTOP_POT}.tmp 2>/dev/null; \
	  python /usr/lib/kubuntu-desktop-i18n/msgsplit desktop.$${KUBUNTU_DESKTOP_POT}; \
	  mv desktop.$${KUBUNTU_DESKTOP_POT} po/desktop_$${KUBUNTU_DESKTOP_POT}.pot; \
	  rm -f desktop.$${KUBUNTU_DESKTOP_POT} desktop.$${KUBUNTU_DESKTOP_POT}.tmp; \
	  # add translation domain to files \
	  for file in `cat LIST`; do \
	    echo X-Ubuntu-Gettext-Domain=desktop_$${KUBUNTU_DESKTOP_POT} >> $${file}; \
	  done; \
	  rm -f LIST; \
	fi
