/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef __PGT_CALENDAR_H__
#define __PGT_CALENDAR_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define PGT_TYPE_CALENDAR                  (pgt_calendar_get_gtype ())
#define PGT_CALENDAR(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGT_TYPE_CALENDAR, PgtCalendar))
#define PGT_CALENDAR_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), PGT_TYPE_CALENDAR, PgtCalendarClass))
#define PGT_IS_CALENDAR(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGT_TYPE_CALENDAR))
#define PGT_IS_CALENDAR_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), PGT_TYPE_CALENDAR))
#define PGT_CALENDAR_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), PGT_TYPE_CALENDAR, PgtCalendarClass))

typedef struct _PgtCalendar PgtCalendar;
typedef struct _PgtCalendarClass PgtCalendarClass;

GType pgt_calendar_get_gtype (void);

PgtCalendar*   pgt_calendar_new (void);

void pgt_calendar_get_date (PgtCalendar *self, guint *year, guint *month, guint *day);

G_END_DECLS

#endif /* __PGT_CALENDAR_H__ */
