#!/bin/sh

function quit() {
    if [ "$1" != "0" ];then
	print ""
	print "\033[31mThere was a error during the installation.\033[0m"
	exit $1
    fi
    exit $1
}

function print() {
    printf "\033[1m$1\033[0m\n"
}
    
print "Installing the runner 'Amarok Runner':"
print "Preparing the 'build' directory..."
if [ -d "$PWD/build" ];then
    rm -rf build
fi
mkdir build
cd build

print "Creating the makefiles..."
cmake -DCMAKE_INSTALL_PREFIX=$(kde4-config --prefix) .. || quit 1
print "Building the runner..."
make || quit 1
print "Installing the runner..."
sudo make install || quit 1

print "Rebuilding the cache..."
kbuildsycoca4 > /dev/null 2>&1
print "Restarting KRunner..."
kquitapp krunner
sleep 1
krunner > /dev/null 2>&1

print "The installation was successful."
exit 0