/*
*   Tasks: daisy
*   Description: a daisy for plasma
*   Copyright (C) 2009 by Lechio <Alessandros1pt@yahoo.com.br>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as
*   published by the Free Software Foundation; either version 3, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/







//-----------------------------------------------------------------------------
// Window added
void daisy::windowAdded(WId id)
{
  if (!m_drawerscleared)clearDrawers();
  KWindowInfo taskInfo = KWindowSystem::windowInfo( id, NET::WMName | NET::WMVisibleName , NET::WM2WindowClass );
  
  if ( m_alias.indexOf( taskInfo.windowClassName() ) != -1 )
  {
    m_activetasks << m_alias.indexOf( taskInfo.windowClassName() );
    if ( m_showindicons )emit update();
  }
  else if ( m_alias.indexOf( QString(taskInfo.windowClassClass().toLower()) ) != -1 )
  {
    m_activetasks << m_alias.indexOf( QString(taskInfo.windowClassClass().toLower()) );
    if ( m_showindicons )emit update();
  }
  else if ( m_alias.indexOf( taskInfo.name() ) != -1 )
  {
    m_activetasks << m_alias.indexOf( taskInfo.name() );
    if ( m_showindicons )emit update();
  }
  
}




//-----------------------------------------------------------------------------
// Window removed
//FIXME
void daisy::windowRemoved(WId id)
{
  if (!m_drawerscleared)clearDrawers();
  m_closingwindow = -1;
    
  KWindowInfo taskInfo = KWindowSystem::windowInfo( id, NET::WMName | NET::WMVisibleName , NET::WM2WindowClass );
  if ( m_alias.indexOf( taskInfo.windowClassName() ) != -1 )
  {
    m_closingwindow = m_alias.indexOf( taskInfo.windowClassName() );
    if ( m_showindicons )m_up_tmr->setInterval(2000);m_up_tmr->start();
  }
  else if ( m_alias.indexOf( QString(taskInfo.windowClassClass().toLower()) ) != -1 )
  {
    m_closingwindow = m_alias.indexOf( QString(taskInfo.windowClassClass().toLower()) );
    if ( m_showindicons )m_up_tmr->setInterval(2000);m_up_tmr->start();
  }
  else if ( m_alias.indexOf( taskInfo.name() ) != -1 )
  {
    m_closingwindow = m_alias.indexOf( taskInfo.name() );
    if ( m_showindicons )m_up_tmr->setInterval(2000);m_up_tmr->start();
  }
  else if ( m_alias.indexOf( taskInfo.visibleName() ) != -1 )
  {
    m_closingwindow = m_alias.indexOf( taskInfo.visibleName() );
    if ( m_showindicons )m_up_tmr->setInterval(2000);m_up_tmr->start();
  }
  
  else
  {
    getAllTasks();
  }
  
  
  if ( m_showindicons )emit update();
  
}





//-----------------------------------------------------------------------------
// Active Window changed
//FIXME
void daisy::activeWindowChanged(WId id)
{
  Q_UNUSED(id);
  
  getAllTasks();
  if (!m_drawerscleared)clearDrawers();
  if (m_showindicons)emit update();
  
}










//-----------------------------------------------------------------------------
// Desktop changed
void daisy::currentDesktopChanged(int desktop)
{
  Q_UNUSED(desktop);
  
  if (!m_drawerscleared)clearDrawers();
  
  if ( m_autohide && m_type == QString("standard_dock") && !m_inpanel && !m_floating && m_showondesk )
  {
    m_tracker_tmr->stop();
    if ( !isVisible() ){setVisible(true);}
    m_tracker_tmr->setInterval(m_hidingdelay);m_tracker_tmr->start();
  }
  
}









////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////








//-----------------------------------------------------------------------------
// Startup added
//FIXME
void daisy::startupAdded(StartupPtr startupItem)
{
  
  m_startingwindow = -1;
  if ( startupItem )
  {
    
    if ( m_alias.indexOf( startupItem->text() ) != -1 )
    {
      m_startingwindow = m_alias.indexOf( startupItem->text() );
    }
    
    else if ( m_alias.indexOf( startupItem->bin() ) != -1 )
    {
      m_startingwindow = m_alias.indexOf( startupItem->bin() );
    }
    
    else
    {
      KStartupInfoId taskid = startupItem->id();
    }
    
    
    if ( m_showindicons )emit update();
    
  }

}





//-----------------------------------------------------------------------------
// Startup removed
//FIXME
void daisy::startupRemoved(StartupPtr startupItem)
{
  
  Q_UNUSED(startupItem);
  
}







//-----------------------------------------------------------------------------
// Window changed
//FIXME
void daisy::windowChanged(WId id, const unsigned long* properties )
{
  Q_UNUSED(properties);
  QString widclass_tmp;
  
  
  KWindowInfo taskInfo = KWindowSystem::windowInfo( id, NET::WMName | NET::WMVisibleName | NET::WMVisibleIconName | NET::WMState | NET::XAWMState | NET::WMDesktop, NET::WM2WindowClass );
  if ( m_showtooltips_l && ( m_alias.indexOf( taskInfo.windowClassName() ) != -1 || m_alias.indexOf( QString(taskInfo.windowClassClass().toLower()) ) != -1 ) )
  {
    if ( m_alias.indexOf( taskInfo.windowClassName() ) != -1  )
      widclass_tmp = QString( taskInfo.windowClassName() );
    else
      widclass_tmp = QString(taskInfo.windowClassClass().toLower());
    
    
    int win_count = m_activetasks.count( m_alias.indexOf( widclass_tmp ) );
    Plasma::ToolTipContent toolTipData;toolTipData.setAutohide(false);
    QString str;QString desk_name = KWindowSystem::desktopName( taskInfo.desktop() );
    
    if ( win_count == 1 )
    {
      if (taskInfo.desktop() != -1)
      {str.append( desk_name );str.insert( 0, i18n("On ") );}
      else str.insert( 0, i18n("On all desktops") );
      toolTipData.setMainText( taskInfo.visibleIconNameWithState()   );
      toolTipData.setSubText( str );
      if ( m_tiptype == "thumbnail" )toolTipData.setWindowToPreview(id);
    }
    else
    {
      str.setNum( win_count );str.append( i18n(" instances") );
      toolTipData.setMainText( widclass_tmp );
      toolTipData.setSubText( str );
    }
    if ( m_tiptype == "thumbnail" || m_tiptype == "icon" )
      toolTipData.setImage( KIcon( m_values[m_alias.indexOf( widclass_tmp )][2]).pixmap(IconSize(KIconLoader::Panel)) );
    Plasma::ToolTipManager::self()->setContent(m_widgets[m_alias.indexOf( widclass_tmp )], toolTipData);
    
  }

  
}



//-----------------------------------------------------------------------------
// Work area changed
//FIXME
void daisy::workAreaChanged()
{
  
  
}





////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////













//-----------------------------------------------------------------------------
// Get all the tasks
//FIXME
QList<WId> daisy::getAllTasks()
{
  m_activetasks.clear();
  QList<WId> taskDict = KWindowSystem::windows();
  m_activewindow = -1;m_startingwindow = -1;m_closingwindow = -1;
  Plasma::ToolTipContent toolTipData;toolTipData.setAutohide(false);
  QString str;QString widclass_tmp;
  
  if (m_showtooltips_l)clearToolTipContent();
  QList<WId>::ConstIterator it;
  for (it = taskDict.begin(); it != taskDict.end(); ++it )
  {
    KWindowInfo taskInfo = KWindowSystem::windowInfo( *it, NET::WMName | NET::WMVisibleName | NET::WMVisibleIconName | NET::WMState | NET::XAWMState | NET::WMDesktop, NET::WM2WindowClass );
    
    if ( m_alias.indexOf( taskInfo.windowClassName() ) != -1 || m_alias.indexOf( QString(taskInfo.windowClassClass().toLower()) ) != -1 )
    {
      
      if ( m_alias.indexOf( taskInfo.windowClassName() ) != -1  )
	widclass_tmp = QString( taskInfo.windowClassName() );
      else
	widclass_tmp = QString(taskInfo.windowClassClass().toLower());
      
      
      m_activetasks << m_alias.indexOf( widclass_tmp );
      if ( *it ==  KWindowSystem::activeWindow() )
	m_activewindow = m_alias.indexOf( widclass_tmp );
      
      
      if (m_showtooltips_l)
      {
	str.clear();QString desk_name = KWindowSystem::desktopName( taskInfo.desktop() );
	int win_count = m_activetasks.count( m_alias.indexOf( widclass_tmp ) );
	
	if ( win_count == 1 )
	{
	  if (taskInfo.desktop() != -1)
	  {str.append( desk_name );str.insert( 0, i18n("On ") );}
	  else str.insert( 0, i18n("On all desktops") );
	  toolTipData.setMainText( taskInfo.visibleIconNameWithState()   );
	  toolTipData.setSubText( str );
	  if ( m_tiptype == "thumbnail" )toolTipData.setWindowToPreview(*it);
	}
	else
	{
	  str.setNum( win_count );str.append( i18n(" instances") );
	  toolTipData.setMainText( widclass_tmp );
	  toolTipData.setSubText( str );
	}
	if ( m_tiptype == "thumbnail" || m_tiptype == "icon" )
	  toolTipData.setImage( KIcon( m_values[m_alias.indexOf( widclass_tmp )][2]).pixmap(IconSize(KIconLoader::Panel)) );
	Plasma::ToolTipManager::self()->setContent(m_widgets[m_alias.indexOf( widclass_tmp )], toolTipData);
	
      }
      
      
    }
  }
  
  
  return taskDict;
}










//-----------------------------------------------------------------------------
// Match a task by its name
//FIXME
WId daisy::matchTask(QString name)
{
  
  QList<WId> taskDict = KWindowSystem::windows();
  QList<WId>::ConstIterator it;
  for (it = taskDict.begin(); it != taskDict.end(); ++it )
  {
    KWindowInfo taskInfo = KWindowSystem::windowInfo( *it, NET::WMName | NET::WMVisibleName , NET::WM2WindowClass );
    if ( name == QString(taskInfo.windowClassName()) || name == QString(taskInfo.windowClassClass().toLower()) )
    {
      return *it;
    }
  }
  
  return 0;
}






//-----------------------------------------------------------------------------
// Get all tasks by name
//FIXME
QList<WId> daisy::matchAllTasks(QString name)
{
  QList<WId> ret_taskDict;
  QList<WId> taskDict = KWindowSystem::windows();
  
  QList<WId>::ConstIterator it;
  for (it = taskDict.begin(); it != taskDict.end(); ++it )
  {
    KWindowInfo taskInfo = KWindowSystem::windowInfo( *it, NET::WMName | NET::WMVisibleName , NET::WM2WindowClass );
    
    if ( name == QString(taskInfo.windowClassName()) || name == QString(taskInfo.windowClassClass().toLower()) )
    {
      ret_taskDict << *it;
    }
    
  }
  
  return ret_taskDict;
  
}







//-----------------------------------------------------------------------------
// Get task
bool daisy::getTaskPtr( QString name  )
{
  
  QList<WId> taskDict = KWindowSystem::windows();
  QList<WId>::ConstIterator it;
  for (it = taskDict.begin(); it != taskDict.end(); ++it )
  {
    KWindowInfo taskInfo = KWindowSystem::windowInfo( *it, NET::WMName | NET::WMVisibleName, NET::WM2WindowClass );
    
    if ( taskInfo.windowClassName() == name || taskInfo.visibleName() == name || taskInfo.name() == name || QString(taskInfo.windowClassClass().toLower()) == name  )
    {
      m_task = TaskManager::TaskManager::self()->findTask( *it );
      return true;
    }
  }
  return false;
  
}















//-----------------------------------------------------------------------------
// Toggle task
//FIXME
void daisy::toggTask(WId id)
{
  
  KWindowInfo taskInfo = KWindowSystem::windowInfo( id, NET::WMState, NET::WM2WindowClass );
  
  if ( taskInfo.valid() )
  {
    //HACK widget gains focus on click FIXME
    if ( !taskInfo.isMinimized() && ( m_actwin_save == id ) )
    {KWindowSystem::minimizeWindow( id, true  );}
    else
    {
      KWindowSystem::unminimizeWindow( id, true  );
      KWindowSystem::activateWindow( id  );
    }
    m_up_tmr->stop();m_up_tmr->setInterval(10);m_up_tmr->start();
    
  }
  
}






//-----------------------------------------------------------------------------
// Toggle Shade task
//FIXME
void daisy::toggShadeTask(WId id)
{
  
  KWindowInfo taskInfo = KWindowSystem::windowInfo( id, NET::WMState, NET::WM2WindowClass );
  
  if ( taskInfo.valid() )
  {
    unsigned long wind_state = taskInfo.state();
    if ( wind_state == NET::Shaded  )
    {KWindowSystem::clearState( id, NET::Shaded );}
    else
    {KWindowSystem::setState( id, NET::Shaded );}
  }
  
}















