/***********************************************************************************
* Fancy Tasks: Plasmoid providing a fancy representation of your tasks and launchers.
* Copyright (C) 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef FANCYTASKSTOOLTIP_HEADER
#define FANCYTASKSTOOLTIP_HEADER

#include <QWidget>
#include <QPixmap>
#include <QPaintEvent>
#include <QMouseEvent>
#include <QGridLayout>

#include <NETRootInfo>

#include <taskmanager/taskitem.h>
#include <taskmanager/groupmanager.h>

#include <Plasma/FrameSvg>

class FancyTasksPreview;
class FancyTasksTask;
class FancyTasksLauncher;

using TaskManager::AbstractGroupableItem;

class FancyTasksToolTip : public QWidget
{
    Q_OBJECT

    public:
        FancyTasksToolTip(QPixmap pixmap, const QPixmap &icon, const QString &description, FancyTasksTask *task, QWidget *parent);
        FancyTasksToolTip(const QPixmap &pixmap, const QPixmap &icon, const QString &description, FancyTasksLauncher *launcher, QWidget *parent);
        FancyTasksToolTip(const QPixmap &icon, const QString &description, QWidget *parent);

        void setText(const QString &text);

    public slots:
        void show();
        void hide(bool force = false);
        void updateTheme();

    protected:
        void init();
        void paintEvent(QPaintEvent *event);
        void resizeEvent(QResizeEvent *event);
        void leaveEvent(QEvent *event);
        void mousePressEvent(QMouseEvent *event);

    private:
        QList<FancyTasksPreview*> m_previews;
        QGridLayout *m_mainLayout;
        QGridLayout *m_tasksLayout;
        Plasma::FrameSvg *m_background;
        bool m_alreadyShown;
        bool m_previewsAvailable;

    signals:
        void startWindowsHighlight(QList<WId> windows);
        void stopWindowsHighlight(QList<WId> windows);
};

#endif
