/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef GAMEITEM_H
#define GAMEITEM_H

/// Qt
#include <QList>
#include <QVariant>
#include <QString>


class GameItem : public QObject
{
	Q_OBJECT


public:
	GameItem( const QString& name, const QString& ic, GameItem *parent = 0 );
	~GameItem();


public slots:
	void appendChild( GameItem *child );
	GameItem *child( int row );
	int childCount() const;
	int columnCount() const;
	int row() const;
	GameItem *parent();

	QVariant data( const int& role ) const;
	QString icon() const;
	QString cmd() const;
	bool startx() const;

	void setName( const QString& newName );
	void setIcon( const QString& newIcon );
	void setCmd( const QString& newCmd );
	void setStartx( const bool& newStartx );


private:
	QList<GameItem*> childItems;
	QString _name;
	QString _icon;
	GameItem *parentItem;
	QString _cmd;
	bool _startx;


signals:
	void needUpdate();

    
};

 #endif