/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/ 
#ifndef STASKSTASK_H
#define STASKSTASK_H

//QT
#include <QGraphicsWidget>
#include <QPixmap>
#include <QTime>
#include <QTimer>
//PLASMA
#include <Plasma/IconWidget>
//KDE
#include <KIcon>
//OTHER
#include <taskmanager/taskmanager.h>
#include <taskmanager/abstractgroupableitem.h>
#include <taskmanager/groupmanager.h>
#include <taskmanager/taskitem.h>
#include <taskmanager/startup.h>
#include <taskmanager/taskactions.h>

class STasksApplet;

using TaskManager::StartupPtr;
using TaskManager::TaskPtr;
using TaskManager::StartupPtr;
using TaskManager::GroupPtr;
using TaskManager::AbstractItemPtr;
using TaskManager::AbstractGroupableItem;
using TaskManager::GroupManager;
using TaskManager::TaskItem;
using TaskManager::TaskGroup;

enum TaskFlag
{
    TaskWantsAttention = 1,
    TaskHasFocus       = 2,
    TaskIsMinimized    = 4
};
Q_DECLARE_FLAGS(TaskFlags, TaskFlag)

class STasksTask : public QObject
{
    Q_OBJECT
    public:
	STasksTask(TaskManager::AbstractGroupableItem *abstractItem, QObject *parent,STasksApplet *applet);
	~STasksTask();

	bool isActive();
	bool isOnCurrentDesktop();
	bool isOnAllDesktops();
	bool isMinimized();
	bool demandsAttention();

	enum ItemType { Other = 0, Startup, Task, Group };
	void setIcon(const QIcon icon);
	QIcon icon();
	void setText(const QString &text);
	QString text();
	QString description();
	int desktop();
	TaskPtr task();
	TaskManager::AbstractItemPtr abstractItem();
	GroupPtr group();
	TaskManager::TaskItem* taskItem();
	StartupPtr startup();
	void popup(QPoint point);
	TaskFlags flags();
	ItemType type();
	KIcon m_icon;
    private:
	void setWindowTask(TaskManager::TaskItem* taskItem);
	TaskManager::TaskItem* m_task;
	TaskManager::TaskGroup* m_group;
	STasksApplet *m_applet;

	TaskManager::AbstractItemPtr m_abstractItem;
	TaskFlags m_flags;
        ItemType m_type;
    private slots:
	void updateTask(::TaskManager::TaskChanges changes);
	void gotTaskPointer();
    signals:
	void updateToolTip();
	void updateState();
	void updateIcon(QIcon icon);
	void update();
	void gotTask();
};
#endif
