/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

#ifndef COUNTRYMAP_H
#define COUNTRYMAP_H

//--- QT4 ---
#include <QAbstractListModel>
#include <QAbstractTableModel>
#include <QCache>
#include <QMap>
#include <QModelIndex>
#include <QMutex>
#include <QPointer>

class CountryMap : public QAbstractListModel
{
public:
	enum CountryMapRole { CountryCodeRole = Qt::UserRole };

	static CountryMap * instance();
	static void         clear();

	~CountryMap();

	int		rowCount ( const QModelIndex & parent = QModelIndex() ) const;	// get number of countries
	QVariant	headerData ( int section,
	                             Qt::Orientation orientation,
	                             int role = Qt::DisplayRole ) const;
	QVariant	data(const QModelIndex &, int) const;

	QPixmap		getPixmapForCountry( const QString & country ) const;
	QPixmap		getPixmapForCountryCode( const QString & countryCode ) const;

	QString		countryCode( const QString & country ) const;
	int		countryIndex( const QString & country ) const;
	int		countryCodeIndex( const QString & countryCode );

private:
	CountryMap( QObject * parent = NULL );
	QPixmap	*	private_getPixmapForCountryCode( const QString & countryCode ) const;

	QMap<QString, QString>			m_vCountryMap;		//--- key = country, value = countrycode
	mutable QCache<QString, QPixmap>	m_vPixmapCache;

	static QMutex				singeltonMutex;
	static const QString			sFlagTemplate;
	static QPointer<CountryMap>		m_pInstance;
};


class UsStatesMap : public QAbstractTableModel
{
public:
	static UsStatesMap * instance();
	static void         clear();

	~UsStatesMap();
	int		rowCount ( const QModelIndex & parent = QModelIndex() ) const;
	int		columnCount( const QModelIndex & parent = QModelIndex() ) const;
	QVariant	headerData ( int section,
	                             Qt::Orientation orientation,
	                             int role = Qt::DisplayRole ) const;
	QVariant	data(const QModelIndex &, int role ) const;

	QString		state( const QString & stateCode ) const;
	int		stateIndex( const QString & state ) const;
	int		stateCodeIndex( const QString & state ) const;

private:
	UsStatesMap( QObject * parent = NULL );

	QMap<QString, QString>		m_vStates;

	static QMutex			singeltonMutex;
	static QPointer<UsStatesMap>	m_pInstance;
};

#endif // COUNTRYMAP_H
