/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file joystick_button.cpp
 * \brief Implementation of the bear::input::joystick_button class.
 * \author Julien Jorge
 */
#include "input/joystick_button.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param joy The index of the joystick.
 * \param b The code of the button.
 */
bear::input::joystick_button::joystick_button( unsigned int joy,
                                         joystick::joy_code b )
  : joystick_index(joy), button(b)
{

} // joystick_button::joystick_button()

/*----------------------------------------------------------------------------*/
/**
 * \brief Compare two joystick_button in lexicographic order.
 * \param that joystick_button to compare to.
 */
bool
bear::input::joystick_button::operator<( const joystick_button& that ) const
{
  if ( joystick_index == that.joystick_index )
    return button < that.button;
  else
    return joystick_index < that.joystick_index;
} // joystick_button::operator<()
