/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file expression_creator.cpp
 * \brief Implementation of the bear::expression_creator class.
 * \author Julien Jorge
 */

#include <claw/logger.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <item>.
 * \param name The name of the field.
 * \param value The value of the field.
 */
template<typename Expression>
bool bear::binary_expression_creator<Expression>::set_item_field
( const std::string& name, engine::base_item* value )
{
  bool result = true;
  typedef typename Expression::operand_type::base_expression_type base_type;

  if ( name == "binary_expression_creator.left_operand" )
    {
      base_type* e( dynamic_cast<base_type*>(value) );

      if ( e != NULL )
        this->set_left_operand(*e);
      else
        claw::logger << claw::log_error << name
                     << ": item is not of a valid type." << std::endl;
    }
  else if ( name == "binary_expression_creator.right_operand" )
    {
      base_type* e( dynamic_cast<base_type*>(value) );

      if ( e != NULL )
        this->set_right_operand(*e);
      else
        claw::logger << claw::log_error << name
                     << ": item is not of a valid type." << std::endl;
    }
  else
    result = super::set_item_field(name, value);

  return result;
} // binary_expression_creator::set_item_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
template<typename Expression>
void bear::binary_expression_creator<Expression>::build()
{
  kill();
} // binary_expression_creator::build()
