/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file typed_layer_creator.hpp
 * \brief A class that instanciate a layer of a given type.
 * \author Julien Jorge
 */
#ifndef __ENGINE_TYPED_LAYER_CREATOR_HPP__
#define __ENGINE_TYPED_LAYER_CREATOR_HPP__

#include "engine/layer/layer_creator.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A class that instanciate a layer of a given type.
     * \author Julien Jorge
     */
    template<typename LayerType>
    class typed_layer_creator:
      public layer_creator
    {
    public:
      virtual LayerType* create( const universe::size_box_type& s ) const;

    }; // class typed_layer_creator

  } // namespace engine
} // namespace bear

#include "engine/layer/impl/typed_layer_creator.tpp"

#endif // __ENGINE_TYPED_LAYER_CREATOR_HPP__
