/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file model_mark_placement.hpp
 * \brief A placement for a mark in a snapshot.
 * \author Julien Jorge
 */
#ifndef __ENGINE_MODEL_MARK_PLACEMENT_HPP__
#define __ENGINE_MODEL_MARK_PLACEMENT_HPP__

#include "universe/types.hpp"
#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A placement for a mark in a snapshot.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT model_mark_placement
    {
    public:
      model_mark_placement();
      model_mark_placement
      ( unsigned int id, universe::coordinate_type x,
        universe::coordinate_type y, int depth, double angle, bool visible );

      void set_mark_id( unsigned int i );
      unsigned int get_mark_id() const;

      void set_position
      ( universe::coordinate_type x, universe::coordinate_type y );
      void set_position( const universe::position_type& pos );
      const universe::position_type& get_position() const;

      void set_depth_position( int z );
      int get_depth_position() const;

      void set_angle( double a );
      double get_angle() const;

      void set_visibility( bool v );
      bool is_visible() const;

    private:
      /** \brief The identifier or the mark concerned by this placement. */
      unsigned int m_mark_id;

      /** \brief The position of the mark. */
      universe::position_type m_position;

      /** \brief The depth-position of the mark. */
      int m_depth;

      /** \brief The angle of the mark. */
      double m_angle;

      /** \brief Tell if the mark is visible or not. */
      bool m_visible;

    }; // class model_mark_placement
  } // namespace engine
} // namespace bear

#endif // __ENGINE_MODEL_MARK_PLACEMENT_HPP__
