/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file string_to_arg.hpp
 * \brief Specialisation of text_interface::string_to_arg to pass special
 *        parameters.
 * \author Julien Jorge
 */
#ifndef __ENGINE_STRING_TO_ARG_HPP__
#define __ENGINE_STRING_TO_ARG_HPP__

#include "engine/class_export.hpp"

#include "engine/script/script_context.hpp"
#include "engine/script/script_runner.hpp"
#include "text_interface/string_to_arg.hpp"

namespace bear
{
  namespace text_interface
  {
    /**
     * \brief Get a const base item from its name in the script.
     * \author Julien Jorge
     */
    template<>
    class ENGINE_EXPORT string_to_arg
    <bear::engine::script_context, const bear::engine::base_item&>
    {
    public:
      static const bear::engine::base_item& convert
        ( const bear::engine::script_context& c, const std::string& arg );

    }; // class string_to_arg

    /**
     * \brief Get a base item from its name in the script.
     * \author Julien Jorge
     */
    template<>
    class ENGINE_EXPORT string_to_arg
    <bear::engine::script_context, bear::engine::base_item&>
    {
    public:
      static bear::engine::base_item& convert
        ( const bear::engine::script_context& c, const std::string& arg );

    }; // class string_to_arg


    /**
     * \brief Get a const script runner from its name in the script.
     * \author Sbastien Angibaud
     */
    template<>
    class ENGINE_EXPORT string_to_arg
    <bear::engine::script_context, const bear::engine::script_runner&>
    {
    public:
      static const bear::engine::script_runner& convert
        ( const bear::engine::script_context& c, const std::string& arg );

    }; // class string_to_arg

     /**
     * \brief Get a script runner from its name in the script.
     * \author Sbastien Angibaud
     */
    template<>
    class ENGINE_EXPORT string_to_arg
    <bear::engine::script_context, bear::engine::script_runner&>
    {
    public:
      static bear::engine::script_runner& convert
        ( const bear::engine::script_context& c, const std::string& arg );

    }; // class string_to_arg

  } // namespace text_interface
} // namespace bear

#endif // __ENGINE_STRING_TO_ARG_HPP__
