/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file base_exportable.cpp
 * \brief Implementation of the bear::text_interface::base_exportable class.
 * \author Julien Jorge.
 */
#include "text_interface/base_exportable.hpp"

#include "text_interface/method_caller.hpp"

#include <claw/logger.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
template<typename Context>
bear::text_interface::base_exportable<Context>::method_list::method_list()
  : parent(NULL)
{
  // nothing to do
} // base_exportable::method_list::method_list()




/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
template<typename Context>
bear::text_interface::base_exportable<Context>::~base_exportable()
{
  // nothing to do
} // base_exportable::~base_exportable()

/*----------------------------------------------------------------------------*/
/**
 * \brief Export the methods of the class.
 */
template<typename Context>
void bear::text_interface::base_exportable<Context>::init_method_list()
{
  // nothing to do
} // base_exportable::init_method_list()

/*----------------------------------------------------------------------------*/
/**
 * \brief Execute a method from the class from its name and its arguments as
 *        passed as strings.
 * \param n The name of the method to call.
 * \param args The string representation of the value of the arguments of the
 *        method.
 * \param context The context in which these methods are called.
 */
template<typename Context>
void bear::text_interface::base_exportable<Context>::execute
( const std::string& n, const std::vector<std::string>& args,
  const context_type& c )
{
  // Get the callers from the lowest class in the hierarchy.
  const method_list* m( get_method_list() );
  typename method_list_data_type::const_iterator it(m->data.find(n));
  bool stop(false);

  while( !stop ) // there is at least the null-terminating entry in m.data
    if ( it == m->data.end() )
      {
        // We are at the end of the caller tables. We will now look in the
        // table of the parent class, if there is such a class.
        if ( m->parent != NULL )
          {
            m = m->parent;
            it = m->data.find(n);
          }
        else
          {
            claw::logger << claw::log_warning << "Method '" << n
                         << "' not found." << std::endl;
            stop = true;
          }
      }
    else
      {
        // We found the method. Execute.
        stop = true;
        it->second->execute(this, args, c);
      }
} // base_exportable::execute()

/** Initialisation of the static member variables used for the caller table in
    bear::text_interface::base_exportable. */
TEXT_INTERFACE_IMPLEMENT_ROOT_METHOD_LIST
