/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file base_image.hpp
 * \brief Base class for all image implementation.
 * \author Julien Jorge
 */
#ifndef __VISUAL_BASE_IMAGE_HPP__
#define __VISUAL_BASE_IMAGE_HPP__

#include <claw/coordinate_2d.hpp>
#include <claw/non_copyable.hpp>

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief Base class for all image implementation.
     * \author Julien Jorge
     */
    class VISUAL_EXPORT base_image:
      public claw::pattern::non_copyable
    {
    public:
      virtual ~base_image() {}

      unsigned int width() const { return size().x; }
      unsigned int height() const { return size().y; }
      virtual claw::math::coordinate_2d<unsigned int> size() const = 0;
      virtual bool has_transparency() const = 0;

    }; // class base_image
  } // namespace visual
} // namespace bear

#endif // __VISUAL_BASE_IMAGE_HPP__
