/*
    Bear Engine - Model editor

    Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/mark_placement.hpp
 * \brief The placement of a mark (position, angle, depth).
 * \author Julien Jorge
 */
#ifndef __BF_MARK_PLACEMENT_HPP__
#define __BF_MARK_PLACEMENT_HPP__

#include <cstdlib>

namespace bf
{
  class compiled_file;
  class mark;

  /**
   * \brief The placement of a mark (position, angle, depth).
   * \author Julien Jorge
   */
  class mark_placement
  {
  public:
    mark_placement( mark* m = NULL );
    mark_placement( const mark_placement& p );

    void set_position_x( double x );
    void set_position_y( double y );
    void set_position( double x, double y );
    double get_position_x() const;
    double get_position_y() const;

    void set_visibility( bool v );
    bool is_visible() const;

    void set_depth_position( int p );
    int get_depth_position() const;

    void set_angle( double a );
    double get_angle() const;

    const mark* get_mark() const;

    void compile( compiled_file& f ) const;

  private:
    /** \brief The mark concerned by this placement. */
    const mark* m_mark;

    /** \brief The X-position of the mark. */
    double m_x;

    /** \brief The Y-position of the mark. */
    double m_y;

    /** \brief The depth-position of the mark. */
    int m_depth;

    /** \brief The angle of the mark. */
    double m_angle;

    /** \brief Tell if the mark is displayed or not. */
    bool m_visible;

  }; // class mark_placement
} // namespace bf

#endif // __BF_MARK_PLACEMENT_HPP__
