;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../../common.scm")

(define idle
  (lambda (dest_image)
    (let ( (src_name "idle.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (idle_3 0)
               (idle_2 1)
               (idle_1 2) )

          (create-layer src_image
                        (list idle_1)
                        0 0 24 16 dest_image)
          (create-layer src_image
                        (list idle_1 idle_2)
                        24 0 24 16 dest_image)
          (create-layer src_image
                        (list idle_1 idle_3)
                        48 0 24 16 dest_image)

          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define idle

(define spatter
  (lambda (dest_image)
    (let ( (src_name "spatter.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (frame_0    0)
               (frame_1    1)
               (spatter_1  2)
               (spatter_2  3)
               (frame_2    4)
               (eye        5)
               (eye_1      6)
               (eye_2      7)
               (eye_3      8)
               (eye_4      9)
               (eye_5     10)
               (eye_6     11)
               (eye_7     12)
               (eye_8     13)
               (eye_9     14)
               (eye_10    15)
               (frame_3   16)
               (spatter_3 17)
               (spatter_4 18)
               (spatter_5 19)
               (spatter_6 20) )

          (create-layer src_image
                        (list frame_0)
                        0 16 64 16 dest_image)
          (create-layer src_image
                        (list frame_1 spatter_1)
                        64 16 64 16 dest_image)
          (create-layer src_image
                        (list frame_2 spatter_2)
                         0 32 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_3 eye)
                        64 32 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_4 eye_1)
                         0 48 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_5 eye_2)
                        64 48 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_3)
                         0 64 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_4)
                        64 64 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_5)
                         0 80 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_6)
                        64 80 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_7)
                         0 96 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_8)
                        64 96 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_9)
                         0 112 64 16 dest_image)

          (create-layer src_image
                        (list frame_3 spatter_6 eye_10)
                         64 112 64 16 dest_image)

          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define spatter

(let ( (dest_name "frog-1.png") )
  (let ( (dest_image (car (gimp-image-new 128 128 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 128 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (idle dest_image);
    (spatter dest_image);

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
